/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.xhtml;

import java.io.IOException;
import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.component.core.input.CoreChooseDate;
import org.apache.myfaces.trinidad.context.LocaleContext;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.skin.Icon;
import org.apache.myfaces.trinidad.util.FastMessageFormat;
import org.apache.myfaces.trinidad.util.IntegerUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.pages.GenericEntry;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.AutoSubmitUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.HiddenLabelUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.OutputUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.PartialPageUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlConstants;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlUtils;
import org.apache.myfaces.trinidadinternal.share.url.EncoderUtils;

public class ChooseDateRenderer
extends XhtmlRenderer {
    public static final String MIN_VALUE_PARAM = "minValue";
    public static final String MAX_VALUE_PARAM = "maxValue";
    public static final String LOC_PARAM = "loc";
    public static final String SCROLLED_VALUE_PARAM = "scrolledValue";
    public static final String MONTH_PARAM = "month";
    public static final String YEAR_PARAM = "year";
    private static final CalendarStyles _INLINE_STYLES = new CalendarStyles("af|chooseDate::nav", "af|chooseDate::title", "af|chooseDate::header", "af|chooseDate::disabled", "af|chooseDate::enabled", "af|chooseDate::selected", "af|chooseDate::content");
    private static final int _MAX_CHOICE_ITEMS = 30;
    private static final int _HALF_MAX_CHOICE_ITEMS = 15;
    private static final long _MILLIS_IN_DAY = 86400000L;
    private static final long _MIN_TIME;
    private static final long _MAX_TIME = Long.MAX_VALUE;
    private static final Object _DATE_SYMBOLS_KEY;
    private PropertyKey _maxValueKey;
    private PropertyKey _minValueKey;
    private PropertyKey _valueKey;
    private PropertyKey _currTimeKey;
    private PropertyKey _scrolledValueKey;
    private PropertyKey _destinationKey;
    private static final TrinidadLogger _LOG;

    public ChooseDateRenderer() {
        this(CoreChooseDate.TYPE);
    }

    protected ChooseDateRenderer(FacesBean.Type type) {
        super(type);
    }

    protected void findTypeConstants(FacesBean.Type type) {
        super.findTypeConstants(type);
        this._maxValueKey = type.findKey(MAX_VALUE_PARAM);
        this._minValueKey = type.findKey(MIN_VALUE_PARAM);
        this._valueKey = PropertyKey.createPropertyKey((String)"value");
        this._currTimeKey = PropertyKey.createPropertyKey((String)"currTime");
        this._scrolledValueKey = PropertyKey.createPropertyKey((String)SCROLLED_VALUE_PARAM);
        this._destinationKey = PropertyKey.createPropertyKey((String)"destination");
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected boolean shouldRenderId(FacesContext context, UIComponent component) {
        return true;
    }

    protected final void encodeAll(FacesContext context, RenderingContext arc, UIComponent component, FacesBean bean) throws IOException {
        if (!ChooseDateRenderer.supportsScripting(arc)) {
            return;
        }
        if (this.canSkipRendering(context, arc, component)) {
            return;
        }
        boolean isInline = this.isInline(bean);
        if (isInline && !ChooseDateRenderer.isInlineSupported(arc)) {
            return;
        }
        TimeZone tz = arc.getLocaleContext().getTimeZone();
        long currTimeMillis = 0L;
        Object currTimeValue = bean.getProperty(this._currTimeKey);
        currTimeMillis = currTimeValue != null ? ((Date)currTimeValue).getTime() : System.currentTimeMillis();
        int baseTZOffsetMinutes = tz.getOffset(currTimeMillis / 60000L);
        boolean isDesktop = ChooseDateRenderer.isDesktop((RenderingContext)arc);
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("table", component);
        this.renderId(context, component);
        this.renderAllAttributes(context, arc, bean);
        if (isDesktop) {
            OutputUtils.renderLayoutTableAttributes(context, arc, "0", null);
        } else {
            OutputUtils.renderLayoutTableAttributes(context, arc, "0", "100%");
        }
        CalendarStyles styles = ChooseDateRenderer._getCalendarStyles(isInline);
        long minTime = this._getMinTime(arc, bean);
        long maxTime = this._getMaxTime(arc, bean);
        long selectedTime = this._getSelectedTime(arc, bean, minTime, maxTime);
        String id = this.getClientId(context, component);
        String destString = isInline ? GenericEntry.getGenericEntryURL(context, "idp") : this.getDestination(bean);
        Calendar displayedCalendar = this._getDisplayedCalendar(arc, bean, minTime, maxTime, selectedTime);
        int firstDOM = ChooseDateRenderer._getActualMinimumDayOfMonth(displayedCalendar);
        int lastDOM = ChooseDateRenderer._getActualMaximumDayOfMonth(displayedCalendar);
        Calendar calcCal = (Calendar)displayedCalendar.clone();
        calcCal.set(5, firstDOM);
        long firstDOMTime = calcCal.getTimeInMillis();
        calcCal.set(5, lastDOM);
        calcCal.add(5, 1);
        long lastDOMTime = calcCal.getTimeInMillis() - 1L;
        DateFormatSymbols dateSymbols = ChooseDateRenderer._getDateFormatSymbols(arc);
        int firstDOW = displayedCalendar.getMinimum(7);
        int lastDOW = displayedCalendar.getMaximum(7);
        int dowCount = lastDOW - firstDOW + 1;
        if (isInline) {
            XhtmlUtils.addLib(context, arc, "_calsd()");
        }
        XhtmlUtils.addLib(context, arc, "_updateCal()");
        String baseNavURL = this._createNavURL(arc, destString, minTime, maxTime, selectedTime, id);
        writer.startElement("tr", null);
        this._renderNextPrev(context, arc, component, bean, true, minTime, firstDOMTime, baseNavURL, isInline);
        writer.startElement("td", null);
        writer.writeAttribute("colspan", (Object)IntegerUtils.getString((int)(dowCount - 2)), null);
        ChooseDateRenderer.renderStyleClass((FacesContext)context, (RenderingContext)arc, (String)styles.TITLE_STYLE);
        writer.writeAttribute("nowrap", (Object)Boolean.TRUE, null);
        this._renderMonthAndYear(context, arc, minTime, maxTime, displayedCalendar, dateSymbols, baseNavURL, id, isInline);
        writer.endElement("td");
        this._renderNextPrev(context, arc, component, bean, false, maxTime, lastDOMTime, baseNavURL, isInline);
        writer.endElement("tr");
        writer.startElement("tr", null);
        writer.startElement("td", null);
        writer.writeAttribute("colspan", (Object)IntegerUtils.getString((int)dowCount), null);
        writer.startElement("table", null);
        OutputUtils.renderDataTableAttributes(context, arc, "0", "0", "0", "100%", arc.getTranslatedString("af_chooseDate.SUMMARY"));
        ChooseDateRenderer.renderStyleClass((FacesContext)context, (RenderingContext)arc, (String)styles.CONTENT_STYLE);
        writer.startElement("tr", null);
        ChooseDateRenderer.renderStyleClass((FacesContext)context, (RenderingContext)arc, (String)styles.HEADER_STYLE);
        String[] shortWeekdays = "ar".equals(arc.getLocaleContext().getFormattingLocale().getLanguage()) ? dateSymbols.getWeekdays() : dateSymbols.getShortWeekdays();
        for (int i = firstDOW; i <= lastDOW; ++i) {
            writer.startElement("th", null);
            writer.writeAttribute("scope", (Object)"col", null);
            writer.writeText((Object)shortWeekdays[i], null);
            writer.endElement("th");
        }
        writer.endElement("tr");
        displayedCalendar.set(5, firstDOM);
        int dow = displayedCalendar.get(7);
        writer.startElement("tr", null);
        int firstDOWInMonth = firstDOW - dow;
        if (firstDOWInMonth < 0) {
            int firstPrevLastDOM;
            displayedCalendar.add(2, -1);
            int prevLastDOM = ChooseDateRenderer._getActualMaximumDayOfMonth(displayedCalendar) - ChooseDateRenderer._getActualMinimumDayOfMonth(displayedCalendar) + 1;
            for (int i = firstPrevLastDOM = prevLastDOM + firstDOWInMonth + 1; i <= prevLastDOM; ++i) {
                writer.startElement("td", null);
                if (isInline) {
                    ChooseDateRenderer.renderStyleClass((FacesContext)context, (RenderingContext)arc, (String)styles.DISABLED_STYLE);
                }
                writer.writeText((Object)String.valueOf(i), null);
                writer.endElement("td");
            }
            displayedCalendar.add(2, 1);
        }
        int currDOM = firstDOM;
        long currTime = firstDOMTime;
        displayedCalendar.add(5, 1);
        long nextTime = displayedCalendar.getTimeInMillis();
        int currLastDOW = firstDOWInMonth + dowCount;
        String[] keysAndValues = new String[]{"value", null, "event", "date", "type", "post", "source", id};
        while (true) {
            if (currDOM <= currLastDOW && currDOM <= lastDOM) {
                boolean enabledDay = currTime >= minTime && currTime <= maxTime;
                writer.startElement("td", null);
                if (isInline && !enabledDay) {
                    ChooseDateRenderer.renderStyleClass((FacesContext)context, (RenderingContext)arc, (String)styles.DISABLED_STYLE);
                }
                boolean selectedDay = false;
                if (enabledDay) {
                    boolean bl = selectedDay = selectedTime >= currTime && selectedTime < nextTime;
                }
                if (enabledDay) {
                    writer.startElement("a", null);
                    this.renderSelectDayAttributes(arc, context, keysAndValues, id, currTime, baseTZOffsetMinutes, isInline, isDesktop, destString);
                }
                if (selectedDay) {
                    writer.startElement("span", null);
                    ChooseDateRenderer.renderStyleClass((FacesContext)context, (RenderingContext)arc, (String)styles.SELECTED_STYLE);
                }
                writer.writeText((Object)String.valueOf(currDOM), null);
                if (selectedDay) {
                    writer.endElement("span");
                }
                if (enabledDay) {
                    writer.endElement("a");
                }
                writer.endElement("td");
                currTime = nextTime;
                displayedCalendar.add(5, 1);
                nextTime = displayedCalendar.getTimeInMillis();
                ++currDOM;
                continue;
            }
            if (currDOM > lastDOM) break;
            writer.endElement("tr");
            writer.startElement("tr", null);
            currLastDOW += dowCount;
        }
        displayedCalendar.set(5, firstDOM);
        int lastDOWInMonth = currLastDOW - currDOM + 1;
        if (lastDOWInMonth > 0) {
            displayedCalendar.add(2, 1);
            int nextFirstDOM = ChooseDateRenderer._getActualMinimumDayOfMonth(displayedCalendar);
            int nextLastDOM = nextFirstDOM + lastDOWInMonth - 1;
            for (int i = nextFirstDOM; i <= nextLastDOM; ++i) {
                writer.startElement("td", null);
                if (isInline) {
                    ChooseDateRenderer.renderStyleClass((FacesContext)context, (RenderingContext)arc, (String)styles.DISABLED_STYLE);
                }
                writer.writeText((Object)String.valueOf(i), null);
                writer.endElement("td");
            }
        }
        writer.endElement("tr");
        writer.endElement("table");
        writer.endElement("td");
        writer.endElement("tr");
        writer.endElement("table");
        if ("ie".equals(arc.getAgent().getAgentName()) && arc.getAgent().getAgentVersion().startsWith("6")) {
            this._renderShowComboBoxScriptForIE6(context, arc, bean);
        }
    }

    protected void renderSelectDayAttributes(RenderingContext arc, FacesContext context, String[] keysAndValues, String id, long currTime, int baseTZOffsetMinutes, boolean isInline, boolean isDesktop, String destString) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        if (isDesktop) {
            TimeZone tz = arc.getLocaleContext().getTimeZone();
            int tzOffsetMinutes = tz.getOffset(currTime) / 60000;
            StringBuilder clickRef = new StringBuilder(30);
            writer.writeURIAttribute("href", (Object)"#", null);
            if (isInline) {
                clickRef.append("return _calsd(");
                if (id == null) {
                    clickRef.append("null");
                } else {
                    clickRef.append("'");
                    clickRef.append(id);
                    clickRef.append("'");
                }
                clickRef.append(',');
            } else {
                clickRef.append("return _selectDate(");
            }
            clickRef.append(currTime);
            if (tzOffsetMinutes != baseTZOffsetMinutes) {
                clickRef.append(", " + tzOffsetMinutes);
            }
            clickRef.append(')');
            writer.writeAttribute("onclick", (Object)clickRef, null);
        } else {
            keysAndValues[1] = IntegerUtils.getString((long)currTime);
            assert (destString != null);
            String url = EncoderUtils.appendURLArguments(destString, keysAndValues);
            this.renderEncodedActionURI(context, "href", url);
        }
    }

    protected void renderNextPrev(FacesContext context, RenderingContext arc, UIComponent component, FacesBean bean, boolean isPrev, boolean isEnabled, String halign, Object altText, String destination, String onClick) throws IOException {
        CalendarStyles styles = this._getCalendarStyles(bean);
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("td", null);
        ChooseDateRenderer.renderStyleClass((FacesContext)context, (RenderingContext)arc, (String)styles.NAV_STYLE);
        writer.writeAttribute("align", (Object)halign, null);
        if (isEnabled) {
            writer.startElement("a", null);
            this.renderEncodedActionURI(context, "href", destination);
            writer.writeAttribute("onclick", (Object)onClick, null);
        }
        String iconName = this.isInline(bean) ? (isPrev ? (isEnabled ? "af|chooseDate::prev-icon" : "af|chooseDate::prev-disabled-icon") : (isEnabled ? "af|chooseDate::next-icon" : "af|chooseDate::next-disabled-icon")) : (isPrev ? (isEnabled ? "af|inputDate::prev-icon" : "af|inputDate::prev-disabled-icon") : (isEnabled ? "af|inputDate::next-icon" : "af|inputDate::next-disabled-icon"));
        Icon icon = arc.getIcon(iconName);
        if (icon != null) {
            OutputUtils.renderIcon(context, arc, icon, altText, null);
        }
        if (isEnabled) {
            writer.endElement("a");
        }
        writer.endElement("td");
    }

    protected String getDestination(FacesBean bean) {
        return ChooseDateRenderer.toString((Object)bean.getProperty(this._destinationKey));
    }

    protected boolean isInline(FacesBean bean) {
        return this.getDestination(bean) == null;
    }

    private void _renderShowComboBoxScriptForIE6(FacesContext context, RenderingContext arc, FacesBean bean) throws IOException {
        String baseId = "";
        ResponseWriter writer = context.getResponseWriter();
        String monthId = MONTH_PARAM;
        String yearId = YEAR_PARAM;
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.writeText((Object)"window.onload=showCombo; \n", null);
        writer.writeText((Object)"function showCombo() { \n", null);
        writer.writeText((Object)"_checkLoad(); \n", null);
        writer.writeText((Object)"document.getElementById('month').style.cssText = 'display: inline !important; visibility: visible !important;'; \n", null);
        writer.writeText((Object)"if (document.getElementById('year') != null) {", null);
        writer.writeText((Object)"document.getElementById('year').style.cssText = 'display: inline !important; visibility: visible !important;'; \n", null);
        writer.writeText((Object)"}", null);
        writer.writeText((Object)"return true; \n", null);
        writer.writeText((Object)"} \n", null);
        writer.endElement("script");
    }

    private void _renderNextPrev(FacesContext context, RenderingContext arc, UIComponent component, FacesBean bean, boolean isPrev, long compareTime, long buttonTime, String destination, boolean isInline) throws IOException {
        String halign;
        String iconDesc;
        boolean isEnabled;
        if (isPrev) {
            isEnabled = buttonTime >= compareTime;
            buttonTime -= 86400000L;
            iconDesc = arc.getTranslatedString("af_chooseDate.PREVIOUS_MONTH_TIP");
            halign = "left";
        } else {
            isEnabled = buttonTime <= compareTime;
            buttonTime += 86400000L;
            iconDesc = arc.getTranslatedString("af_chooseDate.NEXT_MONTH_TIP");
            halign = "right";
        }
        if (isEnabled) {
            destination = destination + "&scrolledValue=" + buttonTime;
        }
        String onClick = null;
        if (isInline) {
            onClick = AutoSubmitUtils.getPartialGetScript(destination);
            destination = "#";
        }
        this.renderNextPrev(context, arc, component, bean, isPrev, isEnabled, halign, iconDesc, destination, onClick);
    }

    private String _createNavURL(RenderingContext arc, String destinationString, long minTime, long maxTime, long selectedTime, String id) {
        StringBuffer buffer = new StringBuffer();
        String[] params = this._createNavURLParams(arc, minTime, maxTime, selectedTime, id);
        EncoderUtils.appendURLArguments(buffer, destinationString, params);
        return buffer.toString();
    }

    private String[] _createNavURLParams(RenderingContext arc, long minTime, long maxTime, long selectedTime, String id) {
        return new String[]{"source", id, MIN_VALUE_PARAM, String.valueOf(minTime), MAX_VALUE_PARAM, String.valueOf(maxTime), "value", String.valueOf(selectedTime), LOC_PARAM, arc.getLocaleContext().getFormattingIANALocaleString()};
    }

    private String _getChangeHandler(String baseNavURL, boolean isInline) {
        String prefix = "_updateCal(this,'";
        String suffix = ");";
        int length = prefix.length() + suffix.length() + baseNavURL.length() + 2;
        StringBuilder buffer = new StringBuilder(length);
        buffer.append(prefix);
        buffer.append(baseNavURL);
        buffer.append("',");
        buffer.append(isInline ? "1" : "0");
        buffer.append(suffix);
        return buffer.toString();
    }

    private void _renderMonthChoice(FacesContext context, RenderingContext arc, String[] months, Calendar currentTime, int visibleMonth, int minimumMonth, int maximumMonth, long offset, String onChange, String baseId) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String label = arc.getTranslatedString("af_chooseDate.MONTH_CHOICE_LABEL");
        String id = MONTH_PARAM;
        if (baseId != null) {
            id = baseId + id;
        }
        writer.startElement("select", null);
        writer.writeAttribute("id", (Object)id, null);
        writer.writeAttribute("name", (Object)id, null);
        writer.writeAttribute("title", (Object)label, null);
        writer.writeAttribute("onchange", (Object)onChange, null);
        ChooseDateRenderer.renderStyleClass((FacesContext)context, (RenderingContext)arc, (String)"AFFieldText");
        for (int currMonth = minimumMonth; currMonth <= maximumMonth; ++currMonth) {
            writer.startElement("option", null);
            if (currMonth == visibleMonth) {
                writer.writeAttribute("selected", (Object)Boolean.TRUE, null);
            }
            currentTime.set(2, currMonth);
            String value = String.valueOf(currentTime.getTimeInMillis() - offset);
            writer.writeAttribute("value", (Object)value, null);
            writer.writeText((Object)months[currMonth], null);
            writer.endElement("option");
        }
        writer.endElement("select");
        HiddenLabelUtils.outputHiddenLabelIfNeeded(context, arc, id, label, null);
    }

    private void _renderYearChoice(FacesContext context, RenderingContext arc, Calendar currentTime, int year, int minimumYear, int maximumYear, String onChange, String baseId) throws IOException {
        String label = arc.getTranslatedString("af_chooseDate.YEAR_CHOICE_LABEL");
        String id = YEAR_PARAM;
        if (baseId != null) {
            id = baseId + id;
        }
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("select", null);
        writer.writeAttribute("name", (Object)id, null);
        writer.writeAttribute("id", (Object)id, null);
        writer.writeAttribute("title", (Object)label, null);
        writer.writeAttribute("onchange", (Object)onChange, null);
        ChooseDateRenderer.renderStyleClass((FacesContext)context, (RenderingContext)arc, (String)"AFFieldText");
        boolean needsPrevItem = false;
        boolean needsNextItem = false;
        if (maximumYear - minimumYear >= 30) {
            int minYearCount = year - minimumYear;
            int maxYearCount = maximumYear - year;
            boolean minSmaller = true;
            int smallerCount = minYearCount;
            if (maxYearCount < minYearCount) {
                smallerCount = maxYearCount;
                minSmaller = false;
            }
            if (smallerCount <= 15) {
                if (minSmaller) {
                    needsNextItem = true;
                    maximumYear = minimumYear + 30 - 1;
                } else {
                    needsPrevItem = true;
                    minimumYear = maximumYear - 30 + 1;
                }
            } else {
                needsPrevItem = true;
                needsNextItem = true;
                minimumYear = year - 15 + 1;
                maximumYear = year + 15 - 1;
            }
        }
        if (needsPrevItem) {
            this._writeYearOption(writer, currentTime, minimumYear - 1, year, this._getBeforeFormat(arc).format((Object[])new String[]{String.valueOf(minimumYear)}));
        }
        for (int currYear = minimumYear; currYear <= maximumYear; ++currYear) {
            this._writeYearOption(writer, currentTime, currYear, year, String.valueOf(currYear));
        }
        if (needsNextItem) {
            this._writeYearOption(writer, currentTime, maximumYear + 1, year, this._getAfterFormat(arc).format((Object[])new String[]{String.valueOf(maximumYear)}));
        }
        writer.endElement("select");
        HiddenLabelUtils.outputHiddenLabelIfNeeded(context, arc, id, label, null);
    }

    private void _writeYearOption(ResponseWriter writer, Calendar currentTime, int year, int selectedYear, String text) throws IOException {
        writer.startElement("option", null);
        if (selectedYear == year) {
            writer.writeAttribute("selected", (Object)Boolean.TRUE, null);
        }
        currentTime.set(1, year);
        writer.writeAttribute("value", (Object)String.valueOf(currentTime.getTimeInMillis()), null);
        writer.writeText((Object)text, null);
        writer.endElement("option");
    }

    private void _renderMonthAndYear(FacesContext context, RenderingContext arc, long minTime, long maxTime, Calendar displayedCalendar, DateFormatSymbols dateSymbols, String baseNavURL, String calendarId, boolean isInline) throws IOException {
        boolean sameMonth;
        String jsNavURL = ChooseDateRenderer._escapeJSURL(context, baseNavURL);
        Calendar minCalendar = ChooseDateRenderer._getCalendar(arc, minTime);
        Calendar maxCalendar = ChooseDateRenderer._getCalendar(arc, maxTime);
        int minYear = minCalendar.get(1);
        int maxYear = maxCalendar.get(1);
        ResponseWriter writer = context.getResponseWriter();
        int monthIndex = displayedCalendar.get(2);
        int year = displayedCalendar.get(1);
        String[] monthNames = dateSymbols.getMonths();
        boolean sameYear = minYear == maxYear;
        int minMonthIndex = minCalendar.get(2);
        int maxMonthIndex = maxCalendar.get(2);
        boolean bl = sameMonth = sameYear && minMonthIndex == maxMonthIndex;
        if (!sameMonth) {
            String onChange = this._getChangeHandler(jsNavURL, isInline);
            Calendar currentTime = ChooseDateRenderer._getCalendar(arc);
            ChooseDateRenderer._zeroOutTime(currentTime);
            currentTime.set(1, year);
            int minimumMonth = year == minYear ? minMonthIndex : displayedCalendar.getActualMinimum(2);
            int maximumMonth = year == maxYear ? maxMonthIndex : displayedCalendar.getActualMaximum(2);
            currentTime.set(5, 15);
            this._renderMonthChoice(context, arc, monthNames, currentTime, monthIndex, minimumMonth, maximumMonth, 0L, onChange, calendarId);
            writer.writeText((Object)XhtmlConstants.NBSP_STRING, null);
            if (sameYear) {
                writer.writeText((Object)String.valueOf(year), null);
            } else {
                ChooseDateRenderer._zeroOutTime(currentTime);
                currentTime.set(2, monthIndex);
                this._renderYearChoice(context, arc, currentTime, year, minYear, maxYear, onChange, calendarId);
            }
        } else {
            FastMessageFormat titleFormat = this._getTitleFormat(arc);
            String monthName = monthNames[monthIndex];
            String yearName = String.valueOf(year);
            String title = titleFormat.format((Object[])new String[]{monthName, yearName});
            writer.writeText((Object)title, null);
        }
    }

    private static long _getTimeAttr(RenderingContext arc, FacesBean bean, PropertyKey key, long defaultTime) {
        Object value = bean.getProperty(key);
        if (value == null) {
            return defaultTime;
        }
        if (value instanceof String) {
            try {
                value = new Date((String)value);
            }
            catch (Exception e) {
                _LOG.warning("INVALID_STRING_ATTRIBUTE", value);
            }
        } else if (value instanceof Calendar) {
            value = ((Calendar)value).getTime();
        }
        if (value instanceof Date) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime((Date)value);
            long dateValueInMs = calendar.getTimeInMillis();
            long tzOffset = calendar.get(15) + calendar.get(16);
            LocaleContext localeContext = arc.getLocaleContext();
            tzOffset = (tzOffset -= (long)localeContext.getTimeZone().getOffset(dateValueInMs)) < 0L ? (long)Math.max((float)tzOffset, -9.223372E18f - (float)dateValueInMs) : (long)Math.min((float)tzOffset, 9.223372E18f - (float)dateValueInMs);
            return dateValueInMs + tzOffset;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        return defaultTime;
    }

    private static Calendar _getCalendar(RenderingContext arc) {
        LocaleContext localeContext = arc.getLocaleContext();
        Calendar calendar = Calendar.getInstance(localeContext.getTimeZone(), localeContext.getFormattingLocale());
        if (calendar instanceof GregorianCalendar) {
            ((GregorianCalendar)calendar).setGregorianChange(new Date(Long.MIN_VALUE));
        }
        return calendar;
    }

    private static Calendar _getCalendar(RenderingContext arc, long time) {
        Calendar cal = ChooseDateRenderer._getCalendar(arc);
        cal.setTime(new Date(time));
        ChooseDateRenderer._zeroOutTime(cal);
        return cal;
    }

    private static void _zeroOutTime(Calendar cal) {
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
    }

    private long _getMinTime(RenderingContext arc, FacesBean bean) {
        return ChooseDateRenderer._getTimeAttr(arc, bean, this._minValueKey, _MIN_TIME);
    }

    private long _getMaxTime(RenderingContext arc, FacesBean bean) {
        return ChooseDateRenderer._getTimeAttr(arc, bean, this._maxValueKey, Long.MAX_VALUE);
    }

    private Calendar _getDisplayedCalendar(RenderingContext arc, FacesBean bean, long minTime, long maxTime, long selectedTime) {
        Calendar displayedCal = ChooseDateRenderer._getCalendar(arc, this._getDisplayedTime(arc, bean, minTime, maxTime, selectedTime));
        displayedCal.set(5, 1);
        return displayedCal;
    }

    private long _getDisplayedTime(RenderingContext arc, FacesBean bean, long minTime, long maxTime, long selectedTime) {
        long displayedTime = ChooseDateRenderer._getTimeAttr(arc, bean, this._scrolledValueKey, selectedTime);
        return ChooseDateRenderer._getBoundedTime(displayedTime, minTime, maxTime);
    }

    private long _getSelectedTime(RenderingContext arc, FacesBean bean, long minTime, long maxTime) {
        long selectedTime = ChooseDateRenderer._getTimeAttr(arc, bean, this._valueKey, System.currentTimeMillis());
        return ChooseDateRenderer._getBoundedTime(selectedTime, minTime, maxTime);
    }

    private static long _getBoundedTime(long time, long minTime, long maxTime) {
        if (time < minTime) {
            time = minTime;
        } else if (time > maxTime) {
            time = maxTime;
        }
        return time;
    }

    private FastMessageFormat _getTitleFormat(RenderingContext arc) {
        return this._getMessageFormat(arc, "af_chooseDate.TITLE_FORMAT");
    }

    private FastMessageFormat _getBeforeFormat(RenderingContext arc) {
        return this._getMessageFormat(arc, "af_chooseDate.DIALOG_EARLIER");
    }

    private FastMessageFormat _getAfterFormat(RenderingContext arc) {
        return this._getMessageFormat(arc, "af_chooseDate.DIALOG_LATER");
    }

    private FastMessageFormat _getMessageFormat(RenderingContext arc, String translationKey) {
        FastMessageFormat format = new FastMessageFormat(arc.getTranslatedString(translationKey));
        return format;
    }

    private static DateFormatSymbols _getDateFormatSymbols(RenderingContext arc) {
        DateFormatSymbols symbols = (DateFormatSymbols)arc.getProperties().get(_DATE_SYMBOLS_KEY);
        if (symbols == null) {
            symbols = new DateFormatSymbols(arc.getLocaleContext().getFormattingLocale());
            arc.getProperties().put(_DATE_SYMBOLS_KEY, symbols);
        }
        return symbols;
    }

    private static int _getActualMinimumDayOfMonth(Calendar calendar) {
        return calendar.getActualMinimum(5);
    }

    private static int _getActualMaximumDayOfMonth(Calendar calendar) {
        return calendar.getActualMaximum(5);
    }

    private static String _escapeJSURL(FacesContext context, String url) {
        url = context.getExternalContext().encodeActionURL(url);
        String encoding = OutputUtils.getOutputEncoding(context);
        try {
            url = EncoderUtils.encodeURL(url, encoding, false);
        }
        catch (Exception e) {
            if (_LOG.isWarning()) {
                _LOG.warning("UNABLE_ENCODE_URL", new Object[]{url, encoding});
            }
            _LOG.warning((Throwable)e);
        }
        return XhtmlUtils.escapeJS(url);
    }

    protected static boolean isInlineSupported(RenderingContext arc) {
        return PartialPageUtils.supportsPartialRendering(arc) && ChooseDateRenderer.isDesktop((RenderingContext)arc) && !ChooseDateRenderer.isScreenReaderMode((RenderingContext)arc);
    }

    private CalendarStyles _getCalendarStyles(FacesBean bean) {
        return ChooseDateRenderer._getCalendarStyles(this.isInline(bean));
    }

    private static CalendarStyles _getCalendarStyles(boolean isInline) {
        return _INLINE_STYLES;
    }

    static {
        _DATE_SYMBOLS_KEY = new Object();
        Calendar cal = Calendar.getInstance();
        cal.set(1, 1, 1, 0, 0);
        _MIN_TIME = cal.getTimeInMillis();
        _LOG = TrinidadLogger.createTrinidadLogger(ChooseDateRenderer.class);
    }

    private static final class CalendarStyles {
        public final String NAV_STYLE;
        public final String TITLE_STYLE;
        public final String HEADER_STYLE;
        public final String DISABLED_STYLE;
        public final String ENABLED_STYLE;
        public final String SELECTED_STYLE;
        public final String CONTENT_STYLE;

        public CalendarStyles(String navStyle, String titleStyle, String headerStyle, String disabledStyle, String enabledStyle, String selectedStyle, String contentStyle) {
            this.NAV_STYLE = navStyle;
            this.TITLE_STYLE = titleStyle;
            this.HEADER_STYLE = headerStyle;
            this.DISABLED_STYLE = disabledStyle;
            this.ENABLED_STYLE = enabledStyle;
            this.SELECTED_STYLE = selectedStyle;
            this.CONTENT_STYLE = contentStyle;
        }
    }
}

