/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.menu;

import java.lang.reflect.Array;
import java.util.List;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidadinternal.menu.MenuNode;

public class GroupNode
extends MenuNode {
    private String _idref = null;
    private String[] _idrefList = null;
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(GroupNode.class);

    public String doAction() {
        return this.getRefNode().doAction();
    }

    public String getDestination() {
        return this.getRefNode().getDestination();
    }

    public void setIdRef(String idref) {
        this._idref = idref;
        if (this._idref != null) {
            this._makeIdRefList(idref);
        }
    }

    public MenuNode getRefNode() {
        MenuNode refNode = null;
        if (this._idrefList == null) {
            String idref = this.getIdRef();
            this._makeIdRefList(idref);
        }
        String[] idrefList = this._getIdRefList();
        List<MenuNode> children = this.getChildren();
        for (int i = 0; i < Array.getLength(idrefList); ++i) {
            for (MenuNode childNode : children) {
                String nodeSysId = childNode.getNodeSysId();
                String refNodeId = idrefList[i] + nodeSysId;
                refNode = (MenuNode)this.getRootModel().getNode(refNodeId);
                if (refNode == null) continue;
                break;
            }
            if (refNode == null) continue;
            if (refNode.getRendered() && !refNode.getDisabled() && !refNode.getReadOnly() && refNode.getVisible()) break;
            refNode = null;
        }
        if (refNode == null) {
            _LOG.severe("GroupNode " + this.getLabel() + " refers to no valid node.\n");
            return null;
        }
        return refNode;
    }

    public String getIdRef() {
        return this._idref;
    }

    private String[] _getIdRefList() {
        return this._idrefList;
    }

    private void _makeIdRefList(String entries) {
        this._idrefList = entries.trim().split("\\s+");
    }
}

