/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.image.cache;

import java.util.Map;
import org.apache.myfaces.trinidadinternal.image.ImageConstants;
import org.apache.myfaces.trinidadinternal.image.ImageContext;
import org.apache.myfaces.trinidadinternal.image.cache.CacheUtils;
import org.apache.myfaces.trinidadinternal.image.cache.NameProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeButtonNameProvider
implements NameProvider,
ImageConstants {
    private static final String _PREFIX = "c";
    private static final int _MAX_LENGTH = 4;

    @Override
    public String getName(ImageContext context, Map<Object, Object> requestedProperties) {
        String name = (String)requestedProperties.get(ImageConstants.NAME_KEY);
        if (name == null) {
            String text = (String)requestedProperties.get(ImageConstants.TEXT_KEY);
            if (text == null || text.length() == 0) {
                text = "empty";
            } else if (text.length() > 4) {
                text = text.substring(0, 4);
            }
            name = text;
        }
        int hashCode = this._hashCode(context, requestedProperties);
        String hashString = CacheUtils.base64Encode(hashCode);
        return _PREFIX + name + hashString;
    }

    private int _hashCode(ImageContext context, Map<Object, Object> properties) {
        Object text = properties.get(TEXT_KEY);
        Object foreground = properties.get(FOREGROUND_KEY);
        Object background = properties.get(BACKGROUND_KEY);
        Object surroundingColor = properties.get(SURROUNDING_COLOR_KEY);
        Object font = properties.get(FONT_KEY);
        Object disabled = properties.get(DISABLED_KEY);
        Object textAntialias = properties.get(TEXT_ANTIALIAS_KEY);
        Object accessKey = properties.get(ACCESS_KEY_KEY);
        int direction = CacheUtils.getReadingDirection(context, properties);
        int hashCode = 0;
        if (text != null) {
            hashCode ^= text.hashCode();
        }
        if (foreground != null) {
            hashCode ^= foreground.hashCode();
        }
        if (background != null) {
            hashCode ^= background.hashCode();
        }
        if (surroundingColor != null) {
            hashCode ^= surroundingColor.hashCode();
        }
        if (font != null) {
            hashCode ^= font.hashCode();
        }
        if (disabled != null) {
            hashCode ^= disabled.hashCode();
        }
        if (textAntialias != null) {
            hashCode ^= textAntialias.hashCode();
        }
        if (accessKey != null) {
            hashCode ^= accessKey.hashCode();
        }
        return hashCode ^= direction;
    }
}

