/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.model;

import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.faces.el.PropertyNotFoundException;
import javax.faces.el.PropertyResolver;
import javax.faces.el.ValueBinding;
import javax.faces.webapp.UIComponentTag;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.model.BaseMenuModel;
import org.apache.myfaces.trinidad.model.TreeModel;
import org.apache.myfaces.trinidad.util.ClassLoaderUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLMenuModel
extends BaseMenuModel
implements Serializable {
    private Object _currentNode = null;
    private Object _prevFocusPath = null;
    private String _prevViewId = null;
    private String _requestMethod = "none";
    private String _mdSource = null;
    private boolean _createHiddenNodes = false;
    private Map<String, List<Object>> _viewIdFocusPathMap;
    private Map<Object, List<Object>> _nodeFocusPathMap;
    private Map<String, Object> _idNodeMap;
    private static MenuContentHandler _contentHandler = null;
    private static Object _prevRequestNode = null;
    private static final String _ROOT_MODEL_KEY = "org.apache.myfaces.trinidad.model.XMLMenuModel.__root_menu__";
    private static final String _NODE_ID_PROPERTY = "nodeId";
    private static final String _METHOD_GET = "get";
    private static final String _METHOD_POST = "post";
    private static final String _METHOD_NONE = "none";
    private static final String _CUSTOM_ATTR_LIST = "customPropList";
    private static final String _MENUCONTENTHANDLER_SERVICE = "org.apache.myfaces.trinidad.model.XMLMenuModel$MenuContentHandler";
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(XMLMenuModel.class);
    private static final long serialVersionUID = 1L;

    public void setSource(String menuMetadataUri) {
        if (menuMetadataUri == null || "".equals(menuMetadataUri)) {
            return;
        }
        this._mdSource = menuMetadataUri;
        this._createModel();
    }

    @Override
    public void setWrappedData(Object data) {
        super.setWrappedData(data);
        if (this == this._getRootModel()) {
            this._viewIdFocusPathMap = _contentHandler.getViewIdFocusPathMap(this._mdSource);
            this._nodeFocusPathMap = _contentHandler.getNodeFocusPathMap(this._mdSource);
            this._idNodeMap = _contentHandler.getIdNodeMap(this._mdSource);
        }
    }

    @Override
    public Object getFocusRowKey() {
        ArrayList fpArrayList;
        Map paramMap;
        String nodeId;
        List<Object> focusPath = null;
        String currentViewId = this._getCurrentViewId();
        FacesContext context = FacesContext.getCurrentInstance();
        if (this._prevViewId != null && this._prevViewId.equals(currentViewId)) {
            return this._prevFocusPath;
        }
        this._prevViewId = currentViewId;
        if (this._getRequestMethod() != _METHOD_POST && (nodeId = (String)(paramMap = context.getExternalContext().getRequestParameterMap()).get(_NODE_ID_PROPERTY)) != null) {
            this._setCurrentlySelectedNode(this.getNode(nodeId));
            this._setRequestMethod(_METHOD_GET);
        }
        if (this._getRequestMethod() == _METHOD_NONE) {
            this._setCurrentlySelectedNode(null);
        }
        if ((fpArrayList = (ArrayList)this._viewIdFocusPathMap.get(currentViewId)) != null) {
            if (_prevRequestNode != null) {
                focusPath = this._nodeFocusPathMap.get(_prevRequestNode);
                _prevRequestNode = null;
            } else {
                Object currentNode = this._getCurrentlySelectedNode();
                if (fpArrayList.size() == 1 || currentNode == null) {
                    focusPath = fpArrayList.get(0);
                    _prevRequestNode = null;
                } else {
                    focusPath = this._nodeFocusPathMap.get(currentNode);
                    _prevRequestNode = currentNode;
                }
            }
        }
        this._prevFocusPath = focusPath;
        this._setRequestMethod(_METHOD_NONE);
        return focusPath;
    }

    public String getSource() {
        return this._mdSource;
    }

    public void setCreateHiddenNodes(boolean createHiddenNodes) {
        this._createHiddenNodes = createHiddenNodes;
    }

    public boolean getCreateHiddenNodes() {
        return this._createHiddenNodes;
    }

    public void addViewId(String newViewId, String aliasedViewId) {
        List<Object> focusPath = this._viewIdFocusPathMap.get(aliasedViewId);
        if (focusPath != null) {
            this._viewIdFocusPathMap.put(newViewId, focusPath);
        }
    }

    public void setCurrentlyPostedNode(Object currentNode) {
        this._setCurrentlySelectedNode(currentNode);
        this._setRequestMethod(_METHOD_POST);
        this._prevViewId = null;
    }

    public Object getNode(String id) {
        return this._idNodeMap.get(id);
    }

    public Object getCustomProperty(Object node, String propName) {
        if (node == null) {
            return null;
        }
        FacesContext context = FacesContext.getCurrentInstance();
        PropertyResolver resolver = context.getApplication().getPropertyResolver();
        String value = null;
        try {
            Map propMap = (Map)resolver.getValue(node, (Object)_CUSTOM_ATTR_LIST);
            if (propMap == null) {
                return null;
            }
            value = (String)propMap.get(propName);
        }
        catch (PropertyNotFoundException ex) {
            return null;
        }
        if (value != null && UIComponentTag.isValueReference((String)value)) {
            Object elValue = null;
            try {
                FacesContext ctx = FacesContext.getCurrentInstance();
                ValueBinding binding = ctx.getApplication().createValueBinding(value);
                elValue = binding.getValue(ctx);
            }
            catch (Exception ex) {
                _LOG.warning("INVALID_EL_EXPRESSION", value);
                _LOG.warning(ex);
                return null;
            }
            return elValue;
        }
        return value;
    }

    public InputStream getStream(String uri) {
        try {
            FacesContext context = FacesContext.getCurrentInstance();
            URL url = context.getExternalContext().getResource(uri);
            return url.openStream();
        }
        catch (Exception ex) {
            _LOG.severe("OPEN_URI_EXCEPTION", uri);
            _LOG.severe(ex);
            return null;
        }
    }

    public Map<String, List<Object>> getViewIdFocusPathMap() {
        if (this != this._getRootModel() || _contentHandler == null) {
            return null;
        }
        if (this._viewIdFocusPathMap == null) {
            this._viewIdFocusPathMap = _contentHandler.getViewIdFocusPathMap(this._mdSource);
        }
        return this._viewIdFocusPathMap;
    }

    private void _createModel() {
        try {
            if (_contentHandler == null) {
                List services = ClassLoaderUtils.getServices(_MENUCONTENTHANDLER_SERVICE);
                if (services.isEmpty()) {
                    throw new IllegalStateException(_LOG.getMessage("NO_MENUCONTENTHANDLER_REGISTERED"));
                }
                _contentHandler = (MenuContentHandler)services.get(0);
                if (_contentHandler == null) {
                    throw new NullPointerException();
                }
            }
            this._setRootModelKey(_contentHandler);
            this._setModelUri(_contentHandler);
            TreeModel treeModel = _contentHandler.getTreeModel(this._mdSource);
            this.setWrappedData(treeModel);
        }
        catch (Exception ex) {
            _LOG.severe("ERR_CREATE_MENU_MODEL", this._mdSource);
            _LOG.severe(ex);
            return;
        }
    }

    private void _setRootModelKey(MenuContentHandler contentHandler) {
        if (this._getRootModel() == null) {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            Map requestMap = facesContext.getExternalContext().getRequestMap();
            requestMap.put(_ROOT_MODEL_KEY, this);
            contentHandler.setRootModelKey(_ROOT_MODEL_KEY);
        }
    }

    private XMLMenuModel _getRootModel() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Map requestMap = facesContext.getExternalContext().getRequestMap();
        return (XMLMenuModel)requestMap.get(_ROOT_MODEL_KEY);
    }

    private void _setModelUri(MenuContentHandler contentHandler) {
        String localUri = this._mdSource;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Map requestMap = facesContext.getExternalContext().getRequestMap();
        requestMap.put(localUri, this);
        contentHandler.setModelUri(localUri);
    }

    private String _getCurrentViewId() {
        String currentViewId = FacesContext.getCurrentInstance().getViewRoot().getViewId();
        return currentViewId;
    }

    private Object _getCurrentlySelectedNode() {
        return this._currentNode;
    }

    private void _setCurrentlySelectedNode(Object currentNode) {
        this._currentNode = currentNode;
    }

    private void _setRequestMethod(String method) {
        this._requestMethod = method;
    }

    private String _getRequestMethod() {
        return this._requestMethod;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface MenuContentHandler {
        public TreeModel getTreeModel(String var1);

        public void setRootModelKey(String var1);

        public void setModelUri(String var1);

        public Map<String, Object> getIdNodeMap(Object var1);

        public Map<Object, List<Object>> getNodeFocusPathMap(Object var1);

        public Map<String, List<Object>> getViewIdFocusPathMap(Object var1);
    }
}

