/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.component.html.util;

import java.util.HashMap;
import java.util.Map;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.component.UIParameter;
import javax.faces.context.FacesContext;
import javax.faces.render.Renderer;
import javax.servlet.ServletContext;
import org.apache.myfaces.shared_tomahawk.renderkit.RendererUtils;

public final class HtmlComponentUtils {
    private HtmlComponentUtils() {
    }

    public static String getClientId(UIComponent component, Renderer renderer, FacesContext context) {
        boolean forceId = RendererUtils.getBooleanValue("forceId", component.getAttributes().get("forceId"), false);
        if (forceId && component.getId() != null) {
            int rowIndex;
            boolean forceIdIndex;
            String clientId = component.getId();
            UIComponent parentContainer = HtmlComponentUtils.findParentNamingContainer(component, false);
            if (parentContainer != null && parentContainer instanceof UIData && (forceIdIndex = RendererUtils.getBooleanValue("forceId", component.getAttributes().get("forceIdIndex"), true)) && (rowIndex = ((UIData)parentContainer).getRowIndex()) != -1) {
                clientId = clientId + "[" + rowIndex + "]";
            }
            if (renderer != null) {
                clientId = renderer.convertClientId(context, clientId);
            }
            return clientId;
        }
        return null;
    }

    public static UIComponent findParentNamingContainer(UIComponent component, boolean returnRootIfNotFound) {
        UIComponent parent = component.getParent();
        if (returnRootIfNotFound && parent == null) {
            return component;
        }
        while (parent != null) {
            if (parent instanceof NamingContainer) {
                return parent;
            }
            if (returnRootIfNotFound) {
                UIComponent nextParent = parent.getParent();
                if (nextParent == null) {
                    return parent;
                }
                parent = nextParent;
                continue;
            }
            parent = parent.getParent();
        }
        return null;
    }

    public static Map getParameterMap(UIComponent component) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (UIComponent child : component.getChildren()) {
            UIParameter uiparam;
            Object value;
            if (!(child instanceof UIParameter) || (value = (uiparam = (UIParameter)child).getValue()) == null) continue;
            result.put(uiparam.getName(), value);
        }
        return result;
    }

    public static String getLifecycleId(ServletContext context) {
        String lifecycleId = context.getInitParameter("javax.faces.LIFECYCLE_ID");
        return lifecycleId != null ? lifecycleId : "DEFAULT";
    }
}

