/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.tree.taglib;

import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.servlet.jsp.JspException;
import org.apache.myfaces.custom.tree.HtmlTree;
import org.apache.myfaces.custom.tree.model.DefaultTreeModel;
import org.apache.myfaces.custom.tree.model.TreeModel;
import org.apache.myfaces.custom.tree.model.TreePath;
import org.apache.myfaces.shared_tomahawk.taglib.html.HtmlPanelGroupTag;

public class AbstractTreeTag
extends HtmlPanelGroupTag {
    private ValueExpression value;
    private boolean expandRoot;

    public String getComponentType() {
        return "org.apache.myfaces.HtmlTree";
    }

    public String getRendererType() {
        return "org.apache.myfaces.HtmlTree";
    }

    public ValueExpression getValue() {
        return this.value;
    }

    public void setValue(ValueExpression newValue) {
        this.value = newValue;
    }

    public boolean isExpandRoot() {
        return this.expandRoot;
    }

    public void setExpandRoot(boolean expandRoot) {
        this.expandRoot = expandRoot;
    }

    public int doStartTag() throws JspException {
        TreeModel model;
        TreeModel treeModel;
        FacesContext context = FacesContext.getCurrentInstance();
        if (this.value != null && (treeModel = (TreeModel)this.value.getValue(context.getELContext())) == null) {
            treeModel = new DefaultTreeModel();
            this.value.setValue(context.getELContext(), (Object)treeModel);
        }
        int answer = super.doStartTag();
        HtmlTree tree = (HtmlTree)this.getComponentInstance();
        if (this.getCreated() && this.expandRoot && (model = tree.getModel(context)) != null) {
            tree.expandPath(new TreePath(new Object[]{model.getRoot()}), context);
        }
        tree.addToModelListeners();
        return answer;
    }

    public void release() {
        super.release();
        this.value = null;
        this.expandRoot = false;
    }

    protected void setProperties(UIComponent component) {
        super.setProperties(component);
        FacesContext context = FacesContext.getCurrentInstance();
        if (this.value != null) {
            if (!this.value.isLiteralText()) {
                component.setValueExpression("model", this.value);
            }
        } else {
            ValueExpression binding = component.getValueExpression("model");
            if (binding == null) {
                binding = context.getApplication().getExpressionFactory().createValueExpression(context.getELContext(), "#{sessionScope.tree}", Object.class);
            }
            component.setValueExpression("model", binding);
        }
    }
}

