/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import jakarta.faces.component.EditableValueHolder;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import java.lang.invoke.MethodHandles;
import java.util.Map;
import org.apache.myfaces.tobago.component.Attributes;
import org.apache.myfaces.tobago.internal.util.StringUtils;
import org.apache.myfaces.tobago.renderkit.RendererBase;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DecodingInputRendererBase<T extends UIComponent>
extends RendererBase<T> {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Override
    public void decodeInternal(FacesContext facesContext, T component) {
        if (!(component instanceof EditableValueHolder)) {
            return;
        }
        if (this.isOutputOnly(component)) {
            return;
        }
        String clientId = component.getClientId(facesContext);
        Map requestParameterMap = facesContext.getExternalContext().getRequestParameterMap();
        if (requestParameterMap.containsKey(clientId)) {
            String newValue = (String)requestParameterMap.get(clientId);
            if (LOG.isDebugEnabled()) {
                boolean password = ComponentUtils.getBooleanAttribute(component, Attributes.password);
                LOG.debug("clientId='{}'", (Object)clientId);
                LOG.debug("requestParameterMap.get(clientId)='{}'", (Object)StringUtils.toConfidentialString(newValue, password));
            }
            this.setSubmittedValue(facesContext, (EditableValueHolder)component, newValue);
        }
        this.decodeClientBehaviors(facesContext, component);
    }

    protected abstract boolean isOutputOnly(T var1);

    protected void setSubmittedValue(FacesContext facesContext, EditableValueHolder component, String newValue) {
        component.setSubmittedValue((Object)newValue);
    }
}

