/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.webapp;

import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Arrays;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.tobago.internal.util.HtmlWriterHelper;
import org.apache.myfaces.tobago.internal.util.WriterHelper;
import org.apache.myfaces.tobago.internal.webapp.TobagoResponseWriterBase;

public class HtmlResponseWriter
extends TobagoResponseWriterBase {
    private static final String HTML_DOCTYPE = "<!DOCTYPE html>";
    private final WriterHelper helper;

    @Deprecated(since="4.3.0", forRemoval=true)
    public HtmlResponseWriter(Writer writer, String contentType, String characterEncoding) {
        this(writer, contentType, Charset.forName(characterEncoding), true);
    }

    public HtmlResponseWriter(Writer writer, String contentType, Charset charset, boolean prettyPrint) {
        super(writer, contentType, charset, prettyPrint);
        this.helper = new HtmlWriterHelper(writer, charset);
    }

    @Override
    public void write(String string) throws IOException {
        this.writeInternal(this.getWriter(), string);
    }

    public final WriterHelper getHelper() {
        return this.helper;
    }

    @Override
    public void writeText(Object text, String property) throws IOException {
        this.closeOpenTag();
        String value = this.findValue(text, property);
        this.helper.writeText(value);
    }

    public void writeText(char[] text, int offset, int length) throws IOException {
        this.closeOpenTag();
        this.helper.writeText(text, offset, length);
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        if (!Arrays.equals(cbuf, XML_VERSION_1_0_ENCODING_UTF_8_CHARS)) {
            super.write(cbuf, off, len);
        }
    }

    @Override
    protected void closeEmptyTag() throws IOException {
        this.handlePassThroughAttributes();
        this.getWriter().write(">");
    }

    @Override
    protected void writerAttributeValue(String value, boolean escape) throws IOException {
        if (escape) {
            this.helper.writeAttributeValue(value);
        } else {
            this.getWriter().write(value);
        }
    }

    @Override
    public ResponseWriter cloneWithWriter(Writer originalWriter) {
        return new HtmlResponseWriter(originalWriter, this.getContentType(), this.getCharset(), this.isPrettyPrint());
    }

    @Override
    public void startDocument() throws IOException {
        this.getWriter().write(HTML_DOCTYPE);
        this.getWriter().write(10);
    }

    @Override
    public void endElement(String name) throws IOException {
        super.endElement(name);
    }

    @Override
    public void endDocument() throws IOException {
    }
}

