/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.config;

import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.myfaces.tobago.config.TobagoConfig;
import org.apache.myfaces.tobago.exception.TobagoConfigurationException;
import org.apache.myfaces.tobago.internal.config.TobagoConfigFragment;
import org.apache.myfaces.tobago.internal.config.TobagoConfigImpl;
import org.apache.myfaces.tobago.internal.config.TobagoConfigMerger;
import org.apache.myfaces.tobago.internal.config.TobagoConfigParser;
import org.apache.myfaces.tobago.internal.config.TobagoConfigSorter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class TobagoConfigBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(TobagoConfigBuilder.class);
    private static final String WEB_INF_TOBAGO_CONFIG_XML = "WEB-INF/tobago-config.xml";
    private static final String META_INF_TOBAGO_CONFIG_XML = "META-INF/tobago-config.xml";
    private List<TobagoConfigFragment> configFragmentList;
    private ServletContext servletContext;

    public TobagoConfigBuilder(ServletContext servletContext) {
        this.servletContext = servletContext;
        this.configFragmentList = new ArrayList<TobagoConfigFragment>();
    }

    public TobagoConfigBuilder(ServletContext servletContext, List<TobagoConfigFragment> configFragmentList) {
        this(servletContext);
        this.configFragmentList.addAll(configFragmentList);
    }

    public static void init(ServletContext servletContext) {
        try {
            TobagoConfigBuilder builder = new TobagoConfigBuilder(servletContext);
            builder.build();
        }
        catch (Exception e) {
            String error = "Error while deployment. Tobago can't be initialized! Application will not run correctly!";
            LOG.error("Error while deployment. Tobago can't be initialized! Application will not run correctly!", (Throwable)e);
            throw new TobagoConfigurationException("Error while deployment. Tobago can't be initialized! Application will not run correctly!", e);
        }
    }

    public TobagoConfig build() throws URISyntaxException, SAXException, ParserConfigurationException, ServletException, IOException {
        TobagoConfigImpl tobagoConfig = this.initializeConfigFromFiles();
        tobagoConfig.resolveThemes();
        tobagoConfig.initDefaultValidatorInfo();
        tobagoConfig.lock();
        this.servletContext.setAttribute("org.apache.myfaces.tobago.config.TobagoConfig", (Object)tobagoConfig);
        return tobagoConfig;
    }

    protected TobagoConfigImpl initializeConfigFromFiles() throws ServletException, IOException, SAXException, ParserConfigurationException, URISyntaxException {
        this.configFromClasspath();
        this.configFromWebInf();
        TobagoConfigSorter sorter = new TobagoConfigSorter(this.configFragmentList);
        TobagoConfigMerger merger = new TobagoConfigMerger(sorter.topologicalSort());
        return merger.merge();
    }

    private void configFromWebInf() throws IOException, SAXException, ParserConfigurationException, URISyntaxException {
        URL url = this.servletContext.getResource("/WEB-INF/tobago-config.xml");
        if (url != null) {
            this.configFragmentList.add(new TobagoConfigParser().parse(url));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void configFromClasspath() throws ServletException {
        try {
            if (LOG.isInfoEnabled()) {
                LOG.info("Searching for 'META-INF/tobago-config.xml'");
            }
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Enumeration<URL> urls = classLoader.getResources(META_INF_TOBAGO_CONFIG_XML);
            while (urls.hasMoreElements()) {
                URL themeUrl = urls.nextElement();
                try {
                    TobagoConfigFragment fragment = new TobagoConfigParser().parse(themeUrl);
                    fragment.setUrl(themeUrl);
                    this.configFragmentList.add(fragment);
                    String protocol = themeUrl.getProtocol();
                    if ("jar".equals(protocol) || "zip".equals(protocol) || "wsjar".equals(protocol)) continue;
                    LOG.warn("Unknown protocol '" + themeUrl + "'");
                }
                catch (Exception e) {
                    throw new Exception(e.getClass().getName() + " on themeUrl: " + themeUrl, e);
                    return;
                }
            }
        }
        catch (Exception e) {
            String msg = "while loading ";
            LOG.error("while loading ", (Throwable)e);
            throw new ServletException("while loading ", (Throwable)e);
        }
    }
}

