/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.validator.crossval.strategy;

import java.lang.annotation.Annotation;
import org.apache.myfaces.extensions.validator.crossval.storage.CrossValidationStorageEntry;
import org.apache.myfaces.extensions.validator.crossval.storage.ProcessedInformationStorageEntry;
import org.apache.myfaces.extensions.validator.crossval.strategy.AbstractCompareStrategy;
import org.apache.myfaces.extensions.validator.internal.UsageCategory;
import org.apache.myfaces.extensions.validator.internal.UsageInformation;

@UsageInformation(value={UsageCategory.INTERNAL})
class CrossValidationHelper {
    CrossValidationHelper() {
    }

    public static void crossValidateCompareStrategy(AbstractCompareStrategy compareStrategy, CrossValidationStorageEntry crossValidationStorageEntry, ProcessedInformationStorageEntry validationTargetEntry, boolean isModelAwareValidation) {
        if (compareStrategy.isViolation(crossValidationStorageEntry.getConvertedObject(), validationTargetEntry.getConvertedValue(), (Annotation)crossValidationStorageEntry.getMetaDataEntry().getValue(Annotation.class))) {
            if (!isModelAwareValidation) {
                CrossValidationHelper.processTargetAfterCrossComponentValidation(compareStrategy, crossValidationStorageEntry, validationTargetEntry);
            } else {
                CrossValidationHelper.processTargetAfterModelAwareCrossValidation(compareStrategy, crossValidationStorageEntry);
            }
            compareStrategy.processSourceComponentAfterViolation(crossValidationStorageEntry);
        }
    }

    private static void processTargetAfterCrossComponentValidation(AbstractCompareStrategy compareStrategy, CrossValidationStorageEntry sourceCrossValidationStorageEntry, ProcessedInformationStorageEntry validationTargetEntry) {
        CrossValidationStorageEntry targetCrossValidationStorageEntry = new CrossValidationStorageEntry();
        if (compareStrategy.useTargetComponentToDisplayErrorMsg(sourceCrossValidationStorageEntry)) {
            targetCrossValidationStorageEntry.setComponent(validationTargetEntry.getComponent());
            targetCrossValidationStorageEntry.setClientId(validationTargetEntry.getClientId());
        } else {
            targetCrossValidationStorageEntry.setComponent(sourceCrossValidationStorageEntry.getComponent());
            targetCrossValidationStorageEntry.setClientId(sourceCrossValidationStorageEntry.getClientId());
        }
        targetCrossValidationStorageEntry.setConvertedObject(validationTargetEntry.getConvertedValue());
        targetCrossValidationStorageEntry.setValidationStrategy(compareStrategy);
        compareStrategy.processTargetComponentAfterViolation(sourceCrossValidationStorageEntry, targetCrossValidationStorageEntry);
    }

    private static void processTargetAfterModelAwareCrossValidation(AbstractCompareStrategy compareStrategy, CrossValidationStorageEntry crossValidationStorageEntry) {
        compareStrategy.processTargetComponentAfterViolation(crossValidationStorageEntry, null);
    }
}

