/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.validator.util;

import java.beans.Introspector;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.myfaces.extensions.validator.core.ExtValCoreConfiguration;
import org.apache.myfaces.extensions.validator.core.property.PropertyDetails;
import org.apache.myfaces.extensions.validator.core.storage.MappedConstraintSourceStorage;
import org.apache.myfaces.extensions.validator.core.storage.PropertyStorage;
import org.apache.myfaces.extensions.validator.internal.UsageCategory;
import org.apache.myfaces.extensions.validator.internal.UsageInformation;
import org.apache.myfaces.extensions.validator.util.ExtValAnnotationUtils;
import org.apache.myfaces.extensions.validator.util.ExtValUtils;
import org.apache.myfaces.extensions.validator.util.ProxyUtils;
import org.apache.myfaces.extensions.validator.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@UsageInformation(value={UsageCategory.INTERNAL})
public final class ConstraintSourceUtils {
    protected ConstraintSourceUtils() {
    }

    public static PropertyDetails resolveMappedConstraintSourceFor(String originalKey, Class originalClass, String originalProperty) {
        MappedConstraintSourceStorage mappedConstraintSourceStorage = ConstraintSourceUtils.getConstraintSourceStorage();
        if (ConstraintSourceUtils.isMappedConstraintSourceCached(mappedConstraintSourceStorage, originalClass, originalProperty)) {
            return ConstraintSourceUtils.getMappedConstraintSource(mappedConstraintSourceStorage, originalClass, originalProperty);
        }
        originalClass = ProxyUtils.getUnproxiedClass(originalClass);
        PropertyStorage propertyStorage = ReflectionUtils.getPropertyStorage();
        Class newClass = ConstraintSourceUtils.findMappedClass(propertyStorage, originalClass, originalProperty);
        if (newClass == null) {
            ConstraintSourceUtils.tryToCacheMappedConstraintSourceMetaData(mappedConstraintSourceStorage, originalClass, originalProperty, null);
            return null;
        }
        String newProperty = ConstraintSourceUtils.findMappedProperty(propertyStorage, originalClass, newClass, originalProperty);
        PropertyDetails result = new PropertyDetails(originalKey, newClass, newProperty);
        ConstraintSourceUtils.tryToCacheMappedConstraintSourceMetaData(mappedConstraintSourceStorage, originalClass, originalProperty, result);
        return result;
    }

    private static boolean isMappedConstraintSourceCached(MappedConstraintSourceStorage storage, Class baseBeanClass, String property) {
        return storage.containsMapping(baseBeanClass, property);
    }

    private static PropertyDetails getMappedConstraintSource(MappedConstraintSourceStorage storage, Class baseBeanClass, String property) {
        return storage.getMappedConstraintSource(baseBeanClass, property);
    }

    private static void tryToCacheMappedConstraintSourceMetaData(MappedConstraintSourceStorage storage, Class originalClass, String originalProperty, PropertyDetails result) {
        storage.storeMapping(originalClass, originalProperty, result);
    }

    private static MappedConstraintSourceStorage getConstraintSourceStorage() {
        return ExtValUtils.getStorage(MappedConstraintSourceStorage.class, MappedConstraintSourceStorage.class.getName());
    }

    private static Class findMappedClass(PropertyStorage storage, Class baseBeanClass, String property) {
        Class<? extends Annotation> constraintSourceAnnotationImplementation = ExtValCoreConfiguration.get().constraintSourceAnnotation();
        Annotation foundConstraintSourceAnnotation = ConstraintSourceUtils.tryToGetAnnotationFromProperty(storage, baseBeanClass, property, constraintSourceAnnotationImplementation);
        if (foundConstraintSourceAnnotation == null) {
            foundConstraintSourceAnnotation = ConstraintSourceUtils.tryToGetAnnotationFromField(storage, baseBeanClass, property, constraintSourceAnnotationImplementation);
        }
        if (foundConstraintSourceAnnotation == null && !ConstraintSourceUtils.isMappedConstraintSourceIgnored(baseBeanClass, property)) {
            foundConstraintSourceAnnotation = ConstraintSourceUtils.tryToGetConstraintSourceAnnotationFromClass(baseBeanClass, constraintSourceAnnotationImplementation);
        }
        if (foundConstraintSourceAnnotation != null) {
            return ExtValAnnotationUtils.extractValueOf(foundConstraintSourceAnnotation, Class.class);
        }
        return null;
    }

    private static String findMappedProperty(PropertyStorage storage, Class baseBeanClass, Class newBaseBeanClass, String originalProperty) {
        Annotation targetPropertyAnnotation = ConstraintSourceUtils.getTargetPropertyMetaData(storage, baseBeanClass, originalProperty);
        if (targetPropertyAnnotation != null) {
            return ConstraintSourceUtils.extractNewPropertyName(newBaseBeanClass, targetPropertyAnnotation);
        }
        return originalProperty;
    }

    private static Annotation getTargetPropertyMetaData(PropertyStorage storage, Class baseBeanClass, String originalProperty) {
        Class<? extends Annotation> targetPropertyAnnotation = ConstraintSourceUtils.getTargetPropertyAnnotationImplementation();
        Class<? extends Annotation> targetPropertyIdAnnotation = ConstraintSourceUtils.getTargetPropertyIdAnnotationImplementation();
        Annotation result = ConstraintSourceUtils.findTargetPropertyIdAnnotation(storage, baseBeanClass, originalProperty, targetPropertyIdAnnotation);
        if (result == null) {
            result = ConstraintSourceUtils.findTargetPropertyAnnotation(storage, baseBeanClass, originalProperty, targetPropertyAnnotation);
        }
        return result;
    }

    private static Class<? extends Annotation> getTargetPropertyAnnotationImplementation() {
        return ExtValCoreConfiguration.get().targetPropertyAnnotation();
    }

    private static Class<? extends Annotation> getTargetPropertyIdAnnotationImplementation() {
        return ExtValCoreConfiguration.get().targetPropertyIdAnnotation();
    }

    private static String extractNewPropertyName(Class targetClass, Annotation annotation) {
        Object annotationValue = ExtValAnnotationUtils.extractValueOf(annotation, Object.class);
        if (annotationValue instanceof String) {
            return (String)annotationValue;
        }
        if (annotationValue instanceof Class) {
            return ConstraintSourceUtils.findNameOfAnnotatedProperty(targetClass, (Class)annotationValue);
        }
        return null;
    }

    private static String findNameOfAnnotatedProperty(Class targetClass, Class<? extends Annotation> customTargetMarkerAnnotation) {
        for (Method method : targetClass.getDeclaredMethods()) {
            if (!method.isAnnotationPresent(customTargetMarkerAnnotation)) continue;
            return ConstraintSourceUtils.convertMethodToPropertyName(method.getName());
        }
        for (AccessibleObject accessibleObject : targetClass.getDeclaredFields()) {
            if (!accessibleObject.isAnnotationPresent(customTargetMarkerAnnotation)) continue;
            return ConstraintSourceUtils.convertFieldToPropertyName(((Field)accessibleObject).getName());
        }
        return null;
    }

    private static String convertMethodToPropertyName(String name) {
        String result = name;
        if (name.startsWith("is")) {
            result = name.substring(2);
        } else if (name.startsWith("get")) {
            result = name.substring(3);
        }
        return Introspector.decapitalize(result);
    }

    private static String convertFieldToPropertyName(String name) {
        if (name.startsWith("_")) {
            return name.substring(1);
        }
        return name;
    }

    private static Annotation findTargetPropertyIdAnnotation(PropertyStorage storage, Class baseBeanClass, String property, Class<? extends Annotation> targetPropertyIdAnnotation) {
        Annotation result = ConstraintSourceUtils.tryToGetAnnotationFromProperty(storage, baseBeanClass, property, targetPropertyIdAnnotation);
        if (result == null) {
            result = ConstraintSourceUtils.tryToGetAnnotationFromField(storage, baseBeanClass, property, targetPropertyIdAnnotation);
        }
        return result;
    }

    private static Annotation findTargetPropertyAnnotation(PropertyStorage storage, Class baseBeanClass, String property, Class<? extends Annotation> targetPropertyAnnotation) {
        Annotation result = ConstraintSourceUtils.tryToGetAnnotationFromProperty(storage, baseBeanClass, property, targetPropertyAnnotation);
        if (result == null) {
            result = ConstraintSourceUtils.tryToGetAnnotationFromField(storage, baseBeanClass, property, targetPropertyAnnotation);
        }
        return result;
    }

    private static boolean isMappedConstraintSourceIgnored(Class baseBeanClass, String property) {
        PropertyStorage storage = ReflectionUtils.getPropertyStorage();
        Method method = ReflectionUtils.tryToGetMethodOfProperty(storage, baseBeanClass, property);
        if (method != null && method.isAnnotationPresent(ConstraintSourceUtils.getIgnoreConstraintSourceAnnotationImplementation())) {
            return true;
        }
        Field field = ReflectionUtils.tryToGetFieldOfProperty(storage, baseBeanClass, property);
        return field != null && field.isAnnotationPresent(ConstraintSourceUtils.getIgnoreConstraintSourceAnnotationImplementation());
    }

    private static Annotation tryToGetConstraintSourceAnnotationFromClass(Class baseBeanClass, Class<? extends Annotation> annotation) {
        if (baseBeanClass.isAnnotationPresent(annotation)) {
            return baseBeanClass.getAnnotation(annotation);
        }
        return null;
    }

    private static Class<? extends Annotation> getIgnoreConstraintSourceAnnotationImplementation() {
        return ExtValCoreConfiguration.get().ignoreConstraintSourceAnnotation();
    }

    private static Annotation tryToGetAnnotationFromField(PropertyStorage storage, Class baseBeanClass, String property, Class<? extends Annotation> annotationClass) {
        Field field = ReflectionUtils.tryToGetFieldOfProperty(storage, baseBeanClass, property);
        if (field != null && field.isAnnotationPresent(annotationClass)) {
            return field.getAnnotation(annotationClass);
        }
        return null;
    }

    private static Annotation tryToGetAnnotationFromProperty(PropertyStorage storage, Class baseBeanClass, String property, Class<? extends Annotation> annotationClass) {
        Method method = ReflectionUtils.tryToGetMethodOfProperty(storage, baseBeanClass, property);
        if (method != null && method.isAnnotationPresent(annotationClass)) {
            return method.getAnnotation(annotationClass);
        }
        return null;
    }
}

