/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.cdi.jsf.impl.config.view;

import java.beans.Introspector;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Named;
import org.apache.myfaces.extensions.cdi.core.api.config.view.DefaultErrorView;
import org.apache.myfaces.extensions.cdi.core.api.config.view.ViewConfig;
import org.apache.myfaces.extensions.cdi.core.api.provider.BeanManagerProvider;
import org.apache.myfaces.extensions.cdi.core.api.security.AccessDecisionVoter;
import org.apache.myfaces.extensions.cdi.core.impl.util.CodiUtils;
import org.apache.myfaces.extensions.cdi.jsf.api.config.view.Page;
import org.apache.myfaces.extensions.cdi.jsf.api.config.view.PageBean;
import org.apache.myfaces.extensions.cdi.jsf.api.config.view.PageBeanDescriptor;
import org.apache.myfaces.extensions.cdi.jsf.api.config.view.ViewConfigDescriptor;
import org.apache.myfaces.extensions.cdi.jsf.impl.config.view.DefaultPageBeanDescriptor;
import org.apache.myfaces.extensions.cdi.jsf.impl.config.view.spi.EditableViewConfigDescriptor;
import org.apache.myfaces.extensions.cdi.jsf.impl.config.view.spi.LifecycleAwarePageBeanDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultViewConfigDescriptor
implements EditableViewConfigDescriptor {
    private final String viewId;
    private final Class<? extends ViewConfig> viewDefinitionClass;
    private final Page.NavigationMode navigationMode;
    private List<PageBeanDescriptor> pageBeanDescriptors;
    private final List<Class<? extends AccessDecisionVoter>> accessDecisionVoters;
    private final Class<? extends ViewConfig> customErrorView;
    private Page.ViewParameterMode viewParameterMode;
    private List<Annotation> metaDataList;
    private boolean partialViewConfig = false;
    private transient BeanManager beanManager;

    public DefaultViewConfigDescriptor(String viewId, Class<? extends ViewConfig> viewDefinitionClass, Page.NavigationMode navigationMode, Page.ViewParameterMode viewParameterMode, List<Class<? extends AccessDecisionVoter>> accessDecisionVoters, Class<? extends ViewConfig> errorView, List<Annotation> metaDataList) {
        this.viewId = viewId;
        this.viewDefinitionClass = viewDefinitionClass;
        this.navigationMode = navigationMode;
        this.viewParameterMode = viewParameterMode;
        this.metaDataList = metaDataList;
        this.pageBeanDescriptors = Collections.unmodifiableList(this.findPageBeanDefinitions(viewDefinitionClass));
        this.accessDecisionVoters = accessDecisionVoters;
        this.customErrorView = errorView != null ? errorView : DefaultErrorView.class;
    }

    public String getViewId() {
        return this.viewId;
    }

    public Class<? extends ViewConfig> getViewConfig() {
        return this.viewDefinitionClass;
    }

    public Page.NavigationMode getNavigationMode() {
        return this.navigationMode;
    }

    @Override
    public Page.ViewParameterMode getViewParameterMode() {
        return this.viewParameterMode;
    }

    public List<PageBeanDescriptor> getPageBeanDescriptors() {
        return this.pageBeanDescriptors;
    }

    @Override
    public void invokeInitViewMethods() {
        for (PageBeanDescriptor beanEntry : this.getPageBeanDescriptors()) {
            if (!(beanEntry instanceof LifecycleAwarePageBeanDescriptor)) continue;
            this.processCallbacks(beanEntry, ((LifecycleAwarePageBeanDescriptor)beanEntry).getInitViewMethods());
        }
    }

    @Override
    public void invokePrePageActionMethods() {
        for (PageBeanDescriptor beanEntry : this.getPageBeanDescriptors()) {
            if (!(beanEntry instanceof LifecycleAwarePageBeanDescriptor)) continue;
            this.processCallbacks(beanEntry, ((LifecycleAwarePageBeanDescriptor)beanEntry).getPrePageActionMethods());
        }
    }

    @Override
    public void invokePreRenderViewMethods() {
        for (PageBeanDescriptor beanEntry : this.getPageBeanDescriptors()) {
            if (!(beanEntry instanceof LifecycleAwarePageBeanDescriptor)) continue;
            this.processCallbacks(beanEntry, ((LifecycleAwarePageBeanDescriptor)beanEntry).getPreRenderViewMethods());
        }
    }

    @Override
    public void invokePostRenderViewMethods() {
        for (PageBeanDescriptor beanEntry : this.getPageBeanDescriptors()) {
            if (!(beanEntry instanceof LifecycleAwarePageBeanDescriptor)) continue;
            this.processCallbacks(beanEntry, ((LifecycleAwarePageBeanDescriptor)beanEntry).getPostRenderViewMethods());
        }
    }

    private void processCallbacks(PageBeanDescriptor pageBeanDescriptor, List<Method> methodList) {
        if (methodList.isEmpty()) {
            return;
        }
        Object bean = CodiUtils.getContextualReferenceByName((BeanManager)this.getBeanManager(), (String)pageBeanDescriptor.getBeanName(), Object.class);
        if (bean == null) {
            return;
        }
        for (Method callbackMethod : methodList) {
            this.invokeMethod(bean, callbackMethod);
        }
    }

    private void invokeMethod(Object bean, Method preProcessMethod) {
        try {
            preProcessMethod.setAccessible(true);
            preProcessMethod.invoke(bean, new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public List<Class<? extends AccessDecisionVoter>> getAccessDecisionVoters() {
        return Collections.unmodifiableList(this.accessDecisionVoters);
    }

    @Override
    public Class<? extends ViewConfig> getErrorView() {
        return this.customErrorView;
    }

    public List<Annotation> getMetaData() {
        return this.metaDataList;
    }

    public <T extends Annotation> List<T> getMetaData(Class<T> target) {
        ArrayList<Annotation> result = new ArrayList<Annotation>();
        for (Annotation annotation : this.metaDataList) {
            if (!target.isAssignableFrom(annotation.annotationType())) continue;
            result.add(annotation);
        }
        return result;
    }

    @Override
    public void addPageBean(Class pageBeanClass) {
        ArrayList<PageBeanDescriptor> newList = new ArrayList<PageBeanDescriptor>(this.pageBeanDescriptors);
        DefaultPageBeanDescriptor newEntry = new DefaultPageBeanDescriptor(this.getBeanName(pageBeanClass), pageBeanClass);
        newList.add(newEntry);
        this.pageBeanDescriptors = Collections.unmodifiableList(newList);
    }

    @Override
    public void setPartialViewConfig(boolean inlinePageBean) {
        this.partialViewConfig = inlinePageBean;
    }

    @Override
    public boolean isPartialViewConfig() {
        return this.partialViewConfig;
    }

    private List<PageBeanDescriptor> findPageBeanDefinitions(Class<? extends ViewConfig> viewDefinitionClass) {
        if (!viewDefinitionClass.isAnnotationPresent(PageBean.class) && !viewDefinitionClass.isAnnotationPresent(PageBean.List.class)) {
            return Collections.emptyList();
        }
        ArrayList<PageBeanDescriptor> result = new ArrayList<PageBeanDescriptor>();
        if (viewDefinitionClass.isAnnotationPresent(PageBean.class)) {
            result.add(this.extractBeanEntry(viewDefinitionClass.getAnnotation(PageBean.class)));
        }
        if (viewDefinitionClass.isAnnotationPresent(PageBean.List.class)) {
            result.addAll(this.extractBeanEntries(viewDefinitionClass.getAnnotation(PageBean.List.class)));
        }
        return result;
    }

    private List<PageBeanDescriptor> extractBeanEntries(PageBean.List pageBeanList) {
        ArrayList<PageBeanDescriptor> result = new ArrayList<PageBeanDescriptor>();
        for (PageBean pageBean : pageBeanList.value()) {
            result.add(this.extractBeanEntry(pageBean));
        }
        return result;
    }

    private PageBeanDescriptor extractBeanEntry(PageBean pageBean) {
        if (!"".equals(pageBean.name())) {
            return new DefaultPageBeanDescriptor(pageBean.name(), pageBean.value());
        }
        Class pageBeanClass = pageBean.value();
        String pageBeanName = null;
        pageBeanName = this.getBeanName(pageBeanClass);
        return new DefaultPageBeanDescriptor(pageBeanName, pageBeanClass);
    }

    private String getBeanName(Class<?> pageBeanClass) {
        String beanName;
        if (pageBeanClass.isAnnotationPresent(Named.class) && !"".equals(beanName = pageBeanClass.getAnnotation(Named.class).value())) {
            return beanName;
        }
        return Introspector.decapitalize(pageBeanClass.getSimpleName());
    }

    private BeanManager getBeanManager() {
        if (this.beanManager == null) {
            this.beanManager = BeanManagerProvider.getInstance().getBeanManager();
        }
        return this.beanManager;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ViewConfigDescriptor)) {
            return false;
        }
        ViewConfigDescriptor that = (ViewConfigDescriptor)o;
        return this.viewId.equals(that.getViewId());
    }

    public int hashCode() {
        return this.viewId.hashCode();
    }
}

