/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.validator;

import javax.faces.component.PartialStateHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;
import javax.faces.validator._MessageUtils;

public class LongRangeValidator
implements Validator,
PartialStateHolder {
    public static final String MAXIMUM_MESSAGE_ID = "javax.faces.validator.LongRangeValidator.MAXIMUM";
    public static final String MINIMUM_MESSAGE_ID = "javax.faces.validator.LongRangeValidator.MINIMUM";
    public static final String TYPE_MESSAGE_ID = "javax.faces.validator.LongRangeValidator.TYPE";
    public static final String VALIDATOR_ID = "javax.faces.LongRange";
    public static final String NOT_IN_RANGE_MESSAGE_ID = "javax.faces.validator.LongRangeValidator.NOT_IN_RANGE";
    private Long _minimum = null;
    private Long _maximum = null;
    private boolean _transient = false;
    private boolean _initialStateMarked = false;

    public LongRangeValidator() {
    }

    public LongRangeValidator(long maximum) {
        this._maximum = maximum;
    }

    public LongRangeValidator(long maximum, long minimum) {
        this._maximum = maximum;
        this._minimum = minimum;
    }

    @Override
    public void validate(FacesContext facesContext, UIComponent uiComponent, Object value) throws ValidatorException {
        if (facesContext == null) {
            throw new NullPointerException("facesContext");
        }
        if (uiComponent == null) {
            throw new NullPointerException("uiComponent");
        }
        if (value == null) {
            return;
        }
        double dvalue = this.parseLongValue(facesContext, uiComponent, value);
        if (this._minimum != null && this._maximum != null) {
            if (dvalue < (double)this._minimum.longValue() || dvalue > (double)this._maximum.longValue()) {
                Object[] args = new Object[]{this._minimum, this._maximum, _MessageUtils.getLabel(facesContext, uiComponent)};
                throw new ValidatorException(_MessageUtils.getErrorMessage(facesContext, NOT_IN_RANGE_MESSAGE_ID, args));
            }
        } else if (this._minimum != null) {
            if (dvalue < (double)this._minimum.longValue()) {
                Object[] args = new Object[]{this._minimum, _MessageUtils.getLabel(facesContext, uiComponent)};
                throw new ValidatorException(_MessageUtils.getErrorMessage(facesContext, MINIMUM_MESSAGE_ID, args));
            }
        } else if (this._maximum != null && dvalue > (double)this._maximum.longValue()) {
            Object[] args = new Object[]{this._maximum, _MessageUtils.getLabel(facesContext, uiComponent)};
            throw new ValidatorException(_MessageUtils.getErrorMessage(facesContext, MAXIMUM_MESSAGE_ID, args));
        }
    }

    private long parseLongValue(FacesContext facesContext, UIComponent uiComponent, Object value) throws ValidatorException {
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        try {
            return Long.parseLong(value.toString());
        }
        catch (NumberFormatException e) {
            Object[] args = new Object[]{_MessageUtils.getLabel(facesContext, uiComponent)};
            throw new ValidatorException(_MessageUtils.getErrorMessage(facesContext, TYPE_MESSAGE_ID, args));
        }
    }

    public long getMaximum() {
        return this._maximum != null ? this._maximum : Long.MAX_VALUE;
    }

    public void setMaximum(long maximum) {
        this._maximum = maximum;
        this.clearInitialState();
    }

    public long getMinimum() {
        return this._minimum != null ? this._minimum : Long.MIN_VALUE;
    }

    public void setMinimum(long minimum) {
        this._minimum = new Long(minimum);
        this.clearInitialState();
    }

    @Override
    public boolean isTransient() {
        return this._transient;
    }

    @Override
    public void setTransient(boolean transientValue) {
        this._transient = transientValue;
    }

    @Override
    public Object saveState(FacesContext context) {
        if (!this.initialStateMarked()) {
            Object[] values = new Object[]{this._maximum, this._minimum};
            return values;
        }
        return null;
    }

    @Override
    public void restoreState(FacesContext context, Object state) {
        if (state != null) {
            Object[] values = (Object[])state;
            this._maximum = (Long)values[0];
            this._minimum = (Long)values[1];
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LongRangeValidator)) {
            return false;
        }
        LongRangeValidator longRangeValidator = (LongRangeValidator)o;
        if (this._maximum != null ? !this._maximum.equals(longRangeValidator._maximum) : longRangeValidator._maximum != null) {
            return false;
        }
        return !(this._minimum != null ? !this._minimum.equals(longRangeValidator._minimum) : longRangeValidator._minimum != null);
    }

    public int hashCode() {
        int result = this._minimum != null ? this._minimum.hashCode() : 0;
        result = 31 * result + (this._maximum != null ? this._maximum.hashCode() : 0);
        return result;
    }

    @Override
    public void clearInitialState() {
        this._initialStateMarked = false;
    }

    @Override
    public boolean initialStateMarked() {
        return this._initialStateMarked;
    }

    @Override
    public void markInitialState() {
        this._initialStateMarked = true;
    }

    private Boolean isDisabled() {
        return null;
    }

    private String getFor() {
        return null;
    }
}

