/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.session.filters;

import java.io.IOException;
import java.util.Objects;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.filter.InputHandler;
import org.apache.sshd.common.filter.IoFilter;
import org.apache.sshd.common.filter.OutputHandler;
import org.apache.sshd.common.io.IoWriteFuture;
import org.apache.sshd.common.random.Random;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.session.filters.ThreadLocalRandom;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.core.CoreModuleProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InjectIgnoreFilter
extends IoFilter {
    private static final Logger LOG = LoggerFactory.getLogger(InjectIgnoreFilter.class);
    private final PropertyResolver resolver;
    private final Random random = ThreadLocalRandom.INSTANCE;
    private final OutputHandler output = new Injector();

    public InjectIgnoreFilter(PropertyResolver resolver) {
        this.resolver = Objects.requireNonNull(resolver);
    }

    @Override
    public InputHandler in() {
        return null;
    }

    @Override
    public OutputHandler out() {
        return this.output;
    }

    private class Injector
    implements OutputHandler {
        private Settings settings;
        private long ignoreCount;

        Injector() {
        }

        @Override
        public synchronized IoWriteFuture send(int cmd, Buffer message) throws IOException {
            int length;
            if (message != null && (length = this.shouldSendIgnore(cmd)) > 0) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Injector.send({}) injecting SSH_MSG_IGNORE", (Object)InjectIgnoreFilter.this.resolver);
                }
                InjectIgnoreFilter.this.owner().send(2, this.createIgnoreBuffer(length)).addListener(f -> {
                    Throwable t = f.getException();
                    if (t != null && InjectIgnoreFilter.this.resolver instanceof Session) {
                        ((Session)InjectIgnoreFilter.this.resolver).exceptionCaught(t);
                    }
                });
            }
            return InjectIgnoreFilter.this.owner().send(cmd, message);
        }

        private Settings getSettings() {
            if (this.settings == null) {
                int length = CoreModuleProperties.IGNORE_MESSAGE_SIZE.getRequired(InjectIgnoreFilter.this.resolver);
                long frequency = CoreModuleProperties.IGNORE_MESSAGE_FREQUENCY.getRequired(InjectIgnoreFilter.this.resolver);
                int variance = CoreModuleProperties.IGNORE_MESSAGE_VARIANCE.getRequired(InjectIgnoreFilter.this.resolver);
                if ((long)variance >= frequency) {
                    variance = 0;
                }
                this.settings = new Settings(length, frequency, variance);
                if (!this.settings.isDisabled()) {
                    this.ignoreCount = this.calculateNextIgnorePacketCount(this.settings);
                }
            }
            return this.settings;
        }

        private long calculateNextIgnorePacketCount(Settings s) {
            long count;
            if (s.variance == 0) {
                return s.frequency;
            }
            int extra = InjectIgnoreFilter.this.random.random(Math.abs(s.variance));
            long l = count = s.variance < 0 ? s.frequency - (long)extra : s.frequency + (long)extra;
            if (LOG.isTraceEnabled()) {
                LOG.trace("calculateNextIgnorePacketCount({}) count={}", (Object)InjectIgnoreFilter.this.resolver, (Object)count);
            }
            return count;
        }

        private int shouldSendIgnore(int cmd) {
            long count;
            if (cmd <= 49) {
                return 0;
            }
            Settings s = this.getSettings();
            if (s.isDisabled()) {
                return 0;
            }
            if ((count = --this.ignoreCount) == 0L) {
                this.ignoreCount = this.calculateNextIgnorePacketCount(s);
                return s.length;
            }
            return 0;
        }

        private Buffer createIgnoreBuffer(int length) {
            int size = length + InjectIgnoreFilter.this.random.random(length + 1);
            ByteArrayBuffer buffer = new ByteArrayBuffer(6 + size + 127 + 64);
            ((Buffer)buffer).rpos(5);
            ((Buffer)buffer).wpos(5);
            ((Buffer)buffer).putByte((byte)2);
            int start = ((Buffer)buffer).wpos();
            ((Buffer)buffer).wpos(((Buffer)buffer).wpos() + size);
            InjectIgnoreFilter.this.random.fill(((Buffer)buffer).array(), start, size);
            return buffer;
        }
    }

    private static class Settings {
        final int length;
        final long frequency;
        final int variance;

        Settings(int length, long frequency, int variance) {
            this.length = length;
            this.frequency = frequency;
            this.variance = variance;
        }

        boolean isDisabled() {
            return this.length <= 0 || this.frequency <= 0L || this.variance < 0;
        }
    }
}

