/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.command.impl;

import java.io.IOException;
import org.apache.ftpserver.command.AbstractCommand;
import org.apache.ftpserver.command.impl.listing.ListArgument;
import org.apache.ftpserver.command.impl.listing.ListArgumentParser;
import org.apache.ftpserver.command.impl.listing.MLSTFileFormater;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.ftplet.FtpFile;
import org.apache.ftpserver.ftplet.FtpRequest;
import org.apache.ftpserver.impl.FtpIoSession;
import org.apache.ftpserver.impl.FtpServerContext;
import org.apache.ftpserver.impl.LocalizedFtpReply;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MLST
extends AbstractCommand {
    private final Logger LOG = LoggerFactory.getLogger(MLST.class);

    @Override
    public void execute(FtpIoSession session, FtpServerContext context, FtpRequest request) throws IOException {
        session.resetState();
        ListArgument parsedArg = ListArgumentParser.parse(request.getArgument());
        FtpFile file = null;
        try {
            file = session.getFileSystemView().getFile(parsedArg.getFile());
            if (file != null && file.doesExist()) {
                MLSTFileFormater formater = new MLSTFileFormater((String[])session.getAttribute("MLST.types"));
                session.write((Object)LocalizedFtpReply.translate(session, request, context, 250, "MLST", formater.format(file)));
            } else {
                session.write((Object)LocalizedFtpReply.translate(session, request, context, 501, "MLST", null));
            }
        }
        catch (FtpException ex) {
            this.LOG.debug("Exception sending the file listing", (Throwable)ex);
            session.write((Object)LocalizedFtpReply.translate(session, request, context, 501, "MLST", null));
        }
    }
}

