/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.util.graph.visitor;

import java.util.function.Consumer;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.util.graph.visitor.AbstractDependencyNodeConsumerVisitor;
import org.eclipse.aether.util.graph.visitor.Stack;

public final class PostorderDependencyNodeConsumerVisitor
extends AbstractDependencyNodeConsumerVisitor {
    public static final String NAME = "postOrder";
    private final Stack<Boolean> visits = new Stack();

    public PostorderDependencyNodeConsumerVisitor(Consumer<DependencyNode> nodeConsumer) {
        super(nodeConsumer);
    }

    @Override
    public boolean visitEnter(DependencyNode node) {
        boolean visited = !this.setVisited(node);
        this.visits.push(visited);
        return !visited;
    }

    @Override
    public boolean visitLeave(DependencyNode node) {
        Boolean visited = this.visits.pop();
        if (visited.booleanValue()) {
            return true;
        }
        this.nodeConsumer.accept(node);
        return true;
    }
}

