/*
 * Decompiled with CFR 0.152.
 */
package org.mvndaemon.mvnd.daemon;

import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class DaemonMemoryStatus {
    static final int MAX_EVENTS = 20;
    final GcStrategy strategy;
    final GarbageCollectorMXBean garbageCollectorMXBean;
    final MemoryPoolMXBean heapMemoryPoolMXBean;
    final MemoryPoolMXBean nonHeapMemoryPoolMXBean;
    final Clock clock;
    final Deque<GcEvent> heapEvents = new ConcurrentLinkedDeque<GcEvent>();
    final Deque<GcEvent> nonHeapEvents = new ConcurrentLinkedDeque<GcEvent>();

    public DaemonMemoryStatus(ScheduledExecutorService executor) {
        List<GarbageCollectorMXBean> garbageCollectors = ManagementFactory.getGarbageCollectorMXBeans();
        List<MemoryPoolMXBean> memoryPoolMXBeans = ManagementFactory.getMemoryPoolMXBeans();
        GcStrategy strategy = null;
        GarbageCollectorMXBean garbageCollector = null;
        MemoryPoolMXBean heapMemoryPoolMXBean = null;
        MemoryPoolMXBean nonHeapMemoryPoolMXBean = null;
        for (GcStrategy testStrategy : GcStrategy.values()) {
            garbageCollector = garbageCollectors.stream().filter(gc -> gc.getName().equals(testStrategy.garbageCollector)).findFirst().orElse(null);
            heapMemoryPoolMXBean = memoryPoolMXBeans.stream().filter(mp -> mp.getName().equals(testStrategy.heapMemoryPool)).findFirst().orElse(null);
            nonHeapMemoryPoolMXBean = memoryPoolMXBeans.stream().filter(mp -> mp.getName().equals(testStrategy.nonHeapMemoryPool)).findFirst().orElse(null);
            if (garbageCollector == null || heapMemoryPoolMXBean == null || nonHeapMemoryPoolMXBean == null) continue;
            strategy = testStrategy;
            break;
        }
        if (strategy != null) {
            this.strategy = strategy;
            this.garbageCollectorMXBean = garbageCollector;
            this.heapMemoryPoolMXBean = heapMemoryPoolMXBean;
            this.nonHeapMemoryPoolMXBean = nonHeapMemoryPoolMXBean;
            this.clock = Clock.systemUTC();
            executor.scheduleAtFixedRate(this::gatherData, 1L, 1L, TimeUnit.SECONDS);
        } else {
            this.strategy = null;
            this.garbageCollectorMXBean = null;
            this.heapMemoryPoolMXBean = null;
            this.nonHeapMemoryPoolMXBean = null;
            this.clock = null;
        }
    }

    protected void gatherData() {
        GcEvent latest = this.heapEvents.peekLast();
        long currentCount = this.garbageCollectorMXBean.getCollectionCount();
        if (latest == null || latest.count != currentCount) {
            this.slideAndInsert(this.heapEvents, new GcEvent(this.clock.instant(), this.heapMemoryPoolMXBean.getCollectionUsage(), currentCount));
        }
        this.slideAndInsert(this.nonHeapEvents, new GcEvent(this.clock.instant(), this.nonHeapMemoryPoolMXBean.getUsage(), -1L));
    }

    private void slideAndInsert(Deque<GcEvent> events, GcEvent event) {
        events.addLast(event);
        while (events.size() > 20) {
            events.pollFirst();
        }
    }

    public boolean isTrashing() {
        if (this.strategy != null && this.strategy.heapUsageThreshold != 0 && this.strategy.thrashingThreshold != 0.0) {
            GcStats stats = this.heapStats();
            return stats != null && stats.usedPercent >= this.strategy.heapUsageThreshold && stats.gcRate >= this.strategy.thrashingThreshold;
        }
        return false;
    }

    public boolean isHeapSpaceExhausted() {
        if (this.strategy != null && this.strategy.heapUsageThreshold != 0 && this.strategy.heapRateThreshold != 0.0) {
            GcStats stats = this.heapStats();
            return stats != null && stats.usedPercent >= this.strategy.heapUsageThreshold && stats.gcRate >= this.strategy.heapRateThreshold;
        }
        return false;
    }

    public boolean isNonHeapSpaceExhausted() {
        if (this.strategy != null && this.strategy.nonHeapUsageThreshold != 0) {
            GcStats stats = this.nonHeapStats();
            return stats != null && stats.usedPercent >= this.strategy.nonHeapUsageThreshold;
        }
        return false;
    }

    private GcStats heapStats() {
        if (this.heapEvents.size() >= 5) {
            GcEvent first = this.heapEvents.iterator().next();
            long maxSizeInBytes = first.usage.getMax();
            if (maxSizeInBytes > 0L) {
                double gcRate = this.gcRate(this.heapEvents);
                int usagePercent = (int)(this.averageUsage(this.heapEvents) * 100.0 / (double)maxSizeInBytes);
                return new GcStats(gcRate, usagePercent);
            }
        }
        return null;
    }

    private GcStats nonHeapStats() {
        if (this.nonHeapEvents.size() >= 5) {
            GcEvent first = this.heapEvents.iterator().next();
            long maxSizeInBytes = first.usage.getMax();
            if (maxSizeInBytes > 0L) {
                int usagePercent = (int)(this.averageUsage(this.nonHeapEvents) * 100.0 / (double)maxSizeInBytes);
                return new GcStats(0.0, usagePercent);
            }
        }
        return null;
    }

    private double gcRate(Deque<GcEvent> events) {
        GcEvent first = events.peekFirst();
        GcEvent last = events.peekLast();
        double gcCountDelta = last.count - first.count;
        double timeDelta = Duration.between(first.timestamp, last.timestamp).toMillis();
        return gcCountDelta / timeDelta;
    }

    private double averageUsage(Collection<GcEvent> events) {
        return events.stream().mapToLong(e -> e.usage.getUsed()).average().getAsDouble();
    }

    public static enum GcStrategy {
        ORACLE_PARALLEL_CMS("PS Old Gen", "Metaspace", "PS MarkSweep", 1.2, 80, 80, 5.0),
        ORACLE_6_CMS("CMS Old Gen", "Metaspace", "ConcurrentMarkSweep", 1.2, 80, 80, 5.0),
        ORACLE_SERIAL("Tenured Gen", "Metaspace", "MarkSweepCompact", 1.2, 80, 80, 5.0),
        ORACLE_G1("G1 Old Gen", "Metaspace", "G1 Old Generation", 0.4, 75, 80, 2.0),
        IBM_ALL("Java heap", "Not Used", "MarkSweepCompact", 0.8, 70, -1, 6.0);

        final String garbageCollector;
        final String heapMemoryPool;
        final String nonHeapMemoryPool;
        final int heapUsageThreshold;
        final double heapRateThreshold;
        final int nonHeapUsageThreshold;
        final double thrashingThreshold;

        private GcStrategy(String heapMemoryPool, String nonHeapMemoryPool, String garbageCollector, double heapRateThreshold, int heapUsageThreshold, int nonHeapUsageThreshold, double thrashingThreshold) {
            this.garbageCollector = garbageCollector;
            this.heapMemoryPool = heapMemoryPool;
            this.nonHeapMemoryPool = nonHeapMemoryPool;
            this.heapUsageThreshold = heapUsageThreshold;
            this.heapRateThreshold = heapRateThreshold;
            this.nonHeapUsageThreshold = nonHeapUsageThreshold;
            this.thrashingThreshold = thrashingThreshold;
        }
    }

    static class GcEvent {
        final Instant timestamp;
        final MemoryUsage usage;
        final long count;

        public GcEvent(Instant timestamp, MemoryUsage usage, long count) {
            this.timestamp = timestamp;
            this.usage = usage;
            this.count = count;
        }
    }

    static class GcStats {
        final double gcRate;
        final int usedPercent;

        public GcStats(double gcRate, int usedPercent) {
            this.gcRate = gcRate;
            this.usedPercent = usedPercent;
        }
    }
}

