/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.impl.atompub;

import java.math.BigInteger;
import java.util.GregorianCalendar;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.chemistry.opencmis.commons.data.ExtensionsData;
import org.apache.chemistry.opencmis.commons.impl.UrlBuilder;
import org.apache.chemistry.opencmis.commons.impl.XMLConverter;
import org.apache.chemistry.opencmis.commons.impl.XMLUtils;
import org.apache.chemistry.opencmis.server.impl.atompub.AtomDocumentBase;

public class AtomFeed
extends AtomDocumentBase {
    public static final BigInteger DEFAULT_PAGE_SIZE = BigInteger.valueOf(100L);

    public AtomFeed() {
    }

    public AtomFeed(XMLStreamWriter writer) {
        this.setWriter(writer);
    }

    public void startFeed(boolean isRoot) throws XMLStreamException {
        XMLStreamWriter xsw = this.getWriter();
        xsw.writeStartElement("atom", "feed", "http://www.w3.org/2005/Atom");
        if (isRoot) {
            xsw.writeNamespace("atom", "http://www.w3.org/2005/Atom");
            xsw.writeNamespace("cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/");
            xsw.writeNamespace("cmisra", "http://docs.oasis-open.org/ns/cmis/restatom/200908/");
            xsw.writeNamespace("app", "http://www.w3.org/2007/app");
            this.writeAllCustomNamespace();
        }
    }

    public void startChildren() throws XMLStreamException {
        XMLStreamWriter writer = this.getWriter();
        writer.writeStartElement("cmisra", "children", "http://docs.oasis-open.org/ns/cmis/restatom/200908/");
    }

    public void endChildren() throws XMLStreamException {
        this.getWriter().writeEndElement();
    }

    public void endFeed() throws XMLStreamException {
        this.getWriter().writeEndElement();
    }

    public void writeSelfLink(String href, String id) throws XMLStreamException {
        this.writeSelfLink(href, "application/atom+xml;type=feed", id);
    }

    public void writeFeedElements(String id, String atomId, String author, String title, GregorianCalendar updated, String pathSegment, BigInteger numItems) throws XMLStreamException {
        this.writeAuthor(author);
        this.writeId(atomId == null ? this.generateAtomId(id) : atomId);
        this.writeTitle(title);
        this.writeUpdated(updated);
        this.writePathSegment(pathSegment);
        this.writeNumItems(numItems);
    }

    public void writeNumItems(BigInteger numItems) throws XMLStreamException {
        XMLUtils.write((XMLStreamWriter)this.getWriter(), (String)"cmisra", (String)"http://docs.oasis-open.org/ns/cmis/restatom/200908/", (String)"numItems", (BigInteger)numItems);
    }

    public void writePagingLinks(UrlBuilder pagingUrl, BigInteger maxItems, BigInteger skipCount, BigInteger numItems, Boolean hasMoreItems, BigInteger pageSize) throws XMLStreamException {
        BigInteger lastSkip;
        if (skipCount == null || skipCount.compareTo(BigInteger.ZERO) == -1) {
            skipCount = BigInteger.ZERO;
        }
        if (maxItems == null || maxItems.compareTo(BigInteger.ZERO) == -1) {
            maxItems = pageSize == null || pageSize.compareTo(BigInteger.ZERO) == -1 ? DEFAULT_PAGE_SIZE : pageSize;
        }
        if (skipCount.compareTo(BigInteger.ZERO) == 1) {
            UrlBuilder firstLink = new UrlBuilder(pagingUrl);
            firstLink.addParameter("skipCount", (Object)"0");
            firstLink.addParameter("maxItems", (Object)maxItems);
            this.writeFirstLink(firstLink.toString());
            UrlBuilder previousLink = new UrlBuilder(pagingUrl);
            previousLink.addParameter("skipCount", (Object)skipCount.subtract(maxItems).max(BigInteger.ZERO));
            previousLink.addParameter("maxItems", (Object)maxItems);
            this.writePreviousLink(previousLink.toString());
        }
        if (Boolean.TRUE.equals(hasMoreItems)) {
            UrlBuilder nextLink = new UrlBuilder(pagingUrl);
            nextLink.addParameter("skipCount", (Object)skipCount.add(maxItems));
            nextLink.addParameter("maxItems", (Object)maxItems);
            this.writeNextLink(nextLink.toString());
        }
        if (numItems != null && numItems.compareTo(BigInteger.ZERO) == 1 && (lastSkip = numItems.subtract(maxItems).max(BigInteger.ZERO)).compareTo(BigInteger.ZERO) == 1) {
            UrlBuilder lastLink = new UrlBuilder(pagingUrl);
            lastLink.addParameter("skipCount", (Object)lastSkip);
            lastLink.addParameter("maxItems", (Object)maxItems);
            this.writeLastLink(lastLink.toString());
        }
    }

    public void writeExtensions(ExtensionsData extensions) throws XMLStreamException {
        XMLConverter.writeExtensions((XMLStreamWriter)this.getWriter(), (ExtensionsData)extensions);
    }
}

