/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.analysis_engine.service.impl;

import java.io.Serializable;
import org.apache.uima.analysis_engine.AnalysisProcessData;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.admin.CASMgr;
import org.apache.uima.cas.impl.CASCompleteSerializer;
import org.apache.uima.cas.impl.Serialization;
import org.apache.uima.util.ProcessTrace;

public class ServiceDataCargo
implements Serializable {
    private static final long serialVersionUID = 2433836175315405277L;
    private CASCompleteSerializer mCasSer;
    private ProcessTrace mProcessTrace;

    public ServiceDataCargo(AnalysisProcessData aData) {
        this.mCasSer = Serialization.serializeCASComplete((CASMgr)((Object)aData.getCAS()));
        this.mProcessTrace = aData.getProcessTrace();
    }

    public ServiceDataCargo(CAS aCAS, ProcessTrace aProcessTrace) {
        this.mCasSer = Serialization.serializeCASComplete((CASMgr)((Object)aCAS));
        this.mProcessTrace = aProcessTrace;
    }

    public void unmarshalInto(AnalysisProcessData aDataContainer, boolean aReplaceCasTypeSystem) throws CASException {
        this.unmarshalCas(aDataContainer.getCAS(), aReplaceCasTypeSystem);
        aDataContainer.getProcessTrace().addAll(this.mProcessTrace.getEvents());
    }

    public void unmarshalCas(CAS aCas, boolean aReplaceCasTypeSystem) throws CASException {
        CASMgr casMgr = (CASMgr)((Object)aCas);
        if (aReplaceCasTypeSystem) {
            Serialization.deserializeCASComplete(this.mCasSer, casMgr);
        } else {
            Serialization.createCAS(casMgr, this.mCasSer.getCASSerializer());
        }
    }

    public ProcessTrace getProcessTrace() {
        return this.mProcessTrace;
    }

    public void setProcessTrace(ProcessTrace aProcessTrace) {
        this.mProcessTrace = aProcessTrace;
    }
}

