/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.tools.fontlist;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.regex.Pattern;
import org.apache.fop.fonts.FontTriplet;
import org.apache.fop.tools.fontlist.FontSpec;
import org.apache.fop.util.GenerationHelperContentHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class FontListSerializer {
    private static final String FONTS = "fonts";
    private static final String FAMILY = "family";
    private static final String FONT = "font";
    private static final String TRIPLETS = "triplets";
    private static final String TRIPLET = "triplet";
    private static final String NAME = "name";
    private static final String STRIPPED_NAME = "stripped-name";
    private static final String TYPE = "type";
    private static final String KEY = "key";
    private static final String STYLE = "style";
    private static final String WEIGHT = "weight";
    private static final String CDATA = "CDATA";
    private final Pattern quotePattern = Pattern.compile("'");

    public void generateSAX(SortedMap fontFamilies, GenerationHelperContentHandler handler) throws SAXException {
        this.generateSAX(fontFamilies, null, handler);
    }

    public void generateSAX(SortedMap fontFamilies, String singleFamily, GenerationHelperContentHandler handler) throws SAXException {
        handler.startDocument();
        AttributesImpl atts = new AttributesImpl();
        handler.startElement(FONTS, (Attributes)atts);
        Iterator iter = fontFamilies.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String familyName = (String)entry.getKey();
            if (singleFamily != null && familyName != singleFamily) continue;
            atts.clear();
            atts.addAttribute(null, NAME, NAME, CDATA, familyName);
            atts.addAttribute(null, STRIPPED_NAME, STRIPPED_NAME, CDATA, this.stripQuotes(familyName));
            handler.startElement(FAMILY, (Attributes)atts);
            List containers = (List)entry.getValue();
            this.generateXMLForFontContainers(handler, containers);
            handler.endElement(FAMILY);
        }
        handler.endElement(FONTS);
        handler.endDocument();
    }

    private String stripQuotes(String name) {
        return this.quotePattern.matcher(name).replaceAll("");
    }

    private void generateXMLForFontContainers(GenerationHelperContentHandler handler, List containers) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        Iterator fontIter = containers.iterator();
        while (fontIter.hasNext()) {
            FontSpec cont = (FontSpec)fontIter.next();
            atts.clear();
            atts.addAttribute(null, KEY, KEY, CDATA, cont.getKey());
            atts.addAttribute(null, TYPE, TYPE, CDATA, cont.getFontMetrics().getFontType().getName());
            handler.startElement(FONT, (Attributes)atts);
            this.generateXMLForTriplets(handler, cont.getTriplets());
            handler.endElement(FONT);
        }
    }

    private void generateXMLForTriplets(GenerationHelperContentHandler handler, Collection triplets) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        atts.clear();
        handler.startElement(TRIPLETS, (Attributes)atts);
        Iterator iter = triplets.iterator();
        while (iter.hasNext()) {
            FontTriplet triplet = (FontTriplet)iter.next();
            atts.clear();
            atts.addAttribute(null, NAME, NAME, CDATA, triplet.getName());
            atts.addAttribute(null, STYLE, STYLE, CDATA, triplet.getStyle());
            atts.addAttribute(null, WEIGHT, WEIGHT, CDATA, Integer.toString(triplet.getWeight()));
            handler.element(TRIPLET, (Attributes)atts);
        }
        handler.endElement(TRIPLETS);
    }
}

