/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.common.filenet;

import com.filenet.api.admin.ClassDefinition;
import com.filenet.api.collection.AccessPermissionList;
import com.filenet.api.collection.ClassDefinitionSet;
import com.filenet.api.collection.ContentElementList;
import com.filenet.api.collection.FolderSet;
import com.filenet.api.collection.PropertyDescriptionList;
import com.filenet.api.collection.RepositoryRowSet;
import com.filenet.api.constants.AccessType;
import com.filenet.api.constants.FilteredPropertyType;
import com.filenet.api.constants.SecurityPrincipalType;
import com.filenet.api.core.Connection;
import com.filenet.api.core.ContentTransfer;
import com.filenet.api.core.Document;
import com.filenet.api.core.Domain;
import com.filenet.api.core.Factory;
import com.filenet.api.core.Folder;
import com.filenet.api.core.ObjectStore;
import com.filenet.api.core.Scope;
import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.api.meta.ClassDescription;
import com.filenet.api.meta.PropertyDescription;
import com.filenet.api.property.Properties;
import com.filenet.api.property.Property;
import com.filenet.api.property.PropertyFilter;
import com.filenet.api.query.RepositoryRow;
import com.filenet.api.query.SearchSQL;
import com.filenet.api.query.SearchScope;
import com.filenet.api.security.AccessPermission;
import com.filenet.api.security.Group;
import com.filenet.api.security.User;
import com.filenet.api.util.UserContext;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.rmi.RemoteException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.manifoldcf.crawler.common.filenet.DocumentClassDefinition;
import org.apache.manifoldcf.crawler.common.filenet.FileInfo;
import org.apache.manifoldcf.crawler.common.filenet.FilenetException;
import org.apache.manifoldcf.crawler.common.filenet.IFilenet;
import org.apache.manifoldcf.crawler.common.filenet.MetadataFieldDefinition;
import org.apache.manifoldcf.crawler.common.filenet.RMILocalClientSocketFactory;
import org.apache.manifoldcf.crawler.common.filenet.RMILocalSocketFactory;

public class FilenetImpl
extends UnicastRemoteObject
implements IFilenet {
    public static final String _rcsid = "@(#)$Id: FilenetImpl.java 988245 2010-08-23 18:39:35Z kwright $";
    private static final String PARAM_LOGIN_MODULE = "FileNetP8WSI";
    private static final String PARAM_ROOT_DOC_CLASSNAME = "Document";
    private String userID = null;
    private String password = null;
    private String serverWsiURI = null;
    private String fnDomainString = null;
    private String objectStoreName = null;
    private Connection conn = null;
    private ObjectStore os = null;
    private Domain fnDomain = null;
    private UserContext uc = null;

    public FilenetImpl() throws RemoteException {
        super(0, (RMIClientSocketFactory)new RMILocalClientSocketFactory(), (RMIServerSocketFactory)new RMILocalSocketFactory());
    }

    public void createSession(String userID, String password, String domain, String objectStore, String serverWSIURI) throws FilenetException, RemoteException {
        this.userID = userID;
        this.password = password;
        this.fnDomainString = domain;
        this.serverWsiURI = serverWSIURI;
        this.objectStoreName = objectStore;
        try {
            this.conn = Factory.Connection.getConnection((String)this.serverWsiURI);
            this.setConnectionCredentials();
            this.fnDomain = Factory.Domain.fetchInstance((Connection)this.conn, (String)this.fnDomainString, null);
            if (this.fnDomain == null) {
                throw new FilenetException("Could not locate FileNet domain '" + this.fnDomain + "'");
            }
            this.os = Factory.ObjectStore.fetchInstance((Domain)this.fnDomain, (String)this.objectStoreName, null);
            if (this.os == null) {
                throw new FilenetException("Could not locate FileNet objectstore '" + this.objectStoreName + "'");
            }
        }
        catch (EngineRuntimeException e) {
            Throwable e2 = e.getCause();
            ExceptionCode code = e.getExceptionCode();
            if (code.equals((Object)ExceptionCode.TRANSPORT_WSI_NETWORK_ERROR)) {
                throw new FilenetException("Transport error: " + e.getMessage() + (String)(e2 != null ? ": " + e2.getMessage() : ""), 0);
            }
            if (code.equals((Object)ExceptionCode.SECURITY_WSI_NO_LOGIN_MODULES_SUCCEEDED)) {
                throw new FilenetException("Login failure: " + e.getMessage() + (String)(e2 != null ? ": " + e2.getMessage() : ""), 1);
            }
            if (code.equals((Object)ExceptionCode.API_INVALID_URI)) {
                throw new FilenetException("Invalid URI error connecting to FileNet: " + e.getMessage() + (String)(e2 != null ? ": " + e2.getMessage() : "") + " This probably means your connection parameters are incorrect.", 2);
            }
            throw new FilenetException("Runtime exception connecting to FileNet: " + e.getMessage() + (String)(e2 != null ? ": " + e2.getMessage() : ""));
        }
        catch (Exception e) {
            throw new FilenetException("Exception connecting to FileNet: " + e.getMessage());
        }
    }

    public void destroySession() throws FilenetException, RemoteException {
        this.userID = null;
        this.password = null;
        this.serverWsiURI = null;
        this.fnDomainString = null;
        this.objectStoreName = null;
        this.fnDomain = null;
        this.os = null;
        this.conn = null;
    }

    public void checkConnection() throws FilenetException, RemoteException {
    }

    public String[] getChildFolders(String[] parentFolderPath) throws FilenetException, RemoteException {
        this.setConnectionCredentials();
        Folder currentFolder = this.os.get_RootFolder();
        for (int i = 0; i < parentFolderPath.length; ++i) {
            FolderSet folderSet = currentFolder.get_SubFolders();
            currentFolder = null;
            for (Folder folder : folderSet) {
                if (!folder.get_FolderName().equals(parentFolderPath[i])) continue;
                currentFolder = folder;
                break;
            }
            if (currentFolder != null) continue;
            return null;
        }
        ArrayList<String> rval = new ArrayList<String>();
        FolderSet children = currentFolder.get_SubFolders();
        for (Folder child : children) {
            rval.add(child.get_FolderName());
        }
        String[] rvalArray = new String[rval.size()];
        rval.toArray(rvalArray);
        return rvalArray;
    }

    public DocumentClassDefinition[] getDocumentClassesDetails() throws FilenetException, RemoteException {
        DocumentClassDefinition[] oDocClasses = null;
        this.setConnectionCredentials();
        ArrayList docClasses = this.getFNDocClasses(PARAM_ROOT_DOC_CLASSNAME);
        docClasses.add(new DocumentClassDefinition(PARAM_ROOT_DOC_CLASSNAME, PARAM_ROOT_DOC_CLASSNAME));
        oDocClasses = new DocumentClassDefinition[docClasses.size()];
        docClasses.toArray(oDocClasses);
        return oDocClasses;
    }

    public MetadataFieldDefinition[] getDocumentClassMetadataFieldsDetails(String documentClassName) throws FilenetException, RemoteException {
        MetadataFieldDefinition[] oProps = null;
        ArrayList<MetadataFieldDefinition> propDescs = new ArrayList<MetadataFieldDefinition>();
        PropertyDescriptionList pdescs = null;
        this.setConnectionCredentials();
        boolean i = false;
        try {
            PropertyFilter pf = new PropertyFilter();
            pf.addIncludeType(0, null, Boolean.TRUE, FilteredPropertyType.ANY, null);
            ClassDescription classDesc = Factory.ClassDescription.fetchInstance((Scope)this.os, (String)documentClassName, (PropertyFilter)pf);
            if (classDesc != null) {
                pdescs = classDesc.get_PropertyDescriptions();
                PropertyDescription propDesc2 = null;
                for (PropertyDescription propDesc2 : pdescs) {
                    MetadataFieldDefinition mdf = new MetadataFieldDefinition(propDesc2.get_DisplayName(), propDesc2.get_SymbolicName());
                    propDescs.add(mdf);
                }
            }
        }
        catch (EngineRuntimeException e) {
            Throwable e2 = e.getCause();
            throw new FilenetException("Runtime exception getting document class properties: " + e.getMessage() + (String)(e2 != null ? ": " + e2.getMessage() : ""));
        }
        catch (Exception e) {
            throw new FilenetException("FileNet exception getting document class properties: " + e.getMessage());
        }
        oProps = new MetadataFieldDefinition[propDescs.size()];
        propDescs.toArray(oProps);
        return oProps;
    }

    public String[] getMatchingObjectIds(String sql) throws RemoteException, FilenetException {
        String docId;
        this.setConnectionCredentials();
        HashMap<String, String> docIds = new HashMap<String, String>();
        SearchSQL sqlObject = new SearchSQL();
        sqlObject.setQueryString(sql);
        SearchScope searchScope = new SearchScope(this.os);
        try {
            RepositoryRowSet rowSet = searchScope.fetchRows(sqlObject, null, null, new Boolean(true));
            for (RepositoryRow row : rowSet) {
                docId = row.getProperties().get("Id").getIdValue().toString();
                docIds.put(docId, docId);
            }
        }
        catch (EngineRuntimeException e) {
            Throwable e2 = e.getCause();
            ExceptionCode code = e.getExceptionCode();
            if (code.equals((Object)ExceptionCode.TRANSPORT_WSI_NETWORK_ERROR)) {
                throw new FilenetException("Transport error: " + e.getMessage() + (String)(e2 != null ? ": " + e2.getMessage() : ""), 0);
            }
            if (code.equals((Object)ExceptionCode.SECURITY_WSI_NO_LOGIN_MODULES_SUCCEEDED)) {
                throw new FilenetException("Login failure: " + e.getMessage() + (String)(e2 != null ? ": " + e2.getMessage() : ""), 1);
            }
            if (code.equals((Object)ExceptionCode.E_ACCESS_DENIED)) {
                throw new FilenetException("Access denied getting document information: " + e.getMessage() + (String)(e2 != null ? ": " + e2.getMessage() : ""), 3);
            }
            throw new FilenetException("Runtime exception getting matching object ids: " + e.getMessage() + (String)(e2 != null ? ": " + e2.getMessage() : ""));
        }
        catch (Exception e) {
            throw new FilenetException("Query failed: '" + sql + "':" + e.getMessage(), (Throwable)e);
        }
        String[] rval = new String[docIds.size()];
        Iterator iter = docIds.keySet().iterator();
        int i = 0;
        while (iter.hasNext()) {
            rval[i] = docId = (String)iter.next();
            ++i;
        }
        return rval;
    }

    public Integer getDocumentContentCount(String docId) throws RemoteException, FilenetException {
        this.setConnectionCredentials();
        try {
            Document doc = Factory.Document.fetchInstance((ObjectStore)this.os, (String)docId, null);
            if (doc == null) {
                return null;
            }
            ContentElementList elements = doc.get_ContentElements();
            int count = elements.size();
            return new Integer(count);
        }
        catch (EngineRuntimeException e) {
            Throwable e2 = e.getCause();
            ExceptionCode code = e.getExceptionCode();
            if (code.equals((Object)ExceptionCode.TRANSPORT_WSI_NETWORK_ERROR)) {
                throw new FilenetException("Transport error: " + e.getMessage() + (String)(e2 != null ? ": " + e2.getMessage() : ""), 0);
            }
            if (code.equals((Object)ExceptionCode.SECURITY_WSI_NO_LOGIN_MODULES_SUCCEEDED)) {
                throw new FilenetException("Login failure: " + e.getMessage() + (String)(e2 != null ? ": " + e2.getMessage() : ""), 1);
            }
            if (code.equals((Object)ExceptionCode.E_ACCESS_DENIED)) {
                throw new FilenetException("Access denied getting content information: " + e.getMessage() + (String)(e2 != null ? ": " + e2.getMessage() : ""), 3);
            }
            if (code.equals((Object)ExceptionCode.API_NO_CONTENT_ELEMENTS)) {
                return new Integer(0);
            }
            if (code.equals((Object)ExceptionCode.E_OBJECT_NOT_FOUND)) {
                return null;
            }
            throw new FilenetException("Runtime exception getting content information: " + e.getMessage() + (String)(e2 != null ? ": " + e2.getMessage() : ""));
        }
        catch (Exception e) {
            throw new FilenetException("Content count request failed: '" + docId + "':" + e.getMessage(), (Throwable)e);
        }
    }

    public FileInfo getDocumentInformation(String docId, Map<String, Object> metadataFields) throws FilenetException, RemoteException {
        this.setConnectionCredentials();
        try {
            Document doc = Factory.Document.fetchInstance((ObjectStore)this.os, (String)docId, null);
            if (doc == null) {
                return null;
            }
            if (!doc.get_IsCurrentVersion().booleanValue()) {
                return null;
            }
            String docClass = doc.getClassName();
            FileInfo rval = new FileInfo(docClass);
            Object metadataObject = metadataFields.get(docClass);
            if (metadataObject != null && metadataObject instanceof Boolean) {
                Properties props = doc.getProperties();
                for (Property prop : props) {
                    String sPropName = prop.getPropertyName();
                    Object objPropVal = prop.getObjectValue();
                    if (objPropVal == null) continue;
                    rval.addMetadataValue(sPropName, objPropVal.toString());
                }
            } else if (metadataObject != null) {
                String[] fields = (String[])metadataObject;
                for (int j = 0; j < fields.length; ++j) {
                    String sPropName = fields[j];
                    try {
                        Object objPropVal = doc.getProperties().getObjectValue(sPropName);
                        if (objPropVal == null) continue;
                        rval.addMetadataValue(sPropName, objPropVal.toString());
                        continue;
                    }
                    catch (Exception objPropVal) {
                        // empty catch block
                    }
                }
            } else {
                return null;
            }
            AccessPermissionList apl = doc.get_Permissions();
            for (AccessPermission ap : apl) {
                int tmp;
                AccessType at = ap.get_AccessType();
                int atval = at.getValue();
                int am = ap.get_AccessMask();
                if ((am & (tmp = 131201)) != tmp || atval != 1 && atval != 2) continue;
                String gname = ap.get_GranteeName();
                if (!gname.equals("#AUTHENTICATED-USERS")) {
                    String sid;
                    SecurityPrincipalType gtype = ap.get_GranteeType();
                    if (gtype.getValue() == 2000) {
                        User usr = Factory.User.fetchInstance((Connection)this.conn, (String)gname, null);
                        if (usr == null) continue;
                        sid = usr.get_Id();
                        if (atval == 1) {
                            rval.addAclValue(sid);
                            continue;
                        }
                        if (atval != 2) continue;
                        rval.addDenyAclValue(sid);
                        continue;
                    }
                    Group grp = Factory.Group.fetchInstance((Connection)this.conn, (String)gname, null);
                    if (grp == null) continue;
                    sid = grp.get_Id();
                    if (atval == 1) {
                        rval.addAclValue(sid);
                        continue;
                    }
                    if (atval != 2) continue;
                    rval.addDenyAclValue(sid);
                    continue;
                }
                if (atval == 1) {
                    rval.addAclValue("S-1-1-0");
                    continue;
                }
                if (atval != 2) continue;
                rval.addDenyAclValue("S-1-1-0");
            }
            return rval;
        }
        catch (EngineRuntimeException e) {
            Throwable e2 = e.getCause();
            ExceptionCode code = e.getExceptionCode();
            if (code.equals((Object)ExceptionCode.E_OBJECT_NOT_FOUND)) {
                return null;
            }
            if (code.equals((Object)ExceptionCode.TRANSPORT_WSI_NETWORK_ERROR)) {
                throw new FilenetException("Transport error: " + e.getMessage() + (String)(e2 != null ? ": " + e2.getMessage() : ""), 0);
            }
            if (code.equals((Object)ExceptionCode.SECURITY_WSI_NO_LOGIN_MODULES_SUCCEEDED)) {
                throw new FilenetException("Login failure: " + e.getMessage() + (String)(e2 != null ? ": " + e2.getMessage() : ""), 1);
            }
            if (code.equals((Object)ExceptionCode.E_ACCESS_DENIED)) {
                throw new FilenetException("Access denied getting document information: " + e.getMessage() + (String)(e2 != null ? ": " + e2.getMessage() : ""), 3);
            }
            throw new FilenetException("Runtime exception getting document information: " + e.getMessage() + (String)(e2 != null ? ": " + e2.getMessage() : ""));
        }
        catch (Exception e) {
            throw new FilenetException("Get document information failed:" + e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getDocumentContents(String docId, int elementNumber, String tempFileName) throws FilenetException, RemoteException {
        block24: {
            this.setConnectionCredentials();
            try {
                Document doc = Factory.Document.fetchInstance((ObjectStore)this.os, (String)docId, null);
                if (doc != null) {
                    ContentElementList elements = doc.get_ContentElements();
                    Iterator iter = elements.iterator();
                    ContentTransfer element = null;
                    int i = 0;
                    while (iter.hasNext()) {
                        element = (ContentTransfer)iter.next();
                        if (i == elementNumber) break;
                        ++i;
                    }
                    if (element == null) {
                        throw new FilenetException("Could not locate element " + Integer.toString(elementNumber) + " in document '" + docId + "'");
                    }
                    File f = new File(tempFileName);
                    InputStream is = element.accessContentStream();
                    try (FileOutputStream os = new FileOutputStream(f);){
                        byte[] byteBuffer = new byte[65536];
                        while (true) {
                            int amt;
                            if ((amt = is.read(byteBuffer)) == -1) {
                                break block24;
                            }
                            ((OutputStream)os).write(byteBuffer, 0, amt);
                        }
                    }
                    catch (IOException e) {
                        f.delete();
                        throw new FilenetException("Could not read file from FileNet for document '" + docId + "': " + e.getMessage(), (Throwable)e);
                    }
                    finally {
                        try {
                            is.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                throw new FilenetException("Unknown file: '" + docId + "'");
            }
            catch (EngineRuntimeException e) {
                Throwable e2 = e.getCause();
                ExceptionCode code = e.getExceptionCode();
                if (code.equals((Object)ExceptionCode.E_OBJECT_NOT_FOUND)) {
                    throw new FilenetException("File not found: '" + docId + "'");
                }
                if (code.equals((Object)ExceptionCode.TRANSPORT_WSI_NETWORK_ERROR)) {
                    throw new FilenetException("Transport error: " + e.getMessage() + (String)(e2 != null ? ": " + e2.getMessage() : ""), 0);
                }
                if (code.equals((Object)ExceptionCode.SECURITY_WSI_NO_LOGIN_MODULES_SUCCEEDED)) {
                    throw new FilenetException("Login failure: " + e.getMessage() + (String)(e2 != null ? ": " + e2.getMessage() : ""), 1);
                }
                if (code.equals((Object)ExceptionCode.E_ACCESS_DENIED)) {
                    throw new FilenetException("Access denied getting document contents: " + e.getMessage() + (String)(e2 != null ? ": " + e2.getMessage() : ""), 3);
                }
                throw new FilenetException("Runtime exception getting document contents: " + e.getMessage() + (String)(e2 != null ? ": " + e2.getMessage() : ""));
            }
            catch (Exception e) {
                throw new FilenetException("Get document contents failed:" + e.getMessage(), (Throwable)e);
            }
        }
    }

    protected void setConnectionCredentials() {
        this.uc = UserContext.get();
        this.uc.pushSubject(UserContext.createSubject((Connection)this.conn, (String)this.userID, (String)this.password, (String)PARAM_LOGIN_MODULE));
    }

    protected ArrayList getFNDocClasses(String rootClass) throws FilenetException {
        ArrayList<DocumentClassDefinition> al = new ArrayList<DocumentClassDefinition>();
        try {
            ClassDefinition classDef = Factory.ClassDefinition.fetchInstance((ObjectStore)this.os, (String)rootClass, null);
            ClassDefinitionSet cds = classDef.get_ImmediateSubclassDefinitions();
            ClassDefinition clsDesc = null;
            Iterator iter = cds.iterator();
            if (iter != null) {
                while (iter.hasNext()) {
                    clsDesc = (ClassDefinition)iter.next();
                    al.addAll(this.getFNDocClasses(clsDesc.get_SymbolicName()));
                    DocumentClassDefinition dc = new DocumentClassDefinition(clsDesc.get_DisplayName(), clsDesc.get_SymbolicName());
                    al.add(dc);
                }
            }
        }
        catch (EngineRuntimeException e) {
            Throwable e2 = e.getCause();
            throw new FilenetException("Runtime exception getting FileNet class definition details: " + e.getMessage() + (String)(e2 != null ? ": " + e2.getMessage() : ""));
        }
        catch (Exception e) {
            throw new FilenetException("Exception getting FileNet class definition details: " + e.getMessage());
        }
        return al;
    }
}

