/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.jettyrunner;

import java.io.File;
import org.apache.manifoldcf.agents.system.AgentsDaemon;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.ThreadContextFactory;
import org.apache.manifoldcf.crawler.system.Logging;
import org.apache.manifoldcf.crawler.system.ManifoldCF;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.server.handler.ShutdownHandler;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.xml.XmlConfiguration;

public class ManifoldCFJettyRunner {
    public static final String _rcsid = "@(#)$Id: ManifoldCFJettyRunner.java 989983 2010-08-27 00:10:12Z kwright $";
    public static final String crawlerUIWarPathProperty = "org.apache.manifoldcf.crawleruiwarpath";
    public static final String authorityServiceWarPathProperty = "org.apache.manifoldcf.authorityservicewarpath";
    public static final String apiServiceWarPathProperty = "org.apache.manifoldcf.apiservicewarpath";
    public static final String useJettyParentClassLoaderProperty = "org.apache.manifoldcf.usejettyparentclassloader";
    public static final String jettyConfigFileProperty = "org.apache.manifoldcf.jettyconfigfile";
    protected Server server;

    public ManifoldCFJettyRunner(File configFile, String crawlerWarPath, String authorityServiceWarPath, String apiWarPath, boolean useParentLoader) throws Exception {
        Resource fileserverXml = Resource.newResource((File)configFile.getCanonicalFile());
        XmlConfiguration configuration = new XmlConfiguration(fileserverXml.getInputStream());
        this.server = (Server)configuration.configure();
        this.initializeServer(crawlerWarPath, authorityServiceWarPath, apiWarPath, useParentLoader);
    }

    public ManifoldCFJettyRunner(int port, String crawlerWarPath, String authorityServiceWarPath, String apiWarPath, boolean useParentLoader) {
        Server server = new Server(port);
        this.initializeServer(crawlerWarPath, authorityServiceWarPath, apiWarPath, useParentLoader);
    }

    protected void initializeServer(String crawlerWarPath, String authorityServiceWarPath, String apiWarPath, boolean useParentLoader) {
        this.server.setStopAtShutdown(true);
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        WebAppContext lcfCrawlerUI = new WebAppContext(crawlerWarPath, "/mcf-crawler-ui");
        lcfCrawlerUI.setParentLoaderPriority(useParentLoader);
        contexts.addHandler((Handler)lcfCrawlerUI);
        WebAppContext lcfAuthorityService = new WebAppContext(authorityServiceWarPath, "/mcf-authority-service");
        lcfAuthorityService.setParentLoaderPriority(useParentLoader);
        contexts.addHandler((Handler)lcfAuthorityService);
        WebAppContext lcfApi = new WebAppContext(apiWarPath, "/mcf-api-service");
        lcfApi.setParentLoaderPriority(useParentLoader);
        contexts.addHandler((Handler)lcfApi);
        HandlerList handlers = new HandlerList();
        handlers.addHandler((Handler)contexts);
        String shutdownToken = System.getProperty("org.apache.manifoldcf.jettyshutdowntoken");
        if (shutdownToken != null) {
            ShutdownHandler shutdown = new ShutdownHandler(shutdownToken);
            shutdown.setExitJvm(true);
            handlers.addHandler((Handler)shutdown);
        }
        this.server.setHandler((Handler)handlers);
    }

    public void start() throws ManifoldCFException {
        if (!this.server.isRunning()) {
            try {
                this.server.start();
            }
            catch (Exception e) {
                throw new ManifoldCFException("Couldn't start: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public void stop() throws ManifoldCFException {
        if (this.server.isRunning()) {
            try {
                this.server.stop();
            }
            catch (Exception e) {
                throw new ManifoldCFException("Couldn't stop: " + e.getMessage(), (Throwable)e);
            }
            try {
                this.server.join();
            }
            catch (InterruptedException e) {
                throw new ManifoldCFException(e.getMessage(), (Throwable)e, 2);
            }
        }
    }

    public int getLocalPort() throws ManifoldCFException {
        ServerConnector[] conns = (ServerConnector[])this.server.getConnectors();
        if (0 == conns.length) {
            throw new ManifoldCFException("Jetty Server has no Connectors");
        }
        return conns[0].getLocalPort();
    }

    public static void runAgents(IThreadContext tc) throws ManifoldCFException {
        String processID = ManifoldCF.getProcessID();
        AgentsDaemon ad = new AgentsDaemon(processID);
        ad.registerAgentsShutdownHook(tc);
        ad.runAgents(tc);
    }

    public static void main(String[] args) {
        block16: {
            if (args.length != 4 && args.length != 1 && args.length != 0) {
                System.err.println("Usage: ManifoldCFJettyRunner [<jetty-config-file> [<crawler-war-path> <authority-service-war-path> <api-war-path>]]");
                System.exit(1);
            }
            if (System.getProperty("org.apache.manifoldcf.configfile") == null) {
                System.setProperty("org.apache.manifoldcf.configfile", "./properties.xml");
            }
            try {
                IThreadContext tc = ThreadContextFactory.make();
                ManifoldCF.initializeEnvironment((IThreadContext)tc);
                File crawlerWarPath = ManifoldCF.getFileProperty((String)crawlerUIWarPathProperty);
                File authorityserviceWarPath = ManifoldCF.getFileProperty((String)authorityServiceWarPathProperty);
                File apiWarPath = ManifoldCF.getFileProperty((String)apiServiceWarPathProperty);
                boolean useParentClassLoader = ManifoldCF.getBooleanProperty((String)useJettyParentClassLoaderProperty, (boolean)true);
                File jettyConfigFile = ManifoldCF.getFileProperty((String)jettyConfigFileProperty);
                if (jettyConfigFile == null) {
                    jettyConfigFile = new File("./jetty.xml");
                }
                if (args.length == 4) {
                    crawlerWarPath = new File(args[1]);
                    authorityserviceWarPath = new File(args[2]);
                    apiWarPath = new File(args[3]);
                } else {
                    if (crawlerWarPath == null) {
                        throw new ManifoldCFException("The property 'org.apache.manifoldcf.crawleruiwarpath' must be set");
                    }
                    if (authorityserviceWarPath == null) {
                        throw new ManifoldCFException("The property 'org.apache.manifoldcf.authorityservicewarpath' must be set");
                    }
                    if (apiWarPath == null) {
                        throw new ManifoldCFException("The property 'org.apache.manifoldcf.apiservicewarpath' must be set");
                    }
                }
                if (useParentClassLoader) {
                    AgentsDaemon.clearAgentsShutdownSignal((IThreadContext)tc);
                    ManifoldCF.createSystemDatabase((IThreadContext)tc);
                    ManifoldCF.installTables((IThreadContext)tc);
                    ManifoldCF.registerThisAgent((IThreadContext)tc);
                    ManifoldCF.reregisterAllConnectors((IThreadContext)tc);
                }
                System.err.println("Starting jetty...");
                ManifoldCFJettyRunner jetty = new ManifoldCFJettyRunner(jettyConfigFile, crawlerWarPath.toString(), authorityserviceWarPath.toString(), apiWarPath.toString(), useParentClassLoader);
                jetty.start();
                System.err.println("Jetty started.");
                if (useParentClassLoader) {
                    System.err.println("Starting crawler...");
                    ManifoldCFJettyRunner.runAgents(tc);
                    System.err.println("Shutting down crawler...");
                    break block16;
                }
                try {
                    while (true) {
                        Thread.sleep(5000L);
                    }
                }
                catch (InterruptedException e) {
                }
            }
            catch (Exception e) {
                if (Logging.root != null) {
                    Logging.root.error((Object)("Exception: " + e.getMessage()), (Throwable)e);
                }
                e.printStackTrace(System.err);
                System.exit(1);
            }
        }
    }
}

