/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.feature;

import org.apache.sis.geometry.GeneralEnvelope;
import org.apache.sis.internal.feature.GeometryWrapper;
import org.apache.sis.util.ArgumentChecks;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public abstract class GeometryWithCRS<G>
extends GeometryWrapper<G> {
    private CoordinateReferenceSystem crs;

    protected GeometryWithCRS() {
    }

    @Override
    public final CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.crs;
    }

    @Override
    public final void setCoordinateReferenceSystem(CoordinateReferenceSystem coordinateReferenceSystem) {
        ArgumentChecks.ensureDimensionMatches("crs", 2, coordinateReferenceSystem);
        this.crs = coordinateReferenceSystem;
    }

    @Override
    public final boolean isSameCRS(GeometryWrapper<G> geometryWrapper) {
        return this.crs == ((GeometryWithCRS)geometryWrapper).crs;
    }

    protected final GeneralEnvelope createEnvelope() {
        return this.crs != null ? new GeneralEnvelope(this.crs) : new GeneralEnvelope(2);
    }
}

