/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.jettyrunner;

import java.io.File;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.ThreadContextFactory;
import org.apache.manifoldcf.crawler.system.Logging;
import org.apache.manifoldcf.crawler.system.ManifoldCF;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.server.handler.ShutdownHandler;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.xml.XmlConfiguration;

public class ManifoldCFCombinedJettyRunner {
    public static final String _rcsid = "@(#)$Id: ManifoldCFCombinedJettyRunner.java 1629122 2014-10-03 06:55:33Z kwright $";
    public static final String combinedWarPathProperty = "org.apache.manifoldcf.combinedwarpath";
    public static final String jettyConfigFileProperty = "org.apache.manifoldcf.jettyconfigfile";
    protected Server server;

    public ManifoldCFCombinedJettyRunner(File configFile, String combinedWarPath) throws Exception {
        Resource fileserverXml = Resource.newResource((File)configFile.getCanonicalFile());
        XmlConfiguration configuration = new XmlConfiguration(fileserverXml.getInputStream());
        this.server = (Server)configuration.configure();
        this.initializeServer(combinedWarPath);
    }

    public ManifoldCFCombinedJettyRunner(int port, String combinedWarPath) {
        this.server = new Server(port);
        this.initializeServer(combinedWarPath);
    }

    protected void initializeServer(String combinedWarPath) {
        this.server.setStopAtShutdown(true);
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        WebAppContext mcfCombined = new WebAppContext(combinedWarPath, "/mcf");
        mcfCombined.setParentLoaderPriority(false);
        contexts.addHandler((Handler)mcfCombined);
        HandlerList handlers = new HandlerList();
        handlers.addHandler((Handler)contexts);
        String shutdownToken = System.getProperty("org.apache.manifoldcf.jettyshutdowntoken");
        if (shutdownToken != null) {
            ShutdownHandler shutdown = new ShutdownHandler(shutdownToken);
            shutdown.setExitJvm(true);
            handlers.addHandler((Handler)shutdown);
        }
        this.server.setHandler((Handler)handlers);
    }

    public void start() throws ManifoldCFException {
        if (!this.server.isRunning()) {
            try {
                this.server.start();
            }
            catch (Exception e) {
                throw new ManifoldCFException("Couldn't start: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public void stop() throws ManifoldCFException {
        if (this.server.isRunning()) {
            try {
                this.server.stop();
            }
            catch (Exception e) {
                throw new ManifoldCFException("Couldn't stop: " + e.getMessage(), (Throwable)e);
            }
            try {
                this.server.join();
            }
            catch (InterruptedException e) {
                throw new ManifoldCFException(e.getMessage(), (Throwable)e, 2);
            }
        }
    }

    public int getLocalPort() throws ManifoldCFException {
        ServerConnector[] conns = (ServerConnector[])this.server.getConnectors();
        if (0 == conns.length) {
            throw new ManifoldCFException("Jetty Server has no Connectors");
        }
        return conns[0].getLocalPort();
    }

    public static void main(String[] args) {
        if (args.length != 2 && args.length != 1 && args.length != 0) {
            System.err.println("Usage: ManifoldCFCombinedJettyRunner [<port> [<combined-war-path>]]");
            System.exit(1);
        }
        if (System.getProperty("org.apache.manifoldcf.configfile") == null) {
            System.setProperty("org.apache.manifoldcf.configfile", "./properties.xml");
        }
        try {
            IThreadContext tc = ThreadContextFactory.make();
            ManifoldCF.initializeEnvironment((IThreadContext)tc);
            File combinedWarPath = ManifoldCF.getFileProperty((String)combinedWarPathProperty);
            File jettyConfigFile = ManifoldCF.getFileProperty((String)jettyConfigFileProperty);
            if (jettyConfigFile == null) {
                jettyConfigFile = new File("./jetty.xml");
            }
            if (args.length == 2) {
                combinedWarPath = new File(args[1]);
            } else if (combinedWarPath == null) {
                throw new ManifoldCFException("The property 'org.apache.manifoldcf.combinedwarpath' must be set");
            }
            System.err.println("Starting jetty...");
            ManifoldCFCombinedJettyRunner jetty = new ManifoldCFCombinedJettyRunner(jettyConfigFile, combinedWarPath.toString());
            jetty.start();
            System.err.println("Jetty started.");
            try {
                while (true) {
                    Thread.sleep(5000L);
                }
            }
            catch (InterruptedException e) {
            }
        }
        catch (Exception e) {
            if (Logging.root != null) {
                Logging.root.error((Object)("Exception: " + e.getMessage()), (Throwable)e);
            }
            e.printStackTrace(System.err);
            System.exit(1);
        }
    }
}

