/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.connectors.solr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.auth.Credentials;
import org.apache.http.client.HttpClient;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultRedirectStrategy;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestExecutor;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.apache.http.util.EntityUtils;
import org.apache.manifoldcf.agents.interfaces.RepositoryDocument;
import org.apache.manifoldcf.agents.interfaces.ServiceInterruption;
import org.apache.manifoldcf.connectorcommon.common.XThreadStringBuffer;
import org.apache.manifoldcf.core.interfaces.ConfigParams;
import org.apache.manifoldcf.core.interfaces.ConfigurationNode;
import org.apache.manifoldcf.core.interfaces.IHTTPOutput;
import org.apache.manifoldcf.core.interfaces.IPostParameters;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.Specification;
import org.apache.manifoldcf.core.interfaces.SpecificationNode;
import org.apache.manifoldcf.core.system.ManifoldCF;
import org.apache.manifoldcf.core.util.URLEncoder;
import org.apache.manifoldcf.crawler.connectors.BaseRepositoryConnector;
import org.apache.manifoldcf.crawler.connectors.solr.Messages;
import org.apache.manifoldcf.crawler.interfaces.IExistingVersions;
import org.apache.manifoldcf.crawler.interfaces.IProcessActivity;
import org.apache.manifoldcf.crawler.interfaces.ISeedingActivity;
import org.apache.manifoldcf.crawler.system.Logging;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.params.SolrParams;

public class SolrIngesterConnector
extends BaseRepositoryConnector {
    public static final String _rcsid = "@(#)$Id: solringesterConnector.java 994959 2010-09-08 10:04:42Z redguy $";
    private static final String ACTION_PARAM_NAME = "action";
    private static final String ACTION_CHECK = "check";
    private static final String ACTION_SEED = "seed";
    private static final String ACTION_ITEMS = "items";
    private static final String ACTION_ITEM = "item";
    private int connectionTimeout = -1;
    private int socketTimeout = -1;
    private long sessionTimeout = -1L;
    protected static final long sessionExpirationInterval = 300000L;
    private String solringesterLogin = null;
    private String solringesterPassword = null;
    private HttpClientConnectionManager connectionManager = null;
    private HttpClientBuilder builder = null;
    private CloseableHttpClient httpClient = null;
    private HttpSolrClient httpSolrClient = null;
    private String connectionTimeoutString = null;
    private String socketTimeoutString = null;
    private String solringesterEntryPoint = null;
    private static final String date_target_field = "last_modified";
    private static final String versionField = "_version_";
    protected static final String RELATIONSHIP_RELATED = "related";
    private static final String EDIT_CONFIGURATION_CONNECTOR_JS = "editConfiguration_connector.js";
    private static final String EDIT_CONFIGURATION_CONNECTOR_HTML = "editConfiguration_connector.html";
    private static final String VIEW_CONFIGURATION_CONNECTOR_HTML = "viewConfiguration_connector.html";
    private static final String EDIT_SPECIFICATION_JOB_PARAMETERS_JS = "editSpecification_job_parameters.js";
    private static final String EDIT_SPECIFICATION_JOB_PARAMETERS_HTML = "editSpecification_job_parameters.html";
    private static final String VIEW_SPECIFICATION_JOB_PARAMETERS_HTML = "viewSpecification_job_parameters.html";
    private static final String EDIT_SPECIFICATION_JOB_SECURITY_JS = "editSpecification_job_security.js";
    private static final String EDIT_SPECIFICATION_JOB_SECURITY_HTML = "editSpecification_job_security.html";
    private static final String VIEW_SPECIFICATION_JOB_SECURITY_HTML = "viewSpecification_job_security.html";
    protected static final String ACTIVITY_GET = "get document";

    public int getMaxDocumentRequest() {
        return 1;
    }

    public String[] getRelationshipTypes() {
        return new String[]{RELATIONSHIP_RELATED};
    }

    public int getConnectorModel() {
        return 2;
    }

    public String[] getActivitiesList() {
        return new String[]{ACTIVITY_GET};
    }

    public String[] getBinNames(String documentIdentifier) {
        return new String[]{this.solringesterEntryPoint};
    }

    public void connect(ConfigParams configParams) {
        super.connect(configParams);
        this.solringesterEntryPoint = configParams.getParameter("solrAddress");
        this.solringesterLogin = configParams.getParameter("solrUsername");
        this.solringesterPassword = "";
        try {
            this.solringesterPassword = ManifoldCF.deobfuscate((String)configParams.getParameter("solrPassword"));
        }
        catch (ManifoldCFException manifoldCFException) {
            // empty catch block
        }
        this.connectionTimeoutString = configParams.getParameter("connectionTimeout");
        this.socketTimeoutString = configParams.getParameter("socketTimeout");
        if (Logging.connectors.isDebugEnabled()) {
            Logging.connectors.debug((Object)("SolrIngester: Connection to '" + this.solringesterEntryPoint + "'"));
        }
    }

    public void disconnect() throws ManifoldCFException {
        this.socketTimeoutString = null;
        this.connectionTimeoutString = null;
        this.sessionTimeout = -1L;
        this.httpClient = null;
        this.httpSolrClient = null;
        if (this.connectionManager != null) {
            this.connectionManager.shutdown();
        }
        this.connectionManager = null;
        this.solringesterLogin = null;
        this.solringesterPassword = null;
        this.solringesterEntryPoint = null;
        super.disconnect();
    }

    protected void expireSession() throws ManifoldCFException {
        this.httpClient = null;
        this.httpSolrClient = null;
        if (this.connectionManager != null) {
            this.connectionManager.shutdown();
        }
        this.connectionManager = null;
        this.sessionTimeout = -1L;
    }

    public void poll() throws ManifoldCFException {
        if (System.currentTimeMillis() >= this.sessionTimeout) {
            this.expireSession();
        }
        if (this.connectionManager != null) {
            this.connectionManager.closeIdleConnections(60000L, TimeUnit.MILLISECONDS);
        }
    }

    protected void getSession() throws ManifoldCFException {
        if (this.sessionTimeout == -1L) {
            try {
                this.connectionTimeout = Integer.parseInt(this.connectionTimeoutString);
            }
            catch (NumberFormatException e) {
                throw new ManifoldCFException("Bad connection timeout number: " + this.connectionTimeoutString);
            }
            try {
                this.socketTimeout = Integer.parseInt(this.socketTimeoutString);
            }
            catch (NumberFormatException e) {
                throw new ManifoldCFException("Bad socket timeout number: " + this.socketTimeoutString);
            }
            TrustStrategy acceptingTrustStrategy = (cert, authType) -> true;
            SSLConnectionSocketFactory sslsf = SSLConnectionSocketFactory.getSocketFactory();
            try {
                SSLContext sslContext = SSLContexts.custom().loadTrustMaterial(null, acceptingTrustStrategy).build();
                sslsf = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            }
            catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
                throw new ManifoldCFException("SSL context initialization failure", (Throwable)e);
            }
            PoolingHttpClientConnectionManager poolingConnectionManager = new PoolingHttpClientConnectionManager(RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)sslsf).build());
            poolingConnectionManager.setDefaultMaxPerRoute(1);
            poolingConnectionManager.setValidateAfterInactivity(2000);
            poolingConnectionManager.setDefaultSocketConfig(SocketConfig.custom().setTcpNoDelay(true).setSoTimeout(this.socketTimeout).build());
            this.connectionManager = poolingConnectionManager;
            RequestConfig.Builder requestBuilder = RequestConfig.custom().setCircularRedirectsAllowed(true).setSocketTimeout(this.socketTimeout).setExpectContinueEnabled(false).setConnectTimeout(this.connectionTimeout).setConnectionRequestTimeout(this.socketTimeout);
            ArrayList<BasicHeader> headers = new ArrayList<BasicHeader>();
            if (this.solringesterLogin != null && !this.solringesterLogin.isEmpty() && this.solringesterPassword != null) {
                String auth = this.solringesterLogin + ":" + this.solringesterPassword;
                String encodedAuth = Base64.getEncoder().encodeToString(auth.getBytes(StandardCharsets.ISO_8859_1));
                String authHeader = "Basic " + new String(encodedAuth);
                BasicHeader basicAuthheader = new BasicHeader("Authorization", authHeader);
                headers.add(basicAuthheader);
            }
            this.builder = HttpClients.custom().setDefaultHeaders(headers).setConnectionManager(this.connectionManager).disableAutomaticRetries().setDefaultRequestConfig(requestBuilder.build());
            this.builder.setRequestExecutor(new HttpRequestExecutor(this.socketTimeout)).setRedirectStrategy((RedirectStrategy)new DefaultRedirectStrategy());
            this.httpClient = this.builder.build();
            this.httpSolrClient = ((HttpSolrClient.Builder)((HttpSolrClient.Builder)((HttpSolrClient.Builder)new HttpSolrClient.Builder(this.solringesterEntryPoint).withHttpClient((HttpClient)this.httpClient)).withConnectionTimeout(this.connectionTimeout)).withSocketTimeout(this.socketTimeout)).build();
        }
        this.sessionTimeout = System.currentTimeMillis() + 300000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String check() throws ManifoldCFException {
        this.getSession();
        HttpGet httpGet = new HttpGet(this.solringesterEntryPoint);
        CloseableHttpResponse response = null;
        try {
            try {
                response = this.httpClient.execute((HttpUriRequest)httpGet);
            }
            catch (IOException e) {
                String string = "Connection error: " + e.getMessage();
                if (response != null) {
                    try {
                        response.close();
                    }
                    catch (IOException e2) {
                        return "Connection error: " + e2.getMessage();
                    }
                }
                return string;
            }
            int responseCode = response.getStatusLine().getStatusCode();
            if (responseCode != 200) {
                String string = "Bad response: " + response.getStatusLine();
                return string;
            }
            String string = super.check();
            return string;
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException e) {
                    return "Connection error: " + e.getMessage();
                }
            }
        }
    }

    public String addSeedDocuments(ISeedingActivity activities, Specification spec, String lastSeedVersion, long seedTime, int jobMode) throws ManifoldCFException, ServiceInterruption {
        long dateSolr;
        String idFieldName = null;
        String collection = null;
        String dateField = null;
        Object contentField = null;
        String rowsNumberString = null;
        String filter = null;
        if (Logging.connectors.isDebugEnabled()) {
            Logging.connectors.debug((Object)("SolrIngester: Connection to '" + this.solringesterEntryPoint + "'"));
        }
        for (int l = 0; l < spec.getChildCount(); ++l) {
            SpecificationNode sn = spec.getChild(l);
            if (sn.getType() == "collection") {
                collection = sn.getAttributeValue("value");
            }
            if (sn.getType() == "fieldid") {
                idFieldName = sn.getAttributeValue("value");
            }
            if (sn.getType() == "rowsnumber") {
                rowsNumberString = sn.getAttributeValue("value");
            }
            if (sn.getType() == "fielddate") {
                dateField = sn.getAttributeValue("value");
            }
            if (sn.getType() != "filter") continue;
            filter = sn.getAttributeValue("value");
        }
        long startTime = lastSeedVersion == null ? 0L : new Long(lastSeedVersion);
        this.getSession();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.ROOT);
        sdf.setTimeZone(TimeZone.getDefault());
        StringBuilder url = new StringBuilder(this.solringesterEntryPoint);
        url.append("?").append(ACTION_PARAM_NAME).append("=").append(ACTION_SEED);
        if (startTime > 0L) {
            url.append("&startTime=").append(sdf.format(new Date(startTime)));
        }
        url.append("&endTime=").append(sdf.format(new Date(seedTime)));
        String filterDate = null;
        if (lastSeedVersion != null && !lastSeedVersion.isEmpty() && !lastSeedVersion.contentEquals("0")) {
            dateSolr = new Long(lastSeedVersion);
            String dateSolrString = sdf.format(dateSolr);
            filterDate = dateField + ":[" + dateSolrString + " TO NOW]";
        } else {
            dateSolr = 0L;
        }
        int rowsNumber = Integer.valueOf(rowsNumberString);
        try {
            SolrQuery query = filter == null || filter == "*:*" ? new SolrQuery("*:*").setRows(Integer.valueOf(rowsNumber)).setSort(idFieldName, SolrQuery.ORDER.asc) : new SolrQuery("*:*").addFilterQuery(new String[]{filter}).setRows(Integer.valueOf(rowsNumber)).setSort(idFieldName, SolrQuery.ORDER.asc);
            if (filterDate != null && !filterDate.isEmpty() && !filterDate.contentEquals("0")) {
                query.addFilterQuery(new String[]{filterDate});
            }
            query.setFields(new String[]{idFieldName});
            String cursorMark = "*";
            boolean done = false;
            while (!done) {
                query.set("cursorMark", new String[]{cursorMark});
                QueryResponse response = this.httpSolrClient.query(collection, (SolrParams)query);
                String nextCursorMark = cursorMark;
                try {
                    nextCursorMark = response.getNextCursorMark();
                }
                catch (Exception e) {
                    Logging.connectors.warn((Object)"SolrIngester: the type of the reponse getnextcursormark is not recognized as a String");
                    break;
                }
                SolrDocumentList documents = response.getResults();
                for (SolrDocument document : documents) {
                    activities.addSeedDocument((String)document.getFieldValue(idFieldName));
                }
                if (cursorMark.equals(nextCursorMark)) {
                    done = true;
                }
                cursorMark = nextCursorMark;
            }
        }
        catch (IOException | SolrServerException e) {
            Logging.connectors.error((Object)"Unable to perform Solr requests", e);
            throw new ManifoldCFException("Unable to perform Solr requests", e);
        }
        return new Long(seedTime).toString();
    }

    public void processDocuments(String[] documentIdentifiers, IExistingVersions statuses, Specification spec, IProcessActivity activities, int jobMode, boolean usesDefaultAuthority) throws ManifoldCFException, ServiceInterruption {
        this.getSession();
        if (Logging.connectors.isDebugEnabled()) {
            Logging.connectors.debug((Object)"SolrIngester: ProcessDocuments method");
        }
        String collection = null;
        String idFieldName = null;
        boolean securityActivated = false;
        String dateField = null;
        String contentField = null;
        String securityField = null;
        String securityField2 = null;
        String rowsNumberString = null;
        String errorCode = null;
        String description = "";
        long startFetchTime = System.currentTimeMillis();
        HashMap<String, String> mapFields = new HashMap<String, String>();
        for (int l = 0; l < spec.getChildCount(); ++l) {
            SpecificationNode sn = spec.getChild(l);
            if (sn.getType() == "collection") {
                collection = sn.getAttributeValue("value");
            }
            if (sn.getType() == "securityactivated") {
                securityActivated = Boolean.parseBoolean(sn.getAttributeValue("value"));
            }
            if (sn.getType() == "fieldid") {
                idFieldName = sn.getAttributeValue("value");
            }
            if (sn.getType() == "fielddate") {
                dateField = sn.getAttributeValue("value");
            }
            if (sn.getType() == "fieldcontent") {
                contentField = sn.getAttributeValue("value");
            }
            if (sn.getType() == "securityfield") {
                securityField = sn.getAttributeValue("value");
            }
            if (sn.getType() == "securityfield2") {
                securityField2 = sn.getAttributeValue("value");
            }
            if (sn.getType().equals("fieldmap")) {
                String source = sn.getAttributeValue("source");
                String target = sn.getAttributeValue("target");
                mapFields.put(source, target);
            }
            if (sn.getType() != "rowsnumber") continue;
            rowsNumberString = sn.getAttributeValue("value");
        }
        Object versionString = null;
        StringBuilder url = new StringBuilder(this.solringesterEntryPoint);
        url.append("?").append(ACTION_PARAM_NAME).append("=").append(ACTION_ITEMS);
        for (int i = 0; i < documentIdentifiers.length; ++i) {
            url.append("&id[]=").append(URLEncoder.encode((String)documentIdentifiers[i]));
        }
        String documentIdentifiersString = "\"" + String.join((CharSequence)"\" OR \"", documentIdentifiers) + "\"";
        int rowsNumber = Integer.valueOf(rowsNumberString);
        HashMap<String, String> existingIds = new HashMap<String, String>();
        if (Logging.connectors.isDebugEnabled()) {
            Logging.connectors.debug((Object)("SolrIngester: docidentifiers size '" + documentIdentifiers.length));
        }
        if (documentIdentifiers.length > 0) {
            block52: {
                try {
                    SolrQuery query = new SolrQuery("*:*").setRows(Integer.valueOf(rowsNumber)).setSort(idFieldName, SolrQuery.ORDER.asc);
                    query.setFields(new String[]{idFieldName, versionField});
                    query.addFilterQuery(new String[]{idFieldName + ":(" + documentIdentifiersString + ")"});
                    String cursorMark = "*";
                    boolean done = false;
                    while (!done) {
                        query.set("cursorMark", new String[]{cursorMark});
                        QueryResponse response = this.httpSolrClient.query(collection, (SolrParams)query);
                        String nextCursorMark = cursorMark;
                        try {
                            nextCursorMark = response.getNextCursorMark();
                        }
                        catch (Exception e) {
                            Logging.connectors.warn((Object)"SolrIngester: the type of the reponse getnextcursormark is not recognized as a String");
                            break;
                        }
                        SolrDocumentList documents = response.getResults();
                        for (SolrDocument document : documents) {
                            existingIds.put((String)document.getFieldValue(idFieldName), String.valueOf(document.getFieldValue(versionField)));
                        }
                        if (cursorMark.equals(nextCursorMark)) {
                            done = true;
                        }
                        cursorMark = nextCursorMark;
                    }
                    HashSet<CallSite> toProcess = new HashSet<CallSite>();
                    for (Map.Entry pair : existingIds.entrySet()) {
                        String idStringBis = (String)pair.getKey();
                        String versionStringBis = (String)pair.getValue();
                        if (versionStringBis.length() != 0 && !activities.checkDocumentNeedsReindexing(idStringBis, versionStringBis)) continue;
                        toProcess.add((CallSite)((Object)("\"" + (String)pair.getKey() + "\"")));
                    }
                    if (toProcess.size() <= 0) break block52;
                    ArrayList listToProcess = new ArrayList(toProcess);
                    String listToProcessString = String.join((CharSequence)" OR ", listToProcess);
                    RepositoryDocument doc = new RepositoryDocument();
                    query = new SolrQuery("*:*").setRows(Integer.valueOf(rowsNumber)).setSort(idFieldName, SolrQuery.ORDER.asc);
                    query.setFields(new String[]{"*"});
                    query.addFilterQuery(new String[]{idFieldName + ":(" + listToProcessString + ")"});
                    cursorMark = "*";
                    done = false;
                    while (!done) {
                        query.set("cursorMark", new String[]{cursorMark});
                        SolrDocumentList documents = null;
                        QueryResponse response = this.httpSolrClient.query(collection, (SolrParams)query);
                        String nextCursorMark = cursorMark;
                        try {
                            nextCursorMark = response.getNextCursorMark();
                        }
                        catch (Exception e) {
                            Logging.connectors.warn((Object)"SolrIngester: the type of the reponse getnextcursormark is not recognized as a String");
                            break;
                        }
                        documents = response.getResults();
                        ByteArrayInputStream is = null;
                        for (SolrDocument document : documents) {
                            for (Map.Entry entry : mapFields.entrySet()) {
                                int i;
                                String[] string_list;
                                Object[] tablistFieldValues;
                                ArrayList listFieldValues = null;
                                if (document.getFieldValues((String)entry.getKey()) == null || (listFieldValues = (ArrayList)document.getFieldValues((String)entry.getKey())) == null) continue;
                                if (listFieldValues.get(0) instanceof String) {
                                    tablistFieldValues = listFieldValues.toArray(new String[0]);
                                    doc.addField((String)entry.getValue(), (String[])tablistFieldValues);
                                    continue;
                                }
                                if (listFieldValues.get(0) instanceof Long) {
                                    tablistFieldValues = listFieldValues.toArray(new Long[0]);
                                    string_list = new String[tablistFieldValues.length];
                                    for (i = 0; i < tablistFieldValues.length; ++i) {
                                        string_list[i] = String.valueOf(tablistFieldValues[i]);
                                    }
                                    doc.addField((String)entry.getValue(), string_list);
                                    continue;
                                }
                                if (listFieldValues.get(0) instanceof Integer) {
                                    tablistFieldValues = listFieldValues.toArray(new Integer[0]);
                                    string_list = new String[tablistFieldValues.length];
                                    for (i = 0; i < tablistFieldValues.length; ++i) {
                                        string_list[i] = String.valueOf(tablistFieldValues[i]);
                                    }
                                    doc.addField((String)entry.getValue(), string_list);
                                    continue;
                                }
                                if (listFieldValues.get(0) instanceof Date) {
                                    tablistFieldValues = listFieldValues.toArray(new Date[0]);
                                    doc.addField((String)entry.getValue(), (Date[])tablistFieldValues);
                                    continue;
                                }
                                Logging.connectors.warn((Object)("SolrIngester: the type of the field " + (String)entry.getKey() + " is not recognized"));
                            }
                            if (document.getFieldValues(dateField).size() > 1) {
                                doc.addField(date_target_field, (Date)document.getFirstValue(dateField));
                            } else {
                                doc.addField(date_target_field, (Date)document.getFieldValue(dateField));
                            }
                            doc.setFileName((String)document.getFieldValue(idFieldName));
                            if (Logging.connectors.isDebugEnabled()) {
                                Logging.connectors.debug((Object)("doc '" + (String)document.getFieldValue(idFieldName)));
                            }
                            ArrayList contentFieldValues = null;
                            Object contentFieldValuesString = "";
                            if (document.getFieldValues(contentField) != null) {
                                contentFieldValues = (ArrayList)document.getFieldValues(contentField);
                                if (contentFieldValues != null) {
                                    String[] tabContentFieldValues = contentFieldValues.toArray(new String[0]);
                                    for (String s : tabContentFieldValues) {
                                        contentFieldValuesString = (String)contentFieldValuesString + " " + (String)s;
                                    }
                                }
                            } else {
                                contentFieldValuesString = document.getFieldValue(contentField) != null ? (String)document.getFieldValue(contentField) : "";
                            }
                            is = new ByteArrayInputStream(((String)contentFieldValuesString).getBytes(StandardCharsets.UTF_8));
                            if (securityActivated) {
                                ArrayList securityFieldValues;
                                if (Logging.connectors.isDebugEnabled()) {
                                    Logging.connectors.debug((Object)"Security part");
                                }
                                if (document.getFieldValues(securityField) != null && document.getFieldValues(securityField2) != null) {
                                    securityFieldValues = null;
                                    ArrayList securityFieldValues2 = null;
                                    securityFieldValues = (ArrayList)document.getFieldValues(securityField);
                                    securityFieldValues2 = (ArrayList)document.getFieldValues(securityField2);
                                    if (Logging.connectors.isDebugEnabled()) {
                                        Logging.connectors.debug((Object)("Security field 1 : " + securityFieldValues.toString()));
                                        Logging.connectors.debug((Object)("Security field 2 : " + securityFieldValues2.toString()));
                                    }
                                    String[] securityValues = null;
                                    ArrayList all = new ArrayList();
                                    all.addAll(securityFieldValues);
                                    all.addAll(securityFieldValues2);
                                    HashSet hs = new HashSet();
                                    hs.addAll(all);
                                    all.clear();
                                    all.addAll(hs);
                                    securityValues = all.toArray(new String[0]);
                                    doc.setSecurity("document", securityValues, new String[]{"DEAD_AUTHORITY"});
                                    securityFieldValues = null;
                                    securityFieldValues2 = null;
                                } else if (document.getFieldValues(securityField) != null) {
                                    securityFieldValues = null;
                                    securityFieldValues = (ArrayList)document.getFieldValues(securityField);
                                    String[] tabsecurityFieldValues = securityFieldValues.toArray(new String[0]);
                                    doc.setSecurity("document", tabsecurityFieldValues, new String[]{"DEAD_AUTHORITY"});
                                    securityFieldValues = null;
                                    tabsecurityFieldValues = null;
                                } else if (document.getFieldValues(securityField2) != null) {
                                    ArrayList securityFieldValues2 = null;
                                    securityFieldValues2 = (ArrayList)document.getFieldValues(securityField2);
                                    String[] tabsecurityFieldValues2 = securityFieldValues2.toArray(new String[0]);
                                    doc.setSecurity("document", tabsecurityFieldValues2, new String[]{"DEAD_AUTHORITY"});
                                    securityFieldValues2 = null;
                                    tabsecurityFieldValues2 = null;
                                }
                            }
                            try {
                                doc.setBinary((InputStream)is, (long)((InputStream)is).available());
                                activities.ingestDocumentWithException(String.valueOf(document.getFieldValue(idFieldName)), String.valueOf(document.getFieldValue(versionField)), String.valueOf(document.getFieldValue(idFieldName)), doc);
                                activities.recordActivity(new Long(startFetchTime), ACTIVITY_GET, Long.valueOf(doc.getBinaryLength()), document.getFieldValue(idFieldName).toString(), "OK", "", null);
                                ((InputStream)is).close();
                            }
                            catch (IOException e) {
                                errorCode = "ERROR";
                                description = "Unable to perform Solr requests";
                                Logging.connectors.error((Object)"Unable to perform Solr requests", (Throwable)e);
                            }
                        }
                        if (cursorMark.equals(nextCursorMark)) {
                            done = true;
                        }
                        cursorMark = nextCursorMark;
                    }
                }
                catch (IOException | SolrServerException e) {
                    errorCode = "ERROR";
                    description = "Unable to perform Solr requests";
                    Logging.connectors.error((Object)"Unable to perform Solr requests", e);
                }
            }
            for (int i = 0; i < documentIdentifiers.length; ++i) {
                if (!existingIds.containsKey(documentIdentifiers[i])) {
                    activities.deleteDocument(documentIdentifiers[i]);
                    activities.recordActivity(new Long(startFetchTime), ACTIVITY_GET, Long.valueOf(0L), documentIdentifiers[i], "NOTFOUND", "Document not found in Solr", null);
                    continue;
                }
                if (errorCode == null) continue;
                activities.recordActivity(new Long(startFetchTime), ACTIVITY_GET, Long.valueOf(0L), documentIdentifiers[i], errorCode, description, null);
            }
        }
    }

    public String processSpecificationPost(IPostParameters variableContext, Locale locale, Specification os, int connectionSequenceNumber) throws ManifoldCFException {
        String seqPrefix = "s" + connectionSequenceNumber + "_";
        String x = variableContext.getParameter(seqPrefix + "fieldmapping_count");
        if (x != null && x.length() > 0) {
            int i = 0;
            while (i < os.getChildCount()) {
                SpecificationNode node = os.getChild(i);
                if (node.getType().equals("fieldmap")) {
                    os.removeChild(i);
                    continue;
                }
                ++i;
            }
            int count = Integer.parseInt(x);
            for (i = 0; i < count; ++i) {
                String suffix;
                String prefix = seqPrefix + "fieldmapping_";
                String op = variableContext.getParameter(prefix + "op" + (suffix = "_" + Integer.toString(i)));
                if (op != null && op.equals("Delete")) continue;
                String source = variableContext.getParameter(prefix + "source" + suffix);
                String target = variableContext.getParameter(prefix + "target" + suffix);
                if (target == null) {
                    target = "";
                }
                SpecificationNode node = new SpecificationNode("fieldmap");
                node.setAttribute("source", source);
                node.setAttribute("target", target);
                os.addChild(os.getChildCount(), (ConfigurationNode)node);
            }
            String addop = variableContext.getParameter(seqPrefix + "fieldmapping_op");
            if (addop != null && addop.equals("Add")) {
                String source = variableContext.getParameter(seqPrefix + "fieldmapping_source");
                String target = variableContext.getParameter(seqPrefix + "fieldmapping_target");
                if (target == null) {
                    target = "";
                }
                SpecificationNode node = new SpecificationNode("fieldmap");
                node.setAttribute("source", source);
                node.setAttribute("target", target);
                os.addChild(os.getChildCount(), (ConfigurationNode)node);
            }
            SpecificationNode node2 = new SpecificationNode("securityactivated");
            String securityActivated = variableContext.getParameter(seqPrefix + "securityactivated");
            if (securityActivated != null) {
                node2.setAttribute("value", securityActivated);
            } else {
                node2.setAttribute("value", "false");
            }
            os.addChild(os.getChildCount(), (ConfigurationNode)node2);
            SpecificationNode node3 = new SpecificationNode("securityfield");
            String securityField = variableContext.getParameter(seqPrefix + "securityfield");
            node3.setAttribute("value", securityField);
            os.addChild(os.getChildCount(), (ConfigurationNode)node3);
            SpecificationNode node4 = new SpecificationNode("fieldid");
            String fieldId = variableContext.getParameter(seqPrefix + "fieldid");
            node4.setAttribute("value", fieldId);
            os.addChild(os.getChildCount(), (ConfigurationNode)node4);
            SpecificationNode node5 = new SpecificationNode("fielddate");
            String fieldDate = variableContext.getParameter(seqPrefix + "fielddate");
            node5.setAttribute("value", fieldDate);
            os.addChild(os.getChildCount(), (ConfigurationNode)node5);
            SpecificationNode node6 = new SpecificationNode("fieldcontent");
            String fieldContent = variableContext.getParameter(seqPrefix + "fieldcontent");
            node6.setAttribute("value", fieldContent);
            os.addChild(os.getChildCount(), (ConfigurationNode)node6);
            SpecificationNode node7 = new SpecificationNode("collection");
            String collectionName = variableContext.getParameter(seqPrefix + "collection");
            node7.setAttribute("value", collectionName);
            os.addChild(os.getChildCount(), (ConfigurationNode)node7);
            SpecificationNode node8 = new SpecificationNode("filter");
            String filter = variableContext.getParameter(seqPrefix + "filter");
            node8.setAttribute("value", filter);
            os.addChild(os.getChildCount(), (ConfigurationNode)node8);
            SpecificationNode node9 = new SpecificationNode("rowsnumber");
            String rowsNumber = variableContext.getParameter(seqPrefix + "rowsnumber");
            node9.setAttribute("value", rowsNumber);
            os.addChild(os.getChildCount(), (ConfigurationNode)node9);
            SpecificationNode node10 = new SpecificationNode("securityfield2");
            String securityField2 = variableContext.getParameter(seqPrefix + "securityfield2");
            node10.setAttribute("value", securityField2);
            os.addChild(os.getChildCount(), (ConfigurationNode)node10);
        }
        return null;
    }

    public void outputConfigurationHeader(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters, List<String> tabsArray) throws ManifoldCFException, IOException {
        tabsArray.add(Messages.getString(locale, "SolrIngester.SolrIngesterTabName"));
        Messages.outputResourceWithVelocity(out, locale, EDIT_CONFIGURATION_CONNECTOR_JS, null);
    }

    public void outputConfigurationBody(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters, String tabName) throws ManifoldCFException, IOException {
        HashMap<String, Object> velocityContext = new HashMap<String, Object>();
        velocityContext.put("TabName", tabName);
        SolrIngesterConnector.fillInServerTab(velocityContext, out, parameters);
        Messages.outputResourceWithVelocity(out, locale, EDIT_CONFIGURATION_CONNECTOR_HTML, velocityContext);
    }

    public String processConfigurationPost(IThreadContext threadContext, IPostParameters variableContext, Locale locale, ConfigParams parameters) throws ManifoldCFException {
        String socketTimeout;
        String connectionTimeout;
        String solrPassword;
        String solrUsername;
        String solrAddress = variableContext.getParameter("solrAddress");
        if (solrAddress != null) {
            parameters.setParameter("solrAddress", solrAddress);
        }
        if ((solrUsername = variableContext.getParameter("solrUsername")) != null) {
            parameters.setParameter("solrUsername", solrUsername);
        }
        if ((solrPassword = variableContext.getParameter("solrPassword")) != null) {
            parameters.setParameter("solrPassword", ManifoldCF.obfuscate((String)variableContext.mapKeyToPassword(solrPassword)));
        }
        if ((connectionTimeout = variableContext.getParameter("connectionTimeout")) != null) {
            parameters.setParameter("connectionTimeout", connectionTimeout);
        }
        if ((socketTimeout = variableContext.getParameter("socketTimeout")) != null) {
            parameters.setParameter("socketTimeout", socketTimeout);
        }
        return null;
    }

    public void viewConfiguration(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters) throws ManifoldCFException, IOException {
        HashMap<String, Object> velocityContext = new HashMap<String, Object>();
        SolrIngesterConnector.fillInServerTab(velocityContext, out, parameters);
        Messages.outputResourceWithVelocity(out, locale, VIEW_CONFIGURATION_CONNECTOR_HTML, velocityContext);
    }

    protected static void fillInServerTab(Map<String, Object> velocityContext, IHTTPOutput out, ConfigParams parameters) throws ManifoldCFException {
        String socketTimeout;
        String connectionTimeout;
        String solrPassword;
        String solrUsername;
        String solrAddress = parameters.getParameter("solrAddress");
        if (solrAddress == null) {
            solrAddress = "http://localhost:8983/solr";
        }
        if ((solrUsername = parameters.getParameter("solrUsername")) == null) {
            solrUsername = "";
        }
        if ((solrPassword = parameters.getParameter("solrPassword")) == null) {
            solrPassword = "";
        }
        if ((connectionTimeout = parameters.getParameter("connectionTimeout")) == null) {
            connectionTimeout = "60000";
        }
        if ((socketTimeout = parameters.getParameter("socketTimeout")) == null) {
            socketTimeout = "180000";
        }
        velocityContext.put("SOLRADDRESS", solrAddress);
        velocityContext.put("SOLRUSERNAME", solrUsername);
        velocityContext.put("SOLRPASSWORD", solrPassword);
        velocityContext.put("CONNECTIONTIMEOUT", connectionTimeout);
        velocityContext.put("SOCKETTIMEOUT", socketTimeout);
    }

    public void outputSpecificationHeader(IHTTPOutput out, Locale locale, Specification os, int connectionSequenceNumber, List<String> tabsArray) throws ManifoldCFException, IOException {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("SEQNUM", Integer.toString(connectionSequenceNumber));
        tabsArray.add(Messages.getString(locale, "SolrIngester.SecurityTabName"));
        tabsArray.add(Messages.getString(locale, "SolrIngester.ParametersTabName"));
        Messages.outputResourceWithVelocity(out, locale, EDIT_SPECIFICATION_JOB_PARAMETERS_JS, paramMap);
        Messages.outputResourceWithVelocity(out, locale, EDIT_SPECIFICATION_JOB_SECURITY_JS, paramMap);
    }

    public void outputSpecificationBody(IHTTPOutput out, Locale locale, Specification os, int connectionSequenceNumber, int actualSequenceNumber, String tabName) throws ManifoldCFException, IOException {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("TABNAME", tabName);
        paramMap.put("SEQNUM", Integer.toString(connectionSequenceNumber));
        paramMap.put("SELECTEDNUM", Integer.toString(actualSequenceNumber));
        SolrIngesterConnector.fillInFieldMappingSpecificationMap(paramMap, os);
        Messages.outputResourceWithVelocity(out, locale, EDIT_SPECIFICATION_JOB_PARAMETERS_HTML, paramMap);
        Messages.outputResourceWithVelocity(out, locale, EDIT_SPECIFICATION_JOB_SECURITY_HTML, paramMap);
    }

    public void viewSpecification(IHTTPOutput out, Locale locale, Specification os, int connectionSequenceNumber) throws ManifoldCFException, IOException {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("SEQNUM", Integer.toString(connectionSequenceNumber));
        SolrIngesterConnector.fillInFieldMappingSpecificationMap(paramMap, os);
        Messages.outputResourceWithVelocity(out, locale, VIEW_SPECIFICATION_JOB_PARAMETERS_HTML, paramMap);
        Messages.outputResourceWithVelocity(out, locale, VIEW_SPECIFICATION_JOB_SECURITY_HTML, paramMap);
    }

    protected static void fillInFieldMappingSpecificationMap(Map<String, Object> paramMap, Specification os) {
        String securityActivated = "false";
        String securityField = "";
        String securityField2 = "";
        String idField = "id";
        String dateField = date_target_field;
        String contentField = "content";
        String filterCondition = "*:*";
        String collection = "techproducts";
        String rowsNumber = "50";
        ArrayList fieldMappings = new ArrayList();
        for (int i = 0; i < os.getChildCount(); ++i) {
            SpecificationNode sn = os.getChild(i);
            if (sn.getType().equals("fieldmap")) {
                String targetDisplay;
                String source = sn.getAttributeValue("source");
                String target = sn.getAttributeValue("target");
                if (target == null) {
                    target = "";
                    targetDisplay = "(remove)";
                } else {
                    targetDisplay = target;
                }
                HashMap<String, String> fieldMapping = new HashMap<String, String>();
                fieldMapping.put("SOURCE", source);
                fieldMapping.put("TARGET", target);
                fieldMapping.put("TARGETDISPLAY", targetDisplay);
                fieldMappings.add(fieldMapping);
                continue;
            }
            if (sn.getType().equals("securityactivated")) {
                securityActivated = sn.getAttributeValue("value");
                continue;
            }
            if (sn.getType().equals("securityfield")) {
                securityField = sn.getAttributeValue("value");
                continue;
            }
            if (sn.getType().equals("securityfield2")) {
                securityField2 = sn.getAttributeValue("value");
                continue;
            }
            if (sn.getType().equals("fieldid")) {
                idField = sn.getAttributeValue("value");
                continue;
            }
            if (sn.getType().equals("fielddate")) {
                dateField = sn.getAttributeValue("value");
                continue;
            }
            if (sn.getType().equals("fieldcontent")) {
                contentField = sn.getAttributeValue("value");
                continue;
            }
            if (sn.getType().equals("filter")) {
                filterCondition = sn.getAttributeValue("value");
                continue;
            }
            if (sn.getType().equals("collection")) {
                collection = sn.getAttributeValue("value");
                continue;
            }
            if (!sn.getType().equals("rowsnumber")) continue;
            rowsNumber = sn.getAttributeValue("value");
        }
        paramMap.put("FIELDMAPPINGS", fieldMappings);
        paramMap.put("SECURITYACTIVATION", securityActivated);
        paramMap.put("SECURITYFIELD", securityField);
        paramMap.put("SECURITYFIELD2", securityField2);
        paramMap.put("FIELDID", idField);
        paramMap.put("FIELDDATE", dateField);
        paramMap.put("FIELDCONTENT", contentField);
        paramMap.put("FILTERCONDITION", filterCondition);
        paramMap.put("COLLECTION", collection);
        paramMap.put("ROWSNUMBER", rowsNumber);
    }

    protected static class ExecuteSeedingThread
    extends Thread {
        protected final HttpClient client;
        protected final String url;
        protected final XThreadStringBuffer seedBuffer;
        protected Throwable exception = null;

        public ExecuteSeedingThread(HttpClient client, String url) {
            this.setDaemon(true);
            this.client = client;
            this.url = url;
            this.seedBuffer = new XThreadStringBuffer();
        }

        public XThreadStringBuffer getBuffer() {
            return this.seedBuffer;
        }
    }

    protected static class CheckThread
    extends Thread {
        protected HttpClient client;
        protected String url;
        protected Throwable exception = null;
        protected String result = "Unknown";

        public CheckThread(HttpClient client, String url) {
            this.setDaemon(true);
            this.client = client;
            this.url = url;
        }

        @Override
        public void run() {
            HttpGet method = new HttpGet(this.url);
            try {
                HttpResponse response = this.client.execute((HttpUriRequest)method);
                try {
                    if (response.getStatusLine().getStatusCode() != 200) {
                        this.result = "Connection failed: " + response.getStatusLine().getReasonPhrase();
                        return;
                    }
                    EntityUtils.consume((HttpEntity)response.getEntity());
                    this.result = "Connection OK";
                }
                finally {
                    EntityUtils.consume((HttpEntity)response.getEntity());
                    method.releaseConnection();
                }
            }
            catch (IOException ex) {
                this.exception = ex;
            }
        }

        public Throwable getException() {
            return this.exception;
        }

        public String getResult() {
            return this.result;
        }
    }

    static class PreemptiveAuth
    implements HttpRequestInterceptor {
        private final Credentials credentials;

        public PreemptiveAuth(Credentials creds) {
            this.credentials = creds;
        }

        public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
            request.addHeader(new BasicScheme(StandardCharsets.US_ASCII).authenticate(this.credentials, request, context));
        }
    }
}

