/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.authorities.mapping;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.manifoldcf.authorities.interfaces.AuthorityConnectionManagerFactory;
import org.apache.manifoldcf.authorities.interfaces.CacheKeyFactory;
import org.apache.manifoldcf.authorities.interfaces.IAuthorityConnectionManager;
import org.apache.manifoldcf.authorities.interfaces.IMappingConnection;
import org.apache.manifoldcf.authorities.interfaces.IMappingConnectionManager;
import org.apache.manifoldcf.authorities.mapping.MappingConnection;
import org.apache.manifoldcf.authorities.system.ManifoldCF;
import org.apache.manifoldcf.core.cachemanager.BaseDescription;
import org.apache.manifoldcf.core.cachemanager.ExecutorBase;
import org.apache.manifoldcf.core.database.BaseTable;
import org.apache.manifoldcf.core.interfaces.CacheManagerFactory;
import org.apache.manifoldcf.core.interfaces.ClauseDescription;
import org.apache.manifoldcf.core.interfaces.ColumnDescription;
import org.apache.manifoldcf.core.interfaces.ICacheDescription;
import org.apache.manifoldcf.core.interfaces.ICacheExecutor;
import org.apache.manifoldcf.core.interfaces.ICacheHandle;
import org.apache.manifoldcf.core.interfaces.ICacheManager;
import org.apache.manifoldcf.core.interfaces.IDBInterface;
import org.apache.manifoldcf.core.interfaces.ILockManager;
import org.apache.manifoldcf.core.interfaces.IResultRow;
import org.apache.manifoldcf.core.interfaces.IResultSet;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.LockManagerFactory;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.MultiClause;
import org.apache.manifoldcf.core.interfaces.StringSet;
import org.apache.manifoldcf.core.interfaces.StringSetBuffer;
import org.apache.manifoldcf.core.interfaces.UnitaryClause;

public class MappingConnectionManager
extends BaseTable
implements IMappingConnectionManager {
    public static final String _rcsid = "@(#)$Id: MappingConnectionManager.java 1865954 2019-08-26 20:27:25Z schuch $";
    private static final String passwordSuffix = "password";
    protected static final String nameField = "connname";
    protected static final String descriptionField = "description";
    protected static final String classNameField = "classname";
    protected static final String maxCountField = "maxcount";
    protected static final String configField = "configxml";
    protected static final String mappingField = "mappingname";
    protected final ICacheManager cacheManager;
    protected final IThreadContext threadContext;
    protected final ILockManager lockManager;
    protected static final String mappingsLock = "MAPPINGS_LOCK";
    protected static final int FETCH_MAX = 200;

    public MappingConnectionManager(IThreadContext threadContext, IDBInterface database) throws ManifoldCFException {
        super(database, "mapconnections");
        this.cacheManager = CacheManagerFactory.make((IThreadContext)threadContext);
        this.lockManager = LockManagerFactory.make((IThreadContext)threadContext);
        this.threadContext = threadContext;
    }

    @Override
    public void install() throws ManifoldCFException {
        block0: {
            Map existing = this.getTableSchema(null, null);
            if (existing != null) break block0;
            HashMap<String, ColumnDescription> map = new HashMap<String, ColumnDescription>();
            map.put(nameField, new ColumnDescription("VARCHAR(32)", true, false, null, null, false));
            map.put(descriptionField, new ColumnDescription("VARCHAR(255)", false, true, null, null, false));
            map.put(classNameField, new ColumnDescription("VARCHAR(255)", false, false, null, null, false));
            map.put(maxCountField, new ColumnDescription("BIGINT", false, false, null, null, false));
            map.put(configField, new ColumnDescription("LONGTEXT", false, true, null, null, false));
            map.put(mappingField, new ColumnDescription("VARCHAR(32)", false, true, null, null, false));
            this.performCreate(map, null);
        }
    }

    @Override
    public void deinstall() throws ManifoldCFException {
        this.performDrop(null);
    }

    @Override
    public void exportConfiguration(OutputStream os) throws IOException, ManifoldCFException {
        ManifoldCF.writeDword((OutputStream)os, (int)1);
        IMappingConnection[] list = this.getAllConnections();
        ManifoldCF.writeDword((OutputStream)os, (int)list.length);
        for (IMappingConnection conn : list) {
            ManifoldCF.writeString((OutputStream)os, (String)conn.getName());
            ManifoldCF.writeString((OutputStream)os, (String)conn.getDescription());
            ManifoldCF.writeString((OutputStream)os, (String)conn.getClassName());
            ManifoldCF.writeString((OutputStream)os, (String)conn.getConfigParams().toXML());
            ManifoldCF.writeDword((OutputStream)os, (int)conn.getMaxConnections());
            ManifoldCF.writeString((OutputStream)os, (String)conn.getPrerequisiteMapping());
        }
    }

    @Override
    public void importConfiguration(InputStream is) throws IOException, ManifoldCFException {
        int version = ManifoldCF.readDword((InputStream)is);
        if (version != 1) {
            throw new IOException("Unknown mapping configuration version: " + Integer.toString(version));
        }
        int count = ManifoldCF.readDword((InputStream)is);
        for (int i = 0; i < count; ++i) {
            IMappingConnection conn = this.create();
            conn.setName(ManifoldCF.readString((InputStream)is));
            conn.setDescription(ManifoldCF.readString((InputStream)is));
            conn.setClassName(ManifoldCF.readString((InputStream)is));
            conn.getConfigParams().fromXML(ManifoldCF.readString((InputStream)is));
            conn.setMaxConnections(ManifoldCF.readDword((InputStream)is));
            conn.setPrerequisiteMapping(ManifoldCF.readString((InputStream)is));
            this.save(conn);
        }
    }

    @Override
    public IMappingConnection[] getAllNonLoopingConnections(String startingConnectionName) throws ManifoldCFException {
        IMappingConnection[] connections = this.getAllConnections();
        if (startingConnectionName == null) {
            return connections;
        }
        ArrayList<IMappingConnection> finalConnections = new ArrayList<IMappingConnection>();
        HashMap<String, IMappingConnection> connectionMap = new HashMap<String, IMappingConnection>();
        for (IMappingConnection thisConnection : connections) {
            connectionMap.put(thisConnection.getName(), thisConnection);
        }
        for (IMappingConnection connectionToEvaluate : connections) {
            int i;
            HashSet<String> Q = new HashSet<String>();
            HashSet<CallSite> links = new HashSet<CallSite>();
            HashMap<String, Integer> incomingCount = new HashMap<String, Integer>();
            for (i = 0; i < connections.length; ++i) {
                Q.add(connections[i].getName());
            }
            for (i = 0; i < connections.length; ++i) {
                String connectionName = connections[i].getName();
                String prerequisite = connectionName.equals(startingConnectionName) ? connectionToEvaluate.getName() : connections[i].getPrerequisiteMapping();
                if (prerequisite == null) continue;
                Integer x = (Integer)incomingCount.get(prerequisite);
                if (x == null) {
                    incomingCount.put(prerequisite, new Integer(1));
                } else {
                    incomingCount.put(prerequisite, new Integer(x + 1));
                }
                Q.remove(prerequisite);
                links.add((CallSite)((Object)(connectionName + ":" + prerequisite)));
            }
            while (!Q.isEmpty()) {
                String edgeName;
                String s;
                Iterator iter = Q.iterator();
                String checkConnectionName = (String)iter.next();
                Q.remove(checkConnectionName);
                if (checkConnectionName.equals(startingConnectionName)) {
                    s = connectionToEvaluate.getName();
                } else {
                    IMappingConnection sourceConnection = (IMappingConnection)connectionMap.get(checkConnectionName);
                    s = sourceConnection.getPrerequisiteMapping();
                }
                if (s == null || !links.contains(edgeName = checkConnectionName + ":" + s)) continue;
                links.remove(edgeName);
                Integer x = (Integer)incomingCount.get(s);
                if (x == 1) {
                    incomingCount.remove(s);
                    Q.add(s);
                    continue;
                }
                incomingCount.put(s, new Integer(x - 1));
            }
            if (!links.isEmpty()) continue;
            finalConnections.add(connectionToEvaluate);
        }
        return finalConnections.toArray(new IMappingConnection[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IMappingConnection[] getAllConnections() throws ManifoldCFException {
        this.lockManager.enterReadLock(mappingsLock);
        try {
            StringSetBuffer ssb = new StringSetBuffer();
            ssb.add(MappingConnectionManager.getMappingConnectionsKey());
            StringSet localCacheKeys = new StringSet(ssb);
            IResultSet set = this.performQuery("SELECT connname,lower(connname) AS sortfield FROM " + this.getTableName() + " ORDER BY sortfield ASC", null, localCacheKeys, null);
            String[] names = new String[set.getRowCount()];
            for (int i = 0; i < names.length; ++i) {
                IResultRow row = set.getRow(i);
                names[i] = row.getValue(nameField).toString();
            }
            IMappingConnection[] iMappingConnectionArray = this.loadMultiple(names);
            return iMappingConnectionArray;
        }
        finally {
            this.lockManager.leaveReadLock(mappingsLock);
        }
    }

    @Override
    public IMappingConnection load(String name) throws ManifoldCFException {
        return this.loadMultiple(new String[]{name})[0];
    }

    @Override
    public IMappingConnection[] loadMultiple(String[] names) throws ManifoldCFException {
        IMappingConnection[] rval = new IMappingConnection[names.length];
        if (names.length == 0) {
            return rval;
        }
        int inputIndex = 0;
        int outputIndex = 0;
        while (names.length - inputIndex > 200) {
            outputIndex = this.loadMultipleInternal(rval, outputIndex, names, inputIndex, 200);
            inputIndex += 200;
        }
        this.loadMultipleInternal(rval, outputIndex, names, inputIndex, names.length - inputIndex);
        return rval;
    }

    protected int loadMultipleInternal(IMappingConnection[] rval, int outputIndex, String[] fetchNames, int inputIndex, int length) throws ManifoldCFException {
        MappingConnection[] results;
        MappingConnectionDescription[] objectDescriptions = new MappingConnectionDescription[length];
        StringSetBuffer ssb = new StringSetBuffer();
        for (int i = 0; i < length; ++i) {
            ssb.clear();
            String name = fetchNames[inputIndex + i];
            ssb.add(MappingConnectionManager.getMappingConnectionKey(name));
            objectDescriptions[i] = new MappingConnectionDescription(name, new StringSet(ssb));
        }
        MappingConnectionExecutor exec = new MappingConnectionExecutor(this, objectDescriptions);
        this.cacheManager.findObjectsAndExecute((ICacheDescription[])objectDescriptions, null, (ICacheExecutor)exec, this.getTransactionID());
        for (MappingConnection result : results = exec.getResults()) {
            rval[outputIndex++] = result;
        }
        return outputIndex;
    }

    @Override
    public IMappingConnection create() throws ManifoldCFException {
        MappingConnection rval = new MappingConnection();
        return rval;
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean save(IMappingConnection object) throws ManifoldCFException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(String name) throws ManifoldCFException {
        IAuthorityConnectionManager authManager = AuthorityConnectionManagerFactory.make(this.threadContext);
        StringSetBuffer ssb = new StringSetBuffer();
        ssb.add(MappingConnectionManager.getMappingConnectionsKey());
        ssb.add(MappingConnectionManager.getMappingConnectionKey(name));
        StringSet cacheKeys = new StringSet(ssb);
        this.lockManager.enterNonExWriteLock(mappingsLock);
        try {
            ICacheHandle ch = this.cacheManager.enterCache(null, cacheKeys, this.getTransactionID());
            try {
                this.beginTransaction();
                try {
                    if (this.isReferenced(name)) {
                        throw new ManifoldCFException("Can't delete mapping connection '" + name + "': existing mapping connections refer to it");
                    }
                    if (authManager.isMappingReferenced(name)) {
                        throw new ManifoldCFException("Can't delete mapping connection '" + name + "': existing authority connections refer to it");
                    }
                    ManifoldCF.noteConfigurationChange();
                    ArrayList params = new ArrayList();
                    String query = this.buildConjunctionClause(params, new ClauseDescription[]{new UnitaryClause(nameField, (Object)name)});
                    this.performDelete("WHERE " + query, params, null);
                    this.cacheManager.invalidateKeys(ch);
                }
                catch (ManifoldCFException e) {
                    this.signalRollback();
                    throw e;
                }
                catch (Error e) {
                    this.signalRollback();
                    throw e;
                }
                finally {
                    this.endTransaction();
                }
            }
            finally {
                this.cacheManager.leaveCache(ch);
            }
        }
        finally {
            this.lockManager.leaveNonExWriteLock(mappingsLock);
        }
    }

    @Override
    public String getMappingNameColumn() {
        return nameField;
    }

    protected boolean isReferenced(String mappingName) throws ManifoldCFException {
        StringSetBuffer ssb = new StringSetBuffer();
        ssb.add(MappingConnectionManager.getMappingConnectionsKey());
        StringSet localCacheKeys = new StringSet(ssb);
        ArrayList params = new ArrayList();
        String query = this.buildConjunctionClause(params, new ClauseDescription[]{new UnitaryClause(mappingField, (Object)mappingName)});
        IResultSet set = this.performQuery("SELECT connname FROM " + this.getTableName() + " WHERE " + query, params, localCacheKeys, null);
        return set.getRowCount() > 0;
    }

    protected static String getMappingConnectionsKey() {
        return CacheKeyFactory.makeMappingConnectionsKey();
    }

    protected static String getMappingConnectionKey(String connectionName) {
        return CacheKeyFactory.makeMappingConnectionKey(connectionName);
    }

    protected MappingConnection[] getMappingConnectionsMultiple(String[] connectionNames) throws ManifoldCFException {
        int i;
        MappingConnection[] rval = new MappingConnection[connectionNames.length];
        HashMap<String, Integer> returnIndex = new HashMap<String, Integer>();
        for (i = 0; i < connectionNames.length; ++i) {
            rval[i] = null;
            returnIndex.put(connectionNames[i], new Integer(i));
        }
        this.beginTransaction();
        try {
            i = 0;
            ArrayList<String> params = new ArrayList<String>();
            int j = 0;
            int maxIn = this.maxClauseGetMappingConnectionsChunk();
            while (i < connectionNames.length) {
                if (j == maxIn) {
                    this.getMappingConnectionsChunk(rval, returnIndex, params);
                    params.clear();
                    j = 0;
                }
                params.add(connectionNames[i]);
                ++i;
                ++j;
            }
            if (j > 0) {
                this.getMappingConnectionsChunk(rval, returnIndex, params);
            }
            MappingConnection[] mappingConnectionArray = rval;
            return mappingConnectionArray;
        }
        catch (Error e) {
            this.signalRollback();
            throw e;
        }
        catch (ManifoldCFException e) {
            this.signalRollback();
            throw e;
        }
        finally {
            this.endTransaction();
        }
    }

    protected int maxClauseGetMappingConnectionsChunk() {
        return this.findConjunctionClauseMax(new ClauseDescription[0]);
    }

    protected void getMappingConnectionsChunk(MappingConnection[] rval, Map returnIndex, ArrayList params) throws ManifoldCFException {
        ArrayList list = new ArrayList();
        String query = this.buildConjunctionClause(list, new ClauseDescription[]{new MultiClause(nameField, (List)params)});
        IResultSet set = this.performQuery("SELECT * FROM " + this.getTableName() + " WHERE " + query, list, null, null);
        int i = 0;
        while (i < set.getRowCount()) {
            IResultRow row = set.getRow(i++);
            String name = row.getValue(nameField).toString();
            int index = (Integer)returnIndex.get(name);
            MappingConnection rc = new MappingConnection();
            rc.setIsNew(false);
            rc.setName(name);
            rc.setDescription((String)row.getValue(descriptionField));
            rc.setClassName((String)row.getValue(classNameField));
            rc.setMaxConnections((int)((Long)row.getValue(maxCountField)).longValue());
            rc.setPrerequisiteMapping((String)row.getValue(mappingField));
            String xml = (String)row.getValue(configField);
            if (xml != null && xml.length() > 0) {
                rc.getConfigParams().fromXML(xml);
            }
            rval[index] = rc;
        }
    }

    protected static class MappingConnectionExecutor
    extends ExecutorBase {
        protected MappingConnectionManager thisManager;
        protected MappingConnection[] returnValues;
        protected HashMap returnMap = new HashMap();

        public MappingConnectionExecutor(MappingConnectionManager manager, MappingConnectionDescription[] objectDescriptions) {
            this.thisManager = manager;
            this.returnValues = new MappingConnection[objectDescriptions.length];
            for (int i = 0; i < objectDescriptions.length; ++i) {
                this.returnMap.put(objectDescriptions[i].getConnectionName(), new Integer(i));
            }
        }

        public MappingConnection[] getResults() {
            return this.returnValues;
        }

        public Object[] create(ICacheDescription[] objectDescriptions) throws ManifoldCFException {
            String[] connectionNames = new String[objectDescriptions.length];
            for (int i = 0; i < connectionNames.length; ++i) {
                MappingConnectionDescription desc = (MappingConnectionDescription)objectDescriptions[i];
                connectionNames[i] = desc.getConnectionName();
            }
            return this.thisManager.getMappingConnectionsMultiple(connectionNames);
        }

        public void exists(ICacheDescription objectDescription, Object cachedObject) throws ManifoldCFException {
            MappingConnectionDescription objectDesc = (MappingConnectionDescription)objectDescription;
            MappingConnection ci = (MappingConnection)cachedObject;
            if (ci != null) {
                ci = ci.duplicate();
            }
            this.returnValues[((Integer)this.returnMap.get((Object)objectDesc.getConnectionName())).intValue()] = ci;
        }

        public void execute() throws ManifoldCFException {
        }
    }

    protected static class MappingConnectionDescription
    extends BaseDescription {
        protected String connectionName;
        protected String criticalSectionName;
        protected StringSet cacheKeys;

        public MappingConnectionDescription(String connectionName, StringSet invKeys) {
            super("mappingconnectioncache");
            this.connectionName = connectionName;
            this.criticalSectionName = ((Object)((Object)this)).getClass().getName() + "-" + connectionName;
            this.cacheKeys = invKeys;
        }

        public String getConnectionName() {
            return this.connectionName;
        }

        public int hashCode() {
            return this.connectionName.hashCode();
        }

        public boolean equals(Object o) {
            if (!(o instanceof MappingConnectionDescription)) {
                return false;
            }
            MappingConnectionDescription d = (MappingConnectionDescription)((Object)o);
            return d.connectionName.equals(this.connectionName);
        }

        public String getCriticalSectionName() {
            return this.criticalSectionName;
        }

        public StringSet getObjectKeys() {
            return this.cacheKeys;
        }
    }
}

