/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.ExpressionColumn;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Routine;
import org.hsqldb.Session;
import org.hsqldb.StatementCompound;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.result.Result;
import org.hsqldb.result.ResultMetaData;

public abstract class Statement {
    static final int META_RESET_VIEWS = 1;
    static final int META_RESET_STATEMENTS = 2;
    static final Statement[] emptyArray = new Statement[0];
    final int type;
    int group;
    boolean isLogged = true;
    boolean isValid = true;
    int statementReturnType = 1;
    HsqlNameManager.HsqlName schemaName;
    Routine root;
    StatementCompound parent;
    boolean isError;
    boolean isTransactionStatement;
    boolean isExplain;
    String sql;
    long id;
    long compileTimestamp;
    HsqlNameManager.HsqlName[] readTableNames = HsqlNameManager.HsqlName.emptyArray;
    HsqlNameManager.HsqlName[] writeTableNames = HsqlNameManager.HsqlName.emptyArray;
    OrderedHashSet references;
    int cursorPropertiesRequest;

    public abstract Result execute(Session var1);

    public void setParameters(ExpressionColumn[] expressionColumnArray) {
    }

    Statement(int n) {
        this.type = n;
    }

    Statement(int n, int n2) {
        this.type = n;
        this.group = n2;
    }

    public final boolean isError() {
        return this.isError;
    }

    public boolean isTransactionStatement() {
        return this.isTransactionStatement;
    }

    public boolean isAutoCommitStatement() {
        return false;
    }

    public void setCompileTimestamp(long l) {
        this.compileTimestamp = l;
    }

    public long getCompileTimestamp() {
        return this.compileTimestamp;
    }

    public final void setSQL(String string) {
        this.sql = string;
    }

    public String getSQL() {
        return this.sql;
    }

    public OrderedHashSet getReferences() {
        return this.references;
    }

    public final void setDescribe() {
        this.isExplain = true;
    }

    public abstract String describe(Session var1);

    public HsqlNameManager.HsqlName getSchemaName() {
        return this.schemaName;
    }

    public final void setSchemaHsqlName(HsqlNameManager.HsqlName hsqlName) {
        this.schemaName = hsqlName;
    }

    public final void setID(long l) {
        this.id = l;
    }

    public final long getID() {
        return this.id;
    }

    public final int getType() {
        return this.type;
    }

    public final int getGroup() {
        return this.group;
    }

    public final boolean isValid() {
        return this.isValid;
    }

    public final boolean isLogged() {
        return this.isLogged;
    }

    public void clearVariables() {
    }

    public void resolve(Session session) {
    }

    public final HsqlNameManager.HsqlName[] getTableNamesForRead() {
        return this.readTableNames;
    }

    public final HsqlNameManager.HsqlName[] getTableNamesForWrite() {
        return this.writeTableNames;
    }

    public boolean isCatalogLock() {
        switch (this.group) {
            case 2002: {
                if (this.type == 134) {
                    return false;
                }
                if (this.writeTableNames.length == 0) {
                    return false;
                }
            }
            case 2001: 
            case 2012: {
                return true;
            }
            case 2014: {
                return true;
            }
        }
        return false;
    }

    public boolean isCatalogChange() {
        switch (this.group) {
            case 2001: 
            case 2002: 
            case 2012: {
                return true;
            }
        }
        return false;
    }

    public void setParent(StatementCompound statementCompound) {
        this.parent = statementCompound;
    }

    public void setRoot(Routine routine) {
        this.root = routine;
    }

    public boolean hasGeneratedColumns() {
        return false;
    }

    public ResultMetaData generatedResultMetaData() {
        return null;
    }

    public void setGeneratedColumnInfo(int n, ResultMetaData resultMetaData) {
    }

    public ResultMetaData getResultMetaData() {
        return ResultMetaData.emptyResultMetaData;
    }

    public ResultMetaData getParametersMetaData() {
        return ResultMetaData.emptyParamMetaData;
    }

    public int getResultProperties() {
        return 0;
    }

    public int getStatementReturnType() {
        return this.statementReturnType;
    }

    public int getCursorPropertiesRequest() {
        return this.cursorPropertiesRequest;
    }

    public void setCursorPropertiesRequest(int n) {
        this.cursorPropertiesRequest = n;
    }

    public void clearStructures(Session session) {
    }
}

