/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.store.memory;

import org.elasticsearch.cache.memory.ByteBufferCache;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.service.IndexService;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.index.store.DirectoryService;
import org.elasticsearch.index.store.memory.ByteBufferDirectoryService;
import org.elasticsearch.index.store.support.AbstractIndexStore;
import org.elasticsearch.indices.store.IndicesStore;
import org.elasticsearch.monitor.jvm.JvmInfo;
import org.elasticsearch.monitor.jvm.JvmStats;

public class ByteBufferIndexStore
extends AbstractIndexStore {
    private final boolean direct;

    @Inject
    public ByteBufferIndexStore(Index index, @IndexSettings Settings indexSettings, IndexService indexService, ByteBufferCache byteBufferCache, IndicesStore indicesStore) {
        super(index, indexSettings, indexService, indicesStore);
        this.direct = byteBufferCache.direct();
    }

    @Override
    public boolean persistent() {
        return false;
    }

    @Override
    public Class<? extends DirectoryService> shardDirectory() {
        return ByteBufferDirectoryService.class;
    }

    @Override
    public ByteSizeValue backingStoreTotalSpace() {
        if (this.direct) {
            return new ByteSizeValue(-1L, ByteSizeUnit.BYTES);
        }
        return JvmInfo.jvmInfo().mem().heapMax();
    }

    @Override
    public ByteSizeValue backingStoreFreeSpace() {
        if (this.direct) {
            return new ByteSizeValue(-1L, ByteSizeUnit.BYTES);
        }
        return JvmStats.jvmStats().mem().heapUsed();
    }
}

