/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.connectors.webcrawler;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.crawler.connectors.webcrawler.FindHandler;
import org.apache.manifoldcf.crawler.connectors.webcrawler.IRedirectionHandler;
import org.apache.manifoldcf.crawler.connectors.webcrawler.LoginParameters;
import org.apache.manifoldcf.crawler.system.Logging;

public class FindPreferredRedirectionHandler
extends FindHandler
implements IRedirectionHandler {
    protected Pattern redirectionURIPattern;

    public FindPreferredRedirectionHandler(String parentURI, Pattern redirectionURIPattern) {
        super(parentURI);
        this.redirectionURIPattern = redirectionURIPattern;
    }

    public void applyOverrides(LoginParameters lp) throws ManifoldCFException {
        if (this.targetURI != null && lp != null && lp.getOverrideTargetURL() != null) {
            super.noteDiscoveredLink(lp.getOverrideTargetURL());
        }
    }

    @Override
    public void noteDiscoveredLink(String rawURL) throws ManifoldCFException {
        if (this.targetURI == null) {
            Logging.connectors.debug((Object)("WEB: Tried to match raw url '" + rawURL + "'"));
            super.noteDiscoveredLink(rawURL);
            if (this.targetURI != null) {
                boolean canUse;
                Logging.connectors.debug((Object)("WEB: Tried to match cooked url '" + this.targetURI + "'"));
                if (this.redirectionURIPattern != null) {
                    Matcher m = this.redirectionURIPattern.matcher(this.targetURI);
                    canUse = m.find();
                    Logging.connectors.debug((Object)("WEB: Redirection link lookup " + (canUse ? "matched" : "didn't match") + " '" + this.targetURI + "'"));
                } else {
                    Logging.connectors.debug((Object)("WEB: Redirection link lookup for '" + this.targetURI + "' had no pattern to match"));
                    canUse = true;
                }
                if (!canUse) {
                    this.targetURI = null;
                }
            }
        }
    }
}

