/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.scriptengine;

import org.apache.manifoldcf.core.util.URLEncoder;
import org.apache.manifoldcf.scriptengine.ScriptException;
import org.apache.manifoldcf.scriptengine.Variable;
import org.apache.manifoldcf.scriptengine.VariableBase;
import org.apache.manifoldcf.scriptengine.VariableBoolean;
import org.apache.manifoldcf.scriptengine.VariableReference;

public class VariableQueryArg
extends VariableBase {
    protected final String name;
    protected final String value;

    public VariableQueryArg(String name, String value) {
        if (value == null) {
            value = "";
        }
        this.name = name;
        this.value = value;
    }

    public int hashCode() {
        return this.name.hashCode() + this.value.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof VariableQueryArg)) {
            return false;
        }
        VariableQueryArg other = (VariableQueryArg)o;
        return other.name.equals(this.name) && other.value.equals(this.value);
    }

    @Override
    public boolean hasStringValue() throws ScriptException {
        return true;
    }

    @Override
    public boolean hasScriptValue() throws ScriptException {
        return true;
    }

    @Override
    public boolean hasQueryArgumentValue() throws ScriptException {
        return true;
    }

    @Override
    public String getScriptValue() throws ScriptException {
        StringBuilder sb = new StringBuilder();
        sb.append("new queryarg ").append(VariableQueryArg.escapeValue(this.name)).append("=").append(VariableQueryArg.escapeValue(this.value));
        return sb.toString();
    }

    protected static String escapeValue(String input) {
        StringBuilder sb = new StringBuilder("\"");
        int i = 0;
        while (i < input.length()) {
            char x;
            if ((x = input.charAt(i++)) == '\\' || x == '\"') {
                sb.append('\\');
            }
            sb.append(x);
        }
        sb.append("\"");
        return sb.toString();
    }

    @Override
    public String getStringValue() throws ScriptException {
        return URLEncoder.encode((String)this.name).replace("+", "%20") + "=" + URLEncoder.encode((String)this.value).replace("+", "%20");
    }

    @Override
    public String getQueryArgumentValue() throws ScriptException {
        return this.getStringValue();
    }

    @Override
    public VariableReference doubleEquals(Variable v) throws ScriptException {
        if (v == null) {
            throw new ScriptException(this.composeMessage("Binary '==' operand cannot be null"));
        }
        return new VariableBoolean(this.getStringValue().equals(v.getStringValue()));
    }

    @Override
    public VariableReference exclamationEquals(Variable v) throws ScriptException {
        if (v == null) {
            throw new ScriptException(this.composeMessage("Binary '!=' operand cannot be null"));
        }
        return new VariableBoolean(!this.getStringValue().equals(v.getStringValue()));
    }
}

