/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.engine.spark;

import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.kyuubi.Logging;
import org.apache.kyuubi.util.KyuubiHadoopUtils$;
import org.apache.kyuubi.util.reflect.DynConstructors;
import org.apache.spark.SparkContext;
import org.apache.spark.kyuubi.SparkContextHelper$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class SparkTBinaryFrontendService$
implements Logging {
    public static SparkTBinaryFrontendService$ MODULE$;
    private final Text HIVE_DELEGATION_TOKEN;
    private final String HIVE_CONF_CLASSNAME;
    private volatile Configuration _hiveConf;
    private transient Logger org$apache$kyuubi$Logging$$log_;

    static {
        new SparkTBinaryFrontendService$();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public Logger logger() {
        return Logging.logger$(this);
    }

    @Override
    public void debug(Function0<Object> message) {
        Logging.debug$(this, message);
    }

    @Override
    public void debug(Function0<Object> message, Throwable t) {
        Logging.debug$(this, message, t);
    }

    @Override
    public void info(Function0<Object> message) {
        Logging.info$(this, message);
    }

    @Override
    public void info(Function0<Object> message, Throwable t) {
        Logging.info$(this, message, t);
    }

    @Override
    public void warn(Function0<Object> message) {
        Logging.warn$(this, message);
    }

    @Override
    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$(this, message, t);
    }

    @Override
    public void error(Function0<Object> message, Throwable t) {
        Logging.error$(this, message, t);
    }

    @Override
    public void error(Function0<Object> message) {
        Logging.error$(this, message);
    }

    @Override
    public void initializeLoggerIfNecessary(boolean isInterpreter) {
        Logging.initializeLoggerIfNecessary$(this, isInterpreter);
    }

    @Override
    public Logger org$apache$kyuubi$Logging$$log_() {
        return this.org$apache$kyuubi$Logging$$log_;
    }

    @Override
    public void org$apache$kyuubi$Logging$$log__$eq(Logger x$1) {
        this.org$apache$kyuubi$Logging$$log_ = x$1;
    }

    public Text HIVE_DELEGATION_TOKEN() {
        return this.HIVE_DELEGATION_TOKEN;
    }

    public String HIVE_CONF_CLASSNAME() {
        return this.HIVE_CONF_CLASSNAME;
    }

    private Configuration _hiveConf() {
        return this._hiveConf;
    }

    private void _hiveConf_$eq(Configuration x$1) {
        this._hiveConf = x$1;
    }

    public void renewDelegationToken(SparkContext sc, String delegationToken) {
        Credentials newCreds = KyuubiHadoopUtils$.MODULE$.decodeCredentials(delegationToken);
        Tuple2 tuple2 = KyuubiHadoopUtils$.MODULE$.getTokenMap(newCreds).partition((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)SparkTBinaryFrontendService$.$anonfun$renewDelegationToken$1(x$4)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Map hiveTokens = (Map)tuple2._1();
        Map otherTokens = (Map)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)hiveTokens, (Object)otherTokens);
        Map hiveTokens2 = (Map)tuple22._1();
        Map otherTokens2 = (Map)tuple22._2();
        Credentials updateCreds = new Credentials();
        Credentials oldCreds = UserGroupInformation.getCurrentUser().getCredentials();
        this.addHiveToken(sc, (Map<Text, Token<? extends TokenIdentifier>>)hiveTokens2, oldCreds, updateCreds);
        this.addOtherTokens((Map<Text, Token<? extends TokenIdentifier>>)otherTokens2, oldCreds, updateCreds);
        if (updateCreds.numberOfTokens() > 0) {
            this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(111).append("Update delegation tokens. ").append("The number of tokens sent by the server is ").append(newCreds.numberOfTokens()).append(". ").append("The actual number of updated tokens is ").append(updateCreds.numberOfTokens()).append(".").toString());
            SparkContextHelper$.MODULE$.updateDelegationTokens(sc, updateCreds);
            return;
        }
    }

    private void addHiveToken(SparkContext sc, Map<Text, Token<? extends TokenIdentifier>> newTokens, Credentials oldCreds, Credentials updateCreds) {
        String metastoreUris = this.hiveConf(sc.hadoopConfiguration()).getTrimmed("hive.metastore.uris", "");
        Option oldAliasAndToken = KyuubiHadoopUtils$.MODULE$.getTokenMap(oldCreds).find((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)SparkTBinaryFrontendService$.$anonfun$addHiveToken$1(x0$1)));
        if (new StringOps(Predef$.MODULE$.augmentString(metastoreUris)).nonEmpty() && oldAliasAndToken.isDefined()) {
            Set uriSet = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])metastoreUris.split(","))).filter((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)SparkTBinaryFrontendService$.$anonfun$addHiveToken$2(x$6))))).toSet();
            Option newToken = newTokens.find((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)SparkTBinaryFrontendService$.$anonfun$addHiveToken$3(uriSet, x0$2))).map((Function1 & Serializable & scala.Serializable)x$7 -> (Token)x$7._2());
            newToken.foreach((Function1 & Serializable & scala.Serializable)token -> {
                SparkTBinaryFrontendService$.$anonfun$addHiveToken$7(oldAliasAndToken, updateCreds, token);
                return BoxedUnit.UNIT;
            });
            if (newToken.isEmpty()) {
                this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(55).append("No matching Hive token found for engine metastore uris ").append(metastoreUris).toString());
                return;
            }
            return;
        }
        if (metastoreUris.isEmpty()) {
            this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "Ignore Hive token as hive.metastore.uris are empty");
            return;
        }
        this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "Ignore Hive token as engine does not need it");
    }

    private void addOtherTokens(Map<Text, Token<? extends TokenIdentifier>> tokens, Credentials oldCreds, Credentials updateCreds) {
        tokens.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            SparkTBinaryFrontendService$.$anonfun$addOtherTokens$1(oldCreds, updateCreds, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private int compareIssueDate(Token<? extends TokenIdentifier> newToken, Token<? extends TokenIdentifier> oldToken) {
        Option<Object> newDate = KyuubiHadoopUtils$.MODULE$.getTokenIssueDate(newToken);
        Option<Object> oldDate = KyuubiHadoopUtils$.MODULE$.getTokenIssueDate(oldToken);
        if (newDate.isDefined() && oldDate.isDefined() && BoxesRunTime.unboxToLong((Object)newDate.get()) <= BoxesRunTime.unboxToLong((Object)oldDate.get())) {
            return -1;
        }
        return 1;
    }

    public Configuration hiveConf(Configuration hadoopConf) {
        if (this._hiveConf() == null) {
            SparkTBinaryFrontendService$ sparkTBinaryFrontendService$ = this;
            synchronized (sparkTBinaryFrontendService$) {
                if (this._hiveConf() == null) {
                    this._hiveConf_$eq(this.liftedTree1$1(hadoopConf));
                }
            }
        }
        return this._hiveConf();
    }

    public static final /* synthetic */ boolean $anonfun$renewDelegationToken$1(Tuple2 x$4) {
        Text text = ((Token)x$4._2()).getKind();
        Text text2 = MODULE$.HIVE_DELEGATION_TOKEN();
        return !(text != null ? !text.equals(text2) : text2 != null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$addHiveToken$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        Token token = (Token)tuple2._2();
        Text text = token.getKind();
        Text text2 = MODULE$.HIVE_DELEGATION_TOKEN();
        if (text == null) {
            if (text2 != null) {
                return false;
            }
        } else if (!text.equals(text2)) return false;
        Text text3 = token.getService();
        Text text4 = new Text();
        if (text3 == null) {
            if (text4 == null) return true;
            return false;
        } else {
            if (!text3.equals(text4)) return false;
            return true;
        }
    }

    public static final /* synthetic */ boolean $anonfun$addHiveToken$2(String x$6) {
        return new StringOps(Predef$.MODULE$.augmentString(x$6)).nonEmpty();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$addHiveToken$3(Set uriSet$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        Text uris = (Text)tuple2._1();
        Token token = (Token)tuple2._2();
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])uris.toString().split(","))).exists((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)uriSet$1.contains((Object)elem)))) {
            Text text = token.getService();
            Text text2 = new Text();
            if (text == null) {
                if (text2 == null) return true;
            } else if (text.equals(text2)) {
                return true;
            }
        }
        boolean bl = false;
        boolean matched = bl;
        if (matched) return matched;
        MODULE$.debug((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(22).append("Filter out Hive token ").append(token).toString());
        return matched;
    }

    public static final /* synthetic */ void $anonfun$addHiveToken$7(Option oldAliasAndToken$1, Credentials updateCreds$2, Token token) {
        if (MODULE$.compareIssueDate((Token<? extends TokenIdentifier>)token, (Token<? extends TokenIdentifier>)((Token)((Tuple2)oldAliasAndToken$1.get())._2())) > 0) {
            updateCreds$2.addToken((Text)((Tuple2)oldAliasAndToken$1.get())._1(), token);
            return;
        }
        MODULE$.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Ignore Hive token with earlier issue date: ").append(token).toString());
    }

    public static final /* synthetic */ void $anonfun$addOtherTokens$1(Credentials oldCreds$1, Credentials updateCreds$3, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Text alias = (Text)tuple2._1();
            Token newToken = (Token)tuple2._2();
            Token oldToken = oldCreds$1.getToken(alias);
            if (oldToken != null) {
                if (MODULE$.compareIssueDate((Token<? extends TokenIdentifier>)newToken, (Token<? extends TokenIdentifier>)oldToken) > 0) {
                    updateCreds$3.addToken(alias, newToken);
                    return;
                }
                MODULE$.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Ignore token with earlier issue date: ").append(newToken).toString());
                return;
            }
            MODULE$.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(21).append("Ignore unknown token ").append(newToken).toString());
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    private final /* synthetic */ Configuration liftedTree1$1(Configuration hadoopConf$1) {
        Configuration configuration;
        try {
            configuration = (Configuration)DynConstructors.builder().impl(this.HIVE_CONF_CLASSNAME(), Configuration.class, Class.class).build().newInstance(hadoopConf$1, Class.forName(this.HIVE_CONF_CLASSNAME()));
        }
        catch (Throwable e) {
            this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "Fail to create Hive Configuration", e);
            configuration = hadoopConf$1;
        }
        return configuration;
    }

    private SparkTBinaryFrontendService$() {
        MODULE$ = this;
        Logging.$init$(this);
        this.HIVE_DELEGATION_TOKEN = new Text("HIVE_DELEGATION_TOKEN");
        this.HIVE_CONF_CLASSNAME = "org.apache.hadoop.hive.conf.HiveConf";
    }
}

