/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.engine.spark.util;

import java.io.Serializable;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.kyuubi.Logging;
import org.apache.kyuubi.engine.spark.schema.SchemaHelper$;
import org.apache.kyuubi.util.reflect.ReflectUtils$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.plans.logical.View;
import org.apache.spark.sql.connector.catalog.CatalogExtension;
import org.apache.spark.sql.connector.catalog.CatalogManager;
import org.apache.spark.sql.connector.catalog.CatalogPlugin;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.SupportsNamespaces;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.types.StructField;
import org.slf4j.Logger;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class SparkCatalogUtils$
implements Logging {
    public static final SparkCatalogUtils$ MODULE$ = new SparkCatalogUtils$();
    private static final String VIEW;
    private static final String TABLE;
    private static final String SESSION_CATALOG;
    private static final Set<String> sparkTableTypes;
    private static final Pattern validIdentPattern;
    private static transient Logger org$apache$kyuubi$Logging$$log_;

    static {
        Logging.$init$(MODULE$);
        VIEW = "VIEW";
        TABLE = "TABLE";
        SESSION_CATALOG = "spark_catalog";
        sparkTableTypes = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{MODULE$.VIEW(), MODULE$.TABLE()}));
        validIdentPattern = Pattern.compile("^[a-zA-Z_][a-zA-Z0-9_]*");
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public Logger logger() {
        return Logging.logger$(this);
    }

    @Override
    public void debug(Function0<Object> message) {
        Logging.debug$(this, message);
    }

    @Override
    public void debug(Function0<Object> message, Throwable t) {
        Logging.debug$(this, message, t);
    }

    @Override
    public void info(Function0<Object> message) {
        Logging.info$(this, message);
    }

    @Override
    public void info(Function0<Object> message, Throwable t) {
        Logging.info$(this, message, t);
    }

    @Override
    public void warn(Function0<Object> message) {
        Logging.warn$(this, message);
    }

    @Override
    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$(this, message, t);
    }

    @Override
    public void error(Function0<Object> message, Throwable t) {
        Logging.error$(this, message, t);
    }

    @Override
    public void error(Function0<Object> message) {
        Logging.error$(this, message);
    }

    @Override
    public void initializeLoggerIfNecessary(boolean isInterpreter) {
        Logging.initializeLoggerIfNecessary$(this, isInterpreter);
    }

    @Override
    public Logger org$apache$kyuubi$Logging$$log_() {
        return org$apache$kyuubi$Logging$$log_;
    }

    @Override
    public void org$apache$kyuubi$Logging$$log__$eq(Logger x$1) {
        org$apache$kyuubi$Logging$$log_ = x$1;
    }

    private String VIEW() {
        return VIEW;
    }

    private String TABLE() {
        return TABLE;
    }

    public String SESSION_CATALOG() {
        return SESSION_CATALOG;
    }

    public Set<String> sparkTableTypes() {
        return sparkTableTypes;
    }

    public Seq<Row> getCatalogs(SparkSession spark) {
        CatalogManager catalogMgr = spark.sessionState().catalogManager();
        Object sessionCatalog = ReflectUtils$.MODULE$.invokeAs(catalogMgr, "v2SessionCatalog", (Seq<Tuple2<Class<?>, Object>>)Nil$.MODULE$);
        CatalogPlugin defaultCatalog = catalogMgr.currentCatalog();
        Seq defaults = (Seq)((IterableOps)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{sessionCatalog, defaultCatalog})).distinct()).map((Function1 & Serializable)x$1 -> (String)ReflectUtils$.MODULE$.invokeAs(x$1, "name", (Seq<Tuple2<Class<?>, Object>>)Nil$.MODULE$));
        Map catalogs = (Map)ReflectUtils$.MODULE$.getField(catalogMgr, "catalogs");
        Iterable iterable = catalogs.keys();
        return (Seq)((IterableOps)((SeqOps)defaults.$plus$plus$colon((IterableOnce)iterable)).distinct()).map((Function1 & Serializable)x$2 -> Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{x$2})));
    }

    public CatalogPlugin getCatalog(SparkSession spark, String catalogName) {
        CatalogManager catalogManager = spark.sessionState().catalogManager();
        return StringUtils.isBlank((CharSequence)catalogName) ? catalogManager.currentCatalog() : catalogManager.catalog(catalogName);
    }

    public void setCurrentCatalog(SparkSession spark, String catalog) {
        if (!spark.sessionState().catalogManager().isCatalogRegistered(catalog)) {
            throw new IllegalArgumentException(new StringBuilder(47).append("Cannot find catalog plugin class for catalog '").append(catalog).append("'").toString());
        }
        spark.sessionState().catalogManager().setCurrentCatalog(catalog);
    }

    public Seq<Row> getSchemas(SparkSession spark, String catalogName, String schemaPattern) {
        Seq seq;
        String string = catalogName;
        String string2 = this.SESSION_CATALOG();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            seq = (Seq)((IterableOps)spark.sessionState().catalog().listDatabases(schemaPattern).$plus$plus(this.getGlobalTempViewManager(spark, schemaPattern))).map((Function1 & Serializable)x$3 -> Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{x$3, MODULE$.SESSION_CATALOG()})));
        } else {
            CatalogPlugin catalog = this.getCatalog(spark, catalogName);
            seq = (Seq)this.getSchemasWithPattern(catalog, schemaPattern).map((Function1 & Serializable)x$4 -> Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{x$4, catalog.name()})));
        }
        return seq;
    }

    private Seq<String> getGlobalTempViewManager(SparkSession spark, String schemaPattern) {
        String database = spark.sharedState().globalTempViewManager().database();
        return Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)database).filter((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.matches(schemaPattern)))).toSeq();
    }

    private String[][] listAllNamespaces(SupportsNamespaces catalog, String[][] namespaces) {
        String[][] stringArray;
        String[][] children = (String[][])ArrayOps$.MODULE$.flatMap$extension(Predef$.MODULE$.refArrayOps((Object[])namespaces), (Function1 & Serializable)ns -> catalog.listNamespaces(ns), (Function1 & Serializable)xs -> Predef$.MODULE$.wrapRefArray((Object[])xs), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)));
        if (ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])children))) {
            stringArray = namespaces;
        } else {
            String[][] stringArray2 = namespaces;
            stringArray = (String[][])ArrayOps$.MODULE$.$plus$plus$colon$extension(Predef$.MODULE$.refArrayOps((Object[])this.listAllNamespaces(catalog, children)), (Object)stringArray2, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)));
        }
        return stringArray;
    }

    private String[][] listAllNamespaces(CatalogPlugin catalog) {
        String[][] stringArray;
        CatalogPlugin catalogPlugin = catalog;
        if (catalogPlugin instanceof CatalogExtension) {
            CatalogExtension catalogExtension = (CatalogExtension)catalogPlugin;
            String[] stringArray2 = catalogExtension.defaultNamespace();
            stringArray = (String[][])ArrayOps$.MODULE$.$plus$colon$extension(Predef$.MODULE$.refArrayOps((Object[])catalogExtension.listNamespaces((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class)))), (Object)stringArray2, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)));
        } else if (catalogPlugin instanceof SupportsNamespaces) {
            String[][] allSchemas;
            SupportsNamespaces supportsNamespaces = (SupportsNamespaces)catalogPlugin;
            String[][] rootSchema = supportsNamespaces.listNamespaces();
            stringArray = allSchemas = this.listAllNamespaces(supportsNamespaces, rootSchema);
        } else {
            throw new MatchError((Object)catalogPlugin);
        }
        return stringArray;
    }

    private String[][] listNamespacesWithPattern(CatalogPlugin catalog, String schemaPattern) {
        return (String[][])((List)Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])this.listAllNamespaces(catalog)), (Function1 & Serializable)ns -> BoxesRunTime.boxToBoolean((boolean)SparkCatalogUtils$.$anonfun$listNamespacesWithPattern$1(schemaPattern, ns)))), (Function1 & Serializable)x$6 -> Predef$.MODULE$.wrapRefArray((Object[])x$6).toList(), ClassTag$.MODULE$.apply(List.class))).toList().distinct()).map((Function1 & Serializable)x$7 -> (String[])x$7.toArray(ClassTag$.MODULE$.apply(String.class))).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)));
    }

    private Seq<String> getSchemasWithPattern(CatalogPlugin catalog, String schemaPattern) {
        Pattern p = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(schemaPattern)).pattern();
        return Predef$.MODULE$.copyArrayToImmutableIndexedSeq(ArrayOps$.MODULE$.distinct$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.flatMap$extension(Predef$.MODULE$.refArrayOps((Object[])this.listAllNamespaces(catalog)), (Function1 & Serializable)ns -> {
            String quoted = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ns), (Function1 & Serializable)part -> MODULE$.quoteIfNeeded((String)part), ClassTag$.MODULE$.apply(String.class))).mkString(".");
            return p.matcher(quoted).matches() ? new Some((Object)quoted) : None$.MODULE$;
        }, ClassTag$.MODULE$.apply(String.class)))));
    }

    public Seq<Row> getCatalogTablesOrViews(SparkSession spark, String catalogName, String schemaPattern, String tablePattern, Set<String> tableTypes, boolean ignoreTableProperties) {
        Seq seq;
        CatalogPlugin catalog = this.getCatalog(spark, catalogName);
        String[][] namespaces = this.listNamespacesWithPattern(catalog, schemaPattern);
        CatalogPlugin catalogPlugin = catalog;
        String string = catalogPlugin.name();
        String string2 = this.SESSION_CATALOG();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            SessionCatalog sessionCatalog = spark.sessionState().catalog();
            Seq databases = sessionCatalog.listDatabases(schemaPattern);
            seq = (Seq)databases.flatMap((Function1 & Serializable)db -> {
                Seq identifiers = sessionCatalog.listTables(db, tablePattern, false);
                return ignoreTableProperties ? (IterableOnce)identifiers.map((Function1 & Serializable)ti -> Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{catalogName, ti.database().getOrElse((Function0 & Serializable)() -> "default"), ti.table(), MODULE$.TABLE(), "", null, null, null, null, null}))) : (IterableOnce)((IterableOps)sessionCatalog.getTablesByName(identifiers).filter((Function1 & Serializable)t -> BoxesRunTime.boxToBoolean((boolean)this.isMatchedTableType$1(tableTypes, t.tableType().name())))).map((Function1 & Serializable)t -> {
                    String string = t.tableType().name();
                    String string2 = MODULE$.VIEW();
                    String typ = !(string != null ? !string.equals(string2) : string2 != null) ? MODULE$.VIEW() : MODULE$.TABLE();
                    return Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{catalogName, t.database(), t.identifier().table(), typ, t.comment().getOrElse((Function0 & Serializable)() -> ""), null, null, null, null, null}));
                });
            });
        } else if (catalogPlugin instanceof TableCatalog) {
            TableCatalog tableCatalog = (TableCatalog)catalogPlugin;
            Pattern tp = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(tablePattern)).pattern();
            Identifier[] identifiers = (Identifier[])ArrayOps$.MODULE$.flatMap$extension(Predef$.MODULE$.refArrayOps((Object[])namespaces), (Function1 & Serializable)ns -> (Identifier[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])tableCatalog.listTables(ns)), (Function1 & Serializable)i -> BoxesRunTime.boxToBoolean((boolean)SparkCatalogUtils$.$anonfun$getCatalogTablesOrViews$9(tp, i))), (Function1 & Serializable)xs -> Predef$.MODULE$.wrapRefArray((Object[])xs), ClassTag$.MODULE$.apply(Identifier.class));
            seq = Predef$.MODULE$.copyArrayToImmutableIndexedSeq(ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])identifiers), (Function1 & Serializable)ident -> {
                String comment = ignoreTableProperties ? "" : tableCatalog.loadTable(ident).properties().getOrDefault("comment", "");
                String schema = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ident.namespace()), (Function1 & Serializable)part -> MODULE$.quoteIfNeeded((String)part), ClassTag$.MODULE$.apply(String.class))).mkString(".");
                String tableName = MODULE$.quoteIfNeeded(ident.name());
                return Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{catalog.name(), schema, tableName, MODULE$.TABLE(), comment, null, null, null, null, null}));
            }, ClassTag$.MODULE$.apply(Row.class)));
        } else {
            seq = (Seq)package$.MODULE$.Seq().empty();
        }
        return seq;
    }

    public boolean getCatalogTablesOrViews$default$6() {
        return false;
    }

    private Seq<Row> getColumnsByCatalog(SparkSession spark, String catalogName, String schemaPattern, String tablePattern, Pattern columnPattern) {
        Seq seq;
        CatalogPlugin catalog = this.getCatalog(spark, catalogName);
        CatalogPlugin catalogPlugin = catalog;
        if (catalogPlugin instanceof TableCatalog) {
            TableCatalog tableCatalog = (TableCatalog)catalogPlugin;
            String[][] namespaces = this.listNamespacesWithPattern(catalog, schemaPattern);
            Pattern tp = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(tablePattern)).pattern();
            Identifier[] identifiers = (Identifier[])ArrayOps$.MODULE$.flatMap$extension(Predef$.MODULE$.refArrayOps((Object[])namespaces), (Function1 & Serializable)ns -> (Identifier[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])tableCatalog.listTables(ns)), (Function1 & Serializable)i -> BoxesRunTime.boxToBoolean((boolean)SparkCatalogUtils$.$anonfun$getColumnsByCatalog$2(tp, i))), (Function1 & Serializable)xs -> Predef$.MODULE$.wrapRefArray((Object[])xs), ClassTag$.MODULE$.apply(Identifier.class));
            seq = Predef$.MODULE$.copyArrayToImmutableIndexedSeq(ArrayOps$.MODULE$.flatMap$extension(Predef$.MODULE$.refArrayOps((Object[])identifiers), (Function1 & Serializable)ident -> {
                Table table = tableCatalog.loadTable(ident);
                String namespace = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ident.namespace()), (Function1 & Serializable)part -> MODULE$.quoteIfNeeded((String)part), ClassTag$.MODULE$.apply(String.class))).mkString(".");
                String tableName = MODULE$.quoteIfNeeded(ident.name());
                return (Seq)((IterableOps)((IterableOps)table.schema().zipWithIndex()).filter((Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)SparkCatalogUtils$.$anonfun$getColumnsByCatalog$6(columnPattern, f)))).map((Function1 & Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    StructField f = (StructField)tuple2._1();
                    int i = tuple2._2$mcI$sp();
                    Row row = MODULE$.toColumnResult(tableCatalog.name(), namespace, tableName, f, i);
                    return row;
                });
            }, ClassTag$.MODULE$.apply(Row.class)));
        } else {
            String string = catalogPlugin.name();
            String string2 = this.SESSION_CATALOG();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                SessionCatalog catalog2 = spark.sessionState().catalog();
                Seq databases = catalog2.listDatabases(schemaPattern);
                seq = (Seq)databases.flatMap((Function1 & Serializable)db -> {
                    Seq identifiers = catalog2.listTables(db, tablePattern, true);
                    return (Seq)catalog2.getTablesByName(identifiers).flatMap((Function1 & Serializable)t -> (Seq)((IterableOps)((IterableOps)t.schema().zipWithIndex()).filter((Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)SparkCatalogUtils$.$anonfun$getColumnsByCatalog$10(columnPattern, f)))).map((Function1 & Serializable)x0$2 -> {
                        Tuple2 tuple2 = x0$2;
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        StructField f = (StructField)tuple2._1();
                        int i = tuple2._2$mcI$sp();
                        Row row = MODULE$.toColumnResult(catalogName, t.database(), t.identifier().table(), f, i);
                        return row;
                    }));
                });
            } else {
                throw new MatchError((Object)catalogPlugin);
            }
        }
        return seq;
    }

    public Seq<Row> getTempViews(SparkSession spark, String catalogName, String schemaPattern, String tablePattern) {
        Seq<TableIdentifier> views = this.getViews(spark, schemaPattern, tablePattern);
        return (Seq)views.map((Function1 & Serializable)ident -> Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{catalogName, ident.database().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), ident.table(), MODULE$.VIEW(), "", null, null, null, null, null})));
    }

    private Seq<TableIdentifier> getViews(SparkSession spark, String schemaPattern, String tablePattern) {
        Seq<String> db = this.getGlobalTempViewManager(spark, schemaPattern);
        return db.nonEmpty() ? spark.sessionState().catalog().listTables((String)db.head(), tablePattern) : spark.sessionState().catalog().listLocalTempViews(tablePattern);
    }

    public Seq<Row> getColumns(SparkSession spark, String catalogName, String schemaPattern, String tablePattern, String columnPattern) {
        Pattern cp = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(columnPattern)).pattern();
        Seq<Row> byCatalog = this.getColumnsByCatalog(spark, catalogName, schemaPattern, tablePattern, cp);
        Seq<Row> byGlobalTmpDB = this.getColumnsByGlobalTempViewManager(spark, schemaPattern, tablePattern, cp);
        Seq<Row> byLocalTmp = this.getColumnsByLocalTempViews(spark, tablePattern, cp);
        return (Seq)((IterableOps)byCatalog.$plus$plus(byGlobalTmpDB)).$plus$plus(byLocalTmp);
    }

    private Seq<Row> getColumnsByGlobalTempViewManager(SparkSession spark, String schemaPattern, String tablePattern, Pattern columnPattern) {
        SessionCatalog catalog = spark.sessionState().catalog();
        return (Seq)this.getGlobalTempViewManager(spark, schemaPattern).flatMap((Function1 & Serializable)globalTmpDb -> (Seq)((IterableOps)catalog.globalTempViewManager().listViewNames(tablePattern).flatMap((Function1 & Serializable)v -> catalog.globalTempViewManager().get(v).map((Function1 & Serializable)plan -> (Seq)((IterableOps)((IterableOps)plan.schema().zipWithIndex()).filter((Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)SparkCatalogUtils$.$anonfun$getColumnsByGlobalTempViewManager$4(columnPattern, f)))).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            StructField f = (StructField)tuple2._1();
            int i = tuple2._2$mcI$sp();
            Row row = MODULE$.toColumnResult(MODULE$.SESSION_CATALOG(), (String)globalTmpDb, (String)v, f, i);
            return row;
        })))).flatten(Predef$.MODULE$.$conforms()));
    }

    private Seq<Row> getColumnsByLocalTempViews(SparkSession spark, String tablePattern, Pattern columnPattern) {
        SessionCatalog catalog = spark.sessionState().catalog();
        return (Seq)((IterableOps)catalog.listLocalTempViews(tablePattern).map((Function1 & Serializable)v -> new Tuple2(v, catalog.getTempView(v.table()).get()))).flatMap((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TableIdentifier v = (TableIdentifier)tuple2._1();
            View plan = (View)tuple2._2();
            IterableOnce iterableOnce = (IterableOnce)((IterableOps)((IterableOps)plan.schema().zipWithIndex()).filter((Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)SparkCatalogUtils$.$anonfun$getColumnsByLocalTempViews$3(columnPattern, f)))).map((Function1 & Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                StructField f = (StructField)tuple2._1();
                int i = tuple2._2$mcI$sp();
                Row row = MODULE$.toColumnResult(MODULE$.SESSION_CATALOG(), null, v.table(), f, i);
                return row;
            });
            return iterableOnce;
        });
    }

    private Row toColumnResult(String catalog, String db, String table, StructField col, int pos) {
        return Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{catalog, db, table, col.name(), BoxesRunTime.boxToInteger((int)SchemaHelper$.MODULE$.toJavaSQLType(col.dataType())), col.dataType().sql(), SchemaHelper$.MODULE$.getColumnSize(col.dataType()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), null, SchemaHelper$.MODULE$.getDecimalDigits(col.dataType()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), SchemaHelper$.MODULE$.getNumPrecRadix(col.dataType()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), col.nullable() ? BoxesRunTime.boxToInteger((int)1) : BoxesRunTime.boxToInteger((int)0), col.getComment().getOrElse((Function0 & Serializable)() -> ""), null, null, null, null, BoxesRunTime.boxToInteger((int)pos), "YES", null, null, null, null, "NO"}));
    }

    private Pattern validIdentPattern() {
        return validIdentPattern;
    }

    public String quoteIfNeeded(String part) {
        return this.validIdentPattern().matcher(part).matches() ? part : this.quoteIdentifier(part);
    }

    public String quoteIdentifier(String name) {
        return new StringBuilder(2).append("`").append(name.replace("`", "``")).append("`").toString();
    }

    public static final /* synthetic */ boolean $anonfun$listNamespacesWithPattern$1(String schemaPattern$2, String[] ns) {
        String quoted = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ns), (Function1 & Serializable)part -> MODULE$.quoteIfNeeded((String)part), ClassTag$.MODULE$.apply(String.class))).mkString(".");
        return StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(schemaPattern$2)).pattern().matcher(quoted).matches();
    }

    private final boolean isMatchedTableType$1(Set tableTypes, String tableType) {
        String typ = tableType.equalsIgnoreCase(this.VIEW()) ? this.VIEW() : this.TABLE();
        return tableTypes.exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)typ.equalsIgnoreCase(x$1)));
    }

    public static final /* synthetic */ boolean $anonfun$getCatalogTablesOrViews$9(Pattern tp$1, Identifier i) {
        return tp$1.matcher(MODULE$.quoteIfNeeded(i.name())).matches();
    }

    public static final /* synthetic */ boolean $anonfun$getColumnsByCatalog$2(Pattern tp$2, Identifier i) {
        return tp$2.matcher(MODULE$.quoteIfNeeded(i.name())).matches();
    }

    public static final /* synthetic */ boolean $anonfun$getColumnsByCatalog$6(Pattern columnPattern$1, Tuple2 f) {
        return columnPattern$1.matcher(((StructField)f._1()).name()).matches();
    }

    public static final /* synthetic */ boolean $anonfun$getColumnsByCatalog$10(Pattern columnPattern$1, Tuple2 f) {
        return columnPattern$1.matcher(((StructField)f._1()).name()).matches();
    }

    public static final /* synthetic */ boolean $anonfun$getColumnsByGlobalTempViewManager$4(Pattern columnPattern$2, Tuple2 f) {
        return columnPattern$2.matcher(((StructField)f._1()).name()).matches();
    }

    public static final /* synthetic */ boolean $anonfun$getColumnsByLocalTempViews$3(Pattern columnPattern$3, Tuple2 f) {
        return columnPattern$3.matcher(((StructField)f._1()).name()).matches();
    }

    private SparkCatalogUtils$() {
    }
}

