/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shaded.thrift.server;

import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.util.Iterator;
import org.apache.kyuubi.shaded.thrift.server.AbstractNonblockingServer;
import org.apache.kyuubi.shaded.thrift.transport.TNonblockingServerTransport;
import org.apache.kyuubi.shaded.thrift.transport.TNonblockingTransport;
import org.apache.kyuubi.shaded.thrift.transport.TTransportException;

public class TNonblockingServer
extends AbstractNonblockingServer {
    private SelectAcceptThread selectAcceptThread_;

    public TNonblockingServer(AbstractNonblockingServer.AbstractNonblockingServerArgs args) {
        super(args);
    }

    @Override
    protected boolean startThreads() {
        try {
            this.selectAcceptThread_ = new SelectAcceptThread((TNonblockingServerTransport)this.serverTransport_);
            this.selectAcceptThread_.start();
            return true;
        }
        catch (IOException e) {
            this.LOGGER.error("Failed to start selector thread!", (Throwable)e);
            return false;
        }
    }

    @Override
    protected void waitForShutdown() {
        this.joinSelector();
    }

    protected void joinSelector() {
        try {
            this.selectAcceptThread_.join();
        }
        catch (InterruptedException e) {
            this.LOGGER.debug("Interrupted while waiting for accept thread", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void stop() {
        this.stopped_ = true;
        if (this.selectAcceptThread_ != null) {
            this.selectAcceptThread_.wakeupSelector();
        }
    }

    @Override
    protected boolean requestInvoke(AbstractNonblockingServer.FrameBuffer frameBuffer) {
        frameBuffer.invoke();
        return true;
    }

    public boolean isStopped() {
        return this.selectAcceptThread_.isStopped();
    }

    protected class SelectAcceptThread
    extends AbstractNonblockingServer.AbstractSelectThread {
        private final TNonblockingServerTransport serverTransport;

        public SelectAcceptThread(TNonblockingServerTransport serverTransport) throws IOException {
            super(TNonblockingServer.this);
            this.serverTransport = serverTransport;
            serverTransport.registerSelector(this.selector);
        }

        public boolean isStopped() {
            return TNonblockingServer.this.stopped_;
        }

        @Override
        public void run() {
            try {
                if (TNonblockingServer.this.eventHandler_ != null) {
                    TNonblockingServer.this.eventHandler_.preServe();
                }
                while (!TNonblockingServer.this.stopped_) {
                    this.select();
                    this.processInterestChanges();
                }
                for (SelectionKey selectionKey : this.selector.keys()) {
                    this.cleanupSelectionKey(selectionKey);
                }
            }
            catch (Throwable t) {
                TNonblockingServer.this.LOGGER.error("run() exiting due to uncaught error", t);
            }
            finally {
                try {
                    this.selector.close();
                }
                catch (IOException e) {
                    TNonblockingServer.this.LOGGER.error("Got an IOException while closing selector!", (Throwable)e);
                }
                TNonblockingServer.this.stopped_ = true;
            }
        }

        private void select() {
            try {
                this.selector.select();
                Iterator<SelectionKey> selectedKeys = this.selector.selectedKeys().iterator();
                while (!TNonblockingServer.this.stopped_ && selectedKeys.hasNext()) {
                    SelectionKey key = selectedKeys.next();
                    selectedKeys.remove();
                    if (!key.isValid()) {
                        this.cleanupSelectionKey(key);
                        continue;
                    }
                    if (key.isAcceptable()) {
                        this.handleAccept();
                        continue;
                    }
                    if (key.isReadable()) {
                        this.handleRead(key);
                        continue;
                    }
                    if (key.isWritable()) {
                        this.handleWrite(key);
                        continue;
                    }
                    TNonblockingServer.this.LOGGER.warn("Unexpected state in select! " + key.interestOps());
                }
            }
            catch (IOException e) {
                TNonblockingServer.this.LOGGER.warn("Got an IOException while selecting!", (Throwable)e);
            }
        }

        protected AbstractNonblockingServer.FrameBuffer createFrameBuffer(TNonblockingTransport trans, SelectionKey selectionKey, AbstractNonblockingServer.AbstractSelectThread selectThread) throws TTransportException {
            return TNonblockingServer.this.processorFactory_.isAsyncProcessor() ? new AbstractNonblockingServer.AsyncFrameBuffer(TNonblockingServer.this, trans, selectionKey, selectThread) : new AbstractNonblockingServer.FrameBuffer(TNonblockingServer.this, trans, selectionKey, selectThread);
        }

        private void handleAccept() throws IOException {
            block3: {
                SelectionKey clientKey = null;
                TNonblockingTransport client = null;
                try {
                    client = this.serverTransport.accept();
                    clientKey = client.registerSelector(this.selector, 1);
                    AbstractNonblockingServer.FrameBuffer frameBuffer = this.createFrameBuffer(client, clientKey, this);
                    clientKey.attach(frameBuffer);
                }
                catch (TTransportException tte) {
                    TNonblockingServer.this.LOGGER.warn("Exception trying to accept!", (Throwable)tte);
                    if (clientKey != null) {
                        this.cleanupSelectionKey(clientKey);
                    }
                    if (client == null) break block3;
                    client.close();
                }
            }
        }
    }

    public static class Args
    extends AbstractNonblockingServer.AbstractNonblockingServerArgs<Args> {
        public Args(TNonblockingServerTransport transport) {
            super(transport);
        }
    }
}

