/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.beeline;

import org.apache.hive.beeline.BeeLine;
import org.apache.hive.beeline.OutputFormat;
import org.apache.hive.beeline.Rows;

class VerticalOutputFormat
implements OutputFormat {
    private final BeeLine beeLine;

    VerticalOutputFormat(BeeLine beeLine) {
        this.beeLine = beeLine;
    }

    @Override
    public int print(Rows rows) {
        int count = 0;
        Rows.Row header = (Rows.Row)rows.next();
        while (rows.hasNext()) {
            this.printRow(rows, header, (Rows.Row)rows.next());
            ++count;
        }
        return count;
    }

    public void printRow(Rows rows, Rows.Row header, Rows.Row row) {
        int i;
        String[] head = header.values;
        String[] vals = row.values;
        int headwidth = 0;
        for (i = 0; i < head.length && i < vals.length; ++i) {
            headwidth = Math.max(headwidth, head[i].length());
        }
        headwidth += 2;
        for (i = 0; i < head.length && i < vals.length; ++i) {
            this.beeLine.output(this.beeLine.getColorBuffer().bold(this.beeLine.getColorBuffer().pad(head[i], headwidth).getMono()).append(vals[i] == null ? "" : vals[i]));
        }
        this.beeLine.output("");
    }
}

