/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.session;

import com.codahale.metrics.MetricRegistry;
import com.google.common.annotations.VisibleForTesting;
import java.io.Serializable;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.apache.kyuubi.KyuubiSQLException$;
import org.apache.kyuubi.client.api.v1.dto.Batch;
import org.apache.kyuubi.client.api.v1.dto.BatchRequest;
import org.apache.kyuubi.client.util.BatchUtils;
import org.apache.kyuubi.config.ConfigEntry;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.credentials.HadoopCredentialsManager;
import org.apache.kyuubi.engine.KyuubiApplicationManager;
import org.apache.kyuubi.metrics.MetricsConstants$;
import org.apache.kyuubi.metrics.MetricsSystem;
import org.apache.kyuubi.metrics.MetricsSystem$;
import org.apache.kyuubi.operation.KyuubiOperationManager;
import org.apache.kyuubi.operation.OperationState$;
import org.apache.kyuubi.plugin.GroupProvider;
import org.apache.kyuubi.plugin.PluginLoader$;
import org.apache.kyuubi.plugin.SessionConfAdvisor;
import org.apache.kyuubi.server.metadata.MetadataManager;
import org.apache.kyuubi.server.metadata.MetadataRequestsRetryRef;
import org.apache.kyuubi.server.metadata.api.Metadata;
import org.apache.kyuubi.server.metadata.api.Metadata$;
import org.apache.kyuubi.server.metadata.api.MetadataFilter;
import org.apache.kyuubi.service.Service;
import org.apache.kyuubi.session.KyuubiBatchSession;
import org.apache.kyuubi.session.KyuubiSessionImpl;
import org.apache.kyuubi.session.Session;
import org.apache.kyuubi.session.SessionHandle;
import org.apache.kyuubi.session.SessionLimiter;
import org.apache.kyuubi.session.SessionLimiter$;
import org.apache.kyuubi.session.SessionManager;
import org.apache.kyuubi.session.SessionType$;
import org.apache.kyuubi.session.UserIpAddress;
import org.apache.kyuubi.shaded.hive.service.rpc.thrift.TProtocolVersion;
import org.apache.kyuubi.sql.parser.server.KyuubiParser;
import org.apache.kyuubi.util.SignUtils$;
import org.apache.kyuubi.util.ThreadUtils$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\rme\u0001B\u001e=\u0001\u0015C\u0001B\u0013\u0001\u0003\u0002\u0003\u0006Ia\u0013\u0005\u00061\u0002!I!\u0017\u0005\u00061\u0002!\t\u0001\u0018\u0005\b;\u0002\u0011\r\u0011\"\u0003_\u0011\u0019A\u0007\u0001)A\u0005?\"9\u0011\u000e\u0001b\u0001\n\u0003Q\u0007BB9\u0001A\u0003%1\u000eC\u0004s\u0001\t\u0007I\u0011A:\t\ri\u0004\u0001\u0015!\u0003u\u0011\u001dY\bA1A\u0005\u0002qDq!a\u0002\u0001A\u0003%Q\u0010\u0003\u0006\u0002\n\u0001A)\u0019!C\u0001\u0003\u0017A!\"a\t\u0001\u0011\u000b\u0007I\u0011AA\u0013\u0011)\t)\u0005\u0001EC\u0002\u0013\u0005\u0011q\t\u0005\n\u0003\u001f\u0002\u0001\u0019!C\u0005\u0003#B\u0011\"a\u0017\u0001\u0001\u0004%I!!\u0018\t\u0011\u0005%\u0004\u0001)Q\u0005\u0003'B\u0011\"a\u001b\u0001\u0001\u0004%I!!\u0015\t\u0013\u00055\u0004\u00011A\u0005\n\u0005=\u0004\u0002CA:\u0001\u0001\u0006K!a\u0015\t\u0019\u0005\u001d\u0004\u0001%A\t\b\u0004&I!!\u001e\t\u0015\u0005M\u0005\u0001#b\u0001\n\u0003\t)\n\u0003\u0006\u0002\u0018\u0002A)\u0019!C\u0001\u00033C\u0011\"a'\u0001\u0001\u0004%\t!!(\t\u0013\u0005E\u0006\u00011A\u0005\u0002\u0005M\u0006\u0002CA\\\u0001\u0001\u0006K!a(\t\u0013\u0005e\u0006A1A\u0005\n\u0005m\u0006\u0002CAb\u0001\u0001\u0006I!!0\t\u000f\u0005\u0015\u0007\u0001\"\u0011\u0002H\"9\u0011\u0011\u001c\u0001\u0005R\u0005m\u0007b\u0002B\f\u0001\u0011\u0005#\u0011\u0004\u0005\b\u0005W\u0001A\u0011\tB\u0017\u0011\u001d\u0011\u0019\u0004\u0001C\u0001\u0005kA\u0011Ba\u001e\u0001#\u0003%\tA!\u001f\t\u0011\t=\u0005\u0001\"\u0001?\u0005#CqAa$\u0001\t\u0003\u00119\nC\u0004\u0003:\u0002!\tAa/\t\u000f\t\u0015\u0007\u0001\"\u0001\u0003H\"9!Q\u001a\u0001\u0005\u0002\t=\u0007b\u0002Bj\u0001\u0011\u0005!Q\u001b\u0005\b\u00053\u0004A\u0011\u0001Bn\u0011\u001d\u0011I\u000f\u0001C\u0001\u0005WDqAa<\u0001\t\u0003\u0011\t\u0010C\u0004\u0003\u0000\u0002!\ta!\u0001\t\u000f\ru\u0001\u0001\"\u0001\u0004 !911\u0005\u0001\u0005\u0002\r\u0015\u0002bBB\"\u0001\u0011\u00053Q\t\u0005\b\u0007\u000f\u0002A\u0011AB%\u0011\u001d\u0019\t\u0006\u0001C\u0001\u0007'Bqa!\u0017\u0001\t#\u001aY\u0006C\u0004\u0004^\u0001!Iaa\u0018\t\u0011\r\r\u0004\u0001\"\u0001?\u0007KB\u0001b!\u001c\u0001\t\u0003q4q\u000e\u0005\t\u0007g\u0002A\u0011\u0001 \u0004f!A1Q\u000f\u0001\u0005\u0002y\u001a9\bC\u0004\u0004|\u0001!Ia! \t\u000f\rM\u0005\u0001\"\u0003\u0004F!91Q\u0013\u0001\u0005\n\r]%\u0001F&zkV\u0014\u0017nU3tg&|g.T1oC\u001e,'O\u0003\u0002>}\u000591/Z:tS>t'BA A\u0003\u0019Y\u00170^;cS*\u0011\u0011IQ\u0001\u0007CB\f7\r[3\u000b\u0003\r\u000b1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001$\u0011\u0005\u001dCU\"\u0001\u001f\n\u0005%c$AD*fgNLwN\\'b]\u0006<WM]\u0001\u0005]\u0006lW\r\u0005\u0002M+:\u0011Qj\u0015\t\u0003\u001dFk\u0011a\u0014\u0006\u0003!\u0012\u000ba\u0001\u0010:p_Rt$\"\u0001*\u0002\u000bM\u001c\u0017\r\\1\n\u0005Q\u000b\u0016A\u0002)sK\u0012,g-\u0003\u0002W/\n11\u000b\u001e:j]\u001eT!\u0001V)\u0002\rqJg.\u001b;?)\tQ6\f\u0005\u0002H\u0001!)!J\u0001a\u0001\u0017R\t!,\u0001\u0004qCJ\u001cXM]\u000b\u0002?B\u0011\u0001MZ\u0007\u0002C*\u0011!mY\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0005u#'BA3?\u0003\r\u0019\u0018\u000f\\\u0005\u0003O\u0006\u0014AbS=vk\nL\u0007+\u0019:tKJ\fq\u0001]1sg\u0016\u0014\b%\u0001\tpa\u0016\u0014\u0018\r^5p]6\u000bg.Y4feV\t1\u000e\u0005\u0002m_6\tQN\u0003\u0002o}\u0005Iq\u000e]3sCRLwN\\\u0005\u0003a6\u0014acS=vk\nLw\n]3sCRLwN\\'b]\u0006<WM]\u0001\u0012_B,'/\u0019;j_:l\u0015M\\1hKJ\u0004\u0013AE2sK\u0012,g\u000e^5bYNl\u0015M\\1hKJ,\u0012\u0001\u001e\t\u0003kbl\u0011A\u001e\u0006\u0003oz\n1b\u0019:fI\u0016tG/[1mg&\u0011\u0011P\u001e\u0002\u0019\u0011\u0006$wn\u001c9De\u0016$WM\u001c;jC2\u001cX*\u00198bO\u0016\u0014\u0018aE2sK\u0012,g\u000e^5bYNl\u0015M\\1hKJ\u0004\u0013AE1qa2L7-\u0019;j_:l\u0015M\\1hKJ,\u0012! \t\u0004}\u0006\rQ\"A@\u000b\u0007\u0005\u0005a(\u0001\u0004f]\u001eLg.Z\u0005\u0004\u0003\u000by(\u0001G&zkV\u0014\u0017.\u00119qY&\u001c\u0017\r^5p]6\u000bg.Y4fe\u0006\u0019\u0012\r\u001d9mS\u000e\fG/[8o\u001b\u0006t\u0017mZ3sA\u0005yQ.\u001a;bI\u0006$\u0018-T1oC\u001e,'/\u0006\u0002\u0002\u000eA1\u0011qBA\t\u0003+i\u0011!U\u0005\u0004\u0003'\t&AB(qi&|g\u000e\u0005\u0003\u0002\u0018\u0005}QBAA\r\u0015\u0011\tY\"!\b\u0002\u00115,G/\u00193bi\u0006T!A\u0019 \n\t\u0005\u0005\u0012\u0011\u0004\u0002\u0010\u001b\u0016$\u0018\rZ1uC6\u000bg.Y4fe\u0006\u00112/Z:tS>t7i\u001c8g\u0003\u00124\u0018n]8s+\t\t9\u0003\u0005\u0004\u0002*\u0005M\u0012\u0011\b\b\u0005\u0003W\tyCD\u0002O\u0003[I\u0011AU\u0005\u0004\u0003c\t\u0016a\u00029bG.\fw-Z\u0005\u0005\u0003k\t9DA\u0002TKFT1!!\rR!\u0011\tY$!\u0011\u000e\u0005\u0005u\"bAA }\u00051\u0001\u000f\\;hS:LA!a\u0011\u0002>\t\u00112+Z:tS>t7i\u001c8g\u0003\u00124\u0018n]8s\u000359'o\\;q!J|g/\u001b3feV\u0011\u0011\u0011\n\t\u0005\u0003w\tY%\u0003\u0003\u0002N\u0005u\"!D$s_V\u0004\bK]8wS\u0012,'/A\u0004mS6LG/\u001a:\u0016\u0005\u0005M\u0003CBA\b\u0003#\t)\u0006E\u0002H\u0003/J1!!\u0017=\u00059\u0019Vm]:j_:d\u0015.\\5uKJ\f1\u0002\\5nSR,'o\u0018\u0013fcR!\u0011qLA3!\u0011\ty!!\u0019\n\u0007\u0005\r\u0014K\u0001\u0003V]&$\b\"CA4!\u0005\u0005\t\u0019AA*\u0003\rAH%M\u0001\tY&l\u0017\u000e^3sA\u0005a!-\u0019;dQ2KW.\u001b;fe\u0006\u0001\"-\u0019;dQ2KW.\u001b;fe~#S-\u001d\u000b\u0005\u0003?\n\t\bC\u0005\u0002hM\t\t\u00111\u0001\u0002T\u0005i!-\u0019;dQ2KW.\u001b;fe\u0002*\"!a\u001e\u0011\u0011\u0005=\u0011\u0011PA?\u0003\u001bK1!a\u001fR\u0005\u0019!V\u000f\u001d7feA!\u0011qPAE\u001b\t\t\tI\u0003\u0003\u0002\u0004\u0006\u0015\u0015\u0001C:fGV\u0014\u0018\u000e^=\u000b\u0005\u0005\u001d\u0015\u0001\u00026bm\u0006LA!a#\u0002\u0002\nQ\u0001K]5wCR,7*Z=\u0011\t\u0005}\u0014qR\u0005\u0005\u0003#\u000b\tIA\u0005Qk\nd\u0017nY&fs\u0006\t2/[4oS:<\u0007K]5wCR,7*Z=\u0016\u0005\u0005u\u0014\u0001E:jO:Lgn\u001a)vE2L7mS3z+\t\ti)A\u000ff]\u001eLg.Z*uCJ$X\u000f\u001d)s_\u000e,7o]*f[\u0006\u0004\bn\u001c:f+\t\ty\n\u0005\u0004\u0002\u0010\u0005E\u0011\u0011\u0015\t\u0005\u0003G\u000bi+\u0004\u0002\u0002&*!\u0011qUAU\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0005\u0003W\u000b))\u0001\u0003vi&d\u0017\u0002BAX\u0003K\u0013\u0011bU3nCBDwN]3\u0002C\u0015tw-\u001b8f'R\f'\u000f^;q!J|7-Z:t'\u0016l\u0017\r\u001d5pe\u0016|F%Z9\u0015\t\u0005}\u0013Q\u0017\u0005\n\u0003OJ\u0012\u0011!a\u0001\u0003?\u000ba$\u001a8hS:,7\u000b^1siV\u0004\bK]8dKN\u001c8+Z7ba\"|'/\u001a\u0011\u00029\u0015tw-\u001b8f\u0007>tg.Z2uS>t\u0017\t\\5wK\u000eCWmY6feV\u0011\u0011Q\u0018\t\u0005\u0003G\u000by,\u0003\u0003\u0002B\u0006\u0015&\u0001G*dQ\u0016$W\u000f\\3e\u000bb,7-\u001e;peN+'O^5dK\u0006iRM\\4j]\u0016\u001cuN\u001c8fGRLwN\\!mSZ,7\t[3dW\u0016\u0014\b%\u0001\u0006j]&$\u0018.\u00197ju\u0016$B!a\u0018\u0002J\"9\u00111Z\u000fA\u0002\u00055\u0017\u0001B2p]\u001a\u0004B!a4\u0002V6\u0011\u0011\u0011\u001b\u0006\u0004\u0003't\u0014AB2p]\u001aLw-\u0003\u0003\u0002X\u0006E'AC&zkV\u0014\u0017nQ8oM\u0006i1M]3bi\u0016\u001cVm]:j_:$B\"!8\u0002d\n\r!q\u0001B\u0006\u0005\u001f\u00012aRAp\u0013\r\t\t\u000f\u0010\u0002\b'\u0016\u001c8/[8o\u0011\u001d\t)O\ba\u0001\u0003O\f\u0001\u0002\u001d:pi>\u001cw\u000e\u001c\t\u0005\u0003S\fy0\u0004\u0002\u0002l*!\u0011Q^Ax\u0003\u0019!\bN]5gi*!\u0011\u0011_Az\u0003\r\u0011\bo\u0019\u0006\u0005\u0003k\f90A\u0004tKJ4\u0018nY3\u000b\t\u0005e\u00181`\u0001\u0005Q&4XMC\u0002\u0002~z\naa\u001d5bI\u0016$\u0017\u0002\u0002B\u0001\u0003W\u0014\u0001\u0003\u0016)s_R|7m\u001c7WKJ\u001c\u0018n\u001c8\t\r\t\u0015a\u00041\u0001L\u0003\u0011)8/\u001a:\t\r\t%a\u00041\u0001L\u0003!\u0001\u0018m]:x_J$\u0007B\u0002B\u0007=\u0001\u00071*A\u0005ja\u0006#GM]3tg\"9\u00111\u001a\u0010A\u0002\tE\u0001#\u0002'\u0003\u0014-[\u0015b\u0001B\u000b/\n\u0019Q*\u00199\u0002\u0017=\u0004XM\\*fgNLwN\u001c\u000b\r\u00057\u0011\tCa\t\u0003&\t\u001d\"\u0011\u0006\t\u0004\u000f\nu\u0011b\u0001B\u0010y\ti1+Z:tS>t\u0007*\u00198eY\u0016Dq!!: \u0001\u0004\t9\u000f\u0003\u0004\u0003\u0006}\u0001\ra\u0013\u0005\u0007\u0005\u0013y\u0002\u0019A&\t\r\t5q\u00041\u0001L\u0011\u001d\tYm\ba\u0001\u0005#\tAb\u00197pg\u0016\u001cVm]:j_:$B!a\u0018\u00030!9!\u0011\u0007\u0011A\u0002\tm\u0011!D:fgNLwN\u001c%b]\u0012dW-\u0001\nde\u0016\fG/\u001a\"bi\u000eD7+Z:tS>tG\u0003\u0007B\u001c\u0005{\u0011yD!\u0011\u0003D\t\u0015#\u0011\nB(\u0005'\u00129F!\u0018\u0003nA\u0019qI!\u000f\n\u0007\tmBH\u0001\nLsV,(-\u001b\"bi\u000eD7+Z:tS>t\u0007B\u0002B\u0003C\u0001\u00071\n\u0003\u0004\u0003\n\u0005\u0002\ra\u0013\u0005\u0007\u0005\u001b\t\u0003\u0019A&\t\u000f\u0005-\u0017\u00051\u0001\u0003\u0012!1!qI\u0011A\u0002-\u000b\u0011BY1uG\"$\u0016\u0010]3\t\u000f\t-\u0013\u00051\u0001\u0003N\u0005I!-\u0019;dQ:\u000bW.\u001a\t\u0006\u0003\u001f\t\tb\u0013\u0005\u0007\u0005#\n\u0003\u0019A&\u0002\u0011I,7o\\;sG\u0016DaA!\u0016\"\u0001\u0004Y\u0015!C2mCN\u001ch*Y7f\u0011\u001d\u0011I&\ta\u0001\u00057\n\u0011BY1uG\"\f%oZ:\u0011\u000b\u0005%\u00121G&\t\u0013\u0005m\u0011\u0005%AA\u0002\t}\u0003CBA\b\u0003#\u0011\t\u0007\u0005\u0003\u0003d\t%TB\u0001B3\u0015\u0011\u00119'!\u0007\u0002\u0007\u0005\u0004\u0018.\u0003\u0003\u0003l\t\u0015$\u0001C'fi\u0006$\u0017\r^1\t\u000f\t=\u0014\u00051\u0001\u0003r\u0005aaM]8n%\u0016\u001cwN^3ssB!\u0011q\u0002B:\u0013\r\u0011)(\u0015\u0002\b\u0005>|G.Z1o\u0003u\u0019'/Z1uK\n\u000bGo\u00195TKN\u001c\u0018n\u001c8%I\u00164\u0017-\u001e7uIE\u0002TC\u0001B>U\u0011\u0011yF! ,\u0005\t}\u0004\u0003\u0002BA\u0005\u0017k!Aa!\u000b\t\t\u0015%qQ\u0001\nk:\u001c\u0007.Z2lK\u0012T1A!#R\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005\u001b\u0013\u0019IA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f\u0001c\u001c9f]\n\u000bGo\u00195TKN\u001c\u0018n\u001c8\u0015\t\tm!1\u0013\u0005\b\u0005+\u001b\u0003\u0019\u0001B\u001c\u00031\u0011\u0017\r^2i'\u0016\u001c8/[8o))\u0011YB!'\u0003\u001c\nu%q\u0014\u0005\u0007\u0005\u000b!\u0003\u0019A&\t\r\t%A\u00051\u0001L\u0011\u0019\u0011i\u0001\na\u0001\u0017\"9!\u0011\u0015\u0013A\u0002\t\r\u0016\u0001\u00042bi\u000eD'+Z9vKN$\b\u0003\u0002BS\u0005kk!Aa*\u000b\t\t%&1V\u0001\u0004IR|'\u0002\u0002BW\u0005_\u000b!A^\u0019\u000b\t\t\u001d$\u0011\u0017\u0006\u0004\u0005gs\u0014AB2mS\u0016tG/\u0003\u0003\u00038\n\u001d&\u0001\u0004\"bi\u000eD'+Z9vKN$\u0018\u0001F5oSRL\u0017\r\\5{K\n\u000bGo\u00195Ti\u0006$X\rF\u0005L\u0005{\u0013yL!1\u0003D\"1!QA\u0013A\u0002-CaA!\u0004&\u0001\u0004Y\u0005bBAfK\u0001\u0007!\u0011\u0003\u0005\b\u0005C+\u0003\u0019\u0001BR\u0003=9W\r\u001e\"bi\u000eD7+Z:tS>tG\u0003\u0002Be\u0005\u0017\u0004b!a\u0004\u0002\u0012\t]\u0002b\u0002B\u0019M\u0001\u0007!1D\u0001\u000fS:\u001cXM\u001d;NKR\fG-\u0019;b)\u0011\tyF!5\t\u000f\u0005mq\u00051\u0001\u0003b\u0005qQ\u000f\u001d3bi\u0016lU\r^1eCR\fG\u0003BA0\u0005/Dq!a\u0007)\u0001\u0004\u0011\t'A\u000ehKRlU\r^1eCR\f'+Z9vKN$8OU3uef\u0014VM\u001a\u000b\u0005\u0005;\u0014)\u000f\u0005\u0004\u0002\u0010\u0005E!q\u001c\t\u0005\u0003/\u0011\t/\u0003\u0003\u0003d\u0006e!\u0001G'fi\u0006$\u0017\r^1SKF,Xm\u001d;t%\u0016$(/\u001f*fM\"1!q]\u0015A\u0002-\u000b!\"\u001b3f]RLg-[3s\u0003\t\"WMU3hSN$XM]'fi\u0006$\u0017\r^1SKF,Xm\u001d;t%\u0016$(/\u001f*fMR!\u0011q\fBw\u0011\u0019\u00119O\u000ba\u0001\u0017\u0006Ir-\u001a;CCR\u001c\u0007N\u0012:p[6+G/\u00193bi\u0006\u001cFo\u001c:f)\u0011\u0011\u0019Pa?\u0011\r\u0005=\u0011\u0011\u0003B{!\u0011\u0011)Ka>\n\t\te(q\u0015\u0002\u0006\u0005\u0006$8\r\u001b\u0005\u0007\u0005{\\\u0003\u0019A&\u0002\u000f\t\fGo\u00195JI\u0006Yr-\u001a;CCR\u001c\u0007.Z:Ge>lW*\u001a;bI\u0006$\u0018m\u0015;pe\u0016$\u0002ba\u0001\u0004\u0006\r=1\u0011\u0004\t\u0007\u0003S\t\u0019D!>\t\u000f\r\u001dA\u00061\u0001\u0004\n\u00051a-\u001b7uKJ\u0004BAa\u0019\u0004\f%!1Q\u0002B3\u00059iU\r^1eCR\fg)\u001b7uKJDqa!\u0005-\u0001\u0004\u0019\u0019\"\u0001\u0003ge>l\u0007\u0003BA\b\u0007+I1aa\u0006R\u0005\rIe\u000e\u001e\u0005\b\u00077a\u0003\u0019AB\n\u0003\u0011\u0019\u0018N_3\u0002!\u001d,GOQ1uG\"lU\r^1eCR\fG\u0003\u0002B0\u0007CAaA!@.\u0001\u0004Y\u0015aD2mK\u0006tW\u000f]'fi\u0006$\u0017\r^1\u0015\t\u0005}3q\u0005\u0005\u0007\u0005Ot\u0003\u0019A&)\u00079\u001aY\u0003\u0005\u0003\u0004.\r}RBAB\u0018\u0015\u0011\u0019\tda\r\u0002\u0017\u0005tgn\u001c;bi&|gn\u001d\u0006\u0005\u0007k\u00199$\u0001\u0004d_6lwN\u001c\u0006\u0005\u0007s\u0019Y$\u0001\u0004h_><G.\u001a\u0006\u0003\u0007{\t1aY8n\u0013\u0011\u0019\tea\f\u0003#YK7/\u001b2mK\u001a{'\u000fV3ti&tw-A\u0003ti\u0006\u0014H\u000f\u0006\u0002\u0002`\u0005Ir-\u001a;CCR\u001c\u0007nU3tg&|gn\u001d+p%\u0016\u001cwN^3s)\u0011\u0019Ye!\u0014\u0011\r\u0005%\u00121\u0007B\u001c\u0011\u0019\u0019y\u0005\ra\u0001\u0017\u0006q1._;vE&Len\u001d;b]\u000e,\u0017AI4fiB+WM]%ogR\fgnY3DY>\u001cX\r\u001a\"bi\u000eD7+Z:tS>t7\u000f\u0006\u0003\u0004V\r]\u0003CBA\u0015\u0003g\u0011\t\u0007\u0003\u0004\u0004PE\u0002\raS\u0001\tSN\u001cVM\u001d<feV\u0011!\u0011O\u0001\u0013S:LGoU3tg&|g\u000eT5nSR,'\u000f\u0006\u0003\u0002`\r\u0005\u0004bBAfg\u0001\u0007\u0011QZ\u0001\u0012O\u0016$XK\u001c7j[&$X\rZ+tKJ\u001cXCAB4!\u0011a5\u0011N&\n\u0007\r-tKA\u0002TKR\fQC]3ge\u0016\u001c\b.\u00168mS6LG/\u001a3Vg\u0016\u00148\u000f\u0006\u0003\u0002`\rE\u0004bBAfk\u0001\u0007\u0011QZ\u0001\rO\u0016$H)\u001a8z+N,'o]\u0001\u0011e\u00164'/Z:i\t\u0016t\u00170V:feN$B!a\u0018\u0004z!9\u00111Z\u001cA\u0002\u00055\u0017aE1qa2L8+Z:tS>tG*[7ji\u0016\u0014H\u0003DA*\u0007\u007f\u001a\u0019ia\"\u0004\f\u000e=\u0005bBBAq\u0001\u000711C\u0001\nkN,'\u000fT5nSRDqa!\"9\u0001\u0004\u0019\u0019\"\u0001\bja\u0006#GM]3tg2KW.\u001b;\t\u000f\r%\u0005\b1\u0001\u0004\u0014\u0005\u0011Ro]3s\u0013B\fE\r\u001a:fgNd\u0015.\\5u\u0011\u001d\u0019i\t\u000fa\u0001\u0007O\n\u0011#^:feVsG.[7ji\u0016$G*[:u\u0011\u001d\u0019\t\n\u000fa\u0001\u0007O\nA\"^:fe\u0012+g.\u001f'jgR\fqc\u001d;beR,enZ5oK\u0006c\u0017N^3DQ\u0016\u001c7.\u001a:\u0002C%t\u0017\u000e^#oO&tWm\u0015;beR,\b\u000f\u0015:pG\u0016\u001c8oU3nCBDwN]3\u0015\t\u0005}3\u0011\u0014\u0005\b\u0003\u0017T\u0004\u0019AAg\u0001")
public class KyuubiSessionManager
extends SessionManager {
    private Option<MetadataManager> metadataManager;
    private Seq<SessionConfAdvisor> sessionConfAdvisor;
    private GroupProvider groupProvider;
    private Tuple2<PrivateKey, PublicKey> x$1;
    private PrivateKey signingPrivateKey;
    private PublicKey signingPublicKey;
    private final KyuubiParser parser = new KyuubiParser();
    private final KyuubiOperationManager operationManager = new KyuubiOperationManager();
    private final HadoopCredentialsManager credentialsManager = new HadoopCredentialsManager();
    private final KyuubiApplicationManager applicationManager = new KyuubiApplicationManager();
    private Option<SessionLimiter> limiter = None$.MODULE$;
    private Option<SessionLimiter> batchLimiter = None$.MODULE$;
    private Option<Semaphore> engineStartupProcessSemaphore = None$.MODULE$;
    private final ScheduledExecutorService engineConnectionAliveChecker;
    private volatile byte bitmap$0;

    private KyuubiParser parser() {
        return this.parser;
    }

    public KyuubiOperationManager operationManager() {
        return this.operationManager;
    }

    public HadoopCredentialsManager credentialsManager() {
        return this.credentialsManager;
    }

    public KyuubiApplicationManager applicationManager() {
        return this.applicationManager;
    }

    private Option<MetadataManager> metadataManager$lzycompute() {
        KyuubiSessionManager kyuubiSessionManager = this;
        synchronized (kyuubiSessionManager) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.metadataManager = this.conf().isRESTEnabled() ? new Some((Object)new MetadataManager()) : None$.MODULE$;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.metadataManager;
    }

    public Option<MetadataManager> metadataManager() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.metadataManager$lzycompute();
        }
        return this.metadataManager;
    }

    private Seq<SessionConfAdvisor> sessionConfAdvisor$lzycompute() {
        KyuubiSessionManager kyuubiSessionManager = this;
        synchronized (kyuubiSessionManager) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.sessionConfAdvisor = PluginLoader$.MODULE$.loadSessionConfAdvisor(this.conf());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.sessionConfAdvisor;
    }

    public Seq<SessionConfAdvisor> sessionConfAdvisor() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.sessionConfAdvisor$lzycompute();
        }
        return this.sessionConfAdvisor;
    }

    private GroupProvider groupProvider$lzycompute() {
        KyuubiSessionManager kyuubiSessionManager = this;
        synchronized (kyuubiSessionManager) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.groupProvider = PluginLoader$.MODULE$.loadGroupProvider(this.conf());
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.groupProvider;
    }

    public GroupProvider groupProvider() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.groupProvider$lzycompute();
        }
        return this.groupProvider;
    }

    private Option<SessionLimiter> limiter() {
        return this.limiter;
    }

    private void limiter_$eq(Option<SessionLimiter> x$1) {
        this.limiter = x$1;
    }

    private Option<SessionLimiter> batchLimiter() {
        return this.batchLimiter;
    }

    private void batchLimiter_$eq(Option<SessionLimiter> x$1) {
        this.batchLimiter = x$1;
    }

    private Tuple2<PrivateKey, PublicKey> x$1$lzycompute() {
        KyuubiSessionManager kyuubiSessionManager = this;
        synchronized (kyuubiSessionManager) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                Tuple2 tuple2 = SignUtils$.MODULE$.generateKeyPair(SignUtils$.MODULE$.generateKeyPair$default$1());
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                PrivateKey signingPrivateKey = (PrivateKey)tuple2._1();
                PublicKey signingPublicKey = (PublicKey)tuple2._2();
                this.x$1 = new Tuple2((Object)signingPrivateKey, (Object)signingPublicKey);
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.x$1;
    }

    private /* synthetic */ Tuple2 x$1() {
        if ((byte)(this.bitmap$0 & 8) == 0) {
            return this.x$1$lzycompute();
        }
        return this.x$1;
    }

    private PrivateKey signingPrivateKey$lzycompute() {
        KyuubiSessionManager kyuubiSessionManager = this;
        synchronized (kyuubiSessionManager) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.signingPrivateKey = (PrivateKey)this.x$1()._1();
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
        }
        return this.signingPrivateKey;
    }

    public PrivateKey signingPrivateKey() {
        if ((byte)(this.bitmap$0 & 0x10) == 0) {
            return this.signingPrivateKey$lzycompute();
        }
        return this.signingPrivateKey;
    }

    private PublicKey signingPublicKey$lzycompute() {
        KyuubiSessionManager kyuubiSessionManager = this;
        synchronized (kyuubiSessionManager) {
            if ((byte)(this.bitmap$0 & 0x20) == 0) {
                this.signingPublicKey = (PublicKey)this.x$1()._2();
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x20);
            }
        }
        return this.signingPublicKey;
    }

    public PublicKey signingPublicKey() {
        if ((byte)(this.bitmap$0 & 0x20) == 0) {
            return this.signingPublicKey$lzycompute();
        }
        return this.signingPublicKey;
    }

    public Option<Semaphore> engineStartupProcessSemaphore() {
        return this.engineStartupProcessSemaphore;
    }

    public void engineStartupProcessSemaphore_$eq(Option<Semaphore> x$1) {
        this.engineStartupProcessSemaphore = x$1;
    }

    private ScheduledExecutorService engineConnectionAliveChecker() {
        return this.engineConnectionAliveChecker;
    }

    public void initialize(KyuubiConf conf) {
        this.conf_$eq(conf);
        this.addService((Service)this.applicationManager());
        this.addService((Service)this.credentialsManager());
        this.metadataManager().foreach((Function1 & Serializable & scala.Serializable)service -> {
            this.addService(service);
            return BoxedUnit.UNIT;
        });
        this.initSessionLimiter(conf);
        this.initEngineStartupProcessSemaphore(conf);
        super.initialize(conf);
    }

    public Session createSession(TProtocolVersion protocol, String user, String password, String ipAddress, Map<String, String> conf) {
        KyuubiConf userConf = this.getConf().getUserDefaults(user);
        return new KyuubiSessionImpl(protocol, user, password, ipAddress, conf, this, userConf, BoxesRunTime.unboxToBoolean((Object)userConf.get(KyuubiConf$.MODULE$.ENGINE_DO_AS_ENABLED())), this.parser());
    }

    public SessionHandle openSession(TProtocolVersion protocol, String user, String password, String ipAddress, Map<String, String> conf) {
        SessionHandle sessionHandle;
        String username = (String)Option$.MODULE$.apply((Object)user).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)KyuubiSessionManager.$anonfun$openSession$1(x$2))).getOrElse((Function0 & Serializable & scala.Serializable)() -> "anonymous");
        this.limiter().foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            x$3.increment(new UserIpAddress(username, ipAddress));
            return BoxedUnit.UNIT;
        });
        try {
            sessionHandle = super.openSession(protocol, username, password, ipAddress, conf);
        }
        catch (Throwable e) {
            MetricsSystem$.MODULE$.tracing((Function1 & Serializable & scala.Serializable)ms -> {
                KyuubiSessionManager.$anonfun$openSession$4(user, ms);
                return BoxedUnit.UNIT;
            });
            throw KyuubiSQLException$.MODULE$.apply(new StringBuilder(46).append("Error opening session for ").append(username).append(" client ip ").append(ipAddress).append(", due to ").append(e.getMessage()).toString(), e, KyuubiSQLException$.MODULE$.apply$default$3(), KyuubiSQLException$.MODULE$.apply$default$4());
        }
        return sessionHandle;
    }

    public void closeSession(SessionHandle sessionHandle) {
        Session session = this.getSession(sessionHandle);
        try {
            super.closeSession(sessionHandle);
        }
        finally {
            Session session2 = session;
            if (session2 instanceof KyuubiBatchSession) {
                this.batchLimiter().foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
                    x$4.decrement(new UserIpAddress(session.user(), session.ipAddress()));
                    return BoxedUnit.UNIT;
                });
            } else {
                this.limiter().foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
                    x$5.decrement(new UserIpAddress(session.user(), session.ipAddress()));
                    return BoxedUnit.UNIT;
                });
            }
        }
    }

    public KyuubiBatchSession createBatchSession(String user, String password, String ipAddress, Map<String, String> conf, String batchType, Option<String> batchName, String resource, String className, Seq<String> batchArgs, Option<Metadata> metadata, boolean fromRecovery) {
        String username = (String)Option$.MODULE$.apply((Object)user).filter((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)KyuubiSessionManager.$anonfun$createBatchSession$1(x$6))).getOrElse((Function0 & Serializable & scala.Serializable)() -> "anonymous");
        KyuubiConf sessionConf = this.getConf().getUserDefaults(user);
        return new KyuubiBatchSession(username, password, ipAddress, conf, this, sessionConf, batchType, batchName, resource, className, batchArgs, metadata, fromRecovery);
    }

    public Option<Metadata> createBatchSession$default$10() {
        return None$.MODULE$;
    }

    public SessionHandle openBatchSession(KyuubiBatchSession batchSession) {
        SessionHandle sessionHandle;
        String user = batchSession.user();
        String ipAddress = batchSession.ipAddress();
        this.batchLimiter().foreach((Function1 & Serializable & scala.Serializable)x$7 -> {
            x$7.increment(new UserIpAddress(user, ipAddress));
            return BoxedUnit.UNIT;
        });
        SessionHandle handle = batchSession.handle();
        try {
            batchSession.open();
            this.setSession(handle, (Session)batchSession);
            this.logSessionCountInfo((Session)batchSession, "opened");
            sessionHandle = handle;
        }
        catch (Exception e) {
            try {
                batchSession.close();
            }
            catch (Throwable t) {
                this.warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Error closing batch session[").append(handle).append("] for ").append(user).append(" client ip: ").append(ipAddress).toString(), t);
            }
            MetricsSystem$.MODULE$.tracing((Function1 & Serializable & scala.Serializable)ms -> {
                KyuubiSessionManager.$anonfun$openBatchSession$3(user, ms);
                return BoxedUnit.UNIT;
            });
            throw KyuubiSQLException$.MODULE$.apply(new StringBuilder(54).append("Error opening batch session[").append(handle).append("] for ").append(user).append(" client ip ").append(ipAddress).append(",").append(" due to ").append(e.getMessage()).toString(), (Throwable)e, KyuubiSQLException$.MODULE$.apply$default$3(), KyuubiSQLException$.MODULE$.apply$default$4());
        }
        return sessionHandle;
    }

    public SessionHandle openBatchSession(String user, String password, String ipAddress, BatchRequest batchRequest) {
        KyuubiBatchSession batchSession = this.createBatchSession(user, password, ipAddress, (Map<String, String>)((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(batchRequest.getConf()).asScala()).toMap(Predef$.MODULE$.$conforms()), batchRequest.getBatchType(), (Option<String>)Option$.MODULE$.apply((Object)batchRequest.getName()), batchRequest.getResource(), batchRequest.getClassName(), (Seq<String>)((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(batchRequest.getArgs()).asScala()).toSeq(), (Option<Metadata>)None$.MODULE$, false);
        return this.openBatchSession(batchSession);
    }

    public String initializeBatchState(String user, String ipAddress, Map<String, String> conf, BatchRequest batchRequest) {
        String batchId;
        String realUser = (String)conf.getOrElse((Object)"kyuubi.session.real.user", (Function0 & Serializable & scala.Serializable)() -> user);
        String username = (String)Option$.MODULE$.apply((Object)user).filter((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)KyuubiSessionManager.$anonfun$initializeBatchState$2(x$8))).getOrElse((Function0 & Serializable & scala.Serializable)() -> "anonymous");
        String x$1 = batchId = (String)conf.apply((Object)BatchUtils.KYUUBI_BATCH_ID_KEY);
        Enumeration.Value x$2 = SessionType$.MODULE$.BATCH();
        String x$3 = realUser;
        String x$4 = username;
        String x$5 = ipAddress;
        String x$6 = OperationState$.MODULE$.INITIALIZED().toString();
        String x$7 = batchRequest.getResource();
        String x$82 = batchRequest.getClassName();
        String x$92 = batchRequest.getName();
        Map<String, String> x$102 = conf;
        Seq x$11 = ((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(batchRequest.getArgs()).asScala()).toSeq();
        long x$12 = System.currentTimeMillis();
        String x$13 = batchRequest.getBatchType();
        int x$14 = BoxesRunTime.unboxToInt((Object)conf.get((Object)"kyuubi.batch.priority").map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToInteger((int)KyuubiSessionManager.$anonfun$initializeBatchState$4(x$9))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 10));
        String x$15 = Metadata$.MODULE$.apply$default$6();
        Option<String> x$16 = Metadata$.MODULE$.apply$default$15();
        long x$17 = Metadata$.MODULE$.apply$default$16();
        String x$18 = Metadata$.MODULE$.apply$default$17();
        String x$19 = Metadata$.MODULE$.apply$default$18();
        String x$20 = Metadata$.MODULE$.apply$default$19();
        String x$21 = Metadata$.MODULE$.apply$default$20();
        Option<String> x$22 = Metadata$.MODULE$.apply$default$21();
        long x$23 = Metadata$.MODULE$.apply$default$22();
        boolean x$24 = Metadata$.MODULE$.apply$default$24();
        Metadata metadata = new Metadata(x$1, x$2, x$3, x$4, x$5, x$15, x$6, x$7, x$82, x$92, x$102, (Seq<String>)x$11, x$12, x$13, x$16, x$17, x$18, x$19, x$20, x$21, x$22, x$23, x$14, x$24);
        this.metadataManager().foreach((Function1 & Serializable & scala.Serializable)x$10 -> {
            x$10.insertMetadata(metadata, false);
            return BoxedUnit.UNIT;
        });
        return batchId;
    }

    public Option<KyuubiBatchSession> getBatchSession(SessionHandle sessionHandle) {
        return this.getSessionOption(sessionHandle).map((Function1 & Serializable & scala.Serializable)x$11 -> (KyuubiBatchSession)((Object)x$11));
    }

    public void insertMetadata(Metadata metadata) {
        this.metadataManager().foreach((Function1 & Serializable & scala.Serializable)x$12 -> {
            x$12.insertMetadata(metadata, x$12.insertMetadata$default$2());
            return BoxedUnit.UNIT;
        });
    }

    public void updateMetadata(Metadata metadata) {
        this.metadataManager().foreach((Function1 & Serializable & scala.Serializable)x$13 -> {
            x$13.updateMetadata(metadata, x$13.updateMetadata$default$2());
            return BoxedUnit.UNIT;
        });
    }

    public Option<MetadataRequestsRetryRef> getMetadataRequestsRetryRef(String identifier) {
        return this.metadataManager().flatMap((Function1 & Serializable & scala.Serializable)mm -> Option$.MODULE$.apply((Object)mm.getMetadataRequestsRetryRef(identifier)));
    }

    public void deRegisterMetadataRequestsRetryRef(String identifier) {
        this.metadataManager().foreach((Function1 & Serializable & scala.Serializable)x$14 -> {
            x$14.deRegisterRequestsRetryRef(identifier);
            return BoxedUnit.UNIT;
        });
    }

    public Option<Batch> getBatchFromMetadataStore(String batchId) {
        return this.metadataManager().flatMap((Function1 & Serializable & scala.Serializable)mm -> mm.getBatch(batchId));
    }

    public Seq<Batch> getBatchesFromMetadataStore(MetadataFilter filter, int from, int size) {
        return (Seq)this.metadataManager().map((Function1 & Serializable & scala.Serializable)x$15 -> x$15.getBatches(filter, from, size)).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Nil$.MODULE$);
    }

    public Option<Metadata> getBatchMetadata(String batchId) {
        return this.metadataManager().flatMap((Function1 & Serializable & scala.Serializable)x$16 -> x$16.getBatchSessionMetadata(batchId));
    }

    @VisibleForTesting
    public void cleanupMetadata(String identifier) {
        this.metadataManager().foreach((Function1 & Serializable & scala.Serializable)x$17 -> {
            x$17.cleanupMetadataById(identifier);
            return BoxedUnit.UNIT;
        });
    }

    public synchronized void start() {
        MetricsSystem$.MODULE$.tracing((Function1 & Serializable & scala.Serializable)ms -> {
            KyuubiSessionManager.$anonfun$start$1(this, ms);
            return BoxedUnit.UNIT;
        });
        super.start();
        this.startEngineAliveChecker();
    }

    public Seq<KyuubiBatchSession> getBatchSessionsToRecover(String kyuubiInstance) {
        return (Seq)((TraversableLike)new .colon.colon((Object)OperationState$.MODULE$.PENDING(), (List)new .colon.colon((Object)OperationState$.MODULE$.RUNNING(), (List)Nil$.MODULE$))).flatMap((Function1 & Serializable & scala.Serializable)stateToRecover -> (Seq)this.metadataManager().map((Function1 & Serializable & scala.Serializable)x$18 -> (Seq)x$18.getBatchesRecoveryMetadata(stateToRecover.toString(), kyuubiInstance, 0, Integer.MAX_VALUE).map((Function1 & Serializable & scala.Serializable)metadata -> this.createBatchSession(metadata.username(), "anonymous", metadata.ipAddress(), metadata.requestConf(), metadata.engineType(), (Option<String>)Option$.MODULE$.apply((Object)metadata.requestName()), metadata.resource(), metadata.className(), metadata.requestArgs(), (Option<Metadata>)new Some(metadata), true), Seq$.MODULE$.canBuildFrom())).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom());
    }

    public Seq<Metadata> getPeerInstanceClosedBatchSessions(String kyuubiInstance) {
        return (Seq)((TraversableLike)new .colon.colon((Object)OperationState$.MODULE$.PENDING(), (List)new .colon.colon((Object)OperationState$.MODULE$.RUNNING(), (List)Nil$.MODULE$))).flatMap((Function1 & Serializable & scala.Serializable)stateToKill -> (Seq)this.metadataManager().map((Function1 & Serializable & scala.Serializable)x$19 -> x$19.getPeerInstanceClosedBatchesMetadata(stateToKill.toString(), kyuubiInstance, 0, Integer.MAX_VALUE)).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom());
    }

    public boolean isServer() {
        return true;
    }

    private void initSessionLimiter(KyuubiConf conf) {
        int userLimit = BoxesRunTime.unboxToInt((Object)((Option)conf.get((ConfigEntry)KyuubiConf$.MODULE$.SERVER_LIMIT_CONNECTIONS_PER_USER())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
        int ipAddressLimit = BoxesRunTime.unboxToInt((Object)((Option)conf.get((ConfigEntry)KyuubiConf$.MODULE$.SERVER_LIMIT_CONNECTIONS_PER_IPADDRESS())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
        int userIpAddressLimit = BoxesRunTime.unboxToInt((Object)((Option)conf.get((ConfigEntry)KyuubiConf$.MODULE$.SERVER_LIMIT_CONNECTIONS_PER_USER_IPADDRESS())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
        Set userUnlimitedList = (Set)((TraversableLike)conf.get(KyuubiConf$.MODULE$.SERVER_LIMIT_CONNECTIONS_USER_UNLIMITED_LIST())).filter((Function1 & Serializable & scala.Serializable)x$20 -> BoxesRunTime.boxToBoolean((boolean)KyuubiSessionManager.$anonfun$initSessionLimiter$4(x$20)));
        Set userDenyList = (Set)((TraversableLike)conf.get(KyuubiConf$.MODULE$.SERVER_LIMIT_CONNECTIONS_USER_DENY_LIST())).filter((Function1 & Serializable & scala.Serializable)x$21 -> BoxesRunTime.boxToBoolean((boolean)KyuubiSessionManager.$anonfun$initSessionLimiter$5(x$21)));
        this.limiter_$eq(this.applySessionLimiter(userLimit, ipAddressLimit, userIpAddressLimit, (Set<String>)userUnlimitedList, (Set<String>)userDenyList));
        int userBatchLimit = BoxesRunTime.unboxToInt((Object)((Option)conf.get((ConfigEntry)KyuubiConf$.MODULE$.SERVER_LIMIT_BATCH_CONNECTIONS_PER_USER())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
        int ipAddressBatchLimit = BoxesRunTime.unboxToInt((Object)((Option)conf.get((ConfigEntry)KyuubiConf$.MODULE$.SERVER_LIMIT_BATCH_CONNECTIONS_PER_IPADDRESS())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
        int userIpAddressBatchLimit = BoxesRunTime.unboxToInt((Object)((Option)conf.get((ConfigEntry)KyuubiConf$.MODULE$.SERVER_LIMIT_BATCH_CONNECTIONS_PER_USER_IPADDRESS())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
        this.batchLimiter_$eq(this.applySessionLimiter(userBatchLimit, ipAddressBatchLimit, userIpAddressBatchLimit, (Set<String>)userUnlimitedList, (Set<String>)userDenyList));
    }

    public Set<String> getUnlimitedUsers() {
        return (Set)this.limiter().orElse((Function0 & Serializable & scala.Serializable)() -> this.batchLimiter()).map((Function1 & Serializable & scala.Serializable)limiter -> SessionLimiter$.MODULE$.getUnlimitedUsers((SessionLimiter)limiter)).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Set().empty());
    }

    public void refreshUnlimitedUsers(KyuubiConf conf) {
        Set unlimitedUsers = (Set)((TraversableLike)conf.get(KyuubiConf$.MODULE$.SERVER_LIMIT_CONNECTIONS_USER_UNLIMITED_LIST())).filter((Function1 & Serializable & scala.Serializable)x$22 -> BoxesRunTime.boxToBoolean((boolean)KyuubiSessionManager.$anonfun$refreshUnlimitedUsers$1(x$22)));
        this.limiter().foreach((Function1 & Serializable & scala.Serializable)x$23 -> {
            SessionLimiter$.MODULE$.resetUnlimitedUsers(x$23, (Set<String>)unlimitedUsers);
            return BoxedUnit.UNIT;
        });
        this.batchLimiter().foreach((Function1 & Serializable & scala.Serializable)x$24 -> {
            SessionLimiter$.MODULE$.resetUnlimitedUsers(x$24, (Set<String>)unlimitedUsers);
            return BoxedUnit.UNIT;
        });
    }

    public Set<String> getDenyUsers() {
        return (Set)this.limiter().orElse((Function0 & Serializable & scala.Serializable)() -> this.batchLimiter()).map((Function1 & Serializable & scala.Serializable)limiter -> SessionLimiter$.MODULE$.getDenyUsers((SessionLimiter)limiter)).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Set().empty());
    }

    public void refreshDenyUsers(KyuubiConf conf) {
        Set denyUsers = (Set)((TraversableLike)conf.get(KyuubiConf$.MODULE$.SERVER_LIMIT_CONNECTIONS_USER_DENY_LIST())).filter((Function1 & Serializable & scala.Serializable)x$25 -> BoxesRunTime.boxToBoolean((boolean)KyuubiSessionManager.$anonfun$refreshDenyUsers$1(x$25)));
        this.limiter().foreach((Function1 & Serializable & scala.Serializable)x$26 -> {
            SessionLimiter$.MODULE$.resetDenyUsers(x$26, (Set<String>)denyUsers);
            return BoxedUnit.UNIT;
        });
        this.batchLimiter().foreach((Function1 & Serializable & scala.Serializable)x$27 -> {
            SessionLimiter$.MODULE$.resetDenyUsers(x$27, (Set<String>)denyUsers);
            return BoxedUnit.UNIT;
        });
    }

    private Option<SessionLimiter> applySessionLimiter(int userLimit, int ipAddressLimit, int userIpAddressLimit, Set<String> userUnlimitedList, Set<String> userDenyList) {
        if (((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{userLimit, ipAddressLimit, userIpAddressLimit}))).exists((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$28 -> x$28 > 0) || userDenyList.nonEmpty()) {
            return new Some((Object)SessionLimiter$.MODULE$.apply(userLimit, ipAddressLimit, userIpAddressLimit, userUnlimitedList, userDenyList));
        }
        return None$.MODULE$;
    }

    private void startEngineAliveChecker() {
        long interval = BoxesRunTime.unboxToLong((Object)this.conf().get(KyuubiConf$.MODULE$.ENGINE_ALIVE_PROBE_INTERVAL()));
        Runnable checkTask = () -> this.allSessions().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            KyuubiSessionManager.$anonfun$startEngineAliveChecker$2(this, x0$1);
            return BoxedUnit.UNIT;
        });
        ThreadUtils$.MODULE$.scheduleTolerableRunnableWithFixedDelay(this.engineConnectionAliveChecker(), checkTask, interval, interval, TimeUnit.MILLISECONDS);
    }

    private void initEngineStartupProcessSemaphore(KyuubiConf conf) {
        Option engineCreationLimit = (Option)conf.get((ConfigEntry)KyuubiConf$.MODULE$.SERVER_LIMIT_ENGINE_CREATION());
        engineCreationLimit.filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$29 -> x$29 > 0).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)limit -> this.engineStartupProcessSemaphore_$eq((Option<Semaphore>)new Some((Object)new Semaphore(limit))));
    }

    public static final /* synthetic */ boolean $anonfun$openSession$1(String x$2) {
        return new StringOps(Predef$.MODULE$.augmentString(x$2)).nonEmpty();
    }

    public static final /* synthetic */ void $anonfun$openSession$4(String user$1, MetricsSystem ms) {
        ms.incCount(MetricsConstants$.MODULE$.CONN_FAIL());
        ms.incCount(MetricRegistry.name((String)MetricsConstants$.MODULE$.CONN_FAIL(), (String[])new String[]{user$1}));
        ms.incCount(MetricRegistry.name((String)MetricsConstants$.MODULE$.CONN_FAIL(), (String[])new String[]{SessionType$.MODULE$.INTERACTIVE().toString()}));
    }

    public static final /* synthetic */ boolean $anonfun$createBatchSession$1(String x$6) {
        return new StringOps(Predef$.MODULE$.augmentString(x$6)).nonEmpty();
    }

    public static final /* synthetic */ void $anonfun$openBatchSession$3(String user$2, MetricsSystem ms) {
        ms.incCount(MetricsConstants$.MODULE$.CONN_FAIL());
        ms.incCount(MetricRegistry.name((String)MetricsConstants$.MODULE$.CONN_FAIL(), (String[])new String[]{user$2}));
        ms.incCount(MetricRegistry.name((String)MetricsConstants$.MODULE$.CONN_FAIL(), (String[])new String[]{SessionType$.MODULE$.BATCH().toString()}));
    }

    public static final /* synthetic */ boolean $anonfun$initializeBatchState$2(String x$8) {
        return new StringOps(Predef$.MODULE$.augmentString(x$8)).nonEmpty();
    }

    public static final /* synthetic */ int $anonfun$initializeBatchState$4(String x$9) {
        return new StringOps(Predef$.MODULE$.augmentString(x$9)).toInt();
    }

    public static final /* synthetic */ void $anonfun$start$1(KyuubiSessionManager $this, MetricsSystem ms) {
        ms.registerGauge(MetricsConstants$.MODULE$.CONN_OPEN(), (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> $this.getOpenSessionCount(), (Object)BoxesRunTime.boxToInteger((int)0));
        ms.registerGauge(MetricsConstants$.MODULE$.EXEC_POOL_ALIVE(), (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> $this.getExecPoolSize(), (Object)BoxesRunTime.boxToInteger((int)0));
        ms.registerGauge(MetricsConstants$.MODULE$.EXEC_POOL_ACTIVE(), (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> $this.getActiveCount(), (Object)BoxesRunTime.boxToInteger((int)0));
        ms.registerGauge(MetricsConstants$.MODULE$.EXEC_POOL_WORK_QUEUE_SIZE(), (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> $this.getWorkQueueSize(), (Object)BoxesRunTime.boxToInteger((int)0));
    }

    public static final /* synthetic */ boolean $anonfun$initSessionLimiter$4(String x$20) {
        return new StringOps(Predef$.MODULE$.augmentString(x$20)).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$initSessionLimiter$5(String x$21) {
        return new StringOps(Predef$.MODULE$.augmentString(x$21)).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$refreshUnlimitedUsers$1(String x$22) {
        return new StringOps(Predef$.MODULE$.augmentString(x$22)).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$refreshDenyUsers$1(String x$25) {
        return new StringOps(Predef$.MODULE$.augmentString(x$25)).nonEmpty();
    }

    public static final /* synthetic */ void $anonfun$startEngineAliveChecker$2(KyuubiSessionManager $this, Session x0$1) {
        Session session = x0$1;
        if (session instanceof KyuubiSessionImpl) {
            BoxedUnit boxedUnit;
            KyuubiSessionImpl kyuubiSessionImpl = (KyuubiSessionImpl)session;
            try {
                if (!kyuubiSessionImpl.checkEngineConnectionAlive()) {
                    $this.closeSession(kyuubiSessionImpl.handle());
                    $this.logger().info(new StringBuilder(98).append("The session ").append(kyuubiSessionImpl.handle()).append(" has been closed ").append("due to engine unresponsiveness (checked by the engine alive checker).").toString());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            }
            catch (Throwable e) {
                $this.warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(22).append("Error closing session ").append(kyuubiSessionImpl.handle()).toString(), e);
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
    }

    private KyuubiSessionManager(String name) {
        super(name);
        this.engineConnectionAliveChecker = ThreadUtils$.MODULE$.newDaemonSingleThreadScheduledExecutor(new StringBuilder(21).append(name).append("-engine-alive-checker").toString(), ThreadUtils$.MODULE$.newDaemonSingleThreadScheduledExecutor$default$2());
    }

    public KyuubiSessionManager() {
        this(KyuubiSessionManager.class.getSimpleName());
    }
}

