/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.RecordReader;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class FixedLengthRecordReader
implements RecordReader<LongWritable, BytesWritable> {
    private int recordLength;
    private org.apache.hadoop.mapreduce.lib.input.FixedLengthRecordReader reader;

    public FixedLengthRecordReader(Configuration job, FileSplit split, int recordLength) throws IOException {
        this.recordLength = recordLength;
        this.reader = new org.apache.hadoop.mapreduce.lib.input.FixedLengthRecordReader(recordLength);
        this.reader.initialize(job, split.getStart(), split.getLength(), split.getPath());
    }

    @Override
    public LongWritable createKey() {
        return new LongWritable();
    }

    @Override
    public BytesWritable createValue() {
        return new BytesWritable(new byte[this.recordLength]);
    }

    @Override
    public synchronized boolean next(LongWritable key, BytesWritable value) throws IOException {
        boolean dataRead = this.reader.nextKeyValue();
        if (dataRead) {
            LongWritable newKey = this.reader.getCurrentKey();
            BytesWritable newValue = this.reader.getCurrentValue();
            key.set(newKey.get());
            value.set(newValue);
        }
        return dataRead;
    }

    @Override
    public float getProgress() throws IOException {
        return this.reader.getProgress();
    }

    @Override
    public synchronized long getPos() throws IOException {
        return this.reader.getPos();
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }
}

