/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.engine.spark;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.EvictingQueue;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.kyuubi.KyuubiException;
import org.apache.kyuubi.KyuubiException$;
import org.apache.kyuubi.Logging;
import org.apache.kyuubi.Utils$;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.engine.ApplicationManagerInfo;
import org.apache.kyuubi.engine.ApplicationManagerInfo$;
import org.apache.kyuubi.engine.KubernetesApplicationOperation$;
import org.apache.kyuubi.engine.KyuubiApplicationManager$;
import org.apache.kyuubi.engine.ProcBuilder;
import org.apache.kyuubi.engine.ProcBuilder$;
import org.apache.kyuubi.engine.spark.SparkProcessBuilder$;
import org.apache.kyuubi.ha.HighAvailabilityConf$;
import org.apache.kyuubi.ha.client.AuthTypes$;
import org.apache.kyuubi.operation.log.OperationLog;
import org.apache.kyuubi.package$;
import org.apache.kyuubi.util.KubernetesUtils$;
import org.apache.kyuubi.util.Validator$;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Builder;
import scala.collection.mutable.Map$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001\r-c\u0001B,Y\u0001\rD\u0001B\u001d\u0001\u0003\u0006\u0004%\te\u001d\u0005\t\u007f\u0002\u0011\t\u0011)A\u0005i\"Q\u0011\u0011\u0001\u0001\u0003\u0006\u0004%\t%a\u0001\t\u0015\u0005E\u0001A!A!\u0002\u0013\t)\u0001C\u0005\u0002\u0014\u0001\u0011)\u0019!C\u0001g\"I\u0011Q\u0003\u0001\u0003\u0002\u0003\u0006I\u0001\u001e\u0005\u000b\u0003/\u0001!Q1A\u0005\u0002\u0005e\u0001BCA\u0019\u0001\t\u0005\t\u0015!\u0003\u0002\u001c!9\u00111\u0007\u0001\u0005\u0002\u0005U\u0002bBA\u001a\u0001\u0011\u0005\u00111\t\u0005\n\u0003G\u0002!\u0019!C\u00019NDq!!\u001a\u0001A\u0003%A\u000f\u0003\u0005\u0002h\u0001\u0011\r\u0011\"\u0015t\u0011\u001d\tI\u0007\u0001Q\u0001\nQDa!a\u001b\u0001\t\u0003\u001a\bbBA7\u0001\u0011E\u0013q\u000e\u0005\b\u0003s\u0002A\u0011CA>\u0011!\t\t\t\u0001C\u00019\u0006\r\u0005\u0002CAN\u0001\t\u0007I\u0011K:\t\u000f\u0005u\u0005\u0001)A\u0005i\"Q\u0011q\u0014\u0001\t\u0006\u0004%\t&!)\t\u0015\u0005M\u0006\u0001#b\u0001\n#\n)\f\u0003\u0004\u0002>\u0002!\tf\u001d\u0005\b\u0003\u007f\u0003A\u0011CAa\u0011\u001d\t9\u000e\u0001C\u0005\u00033Dq!!8\u0001\t\u0013\ty\u000e\u0003\u0004\u0002l\u0002!\te\u001d\u0005\u000b\u0003[\u0004\u0001R1A\u0005\u0012\u0005=\bbBAy\u0001\u0011\u0005\u00131\u001f\u0005\b\u0003w\u0004A\u0011AA\u007f\u0011\u001d\u0011\t\u0001\u0001C!\u00033DqAa\u0001\u0001\t\u0003\tI\u000eC\u0004\u0003\u0006\u0001!\tEa\u0002\t\u000f\t=\u0001\u0001\"\u0001\u0002Z\"9!\u0011\u0003\u0001\u0005\u0002\u0005e\u0007b\u0002B\n\u0001\u0011\u0005#Q\u0003\u0005\b\u0005/\u0001A\u0011\u0001B\r\u0011!\u0011\t\u0003\u0001C\u00011\n\rra\u0002B\u00131\"\u0005!q\u0005\u0004\u0007/bC\tA!\u000b\t\u000f\u0005M\u0002\u0006\"\u0001\u0003,!I!Q\u0006\u0015C\u0002\u0013\u0015!q\u0006\u0005\t\u0005oA\u0003\u0015!\u0004\u00032!I!\u0011\b\u0015C\u0002\u0013\u0015!1\b\u0005\t\u0005\u0007B\u0003\u0015!\u0004\u0003>!I!Q\t\u0015C\u0002\u0013\u0015!q\t\u0005\t\u0005\u001fB\u0003\u0015!\u0004\u0003J!I!\u0011\u000b\u0015C\u0002\u0013\u0015!1\u000b\u0005\t\u00057B\u0003\u0015!\u0004\u0003V!I!Q\f\u0015C\u0002\u0013\u0015!q\f\u0005\t\u0005OB\u0003\u0015!\u0004\u0003b!I!\u0011\u000e\u0015C\u0002\u0013\u0015!1\u000e\u0005\t\u0005gB\u0003\u0015!\u0004\u0003n!I!Q\u000f\u0015C\u0002\u0013\u0015!q\u000f\u0005\t\u0005\u007fB\u0003\u0015!\u0004\u0003z!I!\u0011\u0011\u0015C\u0002\u0013\u0015!1\u0011\u0005\t\u0005\u0017C\u0003\u0015!\u0004\u0003\u0006\"I!Q\u0012\u0015C\u0002\u0013\u0015!q\u0012\u0005\t\u0005/C\u0003\u0015!\u0004\u0003\u0012\"I!\u0011\u0014\u0015C\u0002\u0013\u0015!1\u0014\u0005\t\u0005_C\u0003\u0015!\u0004\u0003\u001e\"Q!\u0011\u0017\u0015C\u0002\u0013\u0015\u0001La-\t\u0011\tm\u0006\u0006)A\u0007\u0005kC!B!0)\u0005\u0004%)\u0001\u0017B`\u0011!\u00119\r\u000bQ\u0001\u000e\t\u0005\u0007B\u0003BeQ\t\u0007IQ\u0001-\u0003L\"A!1\u001b\u0015!\u0002\u001b\u0011i\r\u0003\u0006\u0003V\"\u0012\r\u0011\"\u0002Y\u0005/D\u0001Ba8)A\u00035!\u0011\u001c\u0005\u000b\u0005CD#\u0019!C\u00031\n\r\b\u0002\u0003BvQ\u0001\u0006iA!:\t\u0015\t5\bF1A\u0005\u0006a\u0013y\u000f\u0003\u0005\u0003x\"\u0002\u000bQ\u0002By\u0011%\u0011I\u0010\u000bb\u0001\n\u001b\u0011Y\u0010\u0003\u0005\u0003~\"\u0002\u000bQ\u0002BS\u0011%\u0011y\u0010\u000bb\u0001\n\u001b\u0019\t\u0001\u0003\u0005\u0004\b!\u0002\u000bQBB\u0002\u0011%\u0019I\u0001\u000bb\u0001\n\u001b\u0019Y\u0001\u0003\u0005\u0004\u0014!\u0002\u000bQBB\u0007\u0011)\u0019)\u0002\u000bb\u0001\n\u000ba6q\u0003\u0005\t\u0007SA\u0003\u0015!\u0004\u0004\u001a!Q11\u0006\u0015C\u0002\u0013\u0015Ala\u0006\t\u0011\r5\u0002\u0006)A\u0007\u00073A!ba\f)\u0005\u0004%)\u0001XB\f\u0011!\u0019\t\u0004\u000bQ\u0001\u000e\re\u0001\"CB\u001aQE\u0005I\u0011AB\u001b\u0005M\u0019\u0006/\u0019:l!J|7-Z:t\u0005VLG\u000eZ3s\u0015\tI&,A\u0003ta\u0006\u00148N\u0003\u0002\\9\u00061QM\\4j]\u0016T!!\u00180\u0002\r-LX/\u001e2j\u0015\ty\u0006-\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002C\u0006\u0019qN]4\u0004\u0001M!\u0001\u0001\u001a6o!\t)\u0007.D\u0001g\u0015\u00059\u0017!B:dC2\f\u0017BA5g\u0005\u0019\te.\u001f*fMB\u00111\u000e\\\u0007\u00025&\u0011QN\u0017\u0002\f!J|7MQ;jY\u0012,'\u000f\u0005\u0002pa6\tA,\u0003\u0002r9\n9Aj\\4hS:<\u0017!\u00039s_bLXk]3s+\u0005!\bCA;}\u001d\t1(\u0010\u0005\u0002xM6\t\u0001P\u0003\u0002zE\u00061AH]8pizJ!a\u001f4\u0002\rA\u0013X\rZ3g\u0013\tihP\u0001\u0004TiJLgn\u001a\u0006\u0003w\u001a\f!\u0002\u001d:pqf,6/\u001a:!\u0003\u0011\u0019wN\u001c4\u0016\u0005\u0005\u0015\u0001\u0003BA\u0004\u0003\u001bi!!!\u0003\u000b\u0007\u0005-A,\u0001\u0004d_:4\u0017nZ\u0005\u0005\u0003\u001f\tIA\u0001\u0006LsV,(-[\"p]\u001a\fQaY8oM\u0002\n1\"\u001a8hS:,'+\u001a4JI\u0006aQM\\4j]\u0016\u0014VMZ%eA\u0005qQ\r\u001f;sC\u0016sw-\u001b8f\u0019><WCAA\u000e!\u0015)\u0017QDA\u0011\u0013\r\tyB\u001a\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\u0005\r\u0012QF\u0007\u0003\u0003KQA!a\n\u0002*\u0005\u0019An\\4\u000b\u0007\u0005-B,A\u0005pa\u0016\u0014\u0018\r^5p]&!\u0011qFA\u0013\u00051y\u0005/\u001a:bi&|g\u000eT8h\u0003=)\u0007\u0010\u001e:b\u000b:<\u0017N\\3M_\u001e\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0006\u00028\u0005m\u0012QHA \u0003\u0003\u00022!!\u000f\u0001\u001b\u0005A\u0006\"\u0002:\n\u0001\u0004!\bbBA\u0001\u0013\u0001\u0007\u0011Q\u0001\u0005\u0007\u0003'I\u0001\u0019\u0001;\t\u0013\u0005]\u0011\u0002%AA\u0002\u0005mACBA\u001c\u0003\u000b\n9\u0005C\u0003s\u0015\u0001\u0007A\u000fC\u0004\u0002\u0002)\u0001\r!!\u0002)\u0007)\tY\u0005\u0005\u0003\u0002N\u0005}SBAA(\u0015\u0011\t\t&a\u0015\u0002\u0017\u0005tgn\u001c;bi&|gn\u001d\u0006\u0005\u0003+\n9&\u0001\u0004d_6lwN\u001c\u0006\u0005\u00033\nY&\u0001\u0004h_><G.\u001a\u0006\u0003\u0003;\n1aY8n\u0013\u0011\t\t'a\u0014\u0003#YK7/\u001b2mK\u001a{'\u000fV3ti&tw-A\u0005ta\u0006\u00148\u000eS8nK\u0006Q1\u000f]1sW\"{W.\u001a\u0011\u0002\u0015\u0015DXmY;uC\ndW-A\u0006fq\u0016\u001cW\u000f^1cY\u0016\u0004\u0013!C7bS:\u001cE.Y:t\u0003E\u0019w.\u001c9mKR,W*Y:uKJ,&\u000f\u001c\u000b\u0005\u0003c\n9\bE\u0002f\u0003gJ1!!\u001eg\u0005\u0011)f.\u001b;\t\u000f\u0005\u0005\u0001\u00031\u0001\u0002\u0006\u0005\u00012m\u001c8wKJ$8i\u001c8gS\u001e\\U-\u001f\u000b\u0004i\u0006u\u0004BBA@#\u0001\u0007A/A\u0002lKf\fA$\u001a=ue\u0006\u001cGo\u00159be.\u001cuN]3TG\u0006d\u0017MV3sg&|g\u000eF\u0002u\u0003\u000bCq!a\"\u0013\u0001\u0004\tI)A\u0005gS2,g*Y7fgB)\u00111RAKi:!\u0011QRAI\u001d\r9\u0018qR\u0005\u0002O&\u0019\u00111\u00134\u0002\u000fA\f7m[1hK&!\u0011qSAM\u0005!IE/\u001a:bE2,'bAAJM\u0006ARM\\4j]\u0016\u001c6-\u00197b\u0005&t\u0017M]=WKJ\u001c\u0018n\u001c8\u00023\u0015tw-\u001b8f'\u000e\fG.\u0019\"j]\u0006\u0014\u0018PV3sg&|g\u000eI\u0001\u0014K:<\u0017N\\3I_6,G)\u001b:GS2$XM]\u000b\u0003\u0003G\u0003B!!*\u000206\u0011\u0011q\u0015\u0006\u0005\u0003S\u000bY+\u0001\u0002j_*\u0011\u0011QV\u0001\u0005U\u00064\u0018-\u0003\u0003\u00022\u0006\u001d&A\u0003$jY\u00164\u0015\u000e\u001c;fe\u0006A1m\\7nC:$7/\u0006\u0002\u00028B!Q-!/u\u0013\r\tYL\u001a\u0002\u0006\u0003J\u0014\u0018-_\u0001\u0007[>$W\u000f\\3\u0002\u001bM,G/\u001e9LKJ\u0014WM]8t)\u0011\t\t(a1\t\u000f\u0005\u0015\u0007\u00041\u0001\u0002H\u00061!-\u001e4gKJ\u0004R!!3\u0002TRl!!a3\u000b\t\u00055\u0017qZ\u0001\b[V$\u0018M\u00197f\u0015\r\t\tNZ\u0001\u000bG>dG.Z2uS>t\u0017\u0002BAk\u0003\u0017\u00141\"\u0011:sCf\u0014UO\u001a4fe\u0006IAO]=LKf$\u0018M\u0019\u000b\u0003\u00037\u0004B!ZA\u000fi\u0006!\"p[!vi\"\\U-\u001f;bE\u001aKG.Z\"p]\u001a$B!!9\u0002hB)Q/a9ui&\u0019\u0011Q\u001d@\u0003\u00075\u000b\u0007\u000fC\u0004\u0002jj\u0001\r!!9\u0002\u0013M\u0004\u0018M]6D_:4\u0017!C:i_J$h*Y7f\u00031!WMZ1vYR\u001c8i\u001c8g+\t\t\t/\u0001\u0006baBluM]%oM>$\"!!>\u0011\u0007-\f90C\u0002\u0002zj\u0013a#\u00119qY&\u001c\u0017\r^5p]6\u000bg.Y4fe&sgm\\\u0001\u0012CB\u0004XM\u001c3Q_\u0012t\u0015-\\3D_:4G\u0003BAq\u0003\u007fDq!!\u0001\u001f\u0001\u0004\t\t/\u0001\bdYV\u001cH/\u001a:NC:\fw-\u001a:\u0002\u0015\u0011,\u0007\u000f\\8z\u001b>$W-A\u0007jg\u000ecWo\u001d;fe6{G-\u001a\u000b\u0003\u0005\u0013\u00012!\u001aB\u0006\u0013\r\u0011iA\u001a\u0002\b\u0005>|G.Z1o\u0003EYWOY3s]\u0016$Xm]\"p]R,\u0007\u0010^\u0001\u0014WV\u0014WM\u001d8fi\u0016\u001ch*Y7fgB\f7-Z\u0001\rm\u0006d\u0017\u000eZ1uK\u000e{gNZ\u000b\u0003\u0003c\n\u0001c]3u'B\f'o[+tKJt\u0015-\\3\u0015\r\u0005E$1\u0004B\u0010\u0011\u0019\u0011i\"\na\u0001i\u0006AQo]3s\u001d\u0006lW\rC\u0004\u0002F\u0016\u0002\r!a2\u0002#\u0015tw-\u001b8f\u0019><\u0007+\u0019;i\u0007>tg\r\u0006\u0002\u0002b\u0006\u00192\u000b]1sWB\u0013xnY3tg\n+\u0018\u000e\u001c3feB\u0019\u0011\u0011\b\u0015\u0014\u0005!\"GC\u0001B\u0014\u0003\u001d\t\u0005\u000bU0L\u000bf+\"A!\r\u0010\u0005\tM\u0012E\u0001B\u001b\u00039\u0019\b/\u0019:l]\u0005\u0004\bO\f8b[\u0016\f\u0001\"\u0011)Q?.+\u0015\fI\u0001\b)\u0006;ulS#Z+\t\u0011id\u0004\u0002\u0003@\u0005\u0012!\u0011I\u0001\u0010gB\f'o\u001b\u0018zCJtg\u0006^1hg\u0006AA+Q$`\u0017\u0016K\u0006%\u0001\u0006N\u0003N#VIU0L\u000bf+\"A!\u0013\u0010\u0005\t-\u0013E\u0001B'\u00031\u0019\b/\u0019:l]5\f7\u000f^3s\u0003-i\u0015i\u0015+F%~[U)\u0017\u0011\u0002\u001f\u0011+\u0005\u000bT(Z?6{E)R0L\u000bf+\"A!\u0016\u0010\u0005\t]\u0013E\u0001B-\u0003]\u0019\b/\u0019:l]M,(-\\5u]\u0011,\u0007\u000f\\8z\u001b>$W-\u0001\tE\u000bBcu*W0N\u001f\u0012+ulS#ZA\u000512*\u0016\"F%:+E+R*`\u0007>sE+\u0012-U?.+\u0015,\u0006\u0002\u0003b=\u0011!1M\u0011\u0003\u0005K\n\u0001d\u001d9be.t3.\u001e2fe:,G/Z:/G>tG/\u001a=u\u0003]YUKQ#S\u001d\u0016#ViU0D\u001f:#V\t\u0017+`\u0017\u0016K\u0006%\u0001\rL+\n+%KT#U\u000bN{f*Q'F'B\u000b5)R0L\u000bf+\"A!\u001c\u0010\u0005\t=\u0014E\u0001B9\u0003i\u0019\b/\u0019:l]-,(-\u001a:oKR,7O\f8b[\u0016\u001c\b/Y2f\u0003eYUKQ#S\u001d\u0016#ViU0O\u00036+5\u000bU!D\u000b~[U)\u0017\u0011\u00025-+&)\u0012*O\u000bR+5k\u0018#S\u0013Z+%k\u0018)P\t~s\u0015)T#\u0016\u0005\tetB\u0001B>C\t\u0011i(\u0001\u0011ta\u0006\u00148NL6vE\u0016\u0014h.\u001a;fg:\"'/\u001b<fe:\u0002x\u000e\u001a\u0018oC6,\u0017aG&V\u0005\u0016\u0013f*\u0012+F'~#%+\u0013,F%~\u0003v\nR0O\u00036+\u0005%A\u0012L+\n+%KT#U\u000bN{V\tW#D+R{%k\u0018)P\t~s\u0015)T#`!J+e)\u0013-\u0016\u0005\t\u0015uB\u0001BDC\t\u0011I)A\u0014ta\u0006\u00148NL6vE\u0016\u0014h.\u001a;fg:*\u00070Z2vi>\u0014h\u0006]8e\u001d\u0006lW\r\u0015:fM&D\u0018\u0001J&V\u0005\u0016\u0013f*\u0012+F'~+\u0005,R\"V)>\u0013v\fU(E?:\u000bU*R0Q%\u00163\u0015\n\u0017\u0011\u0002#%sE+\u0012*O\u00032{&+R*P+J\u001bU)\u0006\u0002\u0003\u0012>\u0011!1S\u0011\u0003\u0005+\u000bab\u001d9be.l\u0013N\u001c;fe:\fG.\u0001\nJ\u001dR+%KT!M?J+5kT+S\u0007\u0016\u0003\u0013\u0001\u0004)B)\"{6i\u0014(G\u0013\u001e\u001bVC\u0001BO!\u0019\u0011yJ!)\u0003&6\u0011\u0011qZ\u0005\u0005\u0005G\u000byMA\u0002TKF\u0004BAa*\u0003.6\u0011!\u0011\u0016\u0006\u0005\u0005W\u000bY+\u0001\u0003mC:<\u0017bA?\u0003*\u0006i\u0001+\u0011+I?\u000e{eJR%H'\u0002\nAaQ(O\rV\u0011!QW\b\u0003\u0005o\u000b#A!/\u0002\r5j3m\u001c8g\u0003\u0015\u0019uJ\u0014$!\u0003\u0015\u0019E*Q*T+\t\u0011\tm\u0004\u0002\u0003D\u0006\u0012!QY\u0001\b[5\u001aG.Y:t\u0003\u0019\u0019E*Q*TA\u0005Q\u0001KU(Y3~+6+\u0012*\u0016\u0005\t5wB\u0001BhC\t\u0011\t.\u0001\u0007.[A\u0014x\u000e_=.kN,'/A\u0006Q%>C\u0016lX+T\u000bJ\u0003\u0013aC*Q\u0003J[uLR%M\u000bN+\"A!7\u0010\u0005\tm\u0017E\u0001Bo\u0003-\u0019\b/\u0019:l]\u0019LG.Z:\u0002\u0019M\u0003\u0016IU&`\r&cUi\u0015\u0011\u0002\u0013A\u0013\u0016JT\"J!\u0006cUC\u0001Bs\u001f\t\u00119/\t\u0002\u0003j\u0006A2\u000f]1sW:ZWM\u001d2fe>\u001ch\u0006\u001d:j]\u000eL\u0007/\u00197\u0002\u0015A\u0013\u0016JT\"J!\u0006c\u0005%\u0001\u0004L\u000bf#\u0016IQ\u000b\u0003\u0005c|!Aa=\"\u0005\tU\u0018!F:qCJ\\gf[3sE\u0016\u0014xn\u001d\u0018lKf$\u0018MY\u0001\b\u0017\u0016KF+\u0011\"!\u0003E\u0019\u0006+\u0011*L?N+&)T%U?\u001aKE*R\u000b\u0003\u0005K\u000b!c\u0015)B%.{6+\u0016\"N\u0013R{f)\u0013'FA\u0005q1\u000bU!S\u0017~\u001buJ\u0014$`\t&\u0013VCAB\u0002\u001f\t\u0019)!\t\u0002\u0003\u0000\u0006y1\u000bU!S\u0017~\u001buJ\u0014$`\t&\u0013\u0006%\u0001\u000bT!\u0006\u00136jX\"P\u001d\u001a{f)\u0013'F?:\u000bU*R\u000b\u0003\u0007\u001by!aa\u0004\"\u0005\rE\u0011aE:qCJ\\W\u0006Z3gCVdGo\u001d\u0018d_:4\u0017!F*Q\u0003J[ulQ(O\r~3\u0015\nT#`\u001d\u0006kU\tI\u0001\u001f'B\u000b%kS0D\u001fJ+ulU\"B\u0019\u0006{f+\u0012*T\u0013>suLU#H\u000bb+\"a!\u0007\u0011\t\rm1QE\u0007\u0003\u0007;QAaa\b\u0004\"\u0005AQ.\u0019;dQ&twMC\u0002\u0004$\u0019\fA!\u001e;jY&!1qEB\u000f\u0005\u0015\u0011VmZ3y\u0003}\u0019\u0006+\u0011*L?\u000e{%+R0T\u0007\u0006c\u0015i\u0018,F%NKuJT0S\u000b\u001e+\u0005\fI\u0001\u001b'B\u000b%kS0I\u001f6+uLU#H\u000bb{6kQ!M\u0003~\u0013\u0014GM\u0001\u001c'B\u000b%kS0I\u001f6+uLU#H\u000bb{6kQ!M\u0003~\u0013\u0014G\r\u0011\u00025M\u0003\u0016IU&`\u0011>kUi\u0018*F\u000f\u0016CvlU\"B\u0019\u0006{&'M\u001a\u00027M\u0003\u0016IU&`\u0011>kUi\u0018*F\u000f\u0016CvlU\"B\u0019\u0006{&'M\u001a!\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%iU\u00111q\u0007\u0016\u0005\u00037\u0019Id\u000b\u0002\u0004<A!1QHB$\u001b\t\u0019yD\u0003\u0003\u0004B\r\r\u0013!C;oG\",7m[3e\u0015\r\u0019)EZ\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BB%\u0007\u007f\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0001")
public class SparkProcessBuilder
implements ProcBuilder,
Logging {
    private FileFilter engineHomeDirFilter;
    private String[] commands;
    private Map<String, String> defaultsConf;
    private final String proxyUser;
    private final KyuubiConf conf;
    private final String engineRefId;
    private final Option<OperationLog> extraEngineLog;
    private final String sparkHome;
    private final String executable;
    private final String engineScalaBinaryVersion;
    private transient Logger org$apache$kyuubi$Logging$$log_;
    private final Path workingDir;
    private ProcessBuilder processBuilder;
    private volatile Throwable org$apache$kyuubi$engine$ProcBuilder$$error;
    private final int org$apache$kyuubi$engine$ProcBuilder$$engineLogMaxLines;
    private final long org$apache$kyuubi$engine$ProcBuilder$$engineStartupDestroyTimeout;
    private final EvictingQueue<String> lastRowsOfLog;
    private volatile boolean logCaptureThreadReleased;
    private Thread org$apache$kyuubi$engine$ProcBuilder$$logCaptureThread;
    private Process org$apache$kyuubi$engine$ProcBuilder$$process;
    @VisibleForTesting
    private volatile boolean processLaunched;
    private File engineLog;
    private volatile byte bitmap$0;

    public static Option<OperationLog> $lessinit$greater$default$4() {
        return SparkProcessBuilder$.MODULE$.$lessinit$greater$default$4();
    }

    public static Seq<String> PATH_CONFIGS() {
        return SparkProcessBuilder$.MODULE$.PATH_CONFIGS();
    }

    public static String INTERNAL_RESOURCE() {
        return SparkProcessBuilder$.MODULE$.INTERNAL_RESOURCE();
    }

    public static String KUBERNETES_EXECUTOR_POD_NAME_PREFIX() {
        return SparkProcessBuilder$.MODULE$.KUBERNETES_EXECUTOR_POD_NAME_PREFIX();
    }

    public static String KUBERNETES_DRIVER_POD_NAME() {
        return SparkProcessBuilder$.MODULE$.KUBERNETES_DRIVER_POD_NAME();
    }

    public static String KUBERNETES_NAMESPACE_KEY() {
        return SparkProcessBuilder$.MODULE$.KUBERNETES_NAMESPACE_KEY();
    }

    public static String KUBERNETES_CONTEXT_KEY() {
        return SparkProcessBuilder$.MODULE$.KUBERNETES_CONTEXT_KEY();
    }

    public static String DEPLOY_MODE_KEY() {
        return SparkProcessBuilder$.MODULE$.DEPLOY_MODE_KEY();
    }

    public static String MASTER_KEY() {
        return SparkProcessBuilder$.MODULE$.MASTER_KEY();
    }

    public static String TAG_KEY() {
        return SparkProcessBuilder$.MODULE$.TAG_KEY();
    }

    public static String APP_KEY() {
        return SparkProcessBuilder$.MODULE$.APP_KEY();
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    @Override
    public void debug(Function0<Object> message) {
        Logging.debug$((Logging)this, message);
    }

    @Override
    public void debug(Function0<Object> message, Throwable t) {
        Logging.debug$((Logging)this, message, (Throwable)t);
    }

    @Override
    public void info(Function0<Object> message) {
        Logging.info$((Logging)this, message);
    }

    @Override
    public void info(Function0<Object> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    @Override
    public void warn(Function0<Object> message) {
        Logging.warn$((Logging)this, message);
    }

    @Override
    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    @Override
    public void error(Function0<Object> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    @Override
    public void error(Function0<Object> message) {
        Logging.error$((Logging)this, message);
    }

    public void initializeLoggerIfNecessary(boolean isInterpreter) {
        Logging.initializeLoggerIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    @Override
    public /* synthetic */ String org$apache$kyuubi$engine$ProcBuilder$$super$toString() {
        return super.toString();
    }

    @Override
    public Option<String> mainResource() {
        return ProcBuilder.mainResource$(this);
    }

    @Override
    public Map<String, String> env() {
        return ProcBuilder.env$(this);
    }

    @Override
    public final Process start() {
        return ProcBuilder.start$(this);
    }

    @Override
    public void close(boolean destroyProcess) {
        ProcBuilder.close$(this, destroyProcess);
    }

    @Override
    public Throwable getError() {
        return ProcBuilder.getError$(this);
    }

    @Override
    public String toString() {
        return ProcBuilder.toString$(this);
    }

    @Override
    public String getEngineHome(String shortName) {
        return ProcBuilder.getEngineHome$(this, shortName);
    }

    @Override
    public Throwable validateEnv(String requiredEnv) {
        return ProcBuilder.validateEnv$(this, requiredEnv);
    }

    public Logger org$apache$kyuubi$Logging$$log_() {
        return this.org$apache$kyuubi$Logging$$log_;
    }

    public void org$apache$kyuubi$Logging$$log__$eq(Logger x$1) {
        this.org$apache$kyuubi$Logging$$log_ = x$1;
    }

    @Override
    public Path workingDir() {
        return this.workingDir;
    }

    private ProcessBuilder processBuilder$lzycompute() {
        SparkProcessBuilder sparkProcessBuilder = this;
        synchronized (sparkProcessBuilder) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.processBuilder = ProcBuilder.processBuilder$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.processBuilder;
    }

    @Override
    public final ProcessBuilder processBuilder() {
        if ((byte)(this.bitmap$0 & 8) == 0) {
            return this.processBuilder$lzycompute();
        }
        return this.processBuilder;
    }

    @Override
    public Throwable org$apache$kyuubi$engine$ProcBuilder$$error() {
        return this.org$apache$kyuubi$engine$ProcBuilder$$error;
    }

    @Override
    public void org$apache$kyuubi$engine$ProcBuilder$$error_$eq(Throwable x$1) {
        this.org$apache$kyuubi$engine$ProcBuilder$$error = x$1;
    }

    @Override
    public int org$apache$kyuubi$engine$ProcBuilder$$engineLogMaxLines() {
        return this.org$apache$kyuubi$engine$ProcBuilder$$engineLogMaxLines;
    }

    @Override
    public long org$apache$kyuubi$engine$ProcBuilder$$engineStartupDestroyTimeout() {
        return this.org$apache$kyuubi$engine$ProcBuilder$$engineStartupDestroyTimeout;
    }

    @Override
    public EvictingQueue<String> lastRowsOfLog() {
        return this.lastRowsOfLog;
    }

    @Override
    public boolean logCaptureThreadReleased() {
        return this.logCaptureThreadReleased;
    }

    @Override
    public void logCaptureThreadReleased_$eq(boolean x$1) {
        this.logCaptureThreadReleased = x$1;
    }

    @Override
    public Thread org$apache$kyuubi$engine$ProcBuilder$$logCaptureThread() {
        return this.org$apache$kyuubi$engine$ProcBuilder$$logCaptureThread;
    }

    @Override
    public void org$apache$kyuubi$engine$ProcBuilder$$logCaptureThread_$eq(Thread x$1) {
        this.org$apache$kyuubi$engine$ProcBuilder$$logCaptureThread = x$1;
    }

    @Override
    public Process org$apache$kyuubi$engine$ProcBuilder$$process() {
        return this.org$apache$kyuubi$engine$ProcBuilder$$process;
    }

    @Override
    public void org$apache$kyuubi$engine$ProcBuilder$$process_$eq(Process x$1) {
        this.org$apache$kyuubi$engine$ProcBuilder$$process = x$1;
    }

    @Override
    public boolean processLaunched() {
        return this.processLaunched;
    }

    @Override
    public void processLaunched_$eq(boolean x$1) {
        this.processLaunched = x$1;
    }

    private File engineLog$lzycompute() {
        SparkProcessBuilder sparkProcessBuilder = this;
        synchronized (sparkProcessBuilder) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.engineLog = ProcBuilder.engineLog$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
        }
        return this.engineLog;
    }

    @Override
    public File engineLog() {
        if ((byte)(this.bitmap$0 & 0x10) == 0) {
            return this.engineLog$lzycompute();
        }
        return this.engineLog;
    }

    @Override
    public void org$apache$kyuubi$engine$ProcBuilder$_setter_$engineScalaBinaryVersion_$eq(String x$1) {
    }

    @Override
    public void org$apache$kyuubi$engine$ProcBuilder$_setter_$workingDir_$eq(Path x$1) {
        this.workingDir = x$1;
    }

    @Override
    public final void org$apache$kyuubi$engine$ProcBuilder$_setter_$org$apache$kyuubi$engine$ProcBuilder$$engineLogMaxLines_$eq(int x$1) {
        this.org$apache$kyuubi$engine$ProcBuilder$$engineLogMaxLines = x$1;
    }

    @Override
    public final void org$apache$kyuubi$engine$ProcBuilder$_setter_$org$apache$kyuubi$engine$ProcBuilder$$engineStartupDestroyTimeout_$eq(long x$1) {
        this.org$apache$kyuubi$engine$ProcBuilder$$engineStartupDestroyTimeout = x$1;
    }

    @Override
    public void org$apache$kyuubi$engine$ProcBuilder$_setter_$lastRowsOfLog_$eq(EvictingQueue<String> x$1) {
        this.lastRowsOfLog = x$1;
    }

    @Override
    public String proxyUser() {
        return this.proxyUser;
    }

    @Override
    public KyuubiConf conf() {
        return this.conf;
    }

    public String engineRefId() {
        return this.engineRefId;
    }

    @Override
    public Option<OperationLog> extraEngineLog() {
        return this.extraEngineLog;
    }

    public String sparkHome() {
        return this.sparkHome;
    }

    @Override
    public String executable() {
        return this.executable;
    }

    @Override
    public String mainClass() {
        return "org.apache.kyuubi.engine.spark.SparkSQLEngine";
    }

    @Override
    public void completeMasterUrl(KyuubiConf conf) {
        block4: {
            try {
                Tuple3 tuple3 = new Tuple3(this.clusterManager(), (Object)scala.sys.package$.MODULE$.env().get((Object)KubernetesApplicationOperation$.MODULE$.KUBERNETES_SERVICE_HOST()), (Object)scala.sys.package$.MODULE$.env().get((Object)KubernetesApplicationOperation$.MODULE$.KUBERNETES_SERVICE_PORT()));
                if (tuple3 == null) break block4;
                Option option = (Option)tuple3._1();
                Option option2 = (Option)tuple3._2();
                Option option3 = (Option)tuple3._3();
                if (None$.MODULE$.equals(option) && option2 instanceof Some) {
                    Some some = (Some)option2;
                    String kubernetesServiceHost = (String)some.value();
                    if (option3 instanceof Some) {
                        Some some2 = (Some)option3;
                        String kubernetesServicePort = (String)some2.value();
                        String masterURL = new StringBuilder(15).append("k8s://https://").append(kubernetesServiceHost).append(":").append(kubernetesServicePort).toString();
                        conf.set("spark.master", masterURL);
                    }
                }
            }
            catch (Exception e) {
                this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "Failed when setting up spark.master with kubernetes environment automatically.", e);
            }
        }
    }

    public String convertConfigKey(String key) {
        if (key.startsWith("spark.")) {
            return key;
        }
        if (key.startsWith("hadoop.")) {
            return new StringBuilder(13).append("spark.hadoop.").append(key).toString();
        }
        return new StringBuilder(6).append("spark.").append(key).toString();
    }

    public String extractSparkCoreScalaVersion(Iterable<String> fileNames) {
        return (String)fileNames.collectFirst((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends String, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Option option = SparkProcessBuilder$.MODULE$.SPARK_CORE_SCALA_VERSION_REGEX().unapplySeq(A1);
                if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0) {
                    String scalaVersion = (String)((LinearSeqOptimized)option.get()).apply(0);
                    return (B1)scalaVersion;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(String x1) {
                String string = x1;
                Option option = SparkProcessBuilder$.MODULE$.SPARK_CORE_SCALA_VERSION_REGEX().unapplySeq((CharSequence)string);
                return !option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0;
            }
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new KyuubiException("Failed to extract Scala version from spark-core jar", KyuubiException$.MODULE$.$lessinit$greater$default$2());
        });
    }

    @Override
    public String engineScalaBinaryVersion() {
        return this.engineScalaBinaryVersion;
    }

    private FileFilter engineHomeDirFilter$lzycompute() {
        SparkProcessBuilder sparkProcessBuilder = this;
        synchronized (sparkProcessBuilder) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.engineHomeDirFilter = file -> {
                    Regex regex;
                    String string = package$.MODULE$.SCALA_COMPILE_VERSION();
                    if ("2.12".equals(string)) {
                        regex = SparkProcessBuilder$.MODULE$.SPARK_HOME_REGEX_SCALA_212();
                    } else if ("2.13".equals(string)) {
                        regex = SparkProcessBuilder$.MODULE$.SPARK_HOME_REGEX_SCALA_213();
                    } else {
                        throw new MatchError((Object)string);
                    }
                    Regex r = regex;
                    return file.isDirectory() && r.findFirstMatchIn((CharSequence)file.getName()).isDefined();
                };
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.engineHomeDirFilter;
    }

    @Override
    public FileFilter engineHomeDirFilter() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.engineHomeDirFilter$lzycompute();
        }
        return this.engineHomeDirFilter;
    }

    private String[] commands$lzycompute() {
        SparkProcessBuilder sparkProcessBuilder = this;
        synchronized (sparkProcessBuilder) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.completeMasterUrl(this.conf());
                KyuubiApplicationManager$.MODULE$.tagApplication(this.engineRefId(), this.shortName(), this.clusterManager(), this.conf());
                ArrayBuffer buffer = new ArrayBuffer();
                buffer.$plus$eq((Object)this.executable());
                buffer.$plus$eq((Object)"--class");
                buffer.$plus$eq((Object)this.mainClass());
                Map allConf = this.conf().getAll();
                Enumeration.Value value = AuthTypes$.MODULE$.withName((String)this.conf().get(HighAvailabilityConf$.MODULE$.HA_ZK_ENGINE_AUTH_TYPE()));
                Enumeration.Value value2 = AuthTypes$.MODULE$.KERBEROS();
                if (!(value != null ? !value.equals(value2) : value2 != null)) {
                    allConf = allConf.$plus$plus(this.zkAuthKeytabFileConf((Map<String, String>)allConf));
                }
                allConf.$plus$plus(this.engineLogPathConf()).$plus$plus(this.appendPodNameConf((Map<String, String>)allConf)).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 != null) {
                        String k = (String)tuple2._1();
                        String v = (String)tuple2._2();
                        buffer.$plus$eq((Object)"--conf");
                        return buffer.$plus$eq((Object)new StringBuilder(1).append(this.convertConfigKey(k)).append("=").append(v).toString());
                    }
                    throw new MatchError((Object)tuple2);
                });
                this.setupKerberos((ArrayBuffer<String>)buffer);
                this.mainResource().foreach((Function1 & Serializable & scala.Serializable)r -> buffer.$plus$eq(r));
                this.commands = (String[])buffer.toArray(ClassTag$.MODULE$.apply(String.class));
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.commands;
    }

    @Override
    public String[] commands() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.commands$lzycompute();
        }
        return this.commands;
    }

    @Override
    public String module() {
        return "kyuubi-spark-sql-engine";
    }

    public void setupKerberos(ArrayBuffer<String> buffer) {
        Option<String> option = this.tryKeytab();
        if (None$.MODULE$.equals(option)) {
            this.setSparkUserName(this.proxyUser(), buffer);
            buffer.$plus$eq((Object)"--proxy-user");
            buffer.$plus$eq((Object)this.proxyUser());
            return;
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            String name = (String)some.value();
            this.setSparkUserName(name, buffer);
            return;
        }
        throw new MatchError(option);
    }

    private Option<String> tryKeytab() {
        None$ none$;
        block4: {
            Option principal = this.conf().getOption("spark.kerberos.principal");
            Option keytab = this.conf().getOption("spark.kerberos.keytab");
            if (principal.isEmpty() || keytab.isEmpty()) {
                return None$.MODULE$;
            }
            try {
                UserGroupInformation ugi = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)((String)principal.get()), (String)((String)keytab.get()));
                String string = ugi.getShortUserName();
                String string2 = this.proxyUser();
                if (string == null ? string2 != null : !string.equals(string2)) {
                    this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(120).append("The session proxy user: ").append(this.proxyUser()).append(" is not same with ").append("spark principal: ").append(ugi.getShortUserName()).append(", so we can't support use keytab. ").append("Fallback to use proxy user.").toString());
                    none$ = None$.MODULE$;
                    break block4;
                }
                none$ = new Some((Object)ugi.getShortUserName());
            }
            catch (IOException e) {
                this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append("Failed to login for ").append(principal.get()).toString(), e);
                none$ = None$.MODULE$;
            }
        }
        return none$;
    }

    private Map<String, String> zkAuthKeytabFileConf(Map<String, String> sparkConf) {
        Option zkAuthKeytab = (Option)this.conf().get(HighAvailabilityConf$.MODULE$.HA_ZK_AUTH_KEYTAB());
        if (zkAuthKeytab.isDefined()) {
            Option option = sparkConf.get((Object)"spark.files");
            if (option instanceof Some) {
                Some some = (Some)option;
                String files = (String)some.value();
                return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.files"), (Object)new StringBuilder(1).append(files).append(",").append(zkAuthKeytab.get()).toString())}));
            }
            return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.files"), zkAuthKeytab.get())}));
        }
        return (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
    }

    @Override
    public String shortName() {
        return "spark";
    }

    private Map<String, String> defaultsConf$lzycompute() {
        SparkProcessBuilder sparkProcessBuilder = this;
        synchronized (sparkProcessBuilder) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                String confDir = (String)this.env().getOrElse((Object)"SPARK_CONF_DIR", (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(4).append(this.sparkHome()).append(File.separator).append("conf").toString());
                this.defaultsConf = this.liftedTree1$1(confDir);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.defaultsConf;
    }

    public Map<String, String> defaultsConf() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.defaultsConf$lzycompute();
        }
        return this.defaultsConf;
    }

    @Override
    public ApplicationManagerInfo appMgrInfo() {
        return ApplicationManagerInfo$.MODULE$.apply(this.clusterManager(), this.kubernetesContext(), this.kubernetesNamespace());
    }

    public Map<String, String> appendPodNameConf(Map<String, String> conf) {
        BoxedUnit boxedUnit;
        String appName = (String)conf.getOrElse((Object)"spark.app.name", (Function0 & Serializable & scala.Serializable)() -> "spark");
        Builder map = Map$.MODULE$.newBuilder();
        if (this.clusterManager().exists((Function1 & Serializable & scala.Serializable)cm -> BoxesRunTime.boxToBoolean((boolean)SparkProcessBuilder.$anonfun$appendPodNameConf$2(cm)))) {
            BoxedUnit boxedUnit2;
            if (!conf.contains((Object)"spark.kubernetes.executor.podNamePrefix")) {
                String prefix = KubernetesUtils$.MODULE$.generateExecutorPodNamePrefix(appName, this.engineRefId());
                boxedUnit2 = map.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.kubernetes.executor.podNamePrefix"), (Object)prefix));
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            if (this.deployMode().exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)SparkProcessBuilder.$anonfun$appendPodNameConf$3(x$1)))) {
                if (!conf.contains((Object)"spark.kubernetes.driver.pod.name")) {
                    String name = KubernetesUtils$.MODULE$.generateDriverPodName(appName, this.engineRefId());
                    boxedUnit = map.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.kubernetes.driver.pod.name"), (Object)name));
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return ((TraversableOnce)map.result()).toMap(Predef$.MODULE$.$conforms());
    }

    @Override
    public Option<String> clusterManager() {
        return this.conf().getOption("spark.master").orElse((Function0 & Serializable & scala.Serializable)() -> this.defaultsConf().get((Object)"spark.master"));
    }

    public Option<String> deployMode() {
        return this.conf().getOption("spark.submit.deployMode").orElse((Function0 & Serializable & scala.Serializable)() -> this.defaultsConf().get((Object)"spark.submit.deployMode"));
    }

    @Override
    public boolean isClusterMode() {
        Some some;
        String m;
        Option option = this.clusterManager().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.toLowerCase(Locale.ROOT));
        if (option instanceof Some && ((m = (String)(some = (Some)option).value()).startsWith("yarn") || m.startsWith("k8s"))) {
            return this.deployMode().exists((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)SparkProcessBuilder.$anonfun$isClusterMode$2(x$3)));
        }
        return false;
    }

    public Option<String> kubernetesContext() {
        return this.conf().getOption("spark.kubernetes.context").orElse((Function0 & Serializable & scala.Serializable)() -> this.defaultsConf().get((Object)"spark.kubernetes.context"));
    }

    public Option<String> kubernetesNamespace() {
        return this.conf().getOption("spark.kubernetes.namespace").orElse((Function0 & Serializable & scala.Serializable)() -> this.defaultsConf().get((Object)"spark.kubernetes.namespace"));
    }

    @Override
    public void validateConf() {
        Validator$.MODULE$.validateConf(this.conf());
    }

    public void setSparkUserName(String userName, ArrayBuffer<String> buffer) {
        this.clusterManager().foreach((Function1 & Serializable & scala.Serializable)cm -> {
            if (cm.toUpperCase().startsWith("K8S")) {
                buffer.$plus$eq((Object)"--conf");
                buffer.$plus$eq((Object)new StringBuilder(43).append("spark.kubernetes.driverEnv.SPARK_USER_NAME=").append(userName).toString());
                buffer.$plus$eq((Object)"--conf");
                return buffer.$plus$eq((Object)new StringBuilder(34).append("spark.executorEnv.SPARK_USER_NAME=").append(userName).toString());
            }
            return BoxedUnit.UNIT;
        });
    }

    public Map<String, String> engineLogPathConf() {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ProcBuilder$.MODULE$.KYUUBI_ENGINE_LOG_PATH_KEY()), (Object)this.engineLog().getAbsolutePath())}));
    }

    public static final /* synthetic */ boolean $anonfun$engineScalaBinaryVersion$1(CharSequence x$1) {
        return StringUtils.isNotBlank((CharSequence)x$1);
    }

    private final /* synthetic */ Map liftedTree1$1(String confDir$1) {
        Map map;
        block3: {
            try {
                File confFile = new File(new StringBuilder(19).append(confDir$1).append(File.separator).append("spark-defaults.conf").toString());
                if (confFile.exists()) {
                    map = Utils$.MODULE$.getPropertiesFromFile((Option)new Some((Object)confFile));
                    break block3;
                }
                map = Predef$.MODULE$.Map().empty();
            }
            catch (Exception exception) {
                this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Failed to load spark configurations from ").append(confDir$1).toString());
                map = Predef$.MODULE$.Map().empty();
            }
        }
        return map;
    }

    public static final /* synthetic */ boolean $anonfun$appendPodNameConf$2(String cm) {
        return cm.toLowerCase(Locale.ROOT).startsWith("k8s");
    }

    public static final /* synthetic */ boolean $anonfun$appendPodNameConf$3(String x$1) {
        String string = x$1.toLowerCase(Locale.ROOT);
        String string2 = "cluster";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$isClusterMode$2(String x$3) {
        String string = x$3.toLowerCase(Locale.ROOT);
        String string2 = "cluster";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public SparkProcessBuilder(String proxyUser, KyuubiConf conf, String engineRefId, Option<OperationLog> extraEngineLog) {
        this.proxyUser = proxyUser;
        this.conf = conf;
        this.engineRefId = engineRefId;
        this.extraEngineLog = extraEngineLog;
        ProcBuilder.$init$(this);
        Logging.$init$((Logging)this);
        this.sparkHome = this.getEngineHome(this.shortName());
        this.executable = Paths.get(this.sparkHome(), "bin", SparkProcessBuilder$.MODULE$.org$apache$kyuubi$engine$spark$SparkProcessBuilder$$SPARK_SUBMIT_FILE()).toFile().getCanonicalPath();
        this.engineScalaBinaryVersion = (String)this.env().get((Object)"SPARK_SCALA_VERSION").filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)SparkProcessBuilder.$anonfun$engineScalaBinaryVersion$1(x$1))).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.extractSparkCoreScalaVersion((Iterable<String>)Predef$.MODULE$.wrapRefArray((Object[])Paths.get(this.sparkHome(), "jars").toFile().list())));
    }

    @VisibleForTesting
    public SparkProcessBuilder(String proxyUser, KyuubiConf conf) {
        this(proxyUser, conf, "", SparkProcessBuilder$.MODULE$.$lessinit$greater$default$4());
    }
}

