/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.util.Arrays;
import java.util.Collections;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.loader.GeneratedMethod;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.execute.CursorResultSet;
import org.apache.derby.iapi.sql.execute.ExecIndexRow;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.store.access.Qualifier;
import org.apache.derby.iapi.store.access.StaticCompiledOpenConglomInfo;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.impl.sql.execute.TableScanResultSet;

class MultiProbeTableScanResultSet
extends TableScanResultSet
implements CursorResultSet {
    protected DataValueDescriptor[] probeValues;
    protected DataValueDescriptor[] origProbeValues;
    protected int probeValIndex;
    private int sortRequired;
    private boolean skipNextScan;

    MultiProbeTableScanResultSet(long l, StaticCompiledOpenConglomInfo staticCompiledOpenConglomInfo, Activation activation, int n, int n2, GeneratedMethod generatedMethod, int n3, GeneratedMethod generatedMethod2, int n4, boolean bl, Qualifier[][] qualifierArray, DataValueDescriptor[] dataValueDescriptorArray, int n5, String string, String string2, String string3, boolean bl2, boolean bl3, int n6, int n7, int n8, boolean bl4, int n9, boolean bl5, double d, double d2) throws StandardException {
        super(l, staticCompiledOpenConglomInfo, activation, n, n2, generatedMethod, n3, generatedMethod2, n4, bl, qualifierArray, string, string2, string3, bl2, bl3, n6, n7, n8, bl4, n9, 1, bl5, d, d2);
        this.origProbeValues = dataValueDescriptorArray;
        this.sortRequired = n5;
    }

    @Override
    public void openCore() throws StandardException {
        if (this.sortRequired == 3) {
            this.probeValues = this.origProbeValues;
        } else {
            Object[] objectArray = new DataValueDescriptor[this.origProbeValues.length];
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray[i] = this.origProbeValues[i].cloneValue(false);
            }
            if (this.sortRequired == 1) {
                Arrays.sort(objectArray);
            } else {
                Arrays.sort(objectArray, Collections.reverseOrder());
            }
            this.probeValues = objectArray;
        }
        this.probeValIndex = 0;
        super.openCore();
    }

    @Override
    public void reopenCore() throws StandardException {
        this.reopenCore(false);
    }

    private void reopenCore(boolean bl) throws StandardException {
        if (!bl) {
            this.probeValIndex = 0;
        }
        super.reopenCore();
    }

    @Override
    protected void reopenScanController() throws StandardException {
        long l = this.rowsThisScan;
        super.reopenScanController();
        this.rowsThisScan = l;
    }

    @Override
    void initStartAndStopKey() throws StandardException {
        super.initStartAndStopKey();
        if (this.probeValIndex == 0) {
            this.rowsThisScan = 0L;
        }
        DataValueDescriptor[] dataValueDescriptorArray = this.startPosition.getRowArray();
        DataValueDescriptor[] dataValueDescriptorArray2 = this.stopPosition.getRowArray();
        DataValueDescriptor dataValueDescriptor = this.getNextProbeValue();
        if (dataValueDescriptor != null) {
            dataValueDescriptorArray[0] = dataValueDescriptor;
            if (!this.sameStartStopPosition) {
                dataValueDescriptorArray2[0] = dataValueDescriptorArray[0];
            }
        }
        this.skipNextScan = dataValueDescriptor == null;
    }

    @Override
    protected boolean skipScan(ExecIndexRow execIndexRow, ExecIndexRow execIndexRow2) throws StandardException {
        return this.skipNextScan || super.skipScan(execIndexRow, execIndexRow2);
    }

    @Override
    public ExecRow getNextRowCore() throws StandardException {
        if (this.isXplainOnlyMode()) {
            return null;
        }
        this.checkCancellationFlag();
        ExecRow execRow = super.getNextRowCore();
        while (execRow == null && this.moreInListVals()) {
            this.reopenCore(true);
            execRow = super.getNextRowCore();
        }
        return execRow;
    }

    @Override
    public void close() throws StandardException {
        super.close();
    }

    private boolean moreInListVals() {
        return this.probeValIndex < this.probeValues.length;
    }

    private DataValueDescriptor getNextProbeValue() {
        int n;
        for (n = this.probeValIndex; n > 0 && n < this.probeValues.length && this.probeValues[this.probeValIndex - 1].equals(this.probeValues[n]); ++n) {
        }
        this.probeValIndex = n;
        if (this.probeValIndex < this.probeValues.length) {
            return this.probeValues[this.probeValIndex++];
        }
        return null;
    }
}

