/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.engine.flink.operation;

import java.io.Serializable;
import java.util.Map;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.ResultKind;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.client.gateway.Executor;
import org.apache.flink.table.operations.command.AddJarOperation;
import org.apache.flink.table.operations.command.RemoveJarOperation;
import org.apache.flink.table.operations.command.ResetOperation;
import org.apache.flink.table.operations.command.SetOperation;
import org.apache.flink.table.operations.command.ShowJarsOperation;
import org.apache.flink.table.types.DataType;
import org.apache.flink.types.Row;
import org.apache.kyuubi.engine.flink.result.ResultSet;
import org.apache.kyuubi.engine.flink.result.ResultSetUtil$;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;

public final class OperationUtils$ {
    public static OperationUtils$ MODULE$;

    static {
        new OperationUtils$();
    }

    public ResultSet runSetOperation(SetOperation setOperation, Executor executor, String sessionId) {
        ResultSet resultSet;
        if (setOperation.getKey().isPresent()) {
            String key2 = ((String)setOperation.getKey().get()).trim();
            if (setOperation.getValue().isPresent()) {
                String newValue = ((String)setOperation.getValue().get()).trim();
                executor.setSessionProperty(sessionId, key2, newValue);
            }
            String value2 = executor.getSessionConfigMap(sessionId).getOrDefault(key2, "");
            resultSet = ResultSet.builder().resultKind(ResultKind.SUCCESS_WITH_CONTENT).columns(new Column[]{Column.physical((String)"key", (DataType)DataTypes.STRING()), Column.physical((String)"value", (DataType)DataTypes.STRING())}).data((Row[])((Object[])new Row[]{Row.of((Object[])new Object[]{key2, value2})})).build();
        } else {
            Map properties = executor.getSessionConfigMap(sessionId);
            ArrayBuffer entries = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
            properties.forEach((key, value) -> entries.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row.of((Object[])new Object[]{key, value})})));
            if (entries.nonEmpty()) {
                ArrayBuffer prettyEntries = (ArrayBuffer)entries.sortBy((Function1 & Serializable & scala.Serializable)x$1 -> (String)x$1.getField(0), (Ordering)Ordering.String$.MODULE$);
                resultSet = ResultSet.builder().resultKind(ResultKind.SUCCESS_WITH_CONTENT).columns(new Column[]{Column.physical((String)"key", (DataType)DataTypes.STRING()), Column.physical((String)"value", (DataType)DataTypes.STRING())}).data((Row[])prettyEntries.toArray(ClassTag$.MODULE$.apply(Row.class))).build();
            } else {
                resultSet = ResultSet.builder().resultKind(ResultKind.SUCCESS_WITH_CONTENT).columns(new Column[]{Column.physical((String)"key", (DataType)DataTypes.STRING()), Column.physical((String)"value", (DataType)DataTypes.STRING())}).data((Row[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(Row.class))).build();
            }
        }
        return resultSet;
    }

    public ResultSet runResetOperation(ResetOperation resetOperation, Executor executor, String sessionId) {
        if (resetOperation.getKey().isPresent()) {
            executor.resetSessionProperty(sessionId, (String)resetOperation.getKey().get());
        } else {
            executor.resetSessionProperties(sessionId);
        }
        return ResultSetUtil$.MODULE$.successResultSet();
    }

    public ResultSet runAddJarOperation(AddJarOperation addJarOperation, Executor executor, String sessionId) {
        executor.addJar(sessionId, addJarOperation.getPath());
        return ResultSetUtil$.MODULE$.successResultSet();
    }

    public ResultSet runRemoveJarOperation(RemoveJarOperation removeJarOperation, Executor executor, String sessionId) {
        executor.removeJar(sessionId, removeJarOperation.getPath());
        return ResultSetUtil$.MODULE$.successResultSet();
    }

    public ResultSet runShowJarOperation(ShowJarsOperation showJarsOperation, Executor executor, String sessionId) {
        java.util.List jars = executor.listJars(sessionId);
        return ResultSetUtil$.MODULE$.stringListToResultSet((List<String>)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(jars).asScala()).toList(), "jar");
    }

    private OperationUtils$() {
        MODULE$ = this;
    }
}

