/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.server;

import com.google.common.annotations.VisibleForTesting;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.EnumSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import org.apache.hadoop.conf.Configuration;
import org.apache.kyuubi.KyuubiException;
import org.apache.kyuubi.Utils$;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.server.KyuubiRestFrontendService$;
import org.apache.kyuubi.server.KyuubiServer$;
import org.apache.kyuubi.server.api.v1.ApiRootResource$;
import org.apache.kyuubi.server.http.authentication.AuthenticationFilter;
import org.apache.kyuubi.server.http.authentication.AuthenticationFilter$;
import org.apache.kyuubi.server.http.authentication.KyuubiHttpAuthenticationFactory;
import org.apache.kyuubi.server.metadata.api.Metadata;
import org.apache.kyuubi.server.ui.JettyServer;
import org.apache.kyuubi.server.ui.JettyServer$;
import org.apache.kyuubi.service.AbstractFrontendService;
import org.apache.kyuubi.service.Serverable;
import org.apache.kyuubi.service.Service;
import org.apache.kyuubi.service.ServiceUtils$;
import org.apache.kyuubi.service.authentication.KyuubiAuthenticationFactory$;
import org.apache.kyuubi.session.KyuubiBatchSessionImpl;
import org.apache.kyuubi.session.KyuubiSessionManager;
import org.apache.kyuubi.session.SessionHandle;
import org.apache.kyuubi.session.SessionHandle$;
import org.apache.kyuubi.util.ThreadUtils$;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001de\u0001\u0002\u0011\"\u0001)B\u0001\"\r\u0001\u0003\u0006\u0004%\tE\r\u0005\tm\u0001\u0011\t\u0011)A\u0005g!)q\u0007\u0001C\u0001q!I!\u0005\u0001a\u0001\u0002\u0004%I\u0001\u0010\u0005\n\u0007\u0002\u0001\r\u00111A\u0005\n\u0011C\u0011\"\u0014\u0001A\u0002\u0003\u0005\u000b\u0015B\u001f\t\u000f9\u0003!\u0019!C\u0005\u001f\"1A\f\u0001Q\u0001\nACQ!\u0018\u0001\u0005\nyCQa\u001a\u0001\u0005\n!Dqa\u001c\u0001C\u0002\u0013%\u0001\u000f\u0003\u0004v\u0001\u0001\u0006I!\u001d\u0005\u0006m\u0002!\te\u001e\u0005\u0007\u007f\u0002!\t%!\u0001\t\u000f\u0005e\u0001\u0001\"\u0003\u0002\u001c!9\u0011Q\u0004\u0001\u0005\n\u0005m\u0001\u0002CA\u0010\u0001\u0011\u00051%a\u0007\t\u000f\u0005m\u0002\u0001\"\u0011\u0002\u001c!9\u0011Q\b\u0001\u0005B\u0005m\u0001bBA \u0001\u0011\u0005\u0011\u0011\t\u0005\b\u0003\u001b\u0002A\u0011AA\u0001\u0011\u001d\ty\u0005\u0001C\u0005\u0003#B\u0011\"!\u0018\u0001\u0005\u0004%\t%a\u0018\t\u0011\u00055\u0004\u0001)A\u0005\u0003C:q!a\u001c\"\u0011\u0003\t\tH\u0002\u0004!C!\u0005\u00111\u000f\u0005\u0007oi!\t!a\u001f\t\u0015}T\u0002\u0019!a\u0001\n\u0013\t\t\u0001C\u0006\u0002~i\u0001\r\u00111A\u0005\n\u0005}\u0004bCAB5\u0001\u0007\t\u0011)Q\u0005\u0003\u0007Aq!!\"\u001b\t\u0003\t\tAA\rLsV,(-\u001b*fgR4%o\u001c8uK:$7+\u001a:wS\u000e,'B\u0001\u0012$\u0003\u0019\u0019XM\u001d<fe*\u0011A%J\u0001\u0007Wf,XOY5\u000b\u0005\u0019:\u0013AB1qC\u000eDWMC\u0001)\u0003\ry'oZ\u0002\u0001'\t\u00011\u0006\u0005\u0002-_5\tQF\u0003\u0002/G\u000591/\u001a:wS\u000e,\u0017B\u0001\u0019.\u0005]\t%m\u001d;sC\u000e$hI]8oi\u0016tGmU3sm&\u001cW-\u0001\u0006tKJ4XM]1cY\u0016,\u0012a\r\t\u0003YQJ!!N\u0017\u0003\u0015M+'O^3sC\ndW-A\u0006tKJ4XM]1cY\u0016\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0002:wA\u0011!\bA\u0007\u0002C!)\u0011g\u0001a\u0001gU\tQ\b\u0005\u0002?\u00036\tqH\u0003\u0002AC\u0005\u0011Q/[\u0005\u0003\u0005~\u00121BS3uif\u001cVM\u001d<fe\u0006Q1/\u001a:wKJ|F%Z9\u0015\u0005\u0015[\u0005C\u0001$J\u001b\u00059%\"\u0001%\u0002\u000bM\u001c\u0017\r\\1\n\u0005);%\u0001B+oSRDq\u0001T\u0003\u0002\u0002\u0003\u0007Q(A\u0002yIE\nqa]3sm\u0016\u0014\b%A\u0005jgN#\u0018M\u001d;fIV\t\u0001\u000b\u0005\u0002R56\t!K\u0003\u0002T)\u00061\u0011\r^8nS\u000eT!!\u0016,\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002X1\u0006!Q\u000f^5m\u0015\u0005I\u0016\u0001\u00026bm\u0006L!a\u0017*\u0003\u001b\u0005#x.\\5d\u0005>|G.Z1o\u0003)I7o\u0015;beR,G\rI\u0001\u000bQ\u0006$wn\u001c9D_:4W#A0\u0011\u0005\u0001,W\"A1\u000b\u0005\t\u001c\u0017\u0001B2p]\u001aT!\u0001Z\u0013\u0002\r!\fGm\\8q\u0013\t1\u0017MA\u0007D_:4\u0017nZ;sCRLwN\\\u0001\u000fg\u0016\u001c8/[8o\u001b\u0006t\u0017mZ3s+\u0005I\u0007C\u00016n\u001b\u0005Y'B\u00017$\u0003\u001d\u0019Xm]:j_:L!A\\6\u0003)-KX/\u001e2j'\u0016\u001c8/[8o\u001b\u0006t\u0017mZ3s\u00031\u0011\u0017\r^2i\u0007\",7m[3s+\u0005\t\bC\u0001:t\u001b\u0005!\u0016B\u0001;U\u0005a\u00196\r[3ek2,G-\u0012=fGV$xN]*feZL7-Z\u0001\u000eE\u0006$8\r[\"iK\u000e\\WM\u001d\u0011\u0002\u0015%t\u0017\u000e^5bY&TX\r\u0006\u0002Fq\")!-\u0004a\u0001sB\u0011!0`\u0007\u0002w*\u0011ApI\u0001\u0007G>tg-[4\n\u0005y\\(AC&zkV\u0014\u0017nQ8oM\u0006i1m\u001c8oK\u000e$\u0018n\u001c8Ve2,\"!a\u0001\u0011\t\u0005\u0015\u00111\u0003\b\u0005\u0003\u000f\ty\u0001E\u0002\u0002\n\u001dk!!a\u0003\u000b\u0007\u00055\u0011&\u0001\u0004=e>|GOP\u0005\u0004\u0003#9\u0015A\u0002)sK\u0012,g-\u0003\u0003\u0002\u0016\u0005]!AB*ue&twMC\u0002\u0002\u0012\u001d\u000bQb\u001d;beRLe\u000e^3s]\u0006dG#A#\u0002#M$\u0018M\u001d;CCR\u001c\u0007n\u00115fG.,'/\u0001\u000bsK\u000e|g/\u001a:CCR\u001c\u0007nU3tg&|gn\u001d\u0015\u0004#\u0005\r\u0002\u0003BA\u0013\u0003oi!!a\n\u000b\t\u0005%\u00121F\u0001\fC:tw\u000e^1uS>t7O\u0003\u0003\u0002.\u0005=\u0012AB2p[6|gN\u0003\u0003\u00022\u0005M\u0012AB4p_\u001edWM\u0003\u0002\u00026\u0005\u00191m\\7\n\t\u0005e\u0012q\u0005\u0002\u0012-&\u001c\u0018N\u00197f\r>\u0014H+Z:uS:<\u0017!B:uCJ$\u0018\u0001B:u_B\f1bZ3u+N,'OT1nKR!\u00111AA\"\u0011\u001d\t)\u0005\u0006a\u0001\u0003\u000f\n1b]3tg&|gnQ8oMBA\u0011QAA%\u0003\u0007\t\u0019!\u0003\u0003\u0002L\u0005]!aA'ba\u0006aq-\u001a;Ja\u0006#GM]3tg\u0006aq-\u001a;Qe>D\u00180V:feRA\u00111AA*\u0003+\nI\u0006C\u0004\u0002FY\u0001\r!a\u0012\t\u000f\u0005]c\u00031\u0001\u0002\u0004\u0005I\u0011\u000e]!eIJ,7o\u001d\u0005\b\u000372\u0002\u0019AA\u0002\u0003!\u0011X-\u00197Vg\u0016\u0014\u0018\u0001\u00053jg\u000e|g/\u001a:z'\u0016\u0014h/[2f+\t\t\t\u0007E\u0003G\u0003G\n9'C\u0002\u0002f\u001d\u0013aa\u00149uS>t\u0007c\u0001\u0017\u0002j%\u0019\u00111N\u0017\u0003\u000fM+'O^5dK\u0006\tB-[:d_Z,'/_*feZL7-\u001a\u0011\u00023-KX/\u001e2j%\u0016\u001cHO\u0012:p]R,g\u000eZ*feZL7-\u001a\t\u0003ui\u00192AGA;!\r1\u0015qO\u0005\u0004\u0003s:%AB!osJ+g\r\u0006\u0002\u0002r\u0005\t2m\u001c8oK\u000e$\u0018n\u001c8Ve2|F%Z9\u0015\u0007\u0015\u000b\t\t\u0003\u0005M;\u0005\u0005\t\u0019AA\u0002\u00039\u0019wN\u001c8fGRLwN\\+sY\u0002\n\u0001cZ3u\u0007>tg.Z2uS>tWK\u001d7")
public class KyuubiRestFrontendService
extends AbstractFrontendService {
    private final Serverable serverable;
    private JettyServer server;
    private final AtomicBoolean isStarted;
    private final ScheduledExecutorService batchChecker;
    private final Option<Service> discoveryService;

    public static String getConnectionUrl() {
        return KyuubiRestFrontendService$.MODULE$.getConnectionUrl();
    }

    public Serverable serverable() {
        return this.serverable;
    }

    private JettyServer server() {
        return this.server;
    }

    private void server_$eq(JettyServer x$1) {
        this.server = x$1;
    }

    private AtomicBoolean isStarted() {
        return this.isStarted;
    }

    private Configuration hadoopConf() {
        return KyuubiServer$.MODULE$.getHadoopConf();
    }

    public KyuubiSessionManager org$apache$kyuubi$server$KyuubiRestFrontendService$$sessionManager() {
        return (KyuubiSessionManager)this.be().sessionManager();
    }

    private ScheduledExecutorService batchChecker() {
        return this.batchChecker;
    }

    public synchronized void initialize(KyuubiConf conf) {
        String host = (String)((Option)conf.get(KyuubiConf$.MODULE$.FRONTEND_REST_BIND_HOST())).getOrElse((Function0 & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToBoolean((Object)conf.get(KyuubiConf$.MODULE$.FRONTEND_CONNECTION_URL_USE_HOSTNAME())) ? Utils$.MODULE$.findLocalInetAddress().getCanonicalHostName() : Utils$.MODULE$.findLocalInetAddress().getHostAddress());
        this.server_$eq(JettyServer$.MODULE$.apply(this.getName(), host, BoxesRunTime.unboxToInt((Object)conf.get(KyuubiConf$.MODULE$.FRONTEND_REST_BIND_PORT()))));
        super.initialize(conf);
    }

    public String connectionUrl() {
        this.checkInitialized();
        return this.server().getServerUri();
    }

    private void startInternal() {
        ServletContextHandler contextHandler = ApiRootResource$.MODULE$.getServletHandler(this);
        FilterHolder holder = new FilterHolder((Filter)new AuthenticationFilter(this.conf()));
        contextHandler.addFilter(holder, "/v1/*", EnumSet.allOf(DispatcherType.class));
        KyuubiHttpAuthenticationFactory authenticationFactory = new KyuubiHttpAuthenticationFactory(this.conf());
        this.server().addHandler((Handler)authenticationFactory.httpHandlerWrapperFactory().wrapHandler((Handler)contextHandler));
        this.server().addStaticHandler("org/apache/kyuubi/ui/static", "/static/");
        this.server().addRedirectHandler("/", "/static/");
        this.server().addRedirectHandler("/static", "/static/");
        this.server().addStaticHandler("META-INF/resources/webjars/swagger-ui/4.9.1/", "/swagger-static/");
        this.server().addStaticHandler("org/apache/kyuubi/ui/swagger", "/swagger/");
        this.server().addRedirectHandler("/docs", "/swagger/");
        this.server().addRedirectHandler("/docs/", "/swagger/");
        this.server().addRedirectHandler("/swagger", "/swagger/");
    }

    private void startBatchChecker() {
        long interval = BoxesRunTime.unboxToLong((Object)this.conf().get(KyuubiConf$.MODULE$.BATCH_CHECK_INTERVAL()));
        Runnable task = new Runnable(this){
            private final /* synthetic */ KyuubiRestFrontendService $outer;

            public void run() {
                try {
                    this.$outer.org$apache$kyuubi$server$KyuubiRestFrontendService$$sessionManager().getPeerInstanceClosedBatchSessions(this.$outer.connectionUrl()).foreach((Function1 & Serializable & scala.Serializable)batch -> {
                        $anon$1.$anonfun$run$1(this, batch);
                        return BoxedUnit.UNIT;
                    });
                }
                catch (Throwable e) {
                    this.$outer.error((Function0 & Serializable & scala.Serializable)() -> "Error checking batch sessions", e);
                }
            }

            public static final /* synthetic */ void $anonfun$run$3(KyuubiBatchSessionImpl x$1) {
                x$1.close();
            }

            public static final /* synthetic */ void $anonfun$run$1($anon$1 $this, Metadata batch) {
                Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    SessionHandle sessionHandle = SessionHandle$.MODULE$.fromUUID(batch.identifier());
                    Option$.MODULE$.apply((Object)((Object)$this.$outer.org$apache$kyuubi$server$KyuubiRestFrontendService$$sessionManager().getBatchSessionImpl(sessionHandle))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                        $anon$1.$anonfun$run$3(x$1);
                        return BoxedUnit.UNIT;
                    });
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$1$adapted(org.apache.kyuubi.server.KyuubiRestFrontendService$$anon$1 org.apache.kyuubi.server.metadata.api.Metadata ), $anonfun$run$4(), $anonfun$run$3$adapted(org.apache.kyuubi.session.KyuubiBatchSessionImpl ), $anonfun$run$2(org.apache.kyuubi.server.KyuubiRestFrontendService$$anon$1 org.apache.kyuubi.server.metadata.api.Metadata )}, serializedLambda);
            }
        };
        this.batchChecker().scheduleWithFixedDelay(task, interval, interval, TimeUnit.MILLISECONDS);
    }

    @VisibleForTesting
    public void recoverBatchSessions() {
        int recoveryNumThreads = BoxesRunTime.unboxToInt((Object)this.conf().get(KyuubiConf$.MODULE$.METADATA_RECOVERY_THREADS()));
        ThreadPoolExecutor batchRecoveryExecutor = ThreadUtils$.MODULE$.newDaemonFixedThreadPool(recoveryNumThreads, "batch-recovery-executor");
        try {
            Seq<KyuubiBatchSessionImpl> batchSessionsToRecover = this.org$apache$kyuubi$server$KyuubiRestFrontendService$$sessionManager().getBatchSessionsToRecover(this.connectionUrl());
            AtomicInteger pendingRecoveryTasksCount = new AtomicInteger(0);
            Seq tasks = (Seq)batchSessionsToRecover.flatMap((Function1 & Serializable & scala.Serializable)batchSession -> {
                Iterable iterable;
                String batchId = batchSession.batchJobSubmissionOp().batchId();
                try {
                    Future<Object> task = batchRecoveryExecutor.submit(() -> {
                        Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.org$apache$kyuubi$server$KyuubiRestFrontendService$$sessionManager().openBatchSession(batchSession));
                        return BoxedUnit.UNIT;
                    });
                    iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(task), (Object)batchId)));
                }
                catch (Throwable e) {
                    this.error((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Error while submitting batch[").append(batchId).append("] for recovery").toString(), e);
                    iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                }
                return iterable;
            }, Seq$.MODULE$.canBuildFrom());
            pendingRecoveryTasksCount.addAndGet(tasks.size());
            tasks.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                KyuubiRestFrontendService.$anonfun$recoverBatchSessions$5(this, pendingRecoveryTasksCount, x0$1);
                return BoxedUnit.UNIT;
            });
        }
        finally {
            ThreadUtils$.MODULE$.shutdown((ExecutorService)batchRecoveryExecutor, ThreadUtils$.MODULE$.shutdown$default$2());
        }
    }

    public synchronized void start() {
        if (!this.isStarted().get()) {
            try {
                this.server().start();
                this.recoverBatchSessions();
                this.isStarted().set(true);
                this.info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(16).append(this.getName()).append(" has started at ").append(this.server().getServerUri()).toString());
                this.startBatchChecker();
                this.startInternal();
            }
            catch (Exception e) {
                throw new KyuubiException(new StringBuilder(13).append("Cannot start ").append(this.getName()).toString(), (Throwable)e);
            }
        }
        KyuubiRestFrontendService$.MODULE$.org$apache$kyuubi$server$KyuubiRestFrontendService$$connectionUrl_$eq(this.server().getServerUri());
        super.start();
    }

    public synchronized void stop() {
        ThreadUtils$.MODULE$.shutdown((ExecutorService)this.batchChecker(), ThreadUtils$.MODULE$.shutdown$default$2());
        if (this.isStarted().getAndSet(false)) {
            this.server().stop();
        }
        super.stop();
    }

    public String getUserName(Map<String, String> sessionConf) {
        String ipAddress = AuthenticationFilter$.MODULE$.getUserIpAddress();
        String realUser = ServiceUtils$.MODULE$.getShortName((String)Option$.MODULE$.apply((Object)AuthenticationFilter$.MODULE$.getUserName()).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)KyuubiRestFrontendService.$anonfun$getUserName$1(x$2))).getOrElse((Function0 & Serializable & scala.Serializable)() -> "anonymous"));
        return this.getProxyUser(sessionConf, ipAddress, realUser);
    }

    public String getIpAddress() {
        return (String)Option$.MODULE$.apply((Object)AuthenticationFilter$.MODULE$.getUserProxyHeaderIpAddress()).getOrElse((Function0 & Serializable & scala.Serializable)() -> AuthenticationFilter$.MODULE$.getUserIpAddress());
    }

    private String getProxyUser(Map<String, String> sessionConf, String ipAddress, String realUser) {
        return sessionConf == null ? realUser : (String)sessionConf.get((Object)KyuubiAuthenticationFactory$.MODULE$.HS2_PROXY_USER()).map((Function1 & Serializable & scala.Serializable)proxyUser -> {
            KyuubiAuthenticationFactory$.MODULE$.verifyProxyAccess(realUser, proxyUser, ipAddress, this.hadoopConf());
            return proxyUser;
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> realUser);
    }

    public Option<Service> discoveryService() {
        return this.discoveryService;
    }

    public static final /* synthetic */ void $anonfun$recoverBatchSessions$5(KyuubiRestFrontendService $this, AtomicInteger pendingRecoveryTasksCount$1, Tuple2 x0$1) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Future task = (Future)tuple2._1();
            String batchId = (String)tuple2._2();
            try {
                try {
                    boxedUnit = (BoxedUnit)task.get();
                }
                catch (Throwable e) {
                    $this.error((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Error while recovering batch[").append(batchId).append("]").toString(), e);
                    boxedUnit = BoxedUnit.UNIT;
                }
            }
            finally {
                int pendingTasks = pendingRecoveryTasksCount$1.decrementAndGet();
                $this.info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Batch[").append(batchId).append("] recovery task terminated, current pending tasks ").append(pendingTasks).toString());
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    public static final /* synthetic */ boolean $anonfun$getUserName$1(String x$2) {
        return new StringOps(Predef$.MODULE$.augmentString(x$2)).nonEmpty();
    }

    public KyuubiRestFrontendService(Serverable serverable) {
        this.serverable = serverable;
        super("KyuubiRestFrontendService");
        this.isStarted = new AtomicBoolean(false);
        this.batchChecker = ThreadUtils$.MODULE$.newDaemonSingleThreadScheduledExecutor("batch-checker", ThreadUtils$.MODULE$.newDaemonSingleThreadScheduledExecutor$default$2());
        this.discoveryService = None$.MODULE$;
    }
}

