/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.service.authentication;

import java.util.Hashtable;
import javax.naming.NamingException;
import javax.naming.directory.InitialDirContext;
import javax.security.sasl.AuthenticationException;
import org.apache.commons.lang3.StringUtils;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.service.ServiceUtils$;
import org.apache.kyuubi.service.authentication.PasswdAuthenticationProvider;
import scala.Function1;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\t3A!\u0002\u0004\u0001#!AA\u0004\u0001B\u0001B\u0003%Q\u0004C\u0003$\u0001\u0011\u0005A\u0005C\u0003(\u0001\u0011\u0005\u0003\u0006C\u0003<\u0001\u0011%AH\u0001\u0010MI\u0006\u0004\u0018)\u001e;iK:$\u0018nY1uS>t\u0007K]8wS\u0012,'/S7qY*\u0011q\u0001C\u0001\u000fCV$\b.\u001a8uS\u000e\fG/[8o\u0015\tI!\"A\u0004tKJ4\u0018nY3\u000b\u0005-a\u0011AB6zkV\u0014\u0017N\u0003\u0002\u000e\u001d\u00051\u0011\r]1dQ\u0016T\u0011aD\u0001\u0004_J<7\u0001A\n\u0004\u0001IA\u0002CA\n\u0017\u001b\u0005!\"\"A\u000b\u0002\u000bM\u001c\u0017\r\\1\n\u0005]!\"AB!osJ+g\r\u0005\u0002\u001a55\ta!\u0003\u0002\u001c\r\ta\u0002+Y:to\u0012\fU\u000f\u001e5f]RL7-\u0019;j_:\u0004&o\u001c<jI\u0016\u0014\u0018\u0001B2p]\u001a\u0004\"AH\u0011\u000e\u0003}Q!\u0001\t\u0006\u0002\r\r|gNZ5h\u0013\t\u0011sD\u0001\u0006LsV,(-[\"p]\u001a\fa\u0001P5oSRtDCA\u0013'!\tI\u0002\u0001C\u0003\u001d\u0005\u0001\u0007Q$\u0001\u0007bkRDWM\u001c;jG\u0006$X\rF\u0002*Ye\u0002\"a\u0005\u0016\n\u0005-\"\"\u0001B+oSRDQ!L\u0002A\u00029\nA!^:feB\u0011qF\u000e\b\u0003aQ\u0002\"!\r\u000b\u000e\u0003IR!a\r\t\u0002\rq\u0012xn\u001c;?\u0013\t)D#\u0001\u0004Qe\u0016$WMZ\u0005\u0003oa\u0012aa\u0015;sS:<'BA\u001b\u0015\u0011\u0015Q4\u00011\u0001/\u0003!\u0001\u0018m]:x_J$\u0017!\u00035bg\u0012{W.Y5o)\ti\u0004\t\u0005\u0002\u0014}%\u0011q\b\u0006\u0002\b\u0005>|G.Z1o\u0011\u0015\tE\u00011\u0001/\u0003!)8/\u001a:OC6,\u0007")
public class LdapAuthenticationProviderImpl
implements PasswdAuthenticationProvider {
    private final KyuubiConf conf;

    @Override
    public void authenticate(String user, String password) {
        String string;
        if (StringUtils.isBlank((CharSequence)user)) {
            throw new AuthenticationException(new StringBuilder(64).append("Error validating LDAP user, user is null").append(" or contains blank space").toString());
        }
        if (StringUtils.isBlank((CharSequence)password)) {
            throw new AuthenticationException(new StringBuilder(68).append("Error validating LDAP user, password is null").append(" or contains blank space").toString());
        }
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.security.authentication", "simple");
        ((Option)this.conf.get(KyuubiConf$.MODULE$.AUTHENTICATION_LDAP_URL())).foreach((Function1 & java.io.Serializable & Serializable)x$1 -> env.put("java.naming.provider.url", (String)x$1));
        Option domain = (Option)this.conf.get(KyuubiConf$.MODULE$.AUTHENTICATION_LDAP_DOMAIN());
        String u = !this.hasDomain(user) && domain.nonEmpty() ? new StringBuilder(1).append(user).append("@").append(domain.get()).toString() : user;
        String guidKey = this.conf.get(KyuubiConf$.MODULE$.AUTHENTICATION_LDAP_GUIDKEY());
        Option option = (Option)this.conf.get(KyuubiConf$.MODULE$.AUTHENTICATION_LDAP_BASEDN());
        if (option instanceof Some) {
            Some some = (Some)option;
            String dn = (String)some.value();
            string = new StringBuilder(2).append(guidKey).append("=").append(u).append(",").append(dn).toString();
        } else {
            string = u;
        }
        String bindDn = string;
        env.put("java.naming.security.principal", bindDn);
        env.put("java.naming.security.credentials", password);
        try {
            InitialDirContext ctx = new InitialDirContext(env);
            ctx.close();
        }
        catch (NamingException e) {
            throw new AuthenticationException(new StringBuilder(28).append("Error validating LDAP user: ").append(bindDn).toString(), e);
        }
    }

    private boolean hasDomain(String userName) {
        return ServiceUtils$.MODULE$.indexOfDomainMatch(userName) > 0;
    }

    public LdapAuthenticationProviderImpl(KyuubiConf conf) {
        this.conf = conf;
    }
}

