/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.reflection;

import java.util.LinkedHashSet;
import java.util.Set;

public class DynClasses {
    private DynClasses() {
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private ClassLoader loader = Thread.currentThread().getContextClassLoader();
        private Class<?> foundClass = null;
        private boolean nullOk = false;
        private Set<String> classNames = new LinkedHashSet<String>();

        private Builder() {
        }

        public Builder loader(ClassLoader newLoader) {
            this.loader = newLoader;
            return this;
        }

        public Builder impl(String className) {
            this.classNames.add(className);
            if (this.foundClass != null) {
                return this;
            }
            try {
                this.foundClass = Class.forName(className, true, this.loader);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            return this;
        }

        public Builder orNull() {
            this.nullOk = true;
            return this;
        }

        public <S> Class<? extends S> buildChecked() throws ClassNotFoundException {
            if (!this.nullOk && this.foundClass == null) {
                throw new ClassNotFoundException("Cannot find class; alternatives: " + String.join((CharSequence)", ", this.classNames));
            }
            return this.foundClass;
        }

        public <S> Class<? extends S> build() {
            if (!this.nullOk && this.foundClass == null) {
                throw new RuntimeException("Cannot find class; alternatives: " + String.join((CharSequence)", ", this.classNames));
            }
            return this.foundClass;
        }
    }
}

