/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.jdbc.hive.auth;

import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import javax.security.auth.Subject;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.client.CookieStore;
import org.apache.http.protocol.HttpContext;
import org.apache.kyuubi.jdbc.hive.auth.HttpAuthUtils;
import org.apache.kyuubi.jdbc.hive.auth.HttpRequestInterceptorBase;

public class HttpKerberosRequestInterceptor
extends HttpRequestInterceptorBase {
    private static final ReentrantLock kerberosLock = new ReentrantLock(true);
    String serverPrincipal;
    String host;
    Subject loggedInSubject;

    public HttpKerberosRequestInterceptor(String serverPrincipal, String host, Subject loggedInSubject, CookieStore cs, String cn, boolean isSSL, Map<String, String> additionalHeaders, Map<String, String> customCookies) {
        super(cs, cn, isSSL, additionalHeaders, customCookies);
        this.serverPrincipal = serverPrincipal;
        this.host = host;
        this.loggedInSubject = loggedInSubject;
    }

    @Override
    protected void addHttpAuthHeader(HttpRequest httpRequest, HttpContext httpContext) throws Exception {
        try {
            kerberosLock.lock();
            String kerberosAuthHeader = HttpAuthUtils.getKerberosServiceTicket(this.serverPrincipal, this.host, this.loggedInSubject);
            httpRequest.addHeader("Authorization", "Negotiate " + kerberosAuthHeader);
        }
        catch (Exception e) {
            throw new HttpException(e.getMessage(), (Throwable)e);
        }
        finally {
            kerberosLock.unlock();
        }
    }
}

