/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.client.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.kyuubi.client.exception.KyuubiRestException;

public final class JsonUtils {
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public static String toJson(Object object) {
        try {
            return MAPPER.writeValueAsString(object);
        }
        catch (Exception e) {
            throw new KyuubiRestException(String.format("Failed to convert object(%s) to json", object), e);
        }
    }

    public static <T> T fromJson(String json, Class<T> clazz) {
        try {
            return (T)MAPPER.readValue(json, clazz);
        }
        catch (Exception e) {
            throw new KyuubiRestException(String.format("Failed to convert json string(%s) to %s", json, clazz.getName()), e);
        }
    }
}

