/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.client.util;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;

public final class BatchUtils {
    public static String PENDING_STATE = "PENDING";
    public static String RUNNING_STATE = "RUNNING";
    public static String FINISHED_STATE = "FINISHED";
    public static String ERROR_STATE = "ERROR";
    public static String CANCELED_STATE = "CANCELED";
    public static List<String> terminalBatchStates = Arrays.asList(FINISHED_STATE, ERROR_STATE, CANCELED_STATE);

    public static boolean isPendingState(String state) {
        return PENDING_STATE.equalsIgnoreCase(state);
    }

    public static boolean isRunningState(String state) {
        return RUNNING_STATE.equalsIgnoreCase(state);
    }

    public static boolean isFinishedState(String state) {
        return FINISHED_STATE.equalsIgnoreCase(state);
    }

    public static boolean isTerminalState(String state) {
        return state != null && terminalBatchStates.contains(state.toUpperCase(Locale.ROOT));
    }
}

