/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.server.api.v1;

import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.Serializable;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.hive.service.rpc.thrift.TBoolValue;
import org.apache.hive.service.rpc.thrift.TByteValue;
import org.apache.hive.service.rpc.thrift.TColumn;
import org.apache.hive.service.rpc.thrift.TColumnValue;
import org.apache.hive.service.rpc.thrift.TDoubleValue;
import org.apache.hive.service.rpc.thrift.TI16Value;
import org.apache.hive.service.rpc.thrift.TI32Value;
import org.apache.hive.service.rpc.thrift.TI64Value;
import org.apache.hive.service.rpc.thrift.TPrimitiveTypeEntry;
import org.apache.hive.service.rpc.thrift.TRowSet;
import org.apache.hive.service.rpc.thrift.TStringValue;
import org.apache.hive.service.rpc.thrift.TTypeEntry;
import org.apache.hive.service.rpc.thrift.TTypeQualifierValue;
import org.apache.kyuubi.KyuubiSQLException$;
import org.apache.kyuubi.Logging;
import org.apache.kyuubi.events.KyuubiOperationEvent;
import org.apache.kyuubi.events.KyuubiOperationEvent$;
import org.apache.kyuubi.operation.FetchOrientation$;
import org.apache.kyuubi.operation.KyuubiOperation;
import org.apache.kyuubi.operation.Operation;
import org.apache.kyuubi.operation.OperationHandle;
import org.apache.kyuubi.operation.OperationHandle$;
import org.apache.kyuubi.server.KyuubiRestFrontendService;
import org.apache.kyuubi.server.api.ApiRequestContext;
import org.apache.kyuubi.server.api.v1.ColumnDesc;
import org.apache.kyuubi.server.api.v1.Field;
import org.apache.kyuubi.server.api.v1.OpActionRequest;
import org.apache.kyuubi.server.api.v1.OperationLog;
import org.apache.kyuubi.server.api.v1.ResultRowSet;
import org.apache.kyuubi.server.api.v1.ResultSetMetaData;
import org.apache.kyuubi.server.api.v1.Row;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.control.NonFatal$;

@Tag(name="Operation")
@Produces(value={"application/json"})
@ScalaSignature(bytes="\u0006\u0001\u0005\u0005g!B\u0004\t\u0001!!\u0002\"B\u0012\u0001\t\u0003)\u0003\"\u0002\u0015\u0001\t\u0003I\u0003\"\u0002=\u0001\t\u0003I\bbBA\u0013\u0001\u0011\u0005\u0011q\u0005\u0005\b\u0003\u0007\u0002A\u0011AA#\u0011\u001d\t9\b\u0001C\u0001\u0003s\u0012!c\u00149fe\u0006$\u0018n\u001c8t%\u0016\u001cx.\u001e:dK*\u0011\u0011BC\u0001\u0003mFR!a\u0003\u0007\u0002\u0007\u0005\u0004\u0018N\u0003\u0002\u000e\u001d\u000511/\u001a:wKJT!a\u0004\t\u0002\r-LX/\u001e2j\u0015\t\t\"#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002'\u0005\u0019qN]4\u0014\t\u0001)2d\b\t\u0003-ei\u0011a\u0006\u0006\u00021\u0005)1oY1mC&\u0011!d\u0006\u0002\u0007\u0003:L(+\u001a4\u0011\u0005qiR\"\u0001\u0006\n\u0005yQ!!E!qSJ+\u0017/^3ti\u000e{g\u000e^3yiB\u0011\u0001%I\u0007\u0002\u001d%\u0011!E\u0004\u0002\b\u0019><w-\u001b8h\u0003\u0019a\u0014N\\5u}\r\u0001A#\u0001\u0014\u0011\u0005\u001d\u0002Q\"\u0001\u0005\u0002#\u001d,Go\u00149fe\u0006$\u0018n\u001c8Fm\u0016tG\u000f\u0006\u0002+aA\u00111FL\u0007\u0002Y)\u0011QFD\u0001\u0007KZ,g\u000e^:\n\u0005=b#\u0001F&zkV\u0014\u0017n\u00149fe\u0006$\u0018n\u001c8Fm\u0016tG\u000fC\u00032\u0005\u0001\u0007!'\u0001\npa\u0016\u0014\u0018\r^5p]\"\u000bg\u000e\u001a7f'R\u0014\bCA\u001a;\u001d\t!\u0004\b\u0005\u00026/5\taG\u0003\u00028I\u00051AH]8pizJ!!O\f\u0002\rA\u0013X\rZ3g\u0013\tYDH\u0001\u0004TiJLgn\u001a\u0006\u0003s]AC\u0001\r I\u0013B\u0011qHR\u0007\u0002\u0001*\u0011\u0011IQ\u0001\u0003eNT!a\u0011#\u0002\u0005]\u001c(\"A#\u0002\u000b)\fg/\u0019=\n\u0005\u001d\u0003%!\u0003)bi\"\u0004\u0016M]1n\u0003\u00151\u0018\r\\;fC\u0005Q\u0015aD8qKJ\fG/[8o\u0011\u0006tG\r\\3)\t\ta\u0005j\u0014\t\u0003\u007f5K!A\u0014!\u0003\tA\u000bG\u000f[\u0011\u0002!\u000692p\u001c9fe\u0006$\u0018n\u001c8IC:$G.Z?0KZ,g\u000e\u001e\u0015\u0003\u0005I\u0003\"aP*\n\u0005Q\u0003%aA$F)\"B!A\u00164hS*,h\u000f\u0005\u0002XI6\t\u0001L\u0003\u0002Z5\u0006I!/Z:q_:\u001cXm\u001d\u0006\u00037r\u000b1\"\u00198o_R\fG/[8og*\u0011QLX\u0001\u0004_\u0006\u001c(BA0a\u0003\t18G\u0003\u0002bE\u000691o^1hO\u0016\u0014(\"A2\u0002\u0005%|\u0017BA3Y\u0005-\t\u0005/\u001b*fgB|gn]3\u0002\u0019I,7\u000f]8og\u0016\u001cu\u000eZ3\"\u0003!\f1A\r\u00191\u0003\u001d\u0019wN\u001c;f]Rd\u0013a[\u0016\u0004YJ\u001c\bCA7q\u001b\u0005q'BA8[\u0003\u0015iW\rZ5b\u0013\t\thNA\u0004D_:$XM\u001c;\u0002\u00135,G-[1UsB,\u0017%\u0001;\u0002!\u0005\u0004\b\u000f\\5dCRLwN\\\u0018kg>t\u0017a\u00033fg\u000e\u0014\u0018\u000e\u001d;j_:\f\u0013a^\u0001\u0017\u000f\u0016$\b%\u00198!_B,'/\u0019;j_:\u0004SM^3oi\u0006i\u0011\r\u001d9ms>\u0003\u0018i\u0019;j_:$RA_A\u0001\u0003\u0017\u0001\"a\u001f@\u000e\u0003qT!! !\u0002\t\r|'/Z\u0005\u0003\u007fr\u0014\u0001BU3ta>t7/\u001a\u0005\b\u0003\u0007\u0019\u0001\u0019AA\u0003\u0003\u001d\u0011X-];fgR\u00042aJA\u0004\u0013\r\tI\u0001\u0003\u0002\u0010\u001fB\f5\r^5p]J+\u0017/^3ti\")\u0011g\u0001a\u0001e!*\u00111\u0002 I\u0013\"*1\u0001\u0014%\u0002\u0012\u0005\u0012\u00111C\u0001\u0012w>\u0004XM]1uS>t\u0007*\u00198eY\u0016l\bfA\u0002\u0002\u0018A\u0019q(!\u0007\n\u0007\u0005m\u0001IA\u0002Q+RC#b\u0001,gO&\fy\"^A\u0011Y\u0005Y\u0017EAA\u0012\u0003\u0001\n\u0007\u000f\u001d7zA\u0005t\u0007%Y2uS>t\u0007EZ8sA\u0005t\u0007e\u001c9fe\u0006$\u0018n\u001c8\u0002)\u001d,GOU3tk2$8+\u001a;NKR\fG-\u0019;b)\u0011\tI#a\f\u0011\u0007\u001d\nY#C\u0002\u0002.!\u0011\u0011CU3tk2$8+\u001a;NKR\fG)\u0019;b\u0011\u0015\tD\u00011\u00013Q\u0015\tyC\u0010%JQ\u0015!A\nSA\u001bC\t\t9$A\u0012|_B,'/\u0019;j_:D\u0015M\u001c3mKv|#/Z:vYR\u001cX\r^7fi\u0006$\u0017\r^1)\u0005\u0011\u0011\u0006F\u0003\u0003WM\u001eL\u0017QH;\u0002@1\n1.\t\u0002\u0002B\u00059r-\u001a;!e\u0016\u001cX\u000f\u001c;!g\u0016$\b%\\3uC\u0012\fG/Y\u0001\u0010O\u0016$x\n]3sCRLwN\u001c'pOR1\u0011qIA'\u0003#\u00022aJA%\u0013\r\tY\u0005\u0003\u0002\r\u001fB,'/\u0019;j_:dun\u001a\u0005\u0006c\u0015\u0001\rA\r\u0015\u0006\u0003\u001br\u0004*\u0013\u0005\b\u0003'*\u0001\u0019AA+\u0003\u001di\u0017\r\u001f*poN\u00042AFA,\u0013\r\tIf\u0006\u0002\u0004\u0013:$\bfBA)\u0003;B\u00151\r\t\u0004\u007f\u0005}\u0013bAA1\u0001\nQ\u0011+^3ssB\u000b'/Y7\"\u0005\u0005\u0015\u0014aB7bqJ|wo\u001d\u0015\u0006\u000b1C\u0015\u0011N\u0011\u0003\u0003W\nQc_8qKJ\fG/[8o\u0011\u0006tG\r\\3~_1|w\r\u000b\u0002\u0006%\"RQA\u00164hS\u0006ET/a\u001d-\u0003-\f#!!\u001e\u0002#\u001d,G\u000fI8qKJ\fG/[8oA1|w-A\u0007hKRtU\r\u001f;S_^\u001cV\r\u001e\u000b\t\u0003w\n\t)!\"\u0002\nB\u0019q%! \n\u0007\u0005}\u0004B\u0001\u0007SKN,H\u000e\u001e*poN+G\u000fC\u00032\r\u0001\u0007!\u0007K\u0003\u0002\u0002zB\u0015\nC\u0004\u0002T\u0019\u0001\r!!\u0016)\u000f\u0005\u0015\u0015Q\f%\u0002d!1\u00111\u0012\u0004A\u0002I\n\u0001CZ3uG\"|%/[3oi\u0006$\u0018n\u001c8)\u000f\u0005%\u0015Q\f%\u0002\u0010\u0006\u0012\u0011\u0011S\u0001\u0011M\u0016$8\r[8sS\u0016tG/\u0019;j_:DSA\u0002'I\u0003+\u000b#!a&\u00021m|\u0007/\u001a:bi&|g\u000eS1oI2,Wp\f:poN,G\u000f\u000b\u0002\u0007%\"RaA\u00164hS\u0006uU/a(-\u0003-\f#!!)\u0002%\u001d,G\u000f\t:fgVdG\u000f\t:po\u0002\u001aX\r\u001e\u0015\u0007\u0001\u0005\u0015\u0006*a+\u0011\u0007}\n9+C\u0002\u0002*\u0002\u0013\u0001\u0002\u0015:pIV\u001cWm\u001d\u0017\u0002g\":\u0001!a,\u0002<\u0006u\u0006\u0003BAY\u0003ok!!a-\u000b\u0007\u0005U&,\u0001\u0003uC\u001e\u001c\u0018\u0002BA]\u0003g\u00131\u0001V1h\u0003\u0011q\u0017-\\3\"\u0005\u0005}\u0016!C(qKJ\fG/[8o\u0001")
public class OperationsResource
implements ApiRequestContext,
Logging {
    private transient Logger org$apache$kyuubi$Logging$$log_;
    @Context
    private ServletContext servletContext;
    @Context
    private HttpServletRequest httpRequest;

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public void debug(Function0<Object> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<Object> message) {
        Logging.info$((Logging)this, message);
    }

    public void warn(Function0<Object> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message) {
        Logging.error$((Logging)this, message);
    }

    public void initializeLoggerIfNecessary(boolean isInterpreter) {
        Logging.initializeLoggerIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    @Override
    public final KyuubiRestFrontendService fe() {
        return ApiRequestContext.fe$(this);
    }

    public Logger org$apache$kyuubi$Logging$$log_() {
        return this.org$apache$kyuubi$Logging$$log_;
    }

    public void org$apache$kyuubi$Logging$$log__$eq(Logger x$1) {
        this.org$apache$kyuubi$Logging$$log_ = x$1;
    }

    @Override
    public ServletContext servletContext() {
        return this.servletContext;
    }

    @Override
    public void servletContext_$eq(ServletContext x$1) {
        this.servletContext = x$1;
    }

    @Override
    public HttpServletRequest httpRequest() {
        return this.httpRequest;
    }

    @Override
    public void httpRequest_$eq(HttpServletRequest x$1) {
        this.httpRequest = x$1;
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json")}, description="Get an operation event")
    @GET
    @Path(value="{operationHandle}/event")
    public KyuubiOperationEvent getOperationEvent(@PathParam(value="operationHandle") String operationHandleStr) {
        KyuubiOperationEvent kyuubiOperationEvent;
        try {
            OperationHandle opHandle = OperationHandle$.MODULE$.parseOperationHandle(operationHandleStr);
            Operation operation = this.fe().be().sessionManager().operationManager().getOperation(opHandle);
            kyuubiOperationEvent = KyuubiOperationEvent$.MODULE$.apply((KyuubiOperation)operation);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                String errorMsg = "Error getting an operation event";
                this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> errorMsg, e);
                throw new NotFoundException(errorMsg);
            }
            throw throwable;
        }
        return kyuubiOperationEvent;
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json")}, description="apply an action for an operation")
    @PUT
    @Path(value="{operationHandle}")
    public Response applyOpAction(OpActionRequest request, @PathParam(value="operationHandle") String operationHandleStr) {
        Response response;
        try {
            OperationHandle operationHandle = OperationHandle$.MODULE$.parseOperationHandle(operationHandleStr);
            String string = request.action().toLowerCase();
            if ("cancel".equals(string)) {
                this.fe().be().cancelOperation(operationHandle);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if ("close".equals(string)) {
                this.fe().be().closeOperation(operationHandle);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw KyuubiSQLException$.MODULE$.apply(new StringBuilder(15).append("Invalid action ").append(request.action()).toString(), KyuubiSQLException$.MODULE$.apply$default$2(), KyuubiSQLException$.MODULE$.apply$default$3(), KyuubiSQLException$.MODULE$.apply$default$4());
            }
            response = Response.ok().build();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                String errorMsg = new StringBuilder(37).append("Error applying ").append(request.action()).append(" for operation handle ").append(operationHandleStr).toString();
                this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> errorMsg, e);
                throw new NotFoundException(errorMsg);
            }
            throw throwable;
        }
        return response;
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json")}, description="get result set metadata")
    @GET
    @Path(value="{operationHandle}/resultsetmetadata")
    public ResultSetMetaData getResultSetMetadata(@PathParam(value="operationHandle") String operationHandleStr) {
        ResultSetMetaData resultSetMetaData;
        try {
            OperationHandle operationHandle = OperationHandle$.MODULE$.parseOperationHandle(operationHandleStr);
            resultSetMetaData = new ResultSetMetaData((Seq<ColumnDesc>)((Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.fe().be().getResultSetMetadata(operationHandle).getColumns()).asScala()).map((Function1 & Serializable & scala.Serializable)c -> {
                TPrimitiveTypeEntry tPrimitiveTypeEntry = ((TTypeEntry)c.getTypeDesc().getTypes().get(0)).getPrimitiveEntry();
                int precision = 0;
                int scale = 0;
                if (tPrimitiveTypeEntry.getTypeQualifiers() != null) {
                    Map qualifiers = tPrimitiveTypeEntry.getTypeQualifiers().getQualifiers();
                    TTypeQualifierValue defaultValue = TTypeQualifierValue.i32Value((int)0);
                    precision = qualifiers.getOrDefault("precision", defaultValue).getI32Value();
                    scale = qualifiers.getOrDefault("scale", defaultValue).getI32Value();
                }
                return new ColumnDesc(c.getColumnName(), tPrimitiveTypeEntry.getType().toString(), c.getPosition(), precision, scale, c.getComment());
            }, Buffer$.MODULE$.canBuildFrom())));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                String errorMsg = new StringBuilder(55).append("Error getting result set metadata for operation handle ").append(operationHandleStr).toString();
                this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> errorMsg, e);
                throw new NotFoundException(errorMsg);
            }
            throw throwable;
        }
        return resultSetMetaData;
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json")}, description="get operation log")
    @GET
    @Path(value="{operationHandle}/log")
    public OperationLog getOperationLog(@PathParam(value="operationHandle") String operationHandleStr, @QueryParam(value="maxrows") int maxRows) {
        OperationLog operationLog;
        try {
            TRowSet rowSet = this.fe().be().sessionManager().operationManager().getOperationLogRowSet(OperationHandle$.MODULE$.parseOperationHandle(operationHandleStr), FetchOrientation$.MODULE$.FETCH_NEXT(), maxRows);
            Buffer logRowSet = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(((TColumn)rowSet.getColumns().get(0)).getStringVal().getValues()).asScala();
            operationLog = new OperationLog((Seq<String>)logRowSet, logRowSet.size());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                String errorMsg = new StringBuilder(49).append("Error getting operation log for operation handle ").append(operationHandleStr).toString();
                this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> errorMsg, e);
                throw new NotFoundException(errorMsg);
            }
            throw throwable;
        }
        return operationLog;
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json")}, description="get result row set")
    @GET
    @Path(value="{operationHandle}/rowset")
    public ResultRowSet getNextRowSet(@PathParam(value="operationHandle") String operationHandleStr, @QueryParam(value="maxrows") int maxRows, @QueryParam(value="fetchorientation") String fetchOrientation) {
        ResultRowSet resultRowSet;
        try {
            TRowSet rowSet = this.fe().be().sessionManager().operationManager().getOperationNextRowSet(OperationHandle$.MODULE$.parseOperationHandle(operationHandleStr), FetchOrientation$.MODULE$.withName(fetchOrientation), maxRows);
            Buffer rows = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(rowSet.getRows()).asScala()).map((Function1 & Serializable & scala.Serializable)i2 -> new Row((Seq<Field>)((Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(i2.getColVals()).asScala()).map((Function1 & Serializable & scala.Serializable)i -> {
                Object object;
                String string = ((Enum)i.getSetField()).name();
                TColumnValue._Fields _Fields2 = (TColumnValue._Fields)i.getSetField();
                if (TColumnValue._Fields.STRING_VAL.equals(_Fields2)) {
                    object = i.getStringVal().getFieldValue(TStringValue._Fields.VALUE);
                } else if (TColumnValue._Fields.BOOL_VAL.equals(_Fields2)) {
                    object = i.getBoolVal().getFieldValue(TBoolValue._Fields.VALUE);
                } else if (TColumnValue._Fields.BYTE_VAL.equals(_Fields2)) {
                    object = i.getByteVal().getFieldValue(TByteValue._Fields.VALUE);
                } else if (TColumnValue._Fields.DOUBLE_VAL.equals(_Fields2)) {
                    object = i.getDoubleVal().getFieldValue(TDoubleValue._Fields.VALUE);
                } else if (TColumnValue._Fields.I16_VAL.equals(_Fields2)) {
                    object = i.getI16Val().getFieldValue(TI16Value._Fields.VALUE);
                } else if (TColumnValue._Fields.I32_VAL.equals(_Fields2)) {
                    object = i.getI32Val().getFieldValue(TI32Value._Fields.VALUE);
                } else if (TColumnValue._Fields.I64_VAL.equals(_Fields2)) {
                    object = i.getI64Val().getFieldValue(TI64Value._Fields.VALUE);
                } else {
                    throw new MatchError((Object)_Fields2);
                }
                return new Field(string, object);
            }, Buffer$.MODULE$.canBuildFrom()))), Buffer$.MODULE$.canBuildFrom());
            resultRowSet = new ResultRowSet((Seq<Row>)rows, rows.size());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                String errorMsg = new StringBuilder(50).append("Error getting result row set for operation handle ").append(operationHandleStr).toString();
                this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> errorMsg, e);
                throw new NotFoundException(errorMsg);
            }
            throw throwable;
        }
        return resultRowSet;
    }

    public OperationsResource() {
        ApiRequestContext.$init$(this);
        Logging.$init$((Logging)this);
    }
}

