/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.engine.trino.schema;

import io.trino.client.ClientTypeSignature;
import io.trino.client.ClientTypeSignatureParameter;
import io.trino.client.Column;
import io.trino.client.NamedClientTypeSignature;
import io.trino.client.Row;
import io.trino.client.RowField;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Map;
import org.apache.hive.service.rpc.thrift.TBinaryColumn;
import org.apache.hive.service.rpc.thrift.TBoolColumn;
import org.apache.hive.service.rpc.thrift.TBoolValue;
import org.apache.hive.service.rpc.thrift.TByteColumn;
import org.apache.hive.service.rpc.thrift.TByteValue;
import org.apache.hive.service.rpc.thrift.TColumn;
import org.apache.hive.service.rpc.thrift.TColumnValue;
import org.apache.hive.service.rpc.thrift.TDoubleColumn;
import org.apache.hive.service.rpc.thrift.TDoubleValue;
import org.apache.hive.service.rpc.thrift.TI16Column;
import org.apache.hive.service.rpc.thrift.TI16Value;
import org.apache.hive.service.rpc.thrift.TI32Column;
import org.apache.hive.service.rpc.thrift.TI32Value;
import org.apache.hive.service.rpc.thrift.TI64Column;
import org.apache.hive.service.rpc.thrift.TI64Value;
import org.apache.hive.service.rpc.thrift.TProtocolVersion;
import org.apache.hive.service.rpc.thrift.TRow;
import org.apache.hive.service.rpc.thrift.TRowSet;
import org.apache.hive.service.rpc.thrift.TStringColumn;
import org.apache.hive.service.rpc.thrift.TStringValue;
import org.apache.kyuubi.engine.trino.util.PreconditionsWrapper;
import org.apache.kyuubi.util.RowSetUtils$;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Iterable$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public final class RowSet$ {
    public static RowSet$ MODULE$;

    static {
        new RowSet$();
    }

    public TRowSet toTRowSet(Seq<List<?>> rows, List<Column> schema, TProtocolVersion protocolVersion) {
        return protocolVersion.getValue() < TProtocolVersion.HIVE_CLI_SERVICE_PROTOCOL_V6.getValue() ? this.toRowBasedSet(rows, schema) : this.toColumnBasedSet(rows, schema);
    }

    public TRowSet toRowBasedSet(Seq<List<?>> rows, List<Column> schema) {
        java.util.List tRows = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)rows.map((Function1 & Serializable & scala.Serializable)row -> {
            void var2_2;
            TRow tRow = new TRow();
            ((IterableLike)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), row.size()).map((Function1 & Serializable & scala.Serializable)i -> RowSet$.MODULE$.toTColumnValue(BoxesRunTime.unboxToInt((Object)i), (List<Object>)row, (List<Column>)schema), IndexedSeq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                tRow.addToColVals(x$1);
                return BoxedUnit.UNIT;
            });
            return var2_2;
        }, Seq$.MODULE$.canBuildFrom())).asJava();
        return new TRowSet(0L, tRows);
    }

    public TRowSet toColumnBasedSet(Seq<List<?>> rows, List<Column> schema) {
        int size = rows.size();
        TRowSet tRowSet = new TRowSet(0L, new ArrayList(size));
        ((List)schema.zipWithIndex(List$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            RowSet$.$anonfun$toColumnBasedSet$1(rows, tRowSet, x0$1);
            return BoxedUnit.UNIT;
        });
        return tRowSet;
    }

    private TColumn toTColumn(Seq<Seq<Object>> rows, int ordinal, ClientTypeSignature typ) {
        TColumn tColumn;
        BitSet nulls = new BitSet();
        String string = typ.getRawType();
        if ("boolean".equals(string)) {
            java.util.List<Boolean> values = this.getOrSetAsNull(rows, ordinal, nulls, Predef$.MODULE$.boolean2Boolean(true));
            tColumn = TColumn.boolVal((TBoolColumn)new TBoolColumn(values, RowSetUtils$.MODULE$.bitSetToBuffer(nulls)));
        } else if ("tinyint".equals(string)) {
            java.util.List<Byte> values = this.getOrSetAsNull(rows, ordinal, nulls, Predef$.MODULE$.byte2Byte((byte)0));
            tColumn = TColumn.byteVal((TByteColumn)new TByteColumn(values, RowSetUtils$.MODULE$.bitSetToBuffer(nulls)));
        } else if ("smallint".equals(string)) {
            java.util.List<Short> values = this.getOrSetAsNull(rows, ordinal, nulls, Predef$.MODULE$.short2Short((short)0));
            tColumn = TColumn.i16Val((TI16Column)new TI16Column(values, RowSetUtils$.MODULE$.bitSetToBuffer(nulls)));
        } else if ("integer".equals(string)) {
            java.util.List<Integer> values = this.getOrSetAsNull(rows, ordinal, nulls, Predef$.MODULE$.int2Integer(0));
            tColumn = TColumn.i32Val((TI32Column)new TI32Column(values, RowSetUtils$.MODULE$.bitSetToBuffer(nulls)));
        } else if ("bigint".equals(string)) {
            java.util.List<Long> values = this.getOrSetAsNull(rows, ordinal, nulls, Predef$.MODULE$.long2Long(0L));
            tColumn = TColumn.i64Val((TI64Column)new TI64Column(values, RowSetUtils$.MODULE$.bitSetToBuffer(nulls)));
        } else if ("real".equals(string)) {
            java.util.List values = (java.util.List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.getOrSetAsNull(rows, ordinal, nulls, Predef$.MODULE$.float2Float(0.0f))).asScala()).map((Function1 & Serializable & scala.Serializable)n -> Double.valueOf(n.toString()), Buffer$.MODULE$.canBuildFrom())).asJava();
            tColumn = TColumn.doubleVal((TDoubleColumn)new TDoubleColumn(values, RowSetUtils$.MODULE$.bitSetToBuffer(nulls)));
        } else if ("double".equals(string)) {
            java.util.List<Double> values = this.getOrSetAsNull(rows, ordinal, nulls, Predef$.MODULE$.double2Double(0.0));
            tColumn = TColumn.doubleVal((TDoubleColumn)new TDoubleColumn(values, RowSetUtils$.MODULE$.bitSetToBuffer(nulls)));
        } else if ("varchar".equals(string)) {
            java.util.List<String> values = this.getOrSetAsNull(rows, ordinal, nulls, "");
            tColumn = TColumn.stringVal((TStringColumn)new TStringColumn(values, RowSetUtils$.MODULE$.bitSetToBuffer(nulls)));
        } else if ("varbinary".equals(string)) {
            java.util.List values = (java.util.List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.getOrSetAsNull(rows, ordinal, nulls, Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte()))).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> ByteBuffer.wrap(x$1), Buffer$.MODULE$.canBuildFrom())).asJava();
            tColumn = TColumn.binaryVal((TBinaryColumn)new TBinaryColumn(values, RowSetUtils$.MODULE$.bitSetToBuffer(nulls)));
        } else {
            java.util.List values = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableLike)rows.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Seq row = (Seq)tuple2._1();
                int i = tuple2._2$mcI$sp();
                nulls.set(i, row.apply(ordinal) == null);
                String string = row.apply(ordinal) == null ? "" : MODULE$.toHiveString(row.apply(ordinal), typ);
                return string;
            }, Seq$.MODULE$.canBuildFrom())).asJava();
            tColumn = TColumn.stringVal((TStringColumn)new TStringColumn(values, RowSetUtils$.MODULE$.bitSetToBuffer(nulls)));
        }
        return tColumn;
    }

    private <T> java.util.List<T> getOrSetAsNull(Seq<Seq<Object>> rows, int ordinal, BitSet nulls, T defaultVal) {
        int size = rows.length();
        ArrayList<Object> ret = new ArrayList<Object>(size);
        for (int idx = 0; idx < size; ++idx) {
            boolean isNull;
            Seq row = (Seq)rows.apply(idx);
            boolean bl = isNull = row.apply(ordinal) == null;
            if (isNull) {
                nulls.set(idx, true);
                ret.add(idx, defaultVal);
                continue;
            }
            ret.add(idx, row.apply(ordinal));
        }
        return ret;
    }

    private TColumnValue toTColumnValue(int ordinal, List<Object> row, List<Column> types) {
        TColumnValue tColumnValue;
        String string = ((Column)types.apply(ordinal)).getTypeSignature().getRawType();
        if ("boolean".equals(string)) {
            TBoolValue boolValue = new TBoolValue();
            if (row.apply(ordinal) != null) {
                boolValue.setValue(BoxesRunTime.unboxToBoolean((Object)row.apply(ordinal)));
            }
            tColumnValue = TColumnValue.boolVal((TBoolValue)boolValue);
        } else if ("tinyint".equals(string)) {
            TByteValue byteValue = new TByteValue();
            if (row.apply(ordinal) != null) {
                byteValue.setValue(BoxesRunTime.unboxToByte((Object)row.apply(ordinal)));
            }
            tColumnValue = TColumnValue.byteVal((TByteValue)byteValue);
        } else if ("smallint".equals(string)) {
            TI16Value tI16Value = new TI16Value();
            if (row.apply(ordinal) != null) {
                tI16Value.setValue(BoxesRunTime.unboxToShort((Object)row.apply(ordinal)));
            }
            tColumnValue = TColumnValue.i16Val((TI16Value)tI16Value);
        } else if ("integer".equals(string)) {
            TI32Value tI32Value = new TI32Value();
            if (row.apply(ordinal) != null) {
                tI32Value.setValue(BoxesRunTime.unboxToInt((Object)row.apply(ordinal)));
            }
            tColumnValue = TColumnValue.i32Val((TI32Value)tI32Value);
        } else if ("bigint".equals(string)) {
            TI64Value tI64Value = new TI64Value();
            if (row.apply(ordinal) != null) {
                tI64Value.setValue(BoxesRunTime.unboxToLong((Object)row.apply(ordinal)));
            }
            tColumnValue = TColumnValue.i64Val((TI64Value)tI64Value);
        } else if ("real".equals(string)) {
            TDoubleValue tDoubleValue = new TDoubleValue();
            if (row.apply(ordinal) != null) {
                Double doubleValue = Double.valueOf(Float.toString(BoxesRunTime.unboxToFloat((Object)row.apply(ordinal))));
                tDoubleValue.setValue(Predef$.MODULE$.Double2double(doubleValue));
            }
            tColumnValue = TColumnValue.doubleVal((TDoubleValue)tDoubleValue);
        } else if ("double".equals(string)) {
            TDoubleValue tDoubleValue = new TDoubleValue();
            if (row.apply(ordinal) != null) {
                tDoubleValue.setValue(BoxesRunTime.unboxToDouble((Object)row.apply(ordinal)));
            }
            tColumnValue = TColumnValue.doubleVal((TDoubleValue)tDoubleValue);
        } else if ("varchar".equals(string)) {
            TStringValue tStringValue = new TStringValue();
            if (row.apply(ordinal) != null) {
                tStringValue.setValue((String)row.apply(ordinal));
            }
            tColumnValue = TColumnValue.stringVal((TStringValue)tStringValue);
        } else {
            TStringValue tStrValue = new TStringValue();
            if (row.apply(ordinal) != null) {
                tStrValue.setValue(this.toHiveString(row.apply(ordinal), ((Column)types.apply(ordinal)).getTypeSignature()));
            }
            tColumnValue = TColumnValue.stringVal((TStringValue)tStrValue);
        }
        return tColumnValue;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String toHiveString(Object data, ClientTypeSignature typ) {
        Object object;
        Tuple2 tuple2 = new Tuple2(data, (Object)typ.getRawType());
        if (tuple2 != null && (object = tuple2._1()) == null) {
            return "null";
        }
        if (tuple2 != null) {
            Object bin = tuple2._1();
            String string = (String)tuple2._2();
            if (bin instanceof byte[]) {
                byte[] byArray = (byte[])bin;
                if ("varbinary".equals(string)) {
                    return new String(byArray, StandardCharsets.UTF_8);
                }
            }
        }
        if (tuple2 != null) {
            Object s = tuple2._1();
            String string = (String)tuple2._2();
            if (s instanceof String) {
                String string2 = (String)s;
                if ("varchar".equals(string)) {
                    return new StringBuilder(2).append("\"").append(string2).append("\"").toString();
                }
            }
        }
        if (tuple2 != null) {
            Object list = tuple2._1();
            String string = (String)tuple2._2();
            if (list instanceof java.util.List) {
                java.util.List list2 = (java.util.List)list;
                if ("array".equals(string)) {
                    PreconditionsWrapper.checkArgument(((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(typ.getArgumentsAsTypeSignatures()).asScala()).nonEmpty(), "Missing ARRAY argument type");
                    ClientTypeSignature listType = (ClientTypeSignature)typ.getArgumentsAsTypeSignatures().get(0);
                    return ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(list2).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> MODULE$.toHiveString(x$1, listType), Buffer$.MODULE$.canBuildFrom())).mkString("[", ",", "]");
                }
            }
        }
        if (tuple2 != null) {
            Object m = tuple2._1();
            String string = (String)tuple2._2();
            if (m instanceof Map) {
                Map map = (Map)m;
                if ("map".equals(string)) {
                    PreconditionsWrapper.checkArgument(typ.getArgumentsAsTypeSignatures().size() == 2, "Mismatched number of MAP argument types");
                    ClientTypeSignature keyType = (ClientTypeSignature)typ.getArgumentsAsTypeSignatures().get(0);
                    ClientTypeSignature valueType = (ClientTypeSignature)typ.getArgumentsAsTypeSignatures().get(1);
                    return ((TraversableOnce)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(map).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                        Tuple2 tuple2 = x0$1;
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        Object key = tuple2._1();
                        Object value = tuple2._2();
                        String string = new StringBuilder(1).append(MODULE$.toHiveString(key, keyType)).append(":").append(MODULE$.toHiveString(value, valueType)).toString();
                        return string;
                    }, Iterable$.MODULE$.canBuildFrom())).toSeq().sorted((Ordering)Ordering.String$.MODULE$)).mkString("{", ",", "}");
                }
            }
        }
        if (tuple2 != null) {
            Object row = tuple2._1();
            String string = (String)tuple2._2();
            if (row instanceof Row) {
                Row row2 = (Row)row;
                if ("row".equals(string)) {
                    PreconditionsWrapper.checkArgument(row2.getFields().size() == typ.getArguments().size(), "Mismatched data values and ROW type");
                    return ((TraversableOnce)((TraversableLike)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(row2.getFields()).asScala()).zipWithIndex(Buffer$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                        Tuple2 tuple2 = x0$2;
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        RowField r = (RowField)tuple2._1();
                        int index = tuple2._2$mcI$sp();
                        NamedClientTypeSignature namedRowType = ((ClientTypeSignatureParameter)typ.getArguments().get(index)).getNamedTypeSignature();
                        String string = namedRowType.getName().isPresent() ? new StringBuilder(1).append((String)namedRowType.getName().get()).append("=").append(MODULE$.toHiveString(r.getValue(), namedRowType.getTypeSignature())).toString() : MODULE$.toHiveString(r.getValue(), namedRowType.getTypeSignature());
                        return string;
                    }, Buffer$.MODULE$.canBuildFrom())).mkString("{", ",", "}");
                }
            }
        }
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        Object other = tuple2._1();
        return other.toString();
    }

    public static final /* synthetic */ void $anonfun$toColumnBasedSet$1(Seq rows$1, TRowSet tRowSet$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Column filed = (Column)tuple2._1();
        int i = tuple2._2$mcI$sp();
        TColumn tColumn = MODULE$.toTColumn((Seq<Seq<Object>>)rows$1, i, filed.getTypeSignature());
        tRowSet$1.addToColumns(tColumn);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private RowSet$() {
        MODULE$ = this;
    }
}

