/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shade.org.apache.hadoop.hive.ql.io.sarg;

import java.util.List;
import org.apache.kyuubi.shade.org.apache.hadoop.hive.ql.io.sarg.ExpressionTree;
import org.apache.kyuubi.shade.org.apache.hadoop.hive.ql.io.sarg.PredicateLeaf;

public interface SearchArgument {
    public List<PredicateLeaf> getLeaves();

    public ExpressionTree getExpression();

    public TruthValue evaluate(TruthValue[] var1);

    public static interface Builder {
        public Builder startOr();

        public Builder startAnd();

        public Builder startNot();

        public Builder end();

        public Builder lessThan(String var1, PredicateLeaf.Type var2, Object var3);

        public Builder lessThanEquals(String var1, PredicateLeaf.Type var2, Object var3);

        public Builder equals(String var1, PredicateLeaf.Type var2, Object var3);

        public Builder nullSafeEquals(String var1, PredicateLeaf.Type var2, Object var3);

        public Builder in(String var1, PredicateLeaf.Type var2, Object ... var3);

        public Builder isNull(String var1, PredicateLeaf.Type var2);

        public Builder between(String var1, PredicateLeaf.Type var2, Object var3, Object var4);

        public Builder literal(TruthValue var1);

        public SearchArgument build();
    }

    public static enum TruthValue {
        YES,
        NO,
        NULL,
        YES_NULL,
        NO_NULL,
        YES_NO,
        YES_NO_NULL;


        public TruthValue or(TruthValue right) {
            if (right == null || right == this) {
                return this;
            }
            if (right == YES || this == YES) {
                return YES;
            }
            if (right == YES_NULL || this == YES_NULL) {
                return YES_NULL;
            }
            if (right == NO) {
                return this;
            }
            if (this == NO) {
                return right;
            }
            if (this == NULL) {
                if (right == NO_NULL) {
                    return NULL;
                }
                return YES_NULL;
            }
            if (right == NULL) {
                if (this == NO_NULL) {
                    return NULL;
                }
                return YES_NULL;
            }
            return YES_NO_NULL;
        }

        public TruthValue and(TruthValue right) {
            if (right == null || right == this) {
                return this;
            }
            if (right == NO || this == NO) {
                return NO;
            }
            if (right == NO_NULL || this == NO_NULL) {
                return NO_NULL;
            }
            if (right == YES) {
                return this;
            }
            if (this == YES) {
                return right;
            }
            if (this == NULL) {
                if (right == YES_NULL) {
                    return NULL;
                }
                return NO_NULL;
            }
            if (right == NULL) {
                if (this == YES_NULL) {
                    return NULL;
                }
                return NO_NULL;
            }
            return YES_NO_NULL;
        }

        public TruthValue not() {
            switch (this) {
                case NO: {
                    return YES;
                }
                case YES: {
                    return NO;
                }
                case NULL: 
                case YES_NO: 
                case YES_NO_NULL: {
                    return this;
                }
                case NO_NULL: {
                    return YES_NULL;
                }
                case YES_NULL: {
                    return NO_NULL;
                }
            }
            throw new IllegalArgumentException("Unknown value: " + (Object)((Object)this));
        }

        public boolean isNeeded() {
            switch (this) {
                case NO: 
                case NULL: 
                case NO_NULL: {
                    return false;
                }
            }
            return true;
        }
    }
}

