/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.operation.log;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.apache.hive.service.rpc.thrift.TColumn;
import org.apache.hive.service.rpc.thrift.TRowSet;
import org.apache.hive.service.rpc.thrift.TStringColumn;
import org.apache.kyuubi.KyuubiSQLException$;
import org.apache.kyuubi.operation.OperationHandle;
import org.apache.kyuubi.operation.log.OperationLog$;
import org.apache.kyuubi.session.Session;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

@ScalaSignature(bytes="\u0006\u0001\u0005Ut!B\r\u001b\u0011\u0003)c!B\u0014\u001b\u0011\u0003A\u0003\"B\u001a\u0002\t\u0003!\u0004bB\u001b\u0002\u0005\u0004%iA\u000e\u0005\b\u0003\u0003\n\u0001\u0015!\u00048\u0011\u001d\t\u0019%\u0001C\u0001\u0003\u000bBq!a\u0013\u0002\t\u0003\ti\u0005C\u0004\u0002P\u0005!\t!!\u0010\t\u000f\u0005E\u0013\u0001\"\u0001\u0002T!9\u00111M\u0001\u0005\u0002\u0005\u0015d\u0001B\u0014\u001b\u0001\u0001C\u0001\"\u0011\u0006\u0003\u0002\u0003\u0006IA\u0011\u0005\u0006g)!\tA\u0013\u0005\b\u0019*\u0011\r\u0011\"\u0003N\u0011\u0019!&\u0002)A\u0005\u001d\"9QK\u0003b\u0001\n\u00131\u0006B\u0002.\u000bA\u0003%q\u000bC\u0004\\\u0015\t\u0007I\u0011\u0002/\t\r\u0015T\u0001\u0015!\u0003^\u0011\u00151'\u0002\"\u0001h\u0011\u0015a'\u0002\"\u0001n\u0011\u0015Y(\u0002\"\u0003}\u0011\u001d\tiB\u0003C\u0001\u0003?Aq!a\u000f\u000b\t\u0003\ti\u0004C\u0004\u0002@)!I!!\u0010\u0002\u0019=\u0003XM]1uS>tGj\\4\u000b\u0005ma\u0012a\u00017pO*\u0011QDH\u0001\n_B,'/\u0019;j_:T!a\b\u0011\u0002\r-LX/\u001e2j\u0015\t\t#%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002G\u0005\u0019qN]4\u0004\u0001A\u0011a%A\u0007\u00025\taq\n]3sCRLwN\u001c'pON\u0019\u0011!K\u0018\u0011\u0005)jS\"A\u0016\u000b\u00031\nQa]2bY\u0006L!AL\u0016\u0003\r\u0005s\u0017PU3g!\t\u0001\u0014'D\u0001\u001f\u0013\t\u0011dDA\u0004M_\u001e<\u0017N\\4\u0002\rqJg.\u001b;?)\u0005)\u0013!D(Q\u000bJ\u000bE+S(O?2{u)F\u00018!\rAThP\u0007\u0002s)\u0011!hO\u0001\u0005Y\u0006twMC\u0001=\u0003\u0011Q\u0017M^1\n\u0005yJ$AF%oQ\u0016\u0014\u0018\u000e^1cY\u0016$\u0006N]3bI2{7-\u00197\u0011\u0005\u0019R1C\u0001\u0006*\u0003\u0011\u0001\u0018\r\u001e5\u0011\u0005\rCU\"\u0001#\u000b\u0005\u00153\u0015\u0001\u00024jY\u0016T!aR\u001e\u0002\u00079Lw.\u0003\u0002J\t\n!\u0001+\u0019;i)\ty4\nC\u0003B\u0019\u0001\u0007!)\u0001\u0004xe&$XM]\u000b\u0002\u001dB\u0011qJU\u0007\u0002!*\u0011\u0011kO\u0001\u0003S>L!a\u0015)\u0003\u001d\t+hMZ3sK\u0012<&/\u001b;fe\u00069qO]5uKJ\u0004\u0013A\u0002:fC\u0012,'/F\u0001X!\ty\u0005,\u0003\u0002Z!\nq!)\u001e4gKJ,GMU3bI\u0016\u0014\u0018a\u0002:fC\u0012,'\u000fI\u0001\rKb$(/\u0019*fC\u0012,'o]\u000b\u0002;B\u0019alY,\u000e\u0003}S!\u0001Y1\u0002\u000f5,H/\u00192mK*\u0011!mK\u0001\u000bG>dG.Z2uS>t\u0017B\u00013`\u0005)a\u0015n\u001d;Ck\u001a4WM]\u0001\u000eKb$(/\u0019*fC\u0012,'o\u001d\u0011\u0002\u0017\u0005$G-\u0012=ue\u0006dun\u001a\u000b\u0003Q.\u0004\"AK5\n\u0005)\\#\u0001B+oSRDQ!Q\nA\u0002\t\u000bQa\u001e:ji\u0016$\"\u0001\u001b8\t\u000b=$\u0002\u0019\u00019\u0002\u00075\u001cx\r\u0005\u0002rq:\u0011!O\u001e\t\u0003g.j\u0011\u0001\u001e\u0006\u0003k\u0012\na\u0001\u0010:p_Rt\u0014BA<,\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011P\u001f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005]\\\u0013\u0001\u0003:fC\u0012dunZ:\u0015\u000fu\f\u0019\"!\u0006\u0002\u001aA1!F`A\u0001\u0003\u001bI!a`\u0016\u0003\rQ+\b\u000f\\33!\u0015\t\u0019!!\u0003q\u001b\t\t)AC\u0002\u0002\bm\nA!\u001e;jY&!\u00111BA\u0003\u0005%\t%O]1z\u0019&\u001cH\u000fE\u0002+\u0003\u001fI1!!\u0005,\u0005\rIe\u000e\u001e\u0005\u0006+V\u0001\ra\u0016\u0005\b\u0003/)\u0002\u0019AA\u0007\u0003!a\u0017m\u001d;S_^\u001c\bbBA\u000e+\u0001\u0007\u0011QB\u0001\b[\u0006D(k\\<t\u0003\u0011\u0011X-\u00193\u0015\t\u0005\u0005\u0012\u0011\b\t\u0005\u0003G\t)$\u0004\u0002\u0002&)!\u0011qEA\u0015\u0003\u0019!\bN]5gi*!\u00111FA\u0017\u0003\r\u0011\bo\u0019\u0006\u0005\u0003_\t\t$A\u0004tKJ4\u0018nY3\u000b\u0007\u0005M\u0002%\u0001\u0003iSZ,\u0017\u0002BA\u001c\u0003K\u0011q\u0001\u0016*poN+G\u000fC\u0004\u0002\u001cY\u0001\r!!\u0004\u0002\u000b\rdwn]3\u0015\u0003!\f\u0011c\u00197pg\u0016,\u0005\u0010\u001e:b%\u0016\fG-\u001a:t\u00039y\u0005+\u0012*B)&{ej\u0018'P\u000f\u0002\nac]3u\u0007V\u0014(/\u001a8u\u001fB,'/\u0019;j_:dun\u001a\u000b\u0004Q\u0006\u001d\u0003BBA%\u000b\u0001\u0007q(\u0001\u0007pa\u0016\u0014\u0018\r^5p]2{w-\u0001\fhKR\u001cUO\u001d:f]R|\u0005/\u001a:bi&|g\u000eT8h+\u0005y\u0014!\u0007:f[>4XmQ;se\u0016tGo\u00149fe\u0006$\u0018n\u001c8M_\u001e\fqd\u0019:fCR,w\n]3sCRLwN\u001c'pOJ{w\u000e\u001e#je\u0016\u001cGo\u001c:z)\rA\u0017Q\u000b\u0005\b\u0003/B\u0001\u0019AA-\u0003\u001d\u0019Xm]:j_:\u0004B!a\u0017\u0002`5\u0011\u0011Q\f\u0006\u0004\u0003/r\u0012\u0002BA1\u0003;\u0012qaU3tg&|g.\u0001\nde\u0016\fG/Z(qKJ\fG/[8o\u0019><G#B \u0002h\u0005%\u0004bBA,\u0013\u0001\u0007\u0011\u0011\f\u0005\b\u0003WJ\u0001\u0019AA7\u0003!y\u0007\u000fS1oI2,\u0007\u0003BA8\u0003cj\u0011\u0001H\u0005\u0004\u0003gb\"aD(qKJ\fG/[8o\u0011\u0006tG\r\\3")
public class OperationLog {
    private final Path path;
    private final BufferedWriter writer;
    private final BufferedReader reader;
    private final ListBuffer<BufferedReader> extraReaders;

    public static OperationLog createOperationLog(Session session, OperationHandle operationHandle) {
        return OperationLog$.MODULE$.createOperationLog(session, operationHandle);
    }

    public static void createOperationLogRootDirectory(Session session) {
        OperationLog$.MODULE$.createOperationLogRootDirectory(session);
    }

    public static void removeCurrentOperationLog() {
        OperationLog$.MODULE$.removeCurrentOperationLog();
    }

    public static OperationLog getCurrentOperationLog() {
        return OperationLog$.MODULE$.getCurrentOperationLog();
    }

    public static void setCurrentOperationLog(OperationLog operationLog) {
        OperationLog$.MODULE$.setCurrentOperationLog(operationLog);
    }

    public static void error(Function0<Object> function0) {
        OperationLog$.MODULE$.error(function0);
    }

    public static void error(Function0<Object> function0, Throwable throwable) {
        OperationLog$.MODULE$.error(function0, throwable);
    }

    public static void warn(Function0<Object> function0, Throwable throwable) {
        OperationLog$.MODULE$.warn(function0, throwable);
    }

    public static void warn(Function0<Object> function0) {
        OperationLog$.MODULE$.warn(function0);
    }

    public static void info(Function0<Object> function0) {
        OperationLog$.MODULE$.info(function0);
    }

    public static void debug(Function0<Object> function0) {
        OperationLog$.MODULE$.debug(function0);
    }

    private BufferedWriter writer() {
        return this.writer;
    }

    private BufferedReader reader() {
        return this.reader;
    }

    private ListBuffer<BufferedReader> extraReaders() {
        return this.extraReaders;
    }

    public void addExtraLog(Path path) {
        OperationLog operationLog = this;
        synchronized (operationLog) {
            this.liftedTree1$1(path);
        }
    }

    public synchronized void write(String msg) {
        try {
            this.writer().write(msg);
            this.writer().flush();
        }
        catch (IOException iOException) {}
    }

    private Tuple2<ArrayList<String>, Object> readLogs(BufferedReader reader, int lastRows, int maxRows) {
        Tuple2 tuple2;
        ArrayList<String> logs = new ArrayList<String>();
        try {
            int i;
            String line = reader.readLine();
            for (i = 0; (i < lastRows || maxRows <= 0) && line != null; ++i) {
                logs.add(line);
                line = reader.readLine();
            }
            tuple2 = new Tuple2(logs, (Object)BoxesRunTime.boxToInteger((int)i));
        }
        catch (IOException e) {
            Path absPath = this.path.toAbsolutePath();
            Path opHandle = absPath.getFileName();
            throw KyuubiSQLException$.MODULE$.apply(new StringBuilder(34).append("Operation[").append(opHandle).append("] log file ").append(absPath).append(" is not found").toString(), e, KyuubiSQLException$.MODULE$.apply$default$3(), KyuubiSQLException$.MODULE$.apply$default$4());
        }
        return tuple2;
    }

    public synchronized TRowSet read(int maxRows) {
        Tuple2<ArrayList<String>, Object> tuple2 = this.readLogs(this.reader(), maxRows, maxRows);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        ArrayList logs = (ArrayList)tuple2._1();
        int lines = tuple2._2$mcI$sp();
        Tuple2 tuple22 = new Tuple2((Object)logs, (Object)BoxesRunTime.boxToInteger((int)lines));
        Tuple2 tuple23 = tuple22;
        ArrayList logs2 = (ArrayList)tuple23._1();
        int lines2 = tuple23._2$mcI$sp();
        IntRef lastRows = IntRef.create((int)(maxRows - lines2));
        this.extraReaders().withFilter((Function1 & Serializable & scala.Serializable)extraReader -> BoxesRunTime.boxToBoolean((boolean)OperationLog.$anonfun$read$1(lastRows, maxRows, extraReader))).foreach((Function1 & Serializable & scala.Serializable)extraReader -> BoxesRunTime.boxToBoolean((boolean)OperationLog.$anonfun$read$2(this, lastRows, maxRows, logs2, extraReader)));
        TColumn tColumn = TColumn.stringVal((TStringColumn)new TStringColumn((List)logs2, ByteBuffer.allocate(0)));
        TRowSet tRow = new TRowSet(0L, new ArrayList(logs2.size()));
        tRow.addToColumns(tColumn);
        return tRow;
    }

    public synchronized void close() {
        try {
            this.closeExtraReaders();
            this.reader().close();
            this.writer().close();
            Files.delete(this.path);
        }
        catch (IOException e) {
            throw new IOException(new StringBuilder(54).append("Failed to remove corresponding log file of operation: ").append(this.path.toAbsolutePath()).toString(), e);
        }
    }

    private void closeExtraReaders() {
        this.extraReaders().foreach((Function1 & Serializable & scala.Serializable)extraReader -> {
            OperationLog.$anonfun$closeExtraReaders$1(extraReader);
            return BoxedUnit.UNIT;
        });
    }

    private final /* synthetic */ Object liftedTree1$1(Path path$2) {
        BoxedUnit boxedUnit;
        try {
            boxedUnit = this.extraReaders().$plus$eq((Object)Files.newBufferedReader(path$2, StandardCharsets.UTF_8));
        }
        catch (IOException iOException) {
            boxedUnit = BoxedUnit.UNIT;
        }
        return boxedUnit;
    }

    public static final /* synthetic */ boolean $anonfun$read$1(IntRef lastRows$1, int maxRows$1, BufferedReader extraReader) {
        return lastRows$1.elem > 0 || maxRows$1 <= 0;
    }

    public static final /* synthetic */ boolean $anonfun$read$2(OperationLog $this, IntRef lastRows$1, int maxRows$1, ArrayList logs$1, BufferedReader extraReader) {
        Tuple2<ArrayList<String>, Object> tuple2 = $this.readLogs(extraReader, lastRows$1.elem, maxRows$1);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        ArrayList extraLogs = (ArrayList)tuple2._1();
        int extraRows = tuple2._2$mcI$sp();
        Tuple2 tuple22 = new Tuple2((Object)extraLogs, (Object)BoxesRunTime.boxToInteger((int)extraRows));
        Tuple2 tuple23 = tuple22;
        ArrayList extraLogs2 = (ArrayList)tuple23._1();
        int extraRows2 = tuple23._2$mcI$sp();
        lastRows$1.elem -= extraRows2;
        return logs$1.addAll(extraLogs2);
    }

    public static final /* synthetic */ void $anonfun$closeExtraReaders$1(BufferedReader extraReader) {
        try {
            extraReader.close();
        }
        catch (IOException iOException) {}
    }

    public OperationLog(Path path) {
        this.path = path;
        this.writer = Files.newBufferedWriter(path, StandardCharsets.UTF_8, new OpenOption[0]);
        this.reader = Files.newBufferedReader(path, StandardCharsets.UTF_8);
        this.extraReaders = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
    }
}

