/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.jdbc.hive.auth;

import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpRequest;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CookieStore;
import org.apache.http.impl.auth.AuthSchemeBase;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.protocol.HttpContext;
import org.apache.kyuubi.jdbc.hive.auth.HttpRequestInterceptorBase;

public class HttpBasicAuthInterceptor
extends HttpRequestInterceptorBase {
    UsernamePasswordCredentials credentials;
    AuthSchemeBase authScheme = new BasicScheme();

    public HttpBasicAuthInterceptor(String username, String password, CookieStore cookieStore, String cn, boolean isSSL, Map<String, String> additionalHeaders, Map<String, String> customCookies) {
        super(cookieStore, cn, isSSL, additionalHeaders, customCookies);
        if (username != null) {
            this.credentials = new UsernamePasswordCredentials(username, password);
        }
    }

    @Override
    protected void addHttpAuthHeader(HttpRequest httpRequest, HttpContext httpContext) throws Exception {
        Header basicAuthHeader = this.authScheme.authenticate((Credentials)this.credentials, httpRequest, httpContext);
        httpRequest.addHeader(basicAuthHeader);
    }
}

